// SPDX-FileComment: This file is part of TNL - Template Numerical Library (https://tnl-project.org/)
// SPDX-License-Identifier: MIT

#pragma once

#include <type_traits>

#include <TNL/Meshes/Grid.h>
#include <TNL/Meshes/Mesh.h>
#include <TNL/Meshes/DistributedMeshes/DistributedMesh.h>

namespace TNL::Meshes {

template< typename T >
class isGrid : public std::false_type
{};

template< int Dimension, typename Real, typename Device, typename Index >
class isGrid< Grid< Dimension, Real, Device, Index > > : public std::true_type
{};

template< typename T >
class isDistributedGrid : public std::false_type
{};

template< int Dimension, typename Real, typename Device, typename Index >
class isDistributedGrid< DistributedMeshes::DistributedMesh< Grid< Dimension, Real, Device, Index > > > : public std::true_type
{};

template< typename T >
class isMesh : public std::false_type
{};

template< typename Config, typename Device >
class isMesh< Mesh< Config, Device > > : public std::true_type
{};

template< typename T >
class isDistributedMesh : public std::false_type
{};

template< typename Config, typename Device >
class isDistributedMesh< DistributedMeshes::DistributedMesh< Mesh< Config, Device > > > : public std::true_type
{};

}  // namespace TNL::Meshes
