// SPDX-FileComment: This file is part of TNL - Template Numerical Library (https://tnl-project.org/)
// SPDX-License-Identifier: MIT

#pragma once

#include <TNL/Config/ParameterContainer.h>
#include <TNL/Images/Image.h>
#include <TNL/Meshes/Grid.h>

namespace TNL::Images {

template< typename Index = int >
class RegionOfInterest
{
public:
   RegionOfInterest();

   bool
   setup( const Config::ParameterContainer& parameters, const Image< Index >* image );

   [[nodiscard]] bool
   check( const Image< Index >* image ) const;

   [[nodiscard]] Index
   getTop() const;

   [[nodiscard]] Index
   getBottom() const;

   [[nodiscard]] Index
   getLeft() const;

   [[nodiscard]] Index
   getRight() const;

   [[nodiscard]] Index
   getWidth() const;

   [[nodiscard]] Index
   getHeight() const;

   template< typename Grid >
   bool
   setGrid( Grid& grid, bool verbose = false );

   [[nodiscard]] bool
   isIn( Index row, Index column ) const;

protected:
   Index top, bottom, left, right;
};

}  // namespace TNL::Images

#include <TNL/Images/RegionOfInterest_impl.h>
