// SPDX-FileComment: This file is part of TNL - Template Numerical Library (https://tnl-project.org/)
// SPDX-License-Identifier: MIT

#pragma once

#include <utility>

namespace TNL::Algorithms::SegmentsReductionKernels::detail {

template< typename Index, typename Lambda >
class CheckFetchLambda
{
private:
   using YesType = char[ 1 ];
   using NoType = char[ 2 ];

   template< typename C >
   static YesType&
   test( decltype( std::declval< C >()( Index(), Index(), Index() ) ) );
   template< typename C >
   static NoType&
   test( ... );

   static constexpr bool value = ( sizeof( test< Lambda >( 0 ) ) == sizeof( YesType ) );

public:
   static constexpr bool
   hasAllParameters()
   {
      return value;
   }
};

}  // namespace TNL::Algorithms::SegmentsReductionKernels::detail
