// SPDX-FileComment: This file is part of TNL - Template Numerical Library (https://tnl-project.org/)
// SPDX-License-Identifier: MIT

#pragma once

/**
 * \brief Namespace for TNL pointers.
 *
 * Pointers in TNL are similar to STL pointers but they work across different device.
 */
namespace TNL::Pointers {

class SmartPointer
{
public:
   virtual bool
   synchronize() = 0;

   virtual ~SmartPointer() = default;
};

}  // namespace TNL::Pointers
