from collections.abc import Sequence
import pytnl._containers
import pytnl._containers_cuda
import pytnl._meshes
from typing import TypeAlias, overload


class Grid_1:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def setDimensions(self, arg: pytnl._containers.StaticVector_1_int, /) -> None: ...

    def getDimensions(self) -> pytnl._containers.StaticVector_1_int: ...

    def setDomain(self, arg0: pytnl._containers.StaticVector_1_float, arg1: pytnl._containers.StaticVector_1_float, /) -> None: ...

    def setOrigin(self, arg: pytnl._containers.StaticVector_1_float, /) -> None: ...

    def getOrigin(self) -> pytnl._containers.StaticVector_1_float: ...

    def getProportions(self) -> pytnl._containers.StaticVector_1_float: ...

    @overload
    def getCell(self, arg: int, /) -> Grid_1.Cell: ...

    @overload
    def getCell(self, arg: pytnl._containers.StaticVector_1_int, /) -> Grid_1.Cell: ...

    @overload
    def getFace(self, arg: int, /) -> Grid_1.Vertex: ...

    @overload
    def getFace(self, arg: pytnl._containers.StaticVector_1_int, /) -> Grid_1.Vertex: ...

    @overload
    def getVertex(self, arg: int, /) -> Grid_1.Vertex: ...

    @overload
    def getVertex(self, arg: pytnl._containers.StaticVector_1_int, /) -> Grid_1.Vertex: ...

    @overload
    def getEntityIndex(self, arg: Grid_1.Cell, /) -> int: ...

    @overload
    def getEntityIndex(self, arg: Grid_1.Vertex, /) -> int: ...

    def getCellMeasure(self) -> float: ...

    def getSpaceSteps(self) -> pytnl._containers.StaticVector_1_float: ...

    def getSmallestSpaceStep(self) -> float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_1.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_1.Vertex], /) -> int: ...

    def getSpaceStepsProducts(self, xPow: int) -> float: ...

    CoordinatesType: type = ...
    """(arg: object, /) -> type"""

    PointType: type = ...
    """(arg: object, /) -> type"""

    class Cell:
        @overload
        def __init__(self, arg: Grid_1, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, arg2: pytnl._containers.StaticVector_1_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, arg2: pytnl._containers.StaticVector_1_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_1_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_1_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_1_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_1_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_1_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_1_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_1: ...

    class Vertex:
        @overload
        def __init__(self, arg: Grid_1, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, arg2: pytnl._containers.StaticVector_1_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, arg2: pytnl._containers.StaticVector_1_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_1_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_1_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_1_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_1_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_1_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_1_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_1: ...

    Face: TypeAlias = Grid_1.Vertex

class Grid_2:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def setDimensions(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

    def getDimensions(self) -> pytnl._containers.StaticVector_2_int: ...

    def setDomain(self, arg0: pytnl._containers.StaticVector_2_float, arg1: pytnl._containers.StaticVector_2_float, /) -> None: ...

    def setOrigin(self, arg: pytnl._containers.StaticVector_2_float, /) -> None: ...

    def getOrigin(self) -> pytnl._containers.StaticVector_2_float: ...

    def getProportions(self) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getCell(self, arg: int, /) -> Grid_2.Cell: ...

    @overload
    def getCell(self, arg: pytnl._containers.StaticVector_2_int, /) -> Grid_2.Cell: ...

    @overload
    def getFace(self, arg: int, /) -> Grid_2.Face: ...

    @overload
    def getFace(self, arg: pytnl._containers.StaticVector_2_int, /) -> Grid_2.Face: ...

    @overload
    def getVertex(self, arg: int, /) -> Grid_2.Vertex: ...

    @overload
    def getVertex(self, arg: pytnl._containers.StaticVector_2_int, /) -> Grid_2.Vertex: ...

    @overload
    def getEntityIndex(self, arg: Grid_2.Cell, /) -> int: ...

    @overload
    def getEntityIndex(self, arg: Grid_2.Vertex, /) -> int: ...

    @overload
    def getEntityIndex(self, arg: Grid_2.Face, /) -> int: ...

    def getCellMeasure(self) -> float: ...

    def getSpaceSteps(self) -> pytnl._containers.StaticVector_2_float: ...

    def getSmallestSpaceStep(self) -> float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_2.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_2.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_2.Face], /) -> int: ...

    def getSpaceStepsProducts(self, xPow: int, yPow: int = 0) -> float: ...

    CoordinatesType: type = ...
    """(arg: object, /) -> type"""

    PointType: type = ...
    """(arg: object, /) -> type"""

    class Cell:
        @overload
        def __init__(self, arg: Grid_2, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_2_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_2_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_2_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_2_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_2: ...

    class Vertex:
        @overload
        def __init__(self, arg: Grid_2, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_2_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_2_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_2_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_2_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_2: ...

    class Face:
        @overload
        def __init__(self, arg: Grid_2, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_2_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_2_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_2_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_2_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_2: ...

class Grid_3:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def setDimensions(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

    def getDimensions(self) -> pytnl._containers.StaticVector_3_int: ...

    def setDomain(self, arg0: pytnl._containers.StaticVector_3_float, arg1: pytnl._containers.StaticVector_3_float, /) -> None: ...

    def setOrigin(self, arg: pytnl._containers.StaticVector_3_float, /) -> None: ...

    def getOrigin(self) -> pytnl._containers.StaticVector_3_float: ...

    def getProportions(self) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getCell(self, arg: int, /) -> Grid_3.Cell: ...

    @overload
    def getCell(self, arg: pytnl._containers.StaticVector_3_int, /) -> Grid_3.Cell: ...

    @overload
    def getFace(self, arg: int, /) -> Grid_3.Face: ...

    @overload
    def getFace(self, arg: pytnl._containers.StaticVector_3_int, /) -> Grid_3.Face: ...

    @overload
    def getVertex(self, arg: int, /) -> Grid_3.Vertex: ...

    @overload
    def getVertex(self, arg: pytnl._containers.StaticVector_3_int, /) -> Grid_3.Vertex: ...

    @overload
    def getEntityIndex(self, arg: Grid_3.Cell, /) -> int: ...

    @overload
    def getEntityIndex(self, arg: Grid_3.Vertex, /) -> int: ...

    @overload
    def getEntityIndex(self, arg: Grid_3.Face, /) -> int: ...

    def getCellMeasure(self) -> float: ...

    def getSpaceSteps(self) -> pytnl._containers.StaticVector_3_float: ...

    def getSmallestSpaceStep(self) -> float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_3.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_3.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_3.Face], /) -> int: ...

    def getSpaceStepsProducts(self, xPow: int, yPow: int = 0, zPow: int = 0) -> float: ...

    CoordinatesType: type = ...
    """(arg: object, /) -> type"""

    PointType: type = ...
    """(arg: object, /) -> type"""

    class Cell:
        @overload
        def __init__(self, arg: Grid_3, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_3_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_3_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_3_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_3_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_3: ...

    class Vertex:
        @overload
        def __init__(self, arg: Grid_3, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_3_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_3_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_3_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_3_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_3: ...

    class Face:
        @overload
        def __init__(self, arg: Grid_3, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_3_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_3_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_3_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_3_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_3: ...

class Mesh_Edge:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Edge.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Edge.Vertex: ...

    def getVertex(self, arg: int, /) -> Mesh_Edge.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Edge.Cell, /) -> pytnl._containers.StaticVector_1_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Edge.Vertex, /) -> pytnl._containers.StaticVector_1_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Edge.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Edge.Vertex, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Edge.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Edge.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Edge.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Edge.Vertex, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Edge.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Edge.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Edge.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Edge.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Edge.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Edge.Vertex], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_1_float: ...

    Face: TypeAlias = Mesh_Edge.Vertex

class Mesh_Triangle:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Triangle.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Triangle.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Triangle.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Triangle.Cell, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Triangle.Vertex, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Triangle.Face, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Triangle.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Triangle.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Triangle.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Triangle.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Triangle.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Triangle.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Triangle.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Triangle.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Triangle.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Triangle.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Triangle.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Triangle.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Triangle.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Triangle.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Triangle.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Triangle.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Triangle.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Triangle.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_2_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

class Mesh_Quadrangle:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Quadrangle.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Quadrangle.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Quadrangle.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Quadrangle.Cell, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Quadrangle.Vertex, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Quadrangle.Face, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Quadrangle.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Quadrangle.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Quadrangle.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Quadrangle.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Quadrangle.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Quadrangle.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Quadrangle.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Quadrangle.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Quadrangle.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Quadrangle.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Quadrangle.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Quadrangle.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Quadrangle.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Quadrangle.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Quadrangle.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Quadrangle.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Quadrangle.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Quadrangle.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_2_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

class Mesh_Tetrahedron:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Tetrahedron.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Tetrahedron.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Tetrahedron.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Tetrahedron.Cell, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Tetrahedron.Vertex, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Tetrahedron.Face, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Tetrahedron.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Tetrahedron.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Tetrahedron.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Tetrahedron.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Tetrahedron.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Tetrahedron.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Tetrahedron.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Tetrahedron.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Tetrahedron.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Tetrahedron.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Tetrahedron.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Tetrahedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Tetrahedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Tetrahedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Tetrahedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Tetrahedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Tetrahedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Tetrahedron.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_3_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

class Mesh_Hexahedron:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Hexahedron.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Hexahedron.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Hexahedron.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Hexahedron.Cell, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Hexahedron.Vertex, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Hexahedron.Face, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Hexahedron.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Hexahedron.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Hexahedron.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Hexahedron.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Hexahedron.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Hexahedron.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Hexahedron.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Hexahedron.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Hexahedron.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Hexahedron.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Hexahedron.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Hexahedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Hexahedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Hexahedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Hexahedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Hexahedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Hexahedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Hexahedron.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_3_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

class Mesh_Polygon:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Polygon.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Polygon.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Polygon.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polygon.Cell, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polygon.Vertex, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polygon.Face, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polygon.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polygon.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polygon.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polygon.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polygon.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polygon.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polygon.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polygon.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polygon.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polygon.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polygon.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polygon.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polygon.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polygon.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polygon.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polygon.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polygon.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polygon.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_2_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

class Mesh_Polyhedron:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Polyhedron.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Polyhedron.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Polyhedron.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polyhedron.Cell, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polyhedron.Vertex, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polyhedron.Face, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polyhedron.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polyhedron.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polyhedron.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polyhedron.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polyhedron.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polyhedron.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polyhedron.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polyhedron.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polyhedron.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polyhedron.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polyhedron.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polyhedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polyhedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polyhedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polyhedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polyhedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polyhedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polyhedron.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_3_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

@overload
def loadMesh(arg0: pytnl._meshes.MeshReader, arg1: Grid_1, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.MeshReader, arg1: Grid_2, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.MeshReader, arg1: Grid_3, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.MeshReader, arg1: Mesh_Edge, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.MeshReader, arg1: Mesh_Triangle, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.MeshReader, arg1: Mesh_Quadrangle, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.MeshReader, arg1: Mesh_Tetrahedron, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.MeshReader, arg1: Mesh_Hexahedron, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.MeshReader, arg1: Mesh_Polygon, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.MeshReader, arg1: Mesh_Polyhedron, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.PVTUReader, arg1: DistributedMesh_Edge, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.PVTUReader, arg1: DistributedMesh_Triangle, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.PVTUReader, arg1: DistributedMesh_Quadrangle, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.PVTUReader, arg1: DistributedMesh_Tetrahedron, /) -> None: ...

@overload
def loadMesh(arg0: pytnl._meshes.PVTUReader, arg1: DistributedMesh_Hexahedron, /) -> None: ...

class VTKWriter_Grid_1:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_1, /) -> None: ...

    def writeCells(self, arg: Grid_1, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Grid_1:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_1, /) -> None: ...

    def writeCells(self, arg: Grid_1, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTIWriter_Grid_1:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_1, /) -> None: ...

    def writeCells(self, arg: Grid_1, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Grid_2:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_2, /) -> None: ...

    def writeCells(self, arg: Grid_2, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Grid_2:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_2, /) -> None: ...

    def writeCells(self, arg: Grid_2, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTIWriter_Grid_2:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_2, /) -> None: ...

    def writeCells(self, arg: Grid_2, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Grid_3:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_3, /) -> None: ...

    def writeCells(self, arg: Grid_3, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Grid_3:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_3, /) -> None: ...

    def writeCells(self, arg: Grid_3, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTIWriter_Grid_3:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_3, /) -> None: ...

    def writeCells(self, arg: Grid_3, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class DistributedMesh_Edge:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getLocalMesh(self) -> Mesh_Edge: ...

    def setGhostLevels(self, arg: int, /) -> None: ...

    def getGhostLevels(self) -> int: ...

    def getGlobalPointIndices(self) -> pytnl._containers_cuda.Array_int: ...

    def getGlobalCellIndices(self) -> pytnl._containers_cuda.Array_int: ...

    def vtkPointGhostTypes(self) -> pytnl._meshes.VTKTypesArrayType: ...

    def vtkCellGhostTypes(self) -> pytnl._meshes.VTKTypesArrayType: ...

class DistributedMesh_Triangle:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getLocalMesh(self) -> Mesh_Triangle: ...

    def setGhostLevels(self, arg: int, /) -> None: ...

    def getGhostLevels(self) -> int: ...

    def getGlobalPointIndices(self) -> pytnl._containers_cuda.Array_int: ...

    def getGlobalCellIndices(self) -> pytnl._containers_cuda.Array_int: ...

    def vtkPointGhostTypes(self) -> pytnl._meshes.VTKTypesArrayType: ...

    def vtkCellGhostTypes(self) -> pytnl._meshes.VTKTypesArrayType: ...

class DistributedMesh_Quadrangle:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getLocalMesh(self) -> Mesh_Quadrangle: ...

    def setGhostLevels(self, arg: int, /) -> None: ...

    def getGhostLevels(self) -> int: ...

    def getGlobalPointIndices(self) -> pytnl._containers_cuda.Array_int: ...

    def getGlobalCellIndices(self) -> pytnl._containers_cuda.Array_int: ...

    def vtkPointGhostTypes(self) -> pytnl._meshes.VTKTypesArrayType: ...

    def vtkCellGhostTypes(self) -> pytnl._meshes.VTKTypesArrayType: ...

class DistributedMesh_Tetrahedron:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getLocalMesh(self) -> Mesh_Tetrahedron: ...

    def setGhostLevels(self, arg: int, /) -> None: ...

    def getGhostLevels(self) -> int: ...

    def getGlobalPointIndices(self) -> pytnl._containers_cuda.Array_int: ...

    def getGlobalCellIndices(self) -> pytnl._containers_cuda.Array_int: ...

    def vtkPointGhostTypes(self) -> pytnl._meshes.VTKTypesArrayType: ...

    def vtkCellGhostTypes(self) -> pytnl._meshes.VTKTypesArrayType: ...

class DistributedMesh_Hexahedron:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getLocalMesh(self) -> Mesh_Hexahedron: ...

    def setGhostLevels(self, arg: int, /) -> None: ...

    def getGhostLevels(self) -> int: ...

    def getGlobalPointIndices(self) -> pytnl._containers_cuda.Array_int: ...

    def getGlobalCellIndices(self) -> pytnl._containers_cuda.Array_int: ...

    def vtkPointGhostTypes(self) -> pytnl._meshes.VTKTypesArrayType: ...

    def vtkCellGhostTypes(self) -> pytnl._meshes.VTKTypesArrayType: ...

class PVTUWriter_Mesh_Edge:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    @overload
    def writeVertices(self, distributedMesh: DistributedMesh_Edge) -> None: ...

    @overload
    def writeVertices(self, localMesh: Mesh_Edge, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    @overload
    def writeCells(self, distributedMesh: DistributedMesh_Edge) -> None: ...

    @overload
    def writeCells(self, localMesh: Mesh_Edge, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    def writePPointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def addPiece(self, mainFileName: str, subdomainIndex: int) -> str: ...

class PVTUWriter_Mesh_Triangle:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    @overload
    def writeVertices(self, distributedMesh: DistributedMesh_Triangle) -> None: ...

    @overload
    def writeVertices(self, localMesh: Mesh_Triangle, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    @overload
    def writeCells(self, distributedMesh: DistributedMesh_Triangle) -> None: ...

    @overload
    def writeCells(self, localMesh: Mesh_Triangle, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    def writePPointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def addPiece(self, mainFileName: str, subdomainIndex: int) -> str: ...

class PVTUWriter_Mesh_Quadrangle:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    @overload
    def writeVertices(self, distributedMesh: DistributedMesh_Quadrangle) -> None: ...

    @overload
    def writeVertices(self, localMesh: Mesh_Quadrangle, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    @overload
    def writeCells(self, distributedMesh: DistributedMesh_Quadrangle) -> None: ...

    @overload
    def writeCells(self, localMesh: Mesh_Quadrangle, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    def writePPointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def addPiece(self, mainFileName: str, subdomainIndex: int) -> str: ...

class PVTUWriter_Mesh_Tetrahedron:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    @overload
    def writeVertices(self, distributedMesh: DistributedMesh_Tetrahedron) -> None: ...

    @overload
    def writeVertices(self, localMesh: Mesh_Tetrahedron, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    @overload
    def writeCells(self, distributedMesh: DistributedMesh_Tetrahedron) -> None: ...

    @overload
    def writeCells(self, localMesh: Mesh_Tetrahedron, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    def writePPointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def addPiece(self, mainFileName: str, subdomainIndex: int) -> str: ...

class PVTUWriter_Mesh_Hexahedron:
    def __init__(self, stream: object, *, format: pytnl._meshes.VTKFileFormat = pytnl._meshes.VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    @overload
    def writeVertices(self, distributedMesh: DistributedMesh_Hexahedron) -> None: ...

    @overload
    def writeVertices(self, localMesh: Mesh_Hexahedron, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    @overload
    def writeCells(self, distributedMesh: DistributedMesh_Hexahedron) -> None: ...

    @overload
    def writeCells(self, localMesh: Mesh_Hexahedron, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    def writePPointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def addPiece(self, mainFileName: str, subdomainIndex: int) -> str: ...

def resolveMeshType(file_name: str, *, file_format: str = 'auto') -> tuple[pytnl._meshes.MeshReader, type]:
    """
    Returns a `(reader, mesh)` pair where `reader` is initialized with the given file name (using `getMeshReader`) and `mesh` is empty.
    """

def resolveAndLoadMesh(file_name: str, *, file_format: str = 'auto') -> tuple[pytnl._meshes.MeshReader, type]:
    """
    Returns a `(reader, mesh)` pair where `reader` is initialized with the given file name (using `getMeshReader`) and `mesh` contains the mesh loaded from the given file (using `reader.loadMesh(mesh)`).
    """
