import pytnl._containers
from typing import BinaryIO, overload


class CSR:
    def __init__(self) -> None: ...

    @staticmethod
    def getSerializationType() -> str: ...

    def save(self, arg: str, /) -> None: ...

    def load(self, arg: str, /) -> None: ...

    def print(self, arg: BinaryIO, /) -> None: ...

    def __str__(self) -> str: ...

    def setDimensions(self, arg0: int, arg1: int, /) -> None: ...

    def setLike(self, arg: CSR, /) -> None: ...

    def getAllocatedElementsCount(self) -> int: ...

    def getNonzeroElementsCount(self) -> int: ...

    def reset(self) -> None: ...

    def getRows(self) -> int: ...

    def getColumns(self) -> int: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setRowCapacities(self, arg: pytnl._containers.Vector_int, /) -> None: ...

    def getRowCapacities(self, arg: pytnl._containers.Vector_int, /) -> None: ...

    def getCompressedRowLengths(self, arg: pytnl._containers.Vector_int, /) -> None: ...

    def getRowCapacity(self, arg: int, /) -> int: ...

    def getRow(self, arg: int, /) -> SparseMatrixRowView: ...

    def setElement(self, arg0: int, arg1: int, arg2: float, /) -> None: ...

    def addElement(self, arg0: int, arg1: int, arg2: float, arg3: float, /) -> None: ...

    def getElement(self, arg0: int, arg1: int, /) -> float: ...

    def vectorProduct(self, arg0: pytnl._containers.Vector_float, arg1: pytnl._containers.Vector_float, arg2: float, arg3: float, arg4: int, arg5: int, arg6: "TNL::Algorithms::SegmentsReductionKernels::CSRScalarKernel<long, TNL::Devices::Host>", /) -> None: ...

    def assign(self, arg: CSR, /) -> CSR: ...

    def getValues(self) -> pytnl._containers.VectorView_float: ...

    def getColumnIndexes(self) -> pytnl._containers.VectorView_int: ...

    def getSegments(self) -> "TNL::Algorithms::Segments::CSRView<TNL::Devices::Host, long>": ...

    class Segments:
        def getSegmentsCount(self) -> int: ...

        def getSegmentSize(self, arg: int, /) -> int: ...

        def getSize(self) -> int: ...

        def getStorageSize(self) -> int: ...

        def getGlobalIndex(self, arg0: int, arg1: int, /) -> int: ...

        def getOffsets(self) -> pytnl._containers.VectorView_int_const: ...

class Ellpack:
    def __init__(self) -> None: ...

    @staticmethod
    def getSerializationType() -> str: ...

    def save(self, arg: str, /) -> None: ...

    def load(self, arg: str, /) -> None: ...

    def print(self, arg: BinaryIO, /) -> None: ...

    def __str__(self) -> str: ...

    def setDimensions(self, arg0: int, arg1: int, /) -> None: ...

    def setLike(self, arg: Ellpack, /) -> None: ...

    def getAllocatedElementsCount(self) -> int: ...

    def getNonzeroElementsCount(self) -> int: ...

    def reset(self) -> None: ...

    def getRows(self) -> int: ...

    def getColumns(self) -> int: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setRowCapacities(self, arg: pytnl._containers.Vector_int, /) -> None: ...

    def getRowCapacities(self, arg: pytnl._containers.Vector_int, /) -> None: ...

    def getCompressedRowLengths(self, arg: pytnl._containers.Vector_int, /) -> None: ...

    def getRowCapacity(self, arg: int, /) -> int: ...

    def getRow(self, arg: int, /) -> SparseMatrixRowView: ...

    def setElement(self, arg0: int, arg1: int, arg2: float, /) -> None: ...

    def addElement(self, arg0: int, arg1: int, arg2: float, arg3: float, /) -> None: ...

    def getElement(self, arg0: int, arg1: int, /) -> float: ...

    def vectorProduct(self, arg0: pytnl._containers.Vector_float, arg1: pytnl._containers.Vector_float, arg2: float, arg3: float, arg4: int, arg5: int, arg6: "TNL::Algorithms::SegmentsReductionKernels::EllpackKernel<long, TNL::Devices::Host>", /) -> None: ...

    def assign(self, arg: Ellpack, /) -> Ellpack: ...

    def getValues(self) -> pytnl._containers.VectorView_float: ...

    def getColumnIndexes(self) -> pytnl._containers.VectorView_int: ...

    def getSegments(self) -> "TNL::Algorithms::Segments::EllpackView<TNL::Devices::Host, long, (TNL::Algorithms::Segments::ElementsOrganization)1, 32>": ...

    class Segments:
        def getSegmentsCount(self) -> int: ...

        def getSegmentSize(self, arg: int, /) -> int: ...

        def getSize(self) -> int: ...

        def getStorageSize(self) -> int: ...

        def getGlobalIndex(self, arg0: int, arg1: int, /) -> int: ...

class SlicedEllpack:
    def __init__(self) -> None: ...

    @staticmethod
    def getSerializationType() -> str: ...

    def save(self, arg: str, /) -> None: ...

    def load(self, arg: str, /) -> None: ...

    def print(self, arg: BinaryIO, /) -> None: ...

    def __str__(self) -> str: ...

    def setDimensions(self, arg0: int, arg1: int, /) -> None: ...

    def setLike(self, arg: SlicedEllpack, /) -> None: ...

    def getAllocatedElementsCount(self) -> int: ...

    def getNonzeroElementsCount(self) -> int: ...

    def reset(self) -> None: ...

    def getRows(self) -> int: ...

    def getColumns(self) -> int: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setRowCapacities(self, arg: pytnl._containers.Vector_int, /) -> None: ...

    def getRowCapacities(self, arg: pytnl._containers.Vector_int, /) -> None: ...

    def getCompressedRowLengths(self, arg: pytnl._containers.Vector_int, /) -> None: ...

    def getRowCapacity(self, arg: int, /) -> int: ...

    def getRow(self, arg: int, /) -> SparseMatrixRowView: ...

    def setElement(self, arg0: int, arg1: int, arg2: float, /) -> None: ...

    def addElement(self, arg0: int, arg1: int, arg2: float, arg3: float, /) -> None: ...

    def getElement(self, arg0: int, arg1: int, /) -> float: ...

    def vectorProduct(self, arg0: pytnl._containers.Vector_float, arg1: pytnl._containers.Vector_float, arg2: float, arg3: float, arg4: int, arg5: int, arg6: "TNL::Algorithms::SegmentsReductionKernels::SlicedEllpackKernel<long, TNL::Devices::Host>", /) -> None: ...

    def assign(self, arg: SlicedEllpack, /) -> SlicedEllpack: ...

    def getValues(self) -> pytnl._containers.VectorView_float: ...

    def getColumnIndexes(self) -> pytnl._containers.VectorView_int: ...

    def getSegments(self) -> "TNL::Algorithms::Segments::SlicedEllpackView<TNL::Devices::Host, long, (TNL::Algorithms::Segments::ElementsOrganization)1, 32>": ...

    class Segments:
        def getSegmentsCount(self) -> int: ...

        def getSegmentSize(self, arg: int, /) -> int: ...

        def getSize(self) -> int: ...

        def getStorageSize(self) -> int: ...

        def getGlobalIndex(self, arg0: int, arg1: int, /) -> int: ...

class SparseMatrixRowView:
    def getSize(self) -> int: ...

    def getRowIndex(self) -> int: ...

    def getColumnIndex(self, arg: int, /) -> int: ...

    def getValue(self, arg: int, /) -> float: ...

    def __eq__(self, arg: object, /) -> bool: ...

def setValue(arg0: SparseMatrixRowView, arg1: int, arg2: float, /) -> None: ...

def setColumnIndex(arg0: SparseMatrixRowView, arg1: int, arg2: int, /) -> None: ...

def setElement(arg0: SparseMatrixRowView, arg1: int, arg2: int, arg3: float, /) -> None: ...

class SparseMatrixConstRowView:
    def getSize(self) -> int: ...

    def getRowIndex(self) -> int: ...

    def getColumnIndex(self, arg: int, /) -> int: ...

    def getValue(self, arg: int, /) -> float: ...

    def __eq__(self, arg: object, /) -> bool: ...

@overload
def copySparseMatrix(arg0: CSR, arg1: Ellpack, /) -> None: ...

@overload
def copySparseMatrix(arg0: Ellpack, arg1: CSR, /) -> None: ...

@overload
def copySparseMatrix(arg0: CSR, arg1: SlicedEllpack, /) -> None: ...

@overload
def copySparseMatrix(arg0: SlicedEllpack, arg1: CSR, /) -> None: ...

@overload
def copySparseMatrix(arg0: Ellpack, arg1: SlicedEllpack, /) -> None: ...

@overload
def copySparseMatrix(arg0: SlicedEllpack, arg1: Ellpack, /) -> None: ...
