from collections.abc import Iterator, Sequence
import enum
import pytnl._containers
from typing import Any, TypeAlias, overload

import numpy.typing
import typing_extensions

from . import topologies as topologies


class VTKFileFormat(enum.Enum):
    ascii = 0

    binary = 1

    zlib_compressed = 2

class VTKDataType(enum.Enum):
    CellData = 0

    PointData = 1

class VTKEntityShape(enum.Enum):
    Vertex = 1

    PolyVertex = 2

    Line = 3

    PolyLine = 4

    Triangle = 5

    TriangleStrip = 6

    Polygon = 7

    Pixel = 8

    Quad = 9

    Tetra = 10

    Voxel = 11

    Hexahedron = 12

    Wedge = 13

    Pyramid = 14

    Polyhedron = 42

class VTKCellGhostTypes(enum.Enum):
    DUPLICATECELL = 1
    """the cell is present on multiple processors"""

    HIGHCONNECTIVITYCELL = 2
    """the cell has more neighbors than in a regular mesh"""

    LOWCONNECTIVITYCELL = 4
    """the cell has less neighbors than in a regular mesh"""

    REFINEDCELL = 8
    """other cells are present that refines it"""

    EXTERIORCELL = 16
    """the cell is on the exterior of the data set"""

    HIDDENCELL = 32
    """
    the cell is needed to maintain connectivity, but the data values should be ignored
    """

class VTKPointGhostTypes(enum.Enum):
    DUPLICATEPOINT = 1
    """the cell is present on multiple processors"""

    HIDDENPOINT = 2
    """
    the point is needed to maintain connectivity, but the data values should be ignored
    """

class Grid_1:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def setDimensions(self, arg: pytnl._containers.StaticVector_1_int, /) -> None: ...

    def getDimensions(self) -> pytnl._containers.StaticVector_1_int: ...

    def setDomain(self, arg0: pytnl._containers.StaticVector_1_float, arg1: pytnl._containers.StaticVector_1_float, /) -> None: ...

    def setOrigin(self, arg: pytnl._containers.StaticVector_1_float, /) -> None: ...

    def getOrigin(self) -> pytnl._containers.StaticVector_1_float: ...

    def getProportions(self) -> pytnl._containers.StaticVector_1_float: ...

    @overload
    def getCell(self, arg: int, /) -> Grid_1.Cell: ...

    @overload
    def getCell(self, arg: pytnl._containers.StaticVector_1_int, /) -> Grid_1.Cell: ...

    @overload
    def getFace(self, arg: int, /) -> Grid_1.Vertex: ...

    @overload
    def getFace(self, arg: pytnl._containers.StaticVector_1_int, /) -> Grid_1.Vertex: ...

    @overload
    def getVertex(self, arg: int, /) -> Grid_1.Vertex: ...

    @overload
    def getVertex(self, arg: pytnl._containers.StaticVector_1_int, /) -> Grid_1.Vertex: ...

    @overload
    def getEntityIndex(self, arg: Grid_1.Cell, /) -> int: ...

    @overload
    def getEntityIndex(self, arg: Grid_1.Vertex, /) -> int: ...

    def getCellMeasure(self) -> float: ...

    def getSpaceSteps(self) -> pytnl._containers.StaticVector_1_float: ...

    def getSmallestSpaceStep(self) -> float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_1.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_1.Vertex], /) -> int: ...

    def getSpaceStepsProducts(self, xPow: int) -> float: ...

    CoordinatesType: type = ...
    """(arg: object, /) -> type"""

    PointType: type = ...
    """(arg: object, /) -> type"""

    class Cell:
        @overload
        def __init__(self, arg: Grid_1, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, arg2: pytnl._containers.StaticVector_1_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, arg2: pytnl._containers.StaticVector_1_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_1_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_1_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_1_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_1_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_1_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_1_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_1: ...

    class Vertex:
        @overload
        def __init__(self, arg: Grid_1, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, arg2: pytnl._containers.StaticVector_1_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: pytnl._containers.StaticVector_1_int, arg2: pytnl._containers.StaticVector_1_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_1, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_1_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_1_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_1_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_1_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_1_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_1_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_1: ...

    Face: TypeAlias = Grid_1.Vertex

class Grid_2:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def setDimensions(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

    def getDimensions(self) -> pytnl._containers.StaticVector_2_int: ...

    def setDomain(self, arg0: pytnl._containers.StaticVector_2_float, arg1: pytnl._containers.StaticVector_2_float, /) -> None: ...

    def setOrigin(self, arg: pytnl._containers.StaticVector_2_float, /) -> None: ...

    def getOrigin(self) -> pytnl._containers.StaticVector_2_float: ...

    def getProportions(self) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getCell(self, arg: int, /) -> Grid_2.Cell: ...

    @overload
    def getCell(self, arg: pytnl._containers.StaticVector_2_int, /) -> Grid_2.Cell: ...

    @overload
    def getFace(self, arg: int, /) -> Grid_2.Face: ...

    @overload
    def getFace(self, arg: pytnl._containers.StaticVector_2_int, /) -> Grid_2.Face: ...

    @overload
    def getVertex(self, arg: int, /) -> Grid_2.Vertex: ...

    @overload
    def getVertex(self, arg: pytnl._containers.StaticVector_2_int, /) -> Grid_2.Vertex: ...

    @overload
    def getEntityIndex(self, arg: Grid_2.Cell, /) -> int: ...

    @overload
    def getEntityIndex(self, arg: Grid_2.Vertex, /) -> int: ...

    @overload
    def getEntityIndex(self, arg: Grid_2.Face, /) -> int: ...

    def getCellMeasure(self) -> float: ...

    def getSpaceSteps(self) -> pytnl._containers.StaticVector_2_float: ...

    def getSmallestSpaceStep(self) -> float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_2.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_2.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_2.Face], /) -> int: ...

    def getSpaceStepsProducts(self, xPow: int, yPow: int = 0) -> float: ...

    CoordinatesType: type = ...
    """(arg: object, /) -> type"""

    PointType: type = ...
    """(arg: object, /) -> type"""

    class Cell:
        @overload
        def __init__(self, arg: Grid_2, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_2_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_2_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_2_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_2_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_2: ...

    class Vertex:
        @overload
        def __init__(self, arg: Grid_2, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_2_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_2_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_2_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_2_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_2: ...

    class Face:
        @overload
        def __init__(self, arg: Grid_2, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: pytnl._containers.StaticVector_2_int, arg2: pytnl._containers.StaticVector_2_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_2, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_2_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_2_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_2_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_2_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_2_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_2: ...

class Grid_3:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def setDimensions(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

    def getDimensions(self) -> pytnl._containers.StaticVector_3_int: ...

    def setDomain(self, arg0: pytnl._containers.StaticVector_3_float, arg1: pytnl._containers.StaticVector_3_float, /) -> None: ...

    def setOrigin(self, arg: pytnl._containers.StaticVector_3_float, /) -> None: ...

    def getOrigin(self) -> pytnl._containers.StaticVector_3_float: ...

    def getProportions(self) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getCell(self, arg: int, /) -> Grid_3.Cell: ...

    @overload
    def getCell(self, arg: pytnl._containers.StaticVector_3_int, /) -> Grid_3.Cell: ...

    @overload
    def getFace(self, arg: int, /) -> Grid_3.Face: ...

    @overload
    def getFace(self, arg: pytnl._containers.StaticVector_3_int, /) -> Grid_3.Face: ...

    @overload
    def getVertex(self, arg: int, /) -> Grid_3.Vertex: ...

    @overload
    def getVertex(self, arg: pytnl._containers.StaticVector_3_int, /) -> Grid_3.Vertex: ...

    @overload
    def getEntityIndex(self, arg: Grid_3.Cell, /) -> int: ...

    @overload
    def getEntityIndex(self, arg: Grid_3.Vertex, /) -> int: ...

    @overload
    def getEntityIndex(self, arg: Grid_3.Face, /) -> int: ...

    def getCellMeasure(self) -> float: ...

    def getSpaceSteps(self) -> pytnl._containers.StaticVector_3_float: ...

    def getSmallestSpaceStep(self) -> float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_3.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_3.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Grid_3.Face], /) -> int: ...

    def getSpaceStepsProducts(self, xPow: int, yPow: int = 0, zPow: int = 0) -> float: ...

    CoordinatesType: type = ...
    """(arg: object, /) -> type"""

    PointType: type = ...
    """(arg: object, /) -> type"""

    class Cell:
        @overload
        def __init__(self, arg: Grid_3, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_3_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_3_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_3_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_3_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_3: ...

    class Vertex:
        @overload
        def __init__(self, arg: Grid_3, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_3_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_3_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_3_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_3_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_3: ...

    class Face:
        @overload
        def __init__(self, arg: Grid_3, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: pytnl._containers.StaticVector_3_int, arg2: pytnl._containers.StaticVector_3_int, arg3: int, /) -> None: ...

        @overload
        def __init__(self, arg0: Grid_3, arg1: int, /) -> None: ...

        @staticmethod
        def getEntityDimension() -> int: ...

        @staticmethod
        def getMeshDimension() -> int: ...

        def getCoordinates(self) -> pytnl._containers.StaticVector_3_int: ...

        def setCoordinates(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def refresh(self) -> None: ...

        def getIndex(self) -> int: ...

        def getNormals(self) -> pytnl._containers.StaticVector_3_int: ...

        def setNormals(self, arg: pytnl._containers.StaticVector_3_int, /) -> None: ...

        def getOrientation(self) -> int: ...

        def setOrientation(self, arg: int, /) -> None: ...

        def getBasis(self) -> pytnl._containers.StaticVector_3_int: ...

        def isBoundary(self) -> bool: ...

        def getCenter(self) -> pytnl._containers.StaticVector_3_float: ...

        def getMeasure(self) -> float: ...

        def getMesh(self) -> Grid_3: ...

class Mesh_Edge:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Edge.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Edge.Vertex: ...

    def getVertex(self, arg: int, /) -> Mesh_Edge.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Edge.Cell, /) -> pytnl._containers.StaticVector_1_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Edge.Vertex, /) -> pytnl._containers.StaticVector_1_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Edge.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Edge.Vertex, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Edge.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Edge.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Edge.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Edge.Vertex, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Edge.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Edge.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Edge.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Edge.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Edge.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Edge.Vertex], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_1_float: ...

    Face: TypeAlias = Mesh_Edge.Vertex

class Mesh_Triangle:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Triangle.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Triangle.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Triangle.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Triangle.Cell, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Triangle.Vertex, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Triangle.Face, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Triangle.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Triangle.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Triangle.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Triangle.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Triangle.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Triangle.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Triangle.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Triangle.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Triangle.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Triangle.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Triangle.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Triangle.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Triangle.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Triangle.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Triangle.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Triangle.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Triangle.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Triangle.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_2_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

class Mesh_Quadrangle:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Quadrangle.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Quadrangle.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Quadrangle.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Quadrangle.Cell, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Quadrangle.Vertex, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Quadrangle.Face, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Quadrangle.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Quadrangle.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Quadrangle.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Quadrangle.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Quadrangle.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Quadrangle.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Quadrangle.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Quadrangle.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Quadrangle.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Quadrangle.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Quadrangle.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Quadrangle.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Quadrangle.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Quadrangle.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Quadrangle.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Quadrangle.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Quadrangle.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Quadrangle.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_2_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

class Mesh_Tetrahedron:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Tetrahedron.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Tetrahedron.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Tetrahedron.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Tetrahedron.Cell, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Tetrahedron.Vertex, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Tetrahedron.Face, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Tetrahedron.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Tetrahedron.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Tetrahedron.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Tetrahedron.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Tetrahedron.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Tetrahedron.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Tetrahedron.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Tetrahedron.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Tetrahedron.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Tetrahedron.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Tetrahedron.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Tetrahedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Tetrahedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Tetrahedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Tetrahedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Tetrahedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Tetrahedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Tetrahedron.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_3_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

class Mesh_Hexahedron:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Hexahedron.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Hexahedron.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Hexahedron.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Hexahedron.Cell, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Hexahedron.Vertex, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Hexahedron.Face, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Hexahedron.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Hexahedron.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Hexahedron.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Hexahedron.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Hexahedron.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Hexahedron.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Hexahedron.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Hexahedron.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Hexahedron.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Hexahedron.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Hexahedron.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Hexahedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Hexahedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Hexahedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Hexahedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Hexahedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Hexahedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Hexahedron.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_3_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

class Mesh_Polygon:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Polygon.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Polygon.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Polygon.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polygon.Cell, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polygon.Vertex, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polygon.Face, /) -> pytnl._containers.StaticVector_2_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polygon.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polygon.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polygon.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polygon.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polygon.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polygon.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polygon.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polygon.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polygon.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polygon.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polygon.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polygon.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polygon.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polygon.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polygon.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polygon.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polygon.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polygon.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_2_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

class Mesh_Polyhedron:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getCell(self, arg: int, /) -> Mesh_Polyhedron.Cell: ...

    def getFace(self, arg: int, /) -> Mesh_Polyhedron.Face: ...

    def getVertex(self, arg: int, /) -> Mesh_Polyhedron.Vertex: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polyhedron.Cell, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polyhedron.Vertex, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityCenter(self, arg: Mesh_Polyhedron.Face, /) -> pytnl._containers.StaticVector_3_float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polyhedron.Cell, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polyhedron.Vertex, /) -> float: ...

    @overload
    def getEntityMeasure(self, arg: Mesh_Polyhedron.Face, /) -> float: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polyhedron.Cell, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polyhedron.Vertex, /) -> bool: ...

    @overload
    def isBoundaryEntity(self, arg: Mesh_Polyhedron.Face, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polyhedron.Cell, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polyhedron.Vertex, /) -> bool: ...

    @overload
    def isGhostEntity(self, arg: Mesh_Polyhedron.Face, /) -> bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polyhedron.Cell], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polyhedron.Vertex], /) -> int: ...

    @overload
    def getEntitiesCount(self, arg: type[Mesh_Polyhedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polyhedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polyhedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesCount(self, arg: type[Mesh_Polyhedron.Face], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polyhedron.Cell], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polyhedron.Vertex], /) -> int: ...

    @overload
    def getGhostEntitiesOffset(self, arg: type[Mesh_Polyhedron.Face], /) -> int: ...

    class Cell:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

    class Vertex:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getPoint(self) -> pytnl._containers.StaticVector_3_float: ...

    class Face:
        @staticmethod
        def getEntityDimension() -> int: ...

        def getIndex(self) -> int: ...

        def getTag(self) -> int: ...

        def getSuperentityIndex(self, arg: int, /) -> int: ...

        def getSubvertexIndex(self, arg: int, /) -> int: ...

@overload
def loadMesh(arg0: MeshReader, arg1: Grid_1, /) -> None: ...

@overload
def loadMesh(arg0: MeshReader, arg1: Grid_2, /) -> None: ...

@overload
def loadMesh(arg0: MeshReader, arg1: Grid_3, /) -> None: ...

@overload
def loadMesh(arg0: MeshReader, arg1: Mesh_Edge, /) -> None: ...

@overload
def loadMesh(arg0: MeshReader, arg1: Mesh_Triangle, /) -> None: ...

@overload
def loadMesh(arg0: MeshReader, arg1: Mesh_Quadrangle, /) -> None: ...

@overload
def loadMesh(arg0: MeshReader, arg1: Mesh_Tetrahedron, /) -> None: ...

@overload
def loadMesh(arg0: MeshReader, arg1: Mesh_Hexahedron, /) -> None: ...

@overload
def loadMesh(arg0: MeshReader, arg1: Mesh_Polygon, /) -> None: ...

@overload
def loadMesh(arg0: MeshReader, arg1: Mesh_Polyhedron, /) -> None: ...

@overload
def loadMesh(arg0: PVTUReader, arg1: DistributedMesh_Edge, /) -> None: ...

@overload
def loadMesh(arg0: PVTUReader, arg1: DistributedMesh_Triangle, /) -> None: ...

@overload
def loadMesh(arg0: PVTUReader, arg1: DistributedMesh_Quadrangle, /) -> None: ...

@overload
def loadMesh(arg0: PVTUReader, arg1: DistributedMesh_Tetrahedron, /) -> None: ...

@overload
def loadMesh(arg0: PVTUReader, arg1: DistributedMesh_Hexahedron, /) -> None: ...

class MeshReader:
    def __init__(self, arg: str, /) -> None: ...

    def reset(self) -> None: ...

    def detectMesh(self) -> None: ...

    def loadMesh(self, arg: object, /) -> None: ...

    def readPointData(self, arg: str, /) -> list[int] | list[int] | list[int] | list[int] | list[int] | list[int] | list[int] | list[int] | list[float] | list[float]: ...

    def readCellData(self, arg: str, /) -> list[int] | list[int] | list[int] | list[int] | list[int] | list[int] | list[int] | list[int] | list[float] | list[float]: ...

class VTKReader(MeshReader):
    def __init__(self, arg: str, /) -> None: ...

class XMLVTK(MeshReader):
    def __init__(self, arg: str, /) -> None: ...

class VTUReader(XMLVTK):
    def __init__(self, arg: str, /) -> None: ...

class VTIReader(XMLVTK):
    def __init__(self, arg: str, /) -> None: ...

class PVTUReader(XMLVTK):
    def __init__(self, arg: str, /) -> None: ...

def getMeshReader(file_name: str, *, file_format: str = 'auto') -> MeshReader:
    """
    Returns the MeshReader instance for given file based on file extension (does not call `reader.detectMesh` so it succeeds even for invalid file)
    """

class VTKWriter_Grid_1:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_1, /) -> None: ...

    def writeCells(self, arg: Grid_1, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Grid_1:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_1, /) -> None: ...

    def writeCells(self, arg: Grid_1, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTIWriter_Grid_1:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_1, /) -> None: ...

    def writeCells(self, arg: Grid_1, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Grid_2:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_2, /) -> None: ...

    def writeCells(self, arg: Grid_2, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Grid_2:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_2, /) -> None: ...

    def writeCells(self, arg: Grid_2, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTIWriter_Grid_2:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_2, /) -> None: ...

    def writeCells(self, arg: Grid_2, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Grid_3:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_3, /) -> None: ...

    def writeCells(self, arg: Grid_3, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Grid_3:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_3, /) -> None: ...

    def writeCells(self, arg: Grid_3, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTIWriter_Grid_3:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Grid_3, /) -> None: ...

    def writeCells(self, arg: Grid_3, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Mesh_Edge:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Edge, /) -> None: ...

    def writeCells(self, arg: Mesh_Edge, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Mesh_Edge:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Edge, /) -> None: ...

    def writeCells(self, arg: Mesh_Edge, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Mesh_Triangle:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Triangle, /) -> None: ...

    def writeCells(self, arg: Mesh_Triangle, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Mesh_Triangle:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Triangle, /) -> None: ...

    def writeCells(self, arg: Mesh_Triangle, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Mesh_Quadrangle:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Quadrangle, /) -> None: ...

    def writeCells(self, arg: Mesh_Quadrangle, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Mesh_Quadrangle:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Quadrangle, /) -> None: ...

    def writeCells(self, arg: Mesh_Quadrangle, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Mesh_Tetrahedron:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Tetrahedron, /) -> None: ...

    def writeCells(self, arg: Mesh_Tetrahedron, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Mesh_Tetrahedron:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Tetrahedron, /) -> None: ...

    def writeCells(self, arg: Mesh_Tetrahedron, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Mesh_Hexahedron:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Hexahedron, /) -> None: ...

    def writeCells(self, arg: Mesh_Hexahedron, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Mesh_Hexahedron:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Hexahedron, /) -> None: ...

    def writeCells(self, arg: Mesh_Hexahedron, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Mesh_Polygon:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Polygon, /) -> None: ...

    def writeCells(self, arg: Mesh_Polygon, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Mesh_Polygon:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Polygon, /) -> None: ...

    def writeCells(self, arg: Mesh_Polygon, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTKWriter_Mesh_Polyhedron:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.binary) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Polyhedron, /) -> None: ...

    def writeCells(self, arg: Mesh_Polyhedron, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class VTUWriter_Mesh_Polyhedron:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    def writeVertices(self, arg: Mesh_Polyhedron, /) -> None: ...

    def writeCells(self, arg: Mesh_Polyhedron, /) -> None: ...

    def writePointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writeDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

class DistributedMesh_Edge:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getLocalMesh(self) -> Mesh_Edge: ...

    def setGhostLevels(self, arg: int, /) -> None: ...

    def getGhostLevels(self) -> int: ...

    def getGlobalPointIndices(self) -> pytnl._containers.Array_int: ...

    def getGlobalCellIndices(self) -> pytnl._containers.Array_int: ...

    def vtkPointGhostTypes(self) -> VTKTypesArrayType: ...

    def vtkCellGhostTypes(self) -> VTKTypesArrayType: ...

class DistributedMesh_Triangle:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getLocalMesh(self) -> Mesh_Triangle: ...

    def setGhostLevels(self, arg: int, /) -> None: ...

    def getGhostLevels(self) -> int: ...

    def getGlobalPointIndices(self) -> pytnl._containers.Array_int: ...

    def getGlobalCellIndices(self) -> pytnl._containers.Array_int: ...

    def vtkPointGhostTypes(self) -> VTKTypesArrayType: ...

    def vtkCellGhostTypes(self) -> VTKTypesArrayType: ...

class DistributedMesh_Quadrangle:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getLocalMesh(self) -> Mesh_Quadrangle: ...

    def setGhostLevels(self, arg: int, /) -> None: ...

    def getGhostLevels(self) -> int: ...

    def getGlobalPointIndices(self) -> pytnl._containers.Array_int: ...

    def getGlobalCellIndices(self) -> pytnl._containers.Array_int: ...

    def vtkPointGhostTypes(self) -> VTKTypesArrayType: ...

    def vtkCellGhostTypes(self) -> VTKTypesArrayType: ...

class DistributedMesh_Tetrahedron:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getLocalMesh(self) -> Mesh_Tetrahedron: ...

    def setGhostLevels(self, arg: int, /) -> None: ...

    def getGhostLevels(self) -> int: ...

    def getGlobalPointIndices(self) -> pytnl._containers.Array_int: ...

    def getGlobalCellIndices(self) -> pytnl._containers.Array_int: ...

    def vtkPointGhostTypes(self) -> VTKTypesArrayType: ...

    def vtkCellGhostTypes(self) -> VTKTypesArrayType: ...

class DistributedMesh_Hexahedron:
    def __init__(self) -> None: ...

    @staticmethod
    def getMeshDimension() -> int: ...

    def getLocalMesh(self) -> Mesh_Hexahedron: ...

    def setGhostLevels(self, arg: int, /) -> None: ...

    def getGhostLevels(self) -> int: ...

    def getGlobalPointIndices(self) -> pytnl._containers.Array_int: ...

    def getGlobalCellIndices(self) -> pytnl._containers.Array_int: ...

    def vtkPointGhostTypes(self) -> VTKTypesArrayType: ...

    def vtkCellGhostTypes(self) -> VTKTypesArrayType: ...

class VTKTypesArrayType:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, size: int) -> None: ...

    @overload
    def __init__(self, size: int, value: int) -> None: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    def getSize(self) -> int: ...

    def setSize(self, size: int) -> None: ...

    def setLike(self, arg: VTKTypesArrayType, /) -> None: ...

    @overload
    def resize(self, size: int) -> None: ...

    @overload
    def resize(self, size: int, value: int) -> None: ...

    def swap(self, arg: VTKTypesArrayType, /) -> None: ...

    def reset(self) -> None: ...

    def empty(self) -> bool: ...

    def setElement(self, i: int, value: int) -> None: ...

    def getElement(self, i: int) -> int: ...

    def assign(self, arg: VTKTypesArrayType, /) -> VTKTypesArrayType: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: int, begin: int = 0, end: int = 0) -> None: ...

    @staticmethod
    def getSerializationType() -> str: ...

    def save(self, arg: str, /) -> None: ...

    def load(self, arg: str, /) -> None: ...

    def __str__(self) -> str: ...

    def __copy__(self) -> VTKTypesArrayType: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> VTKTypesArrayType: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this Array with shared memory (i.e. the data is not copied)
        """

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[int]: ...

    @overload
    def __getitem__(self, arg: int, /) -> int: ...

    @overload
    def __getitem__(self, arg: slice, /) -> VTKTypesArrayType:
        """Retrieve list elements using a slice object"""

    @overload
    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @overload
    def __setitem__(self, arg0: slice, arg1: VTKTypesArrayType, /) -> None:
        """Assign list elements using a slice object"""

class PVTUWriter_Mesh_Edge:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    @overload
    def writeVertices(self, distributedMesh: DistributedMesh_Edge) -> None: ...

    @overload
    def writeVertices(self, localMesh: Mesh_Edge, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    @overload
    def writeCells(self, distributedMesh: DistributedMesh_Edge) -> None: ...

    @overload
    def writeCells(self, localMesh: Mesh_Edge, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    def writePPointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def addPiece(self, mainFileName: str, subdomainIndex: int) -> str: ...

class PVTUWriter_Mesh_Triangle:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    @overload
    def writeVertices(self, distributedMesh: DistributedMesh_Triangle) -> None: ...

    @overload
    def writeVertices(self, localMesh: Mesh_Triangle, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    @overload
    def writeCells(self, distributedMesh: DistributedMesh_Triangle) -> None: ...

    @overload
    def writeCells(self, localMesh: Mesh_Triangle, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    def writePPointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def addPiece(self, mainFileName: str, subdomainIndex: int) -> str: ...

class PVTUWriter_Mesh_Quadrangle:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    @overload
    def writeVertices(self, distributedMesh: DistributedMesh_Quadrangle) -> None: ...

    @overload
    def writeVertices(self, localMesh: Mesh_Quadrangle, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    @overload
    def writeCells(self, distributedMesh: DistributedMesh_Quadrangle) -> None: ...

    @overload
    def writeCells(self, localMesh: Mesh_Quadrangle, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    def writePPointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def addPiece(self, mainFileName: str, subdomainIndex: int) -> str: ...

class PVTUWriter_Mesh_Tetrahedron:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    @overload
    def writeVertices(self, distributedMesh: DistributedMesh_Tetrahedron) -> None: ...

    @overload
    def writeVertices(self, localMesh: Mesh_Tetrahedron, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    @overload
    def writeCells(self, distributedMesh: DistributedMesh_Tetrahedron) -> None: ...

    @overload
    def writeCells(self, localMesh: Mesh_Tetrahedron, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    def writePPointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def addPiece(self, mainFileName: str, subdomainIndex: int) -> str: ...

class PVTUWriter_Mesh_Hexahedron:
    def __init__(self, stream: object, *, format: VTKFileFormat = VTKFileFormat.zlib_compressed) -> None: ...

    def writeMetadata(self, *, cycle: int = -1, time: float = -1) -> None: ...

    @overload
    def writeVertices(self, distributedMesh: DistributedMesh_Hexahedron) -> None: ...

    @overload
    def writeVertices(self, localMesh: Mesh_Hexahedron, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    @overload
    def writeCells(self, distributedMesh: DistributedMesh_Hexahedron) -> None: ...

    @overload
    def writeCells(self, localMesh: Mesh_Hexahedron, GhostLevel: int = 0, MinCommonVertices: int = 0) -> None: ...

    def writePPointData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePCellData(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def writePDataArray(self, array: Sequence[int] | Sequence[float], name: str, numberOfComponents: int = 1) -> None: ...

    def addPiece(self, mainFileName: str, subdomainIndex: int) -> str: ...

def resolveMeshType(file_name: str, *, file_format: str = 'auto') -> tuple[MeshReader, type]:
    """
    Returns a `(reader, mesh)` pair where `reader` is initialized with the given file name (using `getMeshReader`) and `mesh` is empty.
    """

def resolveAndLoadMesh(file_name: str, *, file_format: str = 'auto') -> tuple[MeshReader, type]:
    """
    Returns a `(reader, mesh)` pair where `reader` is initialized with the given file name (using `getMeshReader`) and `mesh` contains the mesh loaded from the given file (using `reader.loadMesh(mesh)`).
    """

@overload
def distributeFaces(arg: DistributedMesh_Triangle, /) -> None: ...

@overload
def distributeFaces(arg: DistributedMesh_Quadrangle, /) -> None: ...

@overload
def distributeFaces(arg: DistributedMesh_Tetrahedron, /) -> None: ...

@overload
def distributeFaces(arg: DistributedMesh_Hexahedron, /) -> None: ...
