from collections.abc import Callable, Iterator, Sequence
from typing import Any, overload

import numpy.typing
import typing_extensions


class Array_bool:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, size: int) -> None: ...

    @overload
    def __init__(self, size: int, value: bool) -> None: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    def getSize(self) -> int: ...

    def setSize(self, size: int) -> None: ...

    def setLike(self, arg: Array_bool, /) -> None: ...

    @overload
    def resize(self, size: int) -> None: ...

    @overload
    def resize(self, size: int, value: bool) -> None: ...

    def swap(self, arg: Array_bool, /) -> None: ...

    def reset(self) -> None: ...

    def empty(self) -> bool: ...

    def setElement(self, i: int, value: bool) -> None: ...

    def getElement(self, i: int) -> bool: ...

    def assign(self, arg: Array_bool, /) -> Array_bool: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: bool, begin: int = 0, end: int = 0) -> None: ...

    @staticmethod
    def getSerializationType() -> str: ...

    def save(self, arg: str, /) -> None: ...

    def load(self, arg: str, /) -> None: ...

    def __str__(self) -> str: ...

    def __copy__(self) -> Array_bool: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> Array_bool: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this Array with shared memory (i.e. the data is not copied)
        """

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[bool]: ...

    @overload
    def __getitem__(self, arg: int, /) -> bool: ...

    @overload
    def __getitem__(self, arg: slice, /) -> Array_bool:
        """Retrieve list elements using a slice object"""

    @overload
    def __setitem__(self, arg0: int, arg1: bool, /) -> None: ...

    @overload
    def __setitem__(self, arg0: slice, arg1: Array_bool, /) -> None:
        """Assign list elements using a slice object"""

class Array_int:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, size: int) -> None: ...

    @overload
    def __init__(self, size: int, value: int) -> None: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    def getSize(self) -> int: ...

    def setSize(self, size: int) -> None: ...

    def setLike(self, arg: Array_int, /) -> None: ...

    @overload
    def resize(self, size: int) -> None: ...

    @overload
    def resize(self, size: int, value: int) -> None: ...

    def swap(self, arg: Array_int, /) -> None: ...

    def reset(self) -> None: ...

    def empty(self) -> bool: ...

    def setElement(self, i: int, value: int) -> None: ...

    def getElement(self, i: int) -> int: ...

    def assign(self, arg: Array_int, /) -> Array_int: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: int, begin: int = 0, end: int = 0) -> None: ...

    @staticmethod
    def getSerializationType() -> str: ...

    def save(self, arg: str, /) -> None: ...

    def load(self, arg: str, /) -> None: ...

    def __str__(self) -> str: ...

    def __copy__(self) -> Array_int: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> Array_int: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this Array with shared memory (i.e. the data is not copied)
        """

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[int]: ...

    @overload
    def __getitem__(self, arg: int, /) -> int: ...

    @overload
    def __getitem__(self, arg: slice, /) -> Array_int:
        """Retrieve list elements using a slice object"""

    @overload
    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @overload
    def __setitem__(self, arg0: slice, arg1: Array_int, /) -> None:
        """Assign list elements using a slice object"""

class Array_float:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, size: int) -> None: ...

    @overload
    def __init__(self, size: int, value: float) -> None: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    def getSize(self) -> int: ...

    def setSize(self, size: int) -> None: ...

    def setLike(self, arg: Array_float, /) -> None: ...

    @overload
    def resize(self, size: int) -> None: ...

    @overload
    def resize(self, size: int, value: float) -> None: ...

    def swap(self, arg: Array_float, /) -> None: ...

    def reset(self) -> None: ...

    def empty(self) -> bool: ...

    def setElement(self, i: int, value: float) -> None: ...

    def getElement(self, i: int) -> float: ...

    def assign(self, arg: Array_float, /) -> Array_float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: float, begin: int = 0, end: int = 0) -> None: ...

    @staticmethod
    def getSerializationType() -> str: ...

    def save(self, arg: str, /) -> None: ...

    def load(self, arg: str, /) -> None: ...

    def __str__(self) -> str: ...

    def __copy__(self) -> Array_float: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> Array_float: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this Array with shared memory (i.e. the data is not copied)
        """

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[float]: ...

    @overload
    def __getitem__(self, arg: int, /) -> float: ...

    @overload
    def __getitem__(self, arg: slice, /) -> Array_float:
        """Retrieve list elements using a slice object"""

    @overload
    def __setitem__(self, arg0: int, arg1: float, /) -> None: ...

    @overload
    def __setitem__(self, arg0: slice, arg1: Array_float, /) -> None:
        """Assign list elements using a slice object"""

class Array_complex:
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, size: int) -> None: ...

    @overload
    def __init__(self, size: int, value: complex) -> None: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    def getSize(self) -> int: ...

    def setSize(self, size: int) -> None: ...

    def setLike(self, arg: Array_complex, /) -> None: ...

    @overload
    def resize(self, size: int) -> None: ...

    @overload
    def resize(self, size: int, value: complex) -> None: ...

    def swap(self, arg: Array_complex, /) -> None: ...

    def reset(self) -> None: ...

    def empty(self) -> bool: ...

    def setElement(self, i: int, value: complex) -> None: ...

    def getElement(self, i: int) -> complex: ...

    def assign(self, arg: Array_complex, /) -> Array_complex: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: complex, begin: int = 0, end: int = 0) -> None: ...

    @staticmethod
    def getSerializationType() -> str: ...

    def save(self, arg: str, /) -> None: ...

    def load(self, arg: str, /) -> None: ...

    def __str__(self) -> str: ...

    def __copy__(self) -> Array_complex: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> Array_complex: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this Array with shared memory (i.e. the data is not copied)
        """

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[complex]: ...

    @overload
    def __getitem__(self, arg: int, /) -> complex: ...

    @overload
    def __getitem__(self, arg: slice, /) -> Array_complex:
        """Retrieve list elements using a slice object"""

    @overload
    def __setitem__(self, arg0: int, arg1: complex, /) -> None: ...

    @overload
    def __setitem__(self, arg0: slice, arg1: Array_complex, /) -> None:
        """Assign list elements using a slice object"""

class Vector_int(Array_int):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, size: int) -> None: ...

    @overload
    def __init__(self, size: int, value: int) -> None: ...

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSerializationType() -> str: ...

    def __copy__(self) -> Vector_int: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> Vector_int: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def __lt__(self, arg: Vector_int, /) -> bool: ...

    def __le__(self, arg: Vector_int, /) -> bool: ...

    def __gt__(self, arg: Vector_int, /) -> bool: ...

    def __ge__(self, arg: Vector_int, /) -> bool: ...

    @overload
    def __iadd__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __iadd__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __isub__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __isub__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __imul__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __imul__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __idiv__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __idiv__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __add__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __add__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __sub__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __sub__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __mul__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __mul__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __truediv__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __truediv__(self, arg: int, /) -> Vector_int: ...

    def __radd__(self, arg: int, /) -> Vector_int: ...

    def __rsub__(self, arg: int, /) -> Vector_int: ...

    def __rmul__(self, arg: int, /) -> Vector_int: ...

    def __rtruediv__(self, arg: int, /) -> Vector_int: ...

    def __pos__(self) -> Vector_int: ...

    def __neg__(self) -> Vector_int: ...

    @overload
    def __mod__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __mod__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __rmod__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __rmod__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __imod__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __imod__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __and__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __and__(self, arg: int, /) -> Vector_int: ...

    def __rand__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __or__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __or__(self, arg: int, /) -> Vector_int: ...

    def __ror__(self, arg: int, /) -> Vector_int: ...

    @overload
    def __xor__(self, arg: Vector_int, /) -> Vector_int: ...

    @overload
    def __xor__(self, arg: int, /) -> Vector_int: ...

    def __rxor__(self, arg: int, /) -> Vector_int: ...

    def __invert__(self) -> Vector_int: ...

    def __abs__(self) -> Vector_int: ...

    def __floor__(self) -> Vector_int: ...

    def __ceil__(self) -> Vector_int: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[int]: ...

    @overload
    def __getitem__(self, arg: int, /) -> int: ...

    @overload
    def __getitem__(self, arg: slice, /) -> Vector_int:
        """Retrieve list elements using a slice object"""

    @overload
    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

    @overload
    def __setitem__(self, arg0: slice, arg1: Vector_int, /) -> None:
        """Assign list elements using a slice object"""

class Vector_float(Array_float):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, size: int) -> None: ...

    @overload
    def __init__(self, size: int, value: float) -> None: ...

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSerializationType() -> str: ...

    def __copy__(self) -> Vector_float: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> Vector_float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def __lt__(self, arg: Vector_float, /) -> bool: ...

    def __le__(self, arg: Vector_float, /) -> bool: ...

    def __gt__(self, arg: Vector_float, /) -> bool: ...

    def __ge__(self, arg: Vector_float, /) -> bool: ...

    @overload
    def __iadd__(self, arg: Vector_float, /) -> Vector_float: ...

    @overload
    def __iadd__(self, arg: float, /) -> Vector_float: ...

    @overload
    def __isub__(self, arg: Vector_float, /) -> Vector_float: ...

    @overload
    def __isub__(self, arg: float, /) -> Vector_float: ...

    @overload
    def __imul__(self, arg: Vector_float, /) -> Vector_float: ...

    @overload
    def __imul__(self, arg: float, /) -> Vector_float: ...

    @overload
    def __idiv__(self, arg: Vector_float, /) -> Vector_float: ...

    @overload
    def __idiv__(self, arg: float, /) -> Vector_float: ...

    @overload
    def __add__(self, arg: Vector_float, /) -> Vector_float: ...

    @overload
    def __add__(self, arg: float, /) -> Vector_float: ...

    @overload
    def __sub__(self, arg: Vector_float, /) -> Vector_float: ...

    @overload
    def __sub__(self, arg: float, /) -> Vector_float: ...

    @overload
    def __mul__(self, arg: Vector_float, /) -> Vector_float: ...

    @overload
    def __mul__(self, arg: float, /) -> Vector_float: ...

    @overload
    def __truediv__(self, arg: Vector_float, /) -> Vector_float: ...

    @overload
    def __truediv__(self, arg: float, /) -> Vector_float: ...

    def __radd__(self, arg: float, /) -> Vector_float: ...

    def __rsub__(self, arg: float, /) -> Vector_float: ...

    def __rmul__(self, arg: float, /) -> Vector_float: ...

    def __rtruediv__(self, arg: float, /) -> Vector_float: ...

    def __pos__(self) -> Vector_float: ...

    def __neg__(self) -> Vector_float: ...

    def __abs__(self) -> Vector_float: ...

    def __floor__(self) -> Vector_float: ...

    def __ceil__(self) -> Vector_float: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[float]: ...

    @overload
    def __getitem__(self, arg: int, /) -> float: ...

    @overload
    def __getitem__(self, arg: slice, /) -> Vector_float:
        """Retrieve list elements using a slice object"""

    @overload
    def __setitem__(self, arg0: int, arg1: float, /) -> None: ...

    @overload
    def __setitem__(self, arg0: slice, arg1: Vector_float, /) -> None:
        """Assign list elements using a slice object"""

class Vector_complex(Array_complex):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, size: int) -> None: ...

    @overload
    def __init__(self, size: int, value: complex) -> None: ...

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSerializationType() -> str: ...

    def __copy__(self) -> Vector_complex: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> Vector_complex: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def __iadd__(self, arg: Vector_complex, /) -> Vector_complex: ...

    @overload
    def __iadd__(self, arg: complex, /) -> Vector_complex: ...

    @overload
    def __isub__(self, arg: Vector_complex, /) -> Vector_complex: ...

    @overload
    def __isub__(self, arg: complex, /) -> Vector_complex: ...

    @overload
    def __imul__(self, arg: Vector_complex, /) -> Vector_complex: ...

    @overload
    def __imul__(self, arg: complex, /) -> Vector_complex: ...

    @overload
    def __idiv__(self, arg: Vector_complex, /) -> Vector_complex: ...

    @overload
    def __idiv__(self, arg: complex, /) -> Vector_complex: ...

    @overload
    def __add__(self, arg: Vector_complex, /) -> Vector_complex: ...

    @overload
    def __add__(self, arg: complex, /) -> Vector_complex: ...

    @overload
    def __sub__(self, arg: Vector_complex, /) -> Vector_complex: ...

    @overload
    def __sub__(self, arg: complex, /) -> Vector_complex: ...

    @overload
    def __mul__(self, arg: Vector_complex, /) -> Vector_complex: ...

    @overload
    def __mul__(self, arg: complex, /) -> Vector_complex: ...

    @overload
    def __truediv__(self, arg: Vector_complex, /) -> Vector_complex: ...

    @overload
    def __truediv__(self, arg: complex, /) -> Vector_complex: ...

    def __radd__(self, arg: complex, /) -> Vector_complex: ...

    def __rsub__(self, arg: complex, /) -> Vector_complex: ...

    def __rmul__(self, arg: complex, /) -> Vector_complex: ...

    def __rtruediv__(self, arg: complex, /) -> Vector_complex: ...

    def __pos__(self) -> Vector_complex: ...

    def __neg__(self) -> Vector_complex: ...

    def __abs__(self) -> Vector_complex: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[complex]: ...

    @overload
    def __getitem__(self, arg: int, /) -> complex: ...

    @overload
    def __getitem__(self, arg: slice, /) -> Vector_complex:
        """Retrieve list elements using a slice object"""

    @overload
    def __setitem__(self, arg0: int, arg1: complex, /) -> None: ...

    @overload
    def __setitem__(self, arg0: slice, arg1: Vector_complex, /) -> None:
        """Assign list elements using a slice object"""

class StaticVector_1_int:
    @overload
    def __init__(self, arg: int, /) -> None: ...

    @overload
    def __init__(self, arg: StaticVector_1_int) -> None: ...

    @overload
    def __init__(self, arg: Sequence[int], /) -> None: ...

    def as_list(self) -> list[int]: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSize() -> int: ...

    def assign(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    def setValue(self, arg: int, /) -> None: ...

    def __copy__(self) -> StaticVector_1_int: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> StaticVector_1_int: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def __lt__(self, arg: StaticVector_1_int, /) -> bool: ...

    def __le__(self, arg: StaticVector_1_int, /) -> bool: ...

    def __gt__(self, arg: StaticVector_1_int, /) -> bool: ...

    def __ge__(self, arg: StaticVector_1_int, /) -> bool: ...

    @overload
    def __iadd__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __iadd__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __isub__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __isub__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __imul__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __imul__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __idiv__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __idiv__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __add__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __add__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __sub__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __sub__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __mul__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __mul__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __truediv__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __truediv__(self, arg: int, /) -> StaticVector_1_int: ...

    def __radd__(self, arg: int, /) -> StaticVector_1_int: ...

    def __rsub__(self, arg: int, /) -> StaticVector_1_int: ...

    def __rmul__(self, arg: int, /) -> StaticVector_1_int: ...

    def __rtruediv__(self, arg: int, /) -> StaticVector_1_int: ...

    def __pos__(self) -> StaticVector_1_int: ...

    def __neg__(self) -> StaticVector_1_int: ...

    @overload
    def __mod__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __mod__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __rmod__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __rmod__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __imod__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __imod__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __and__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __and__(self, arg: int, /) -> StaticVector_1_int: ...

    def __rand__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __or__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __or__(self, arg: int, /) -> StaticVector_1_int: ...

    def __ror__(self, arg: int, /) -> StaticVector_1_int: ...

    @overload
    def __xor__(self, arg: StaticVector_1_int, /) -> StaticVector_1_int: ...

    @overload
    def __xor__(self, arg: int, /) -> StaticVector_1_int: ...

    def __rxor__(self, arg: int, /) -> StaticVector_1_int: ...

    def __invert__(self) -> StaticVector_1_int: ...

    def __abs__(self) -> StaticVector_1_int: ...

    def __floor__(self) -> StaticVector_1_int: ...

    def __ceil__(self) -> StaticVector_1_int: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[int]: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

class StaticVector_2_int:
    @overload
    def __init__(self, arg: int, /) -> None: ...

    @overload
    def __init__(self, arg: StaticVector_2_int) -> None: ...

    @overload
    def __init__(self, arg: Sequence[int], /) -> None: ...

    def as_list(self) -> list[int]: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSize() -> int: ...

    def assign(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    def setValue(self, arg: int, /) -> None: ...

    def __copy__(self) -> StaticVector_2_int: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> StaticVector_2_int: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    @property
    def y(self) -> int: ...

    @y.setter
    def y(self, arg: int, /) -> None: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def __lt__(self, arg: StaticVector_2_int, /) -> bool: ...

    def __le__(self, arg: StaticVector_2_int, /) -> bool: ...

    def __gt__(self, arg: StaticVector_2_int, /) -> bool: ...

    def __ge__(self, arg: StaticVector_2_int, /) -> bool: ...

    @overload
    def __iadd__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __iadd__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __isub__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __isub__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __imul__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __imul__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __idiv__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __idiv__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __add__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __add__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __sub__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __sub__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __mul__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __mul__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __truediv__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __truediv__(self, arg: int, /) -> StaticVector_2_int: ...

    def __radd__(self, arg: int, /) -> StaticVector_2_int: ...

    def __rsub__(self, arg: int, /) -> StaticVector_2_int: ...

    def __rmul__(self, arg: int, /) -> StaticVector_2_int: ...

    def __rtruediv__(self, arg: int, /) -> StaticVector_2_int: ...

    def __pos__(self) -> StaticVector_2_int: ...

    def __neg__(self) -> StaticVector_2_int: ...

    @overload
    def __mod__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __mod__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __rmod__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __rmod__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __imod__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __imod__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __and__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __and__(self, arg: int, /) -> StaticVector_2_int: ...

    def __rand__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __or__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __or__(self, arg: int, /) -> StaticVector_2_int: ...

    def __ror__(self, arg: int, /) -> StaticVector_2_int: ...

    @overload
    def __xor__(self, arg: StaticVector_2_int, /) -> StaticVector_2_int: ...

    @overload
    def __xor__(self, arg: int, /) -> StaticVector_2_int: ...

    def __rxor__(self, arg: int, /) -> StaticVector_2_int: ...

    def __invert__(self) -> StaticVector_2_int: ...

    def __abs__(self) -> StaticVector_2_int: ...

    def __floor__(self) -> StaticVector_2_int: ...

    def __ceil__(self) -> StaticVector_2_int: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[int]: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

class StaticVector_3_int:
    @overload
    def __init__(self, arg: int, /) -> None: ...

    @overload
    def __init__(self, arg: StaticVector_3_int) -> None: ...

    @overload
    def __init__(self, arg: Sequence[int], /) -> None: ...

    def as_list(self) -> list[int]: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSize() -> int: ...

    def assign(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    def setValue(self, arg: int, /) -> None: ...

    def __copy__(self) -> StaticVector_3_int: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> StaticVector_3_int: ...

    @property
    def x(self) -> int: ...

    @x.setter
    def x(self, arg: int, /) -> None: ...

    @property
    def y(self) -> int: ...

    @y.setter
    def y(self, arg: int, /) -> None: ...

    @property
    def z(self) -> int: ...

    @z.setter
    def z(self, arg: int, /) -> None: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def __lt__(self, arg: StaticVector_3_int, /) -> bool: ...

    def __le__(self, arg: StaticVector_3_int, /) -> bool: ...

    def __gt__(self, arg: StaticVector_3_int, /) -> bool: ...

    def __ge__(self, arg: StaticVector_3_int, /) -> bool: ...

    @overload
    def __iadd__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __iadd__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __isub__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __isub__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __imul__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __imul__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __idiv__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __idiv__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __add__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __add__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __sub__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __sub__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __mul__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __mul__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __truediv__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __truediv__(self, arg: int, /) -> StaticVector_3_int: ...

    def __radd__(self, arg: int, /) -> StaticVector_3_int: ...

    def __rsub__(self, arg: int, /) -> StaticVector_3_int: ...

    def __rmul__(self, arg: int, /) -> StaticVector_3_int: ...

    def __rtruediv__(self, arg: int, /) -> StaticVector_3_int: ...

    def __pos__(self) -> StaticVector_3_int: ...

    def __neg__(self) -> StaticVector_3_int: ...

    @overload
    def __mod__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __mod__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __rmod__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __rmod__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __imod__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __imod__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __and__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __and__(self, arg: int, /) -> StaticVector_3_int: ...

    def __rand__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __or__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __or__(self, arg: int, /) -> StaticVector_3_int: ...

    def __ror__(self, arg: int, /) -> StaticVector_3_int: ...

    @overload
    def __xor__(self, arg: StaticVector_3_int, /) -> StaticVector_3_int: ...

    @overload
    def __xor__(self, arg: int, /) -> StaticVector_3_int: ...

    def __rxor__(self, arg: int, /) -> StaticVector_3_int: ...

    def __invert__(self) -> StaticVector_3_int: ...

    def __abs__(self) -> StaticVector_3_int: ...

    def __floor__(self) -> StaticVector_3_int: ...

    def __ceil__(self) -> StaticVector_3_int: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[int]: ...

    def __getitem__(self, arg: int, /) -> int: ...

    def __setitem__(self, arg0: int, arg1: int, /) -> None: ...

class StaticVector_1_float:
    @overload
    def __init__(self, arg: float, /) -> None: ...

    @overload
    def __init__(self, arg: StaticVector_1_float) -> None: ...

    @overload
    def __init__(self, arg: Sequence[float], /) -> None: ...

    def as_list(self) -> list[float]: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSize() -> int: ...

    def assign(self, arg: StaticVector_1_float, /) -> StaticVector_1_float: ...

    def setValue(self, arg: float, /) -> None: ...

    def __copy__(self) -> StaticVector_1_float: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> StaticVector_1_float: ...

    @property
    def x(self) -> float: ...

    @x.setter
    def x(self, arg: float, /) -> None: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def __lt__(self, arg: StaticVector_1_float, /) -> bool: ...

    def __le__(self, arg: StaticVector_1_float, /) -> bool: ...

    def __gt__(self, arg: StaticVector_1_float, /) -> bool: ...

    def __ge__(self, arg: StaticVector_1_float, /) -> bool: ...

    @overload
    def __iadd__(self, arg: StaticVector_1_float, /) -> StaticVector_1_float: ...

    @overload
    def __iadd__(self, arg: float, /) -> StaticVector_1_float: ...

    @overload
    def __isub__(self, arg: StaticVector_1_float, /) -> StaticVector_1_float: ...

    @overload
    def __isub__(self, arg: float, /) -> StaticVector_1_float: ...

    @overload
    def __imul__(self, arg: StaticVector_1_float, /) -> StaticVector_1_float: ...

    @overload
    def __imul__(self, arg: float, /) -> StaticVector_1_float: ...

    @overload
    def __idiv__(self, arg: StaticVector_1_float, /) -> StaticVector_1_float: ...

    @overload
    def __idiv__(self, arg: float, /) -> StaticVector_1_float: ...

    @overload
    def __add__(self, arg: StaticVector_1_float, /) -> StaticVector_1_float: ...

    @overload
    def __add__(self, arg: float, /) -> StaticVector_1_float: ...

    @overload
    def __sub__(self, arg: StaticVector_1_float, /) -> StaticVector_1_float: ...

    @overload
    def __sub__(self, arg: float, /) -> StaticVector_1_float: ...

    @overload
    def __mul__(self, arg: StaticVector_1_float, /) -> StaticVector_1_float: ...

    @overload
    def __mul__(self, arg: float, /) -> StaticVector_1_float: ...

    @overload
    def __truediv__(self, arg: StaticVector_1_float, /) -> StaticVector_1_float: ...

    @overload
    def __truediv__(self, arg: float, /) -> StaticVector_1_float: ...

    def __radd__(self, arg: float, /) -> StaticVector_1_float: ...

    def __rsub__(self, arg: float, /) -> StaticVector_1_float: ...

    def __rmul__(self, arg: float, /) -> StaticVector_1_float: ...

    def __rtruediv__(self, arg: float, /) -> StaticVector_1_float: ...

    def __pos__(self) -> StaticVector_1_float: ...

    def __neg__(self) -> StaticVector_1_float: ...

    def __abs__(self) -> StaticVector_1_float: ...

    def __floor__(self) -> StaticVector_1_float: ...

    def __ceil__(self) -> StaticVector_1_float: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[float]: ...

    def __getitem__(self, arg: int, /) -> float: ...

    def __setitem__(self, arg0: int, arg1: float, /) -> None: ...

class StaticVector_2_float:
    @overload
    def __init__(self, arg: float, /) -> None: ...

    @overload
    def __init__(self, arg: StaticVector_2_float) -> None: ...

    @overload
    def __init__(self, arg: Sequence[float], /) -> None: ...

    def as_list(self) -> list[float]: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSize() -> int: ...

    def assign(self, arg: StaticVector_2_float, /) -> StaticVector_2_float: ...

    def setValue(self, arg: float, /) -> None: ...

    def __copy__(self) -> StaticVector_2_float: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> StaticVector_2_float: ...

    @property
    def x(self) -> float: ...

    @x.setter
    def x(self, arg: float, /) -> None: ...

    @property
    def y(self) -> float: ...

    @y.setter
    def y(self, arg: float, /) -> None: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def __lt__(self, arg: StaticVector_2_float, /) -> bool: ...

    def __le__(self, arg: StaticVector_2_float, /) -> bool: ...

    def __gt__(self, arg: StaticVector_2_float, /) -> bool: ...

    def __ge__(self, arg: StaticVector_2_float, /) -> bool: ...

    @overload
    def __iadd__(self, arg: StaticVector_2_float, /) -> StaticVector_2_float: ...

    @overload
    def __iadd__(self, arg: float, /) -> StaticVector_2_float: ...

    @overload
    def __isub__(self, arg: StaticVector_2_float, /) -> StaticVector_2_float: ...

    @overload
    def __isub__(self, arg: float, /) -> StaticVector_2_float: ...

    @overload
    def __imul__(self, arg: StaticVector_2_float, /) -> StaticVector_2_float: ...

    @overload
    def __imul__(self, arg: float, /) -> StaticVector_2_float: ...

    @overload
    def __idiv__(self, arg: StaticVector_2_float, /) -> StaticVector_2_float: ...

    @overload
    def __idiv__(self, arg: float, /) -> StaticVector_2_float: ...

    @overload
    def __add__(self, arg: StaticVector_2_float, /) -> StaticVector_2_float: ...

    @overload
    def __add__(self, arg: float, /) -> StaticVector_2_float: ...

    @overload
    def __sub__(self, arg: StaticVector_2_float, /) -> StaticVector_2_float: ...

    @overload
    def __sub__(self, arg: float, /) -> StaticVector_2_float: ...

    @overload
    def __mul__(self, arg: StaticVector_2_float, /) -> StaticVector_2_float: ...

    @overload
    def __mul__(self, arg: float, /) -> StaticVector_2_float: ...

    @overload
    def __truediv__(self, arg: StaticVector_2_float, /) -> StaticVector_2_float: ...

    @overload
    def __truediv__(self, arg: float, /) -> StaticVector_2_float: ...

    def __radd__(self, arg: float, /) -> StaticVector_2_float: ...

    def __rsub__(self, arg: float, /) -> StaticVector_2_float: ...

    def __rmul__(self, arg: float, /) -> StaticVector_2_float: ...

    def __rtruediv__(self, arg: float, /) -> StaticVector_2_float: ...

    def __pos__(self) -> StaticVector_2_float: ...

    def __neg__(self) -> StaticVector_2_float: ...

    def __abs__(self) -> StaticVector_2_float: ...

    def __floor__(self) -> StaticVector_2_float: ...

    def __ceil__(self) -> StaticVector_2_float: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[float]: ...

    def __getitem__(self, arg: int, /) -> float: ...

    def __setitem__(self, arg0: int, arg1: float, /) -> None: ...

class StaticVector_3_float:
    @overload
    def __init__(self, arg: float, /) -> None: ...

    @overload
    def __init__(self, arg: StaticVector_3_float) -> None: ...

    @overload
    def __init__(self, arg: Sequence[float], /) -> None: ...

    def as_list(self) -> list[float]: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSize() -> int: ...

    def assign(self, arg: StaticVector_3_float, /) -> StaticVector_3_float: ...

    def setValue(self, arg: float, /) -> None: ...

    def __copy__(self) -> StaticVector_3_float: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> StaticVector_3_float: ...

    @property
    def x(self) -> float: ...

    @x.setter
    def x(self, arg: float, /) -> None: ...

    @property
    def y(self) -> float: ...

    @y.setter
    def y(self, arg: float, /) -> None: ...

    @property
    def z(self) -> float: ...

    @z.setter
    def z(self, arg: float, /) -> None: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def __lt__(self, arg: StaticVector_3_float, /) -> bool: ...

    def __le__(self, arg: StaticVector_3_float, /) -> bool: ...

    def __gt__(self, arg: StaticVector_3_float, /) -> bool: ...

    def __ge__(self, arg: StaticVector_3_float, /) -> bool: ...

    @overload
    def __iadd__(self, arg: StaticVector_3_float, /) -> StaticVector_3_float: ...

    @overload
    def __iadd__(self, arg: float, /) -> StaticVector_3_float: ...

    @overload
    def __isub__(self, arg: StaticVector_3_float, /) -> StaticVector_3_float: ...

    @overload
    def __isub__(self, arg: float, /) -> StaticVector_3_float: ...

    @overload
    def __imul__(self, arg: StaticVector_3_float, /) -> StaticVector_3_float: ...

    @overload
    def __imul__(self, arg: float, /) -> StaticVector_3_float: ...

    @overload
    def __idiv__(self, arg: StaticVector_3_float, /) -> StaticVector_3_float: ...

    @overload
    def __idiv__(self, arg: float, /) -> StaticVector_3_float: ...

    @overload
    def __add__(self, arg: StaticVector_3_float, /) -> StaticVector_3_float: ...

    @overload
    def __add__(self, arg: float, /) -> StaticVector_3_float: ...

    @overload
    def __sub__(self, arg: StaticVector_3_float, /) -> StaticVector_3_float: ...

    @overload
    def __sub__(self, arg: float, /) -> StaticVector_3_float: ...

    @overload
    def __mul__(self, arg: StaticVector_3_float, /) -> StaticVector_3_float: ...

    @overload
    def __mul__(self, arg: float, /) -> StaticVector_3_float: ...

    @overload
    def __truediv__(self, arg: StaticVector_3_float, /) -> StaticVector_3_float: ...

    @overload
    def __truediv__(self, arg: float, /) -> StaticVector_3_float: ...

    def __radd__(self, arg: float, /) -> StaticVector_3_float: ...

    def __rsub__(self, arg: float, /) -> StaticVector_3_float: ...

    def __rmul__(self, arg: float, /) -> StaticVector_3_float: ...

    def __rtruediv__(self, arg: float, /) -> StaticVector_3_float: ...

    def __pos__(self) -> StaticVector_3_float: ...

    def __neg__(self) -> StaticVector_3_float: ...

    def __abs__(self) -> StaticVector_3_float: ...

    def __floor__(self) -> StaticVector_3_float: ...

    def __ceil__(self) -> StaticVector_3_float: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[float]: ...

    def __getitem__(self, arg: int, /) -> float: ...

    def __setitem__(self, arg0: int, arg1: float, /) -> None: ...

class StaticVector_1_complex:
    @overload
    def __init__(self, arg: complex, /) -> None: ...

    @overload
    def __init__(self, arg: StaticVector_1_complex) -> None: ...

    @overload
    def __init__(self, arg: Sequence[complex], /) -> None: ...

    def as_list(self) -> list[complex]: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSize() -> int: ...

    def assign(self, arg: StaticVector_1_complex, /) -> StaticVector_1_complex: ...

    def setValue(self, arg: complex, /) -> None: ...

    def __copy__(self) -> StaticVector_1_complex: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> StaticVector_1_complex: ...

    @property
    def x(self) -> complex: ...

    @x.setter
    def x(self, arg: complex, /) -> None: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def __iadd__(self, arg: StaticVector_1_complex, /) -> StaticVector_1_complex: ...

    @overload
    def __iadd__(self, arg: complex, /) -> StaticVector_1_complex: ...

    @overload
    def __isub__(self, arg: StaticVector_1_complex, /) -> StaticVector_1_complex: ...

    @overload
    def __isub__(self, arg: complex, /) -> StaticVector_1_complex: ...

    @overload
    def __imul__(self, arg: StaticVector_1_complex, /) -> StaticVector_1_complex: ...

    @overload
    def __imul__(self, arg: complex, /) -> StaticVector_1_complex: ...

    @overload
    def __idiv__(self, arg: StaticVector_1_complex, /) -> StaticVector_1_complex: ...

    @overload
    def __idiv__(self, arg: complex, /) -> StaticVector_1_complex: ...

    @overload
    def __add__(self, arg: StaticVector_1_complex, /) -> StaticVector_1_complex: ...

    @overload
    def __add__(self, arg: complex, /) -> StaticVector_1_complex: ...

    @overload
    def __sub__(self, arg: StaticVector_1_complex, /) -> StaticVector_1_complex: ...

    @overload
    def __sub__(self, arg: complex, /) -> StaticVector_1_complex: ...

    @overload
    def __mul__(self, arg: StaticVector_1_complex, /) -> StaticVector_1_complex: ...

    @overload
    def __mul__(self, arg: complex, /) -> StaticVector_1_complex: ...

    @overload
    def __truediv__(self, arg: StaticVector_1_complex, /) -> StaticVector_1_complex: ...

    @overload
    def __truediv__(self, arg: complex, /) -> StaticVector_1_complex: ...

    def __radd__(self, arg: complex, /) -> StaticVector_1_complex: ...

    def __rsub__(self, arg: complex, /) -> StaticVector_1_complex: ...

    def __rmul__(self, arg: complex, /) -> StaticVector_1_complex: ...

    def __rtruediv__(self, arg: complex, /) -> StaticVector_1_complex: ...

    def __pos__(self) -> StaticVector_1_complex: ...

    def __neg__(self) -> StaticVector_1_complex: ...

    def __abs__(self) -> StaticVector_1_complex: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[complex]: ...

    def __getitem__(self, arg: int, /) -> complex: ...

    def __setitem__(self, arg0: int, arg1: complex, /) -> None: ...

class StaticVector_2_complex:
    @overload
    def __init__(self, arg: complex, /) -> None: ...

    @overload
    def __init__(self, arg: StaticVector_2_complex) -> None: ...

    @overload
    def __init__(self, arg: Sequence[complex], /) -> None: ...

    def as_list(self) -> list[complex]: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSize() -> int: ...

    def assign(self, arg: StaticVector_2_complex, /) -> StaticVector_2_complex: ...

    def setValue(self, arg: complex, /) -> None: ...

    def __copy__(self) -> StaticVector_2_complex: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> StaticVector_2_complex: ...

    @property
    def x(self) -> complex: ...

    @x.setter
    def x(self, arg: complex, /) -> None: ...

    @property
    def y(self) -> complex: ...

    @y.setter
    def y(self, arg: complex, /) -> None: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def __iadd__(self, arg: StaticVector_2_complex, /) -> StaticVector_2_complex: ...

    @overload
    def __iadd__(self, arg: complex, /) -> StaticVector_2_complex: ...

    @overload
    def __isub__(self, arg: StaticVector_2_complex, /) -> StaticVector_2_complex: ...

    @overload
    def __isub__(self, arg: complex, /) -> StaticVector_2_complex: ...

    @overload
    def __imul__(self, arg: StaticVector_2_complex, /) -> StaticVector_2_complex: ...

    @overload
    def __imul__(self, arg: complex, /) -> StaticVector_2_complex: ...

    @overload
    def __idiv__(self, arg: StaticVector_2_complex, /) -> StaticVector_2_complex: ...

    @overload
    def __idiv__(self, arg: complex, /) -> StaticVector_2_complex: ...

    @overload
    def __add__(self, arg: StaticVector_2_complex, /) -> StaticVector_2_complex: ...

    @overload
    def __add__(self, arg: complex, /) -> StaticVector_2_complex: ...

    @overload
    def __sub__(self, arg: StaticVector_2_complex, /) -> StaticVector_2_complex: ...

    @overload
    def __sub__(self, arg: complex, /) -> StaticVector_2_complex: ...

    @overload
    def __mul__(self, arg: StaticVector_2_complex, /) -> StaticVector_2_complex: ...

    @overload
    def __mul__(self, arg: complex, /) -> StaticVector_2_complex: ...

    @overload
    def __truediv__(self, arg: StaticVector_2_complex, /) -> StaticVector_2_complex: ...

    @overload
    def __truediv__(self, arg: complex, /) -> StaticVector_2_complex: ...

    def __radd__(self, arg: complex, /) -> StaticVector_2_complex: ...

    def __rsub__(self, arg: complex, /) -> StaticVector_2_complex: ...

    def __rmul__(self, arg: complex, /) -> StaticVector_2_complex: ...

    def __rtruediv__(self, arg: complex, /) -> StaticVector_2_complex: ...

    def __pos__(self) -> StaticVector_2_complex: ...

    def __neg__(self) -> StaticVector_2_complex: ...

    def __abs__(self) -> StaticVector_2_complex: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[complex]: ...

    def __getitem__(self, arg: int, /) -> complex: ...

    def __setitem__(self, arg0: int, arg1: complex, /) -> None: ...

class StaticVector_3_complex:
    @overload
    def __init__(self, arg: complex, /) -> None: ...

    @overload
    def __init__(self, arg: StaticVector_3_complex) -> None: ...

    @overload
    def __init__(self, arg: Sequence[complex], /) -> None: ...

    def as_list(self) -> list[complex]: ...

    IndexType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    RealType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getSize() -> int: ...

    def assign(self, arg: StaticVector_3_complex, /) -> StaticVector_3_complex: ...

    def setValue(self, arg: complex, /) -> None: ...

    def __copy__(self) -> StaticVector_3_complex: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> StaticVector_3_complex: ...

    @property
    def x(self) -> complex: ...

    @x.setter
    def x(self, arg: complex, /) -> None: ...

    @property
    def y(self) -> complex: ...

    @y.setter
    def y(self, arg: complex, /) -> None: ...

    @property
    def z(self) -> complex: ...

    @z.setter
    def z(self, arg: complex, /) -> None: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    @overload
    def __iadd__(self, arg: StaticVector_3_complex, /) -> StaticVector_3_complex: ...

    @overload
    def __iadd__(self, arg: complex, /) -> StaticVector_3_complex: ...

    @overload
    def __isub__(self, arg: StaticVector_3_complex, /) -> StaticVector_3_complex: ...

    @overload
    def __isub__(self, arg: complex, /) -> StaticVector_3_complex: ...

    @overload
    def __imul__(self, arg: StaticVector_3_complex, /) -> StaticVector_3_complex: ...

    @overload
    def __imul__(self, arg: complex, /) -> StaticVector_3_complex: ...

    @overload
    def __idiv__(self, arg: StaticVector_3_complex, /) -> StaticVector_3_complex: ...

    @overload
    def __idiv__(self, arg: complex, /) -> StaticVector_3_complex: ...

    @overload
    def __add__(self, arg: StaticVector_3_complex, /) -> StaticVector_3_complex: ...

    @overload
    def __add__(self, arg: complex, /) -> StaticVector_3_complex: ...

    @overload
    def __sub__(self, arg: StaticVector_3_complex, /) -> StaticVector_3_complex: ...

    @overload
    def __sub__(self, arg: complex, /) -> StaticVector_3_complex: ...

    @overload
    def __mul__(self, arg: StaticVector_3_complex, /) -> StaticVector_3_complex: ...

    @overload
    def __mul__(self, arg: complex, /) -> StaticVector_3_complex: ...

    @overload
    def __truediv__(self, arg: StaticVector_3_complex, /) -> StaticVector_3_complex: ...

    @overload
    def __truediv__(self, arg: complex, /) -> StaticVector_3_complex: ...

    def __radd__(self, arg: complex, /) -> StaticVector_3_complex: ...

    def __rsub__(self, arg: complex, /) -> StaticVector_3_complex: ...

    def __rmul__(self, arg: complex, /) -> StaticVector_3_complex: ...

    def __rtruediv__(self, arg: complex, /) -> StaticVector_3_complex: ...

    def __pos__(self) -> StaticVector_3_complex: ...

    def __neg__(self) -> StaticVector_3_complex: ...

    def __abs__(self) -> StaticVector_3_complex: ...

    def __len__(self) -> int: ...

    def __iter__(self) -> Iterator[complex]: ...

    def __getitem__(self, arg: int, /) -> complex: ...

    def __setitem__(self, arg0: int, arg1: complex, /) -> None: ...

class NDArrayIndexer_1:
    @overload
    def __init__(self) -> None:
        """Constructs an empty NDArrayIndexer with zero sizes and strides"""

    @overload
    def __init__(self, sizes: tuple[int], strides: tuple[int], overlaps: tuple[int]) -> None:
        """Constructs with given sizes, strides, and overlaps"""

    IndexType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getDimension() -> int:
        """Returns the dimension of the N-dimensional array, i.e. N"""

    def getSizes(self) -> tuple[int]:
        """Returns the sizes of the array (as a tuple in Python)"""

    def getStrides(self) -> tuple[int]:
        """Returns the strides of the array (as a tuple in Python)"""

    def getOverlaps(self) -> tuple[int]:
        """Returns the overlaps of the array (as a tuple in Python)"""

    def getStorageSize(self) -> int:
        """Returns the total size needed to store the array"""

    def getStorageIndex(self, *indices: int) -> int:
        """Computes the linear storage index from N-dimensional indices"""

    def isContiguousBlock(self, begins: tuple[int], ends: tuple[int]) -> bool:
        """Checks if a given block is contiguous"""

    def __str__(self) -> str:
        """Returns a readable string representation of the indexer"""

class NDArrayIndexer_2:
    @overload
    def __init__(self) -> None:
        """Constructs an empty NDArrayIndexer with zero sizes and strides"""

    @overload
    def __init__(self, sizes: tuple[int, int], strides: tuple[int, int], overlaps: tuple[int, int]) -> None:
        """Constructs with given sizes, strides, and overlaps"""

    IndexType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getDimension() -> int:
        """Returns the dimension of the N-dimensional array, i.e. N"""

    def getSizes(self) -> tuple[int, int]:
        """Returns the sizes of the array (as a tuple in Python)"""

    def getStrides(self) -> tuple[int, int]:
        """Returns the strides of the array (as a tuple in Python)"""

    def getOverlaps(self) -> tuple[int, int]:
        """Returns the overlaps of the array (as a tuple in Python)"""

    def getStorageSize(self) -> int:
        """Returns the total size needed to store the array"""

    def getStorageIndex(self, *indices: int) -> int:
        """Computes the linear storage index from N-dimensional indices"""

    def isContiguousBlock(self, begins: tuple[int, int], ends: tuple[int, int]) -> bool:
        """Checks if a given block is contiguous"""

    def __str__(self) -> str:
        """Returns a readable string representation of the indexer"""

class NDArrayIndexer_3:
    @overload
    def __init__(self) -> None:
        """Constructs an empty NDArrayIndexer with zero sizes and strides"""

    @overload
    def __init__(self, sizes: tuple[int, int, int], strides: tuple[int, int, int], overlaps: tuple[int, int, int]) -> None:
        """Constructs with given sizes, strides, and overlaps"""

    IndexType: type = ...
    """(arg: object, /) -> type"""

    @staticmethod
    def getDimension() -> int:
        """Returns the dimension of the N-dimensional array, i.e. N"""

    def getSizes(self) -> tuple[int, int, int]:
        """Returns the sizes of the array (as a tuple in Python)"""

    def getStrides(self) -> tuple[int, int, int]:
        """Returns the strides of the array (as a tuple in Python)"""

    def getOverlaps(self) -> tuple[int, int, int]:
        """Returns the overlaps of the array (as a tuple in Python)"""

    def getStorageSize(self) -> int:
        """Returns the total size needed to store the array"""

    def getStorageIndex(self, *indices: int) -> int:
        """Computes the linear storage index from N-dimensional indices"""

    def isContiguousBlock(self, begins: tuple[int, int, int], ends: tuple[int, int, int]) -> bool:
        """Checks if a given block is contiguous"""

    def __str__(self) -> str:
        """Returns a readable string representation of the indexer"""

class NDArray_1_int(NDArrayIndexer_1):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, other: NDArray_1_int) -> None: ...

    IndexerType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    @overload
    def setSizes(self, sizes: tuple[int]) -> None:
        """
        Set sizes of the array using an instance of SizesHolder (a tuple of ints in Python)
        """

    @overload
    def setSizes(self, *sizes: int) -> None:
        """Set sizes of the array using a sequence of ints"""

    def setLike(self, other: NDArray_1_int) -> None: ...

    def reset(self) -> None:
        """
        Reset the array to the empty state. The current data will be deallocated, thus all pointers and views to the array elements will become invalid.
        """

    def assign(self, arg: NDArray_1_int, /) -> NDArray_1_int: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: int) -> None: ...

    def getStorageArray(self) -> Array_int:
        """Return a reference to the underlying storage array."""

    def __str__(self) -> str:
        """Returns a readable string representation of the array"""

    def __copy__(self) -> NDArray_1_int: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> NDArray_1_int: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this NDArray with shared memory (i.e. the data is not copied)
        """

    def __getitem__(self, indices: object) -> int: ...

    def __setitem__(self, indices: object, value: int) -> None: ...

    def forAll(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements of the array. The function is called with N indices, where N is the array dimension.
        """

    @overload
    def forInterior(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all interior elements of the array. Excludes one element from each side of each dimension.
        """

    @overload
    def forInterior(self, begins: tuple[int], ends: tuple[int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements inside the given N-dimensional range `[begins, ends)`.
        """

    @overload
    def forBoundary(self, f: Callable[..., Any]) -> None:
        """Evaluates the function `f` for all boundary elements of the array."""

    @overload
    def forBoundary(self, skipBegins: tuple[int], skipEnds: tuple[int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements outside the given N-dimensional range `[skipBegins, skipEnds)`.
        """

class NDArray_2_int(NDArrayIndexer_2):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, other: NDArray_2_int) -> None: ...

    IndexerType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    @overload
    def setSizes(self, sizes: tuple[int, int]) -> None:
        """
        Set sizes of the array using an instance of SizesHolder (a tuple of ints in Python)
        """

    @overload
    def setSizes(self, *sizes: int) -> None:
        """Set sizes of the array using a sequence of ints"""

    def setLike(self, other: NDArray_2_int) -> None: ...

    def reset(self) -> None:
        """
        Reset the array to the empty state. The current data will be deallocated, thus all pointers and views to the array elements will become invalid.
        """

    def assign(self, arg: NDArray_2_int, /) -> NDArray_2_int: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: int) -> None: ...

    def getStorageArray(self) -> Array_int:
        """Return a reference to the underlying storage array."""

    def __str__(self) -> str:
        """Returns a readable string representation of the array"""

    def __copy__(self) -> NDArray_2_int: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> NDArray_2_int: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this NDArray with shared memory (i.e. the data is not copied)
        """

    def __getitem__(self, indices: object) -> int: ...

    def __setitem__(self, indices: object, value: int) -> None: ...

    def forAll(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements of the array. The function is called with N indices, where N is the array dimension.
        """

    @overload
    def forInterior(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all interior elements of the array. Excludes one element from each side of each dimension.
        """

    @overload
    def forInterior(self, begins: tuple[int, int], ends: tuple[int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements inside the given N-dimensional range `[begins, ends)`.
        """

    @overload
    def forBoundary(self, f: Callable[..., Any]) -> None:
        """Evaluates the function `f` for all boundary elements of the array."""

    @overload
    def forBoundary(self, skipBegins: tuple[int, int], skipEnds: tuple[int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements outside the given N-dimensional range `[skipBegins, skipEnds)`.
        """

class NDArray_3_int(NDArrayIndexer_3):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, other: NDArray_3_int) -> None: ...

    IndexerType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    @overload
    def setSizes(self, sizes: tuple[int, int, int]) -> None:
        """
        Set sizes of the array using an instance of SizesHolder (a tuple of ints in Python)
        """

    @overload
    def setSizes(self, *sizes: int) -> None:
        """Set sizes of the array using a sequence of ints"""

    def setLike(self, other: NDArray_3_int) -> None: ...

    def reset(self) -> None:
        """
        Reset the array to the empty state. The current data will be deallocated, thus all pointers and views to the array elements will become invalid.
        """

    def assign(self, arg: NDArray_3_int, /) -> NDArray_3_int: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: int) -> None: ...

    def getStorageArray(self) -> Array_int:
        """Return a reference to the underlying storage array."""

    def __str__(self) -> str:
        """Returns a readable string representation of the array"""

    def __copy__(self) -> NDArray_3_int: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> NDArray_3_int: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this NDArray with shared memory (i.e. the data is not copied)
        """

    def __getitem__(self, indices: object) -> int: ...

    def __setitem__(self, indices: object, value: int) -> None: ...

    def forAll(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements of the array. The function is called with N indices, where N is the array dimension.
        """

    @overload
    def forInterior(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all interior elements of the array. Excludes one element from each side of each dimension.
        """

    @overload
    def forInterior(self, begins: tuple[int, int, int], ends: tuple[int, int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements inside the given N-dimensional range `[begins, ends)`.
        """

    @overload
    def forBoundary(self, f: Callable[..., Any]) -> None:
        """Evaluates the function `f` for all boundary elements of the array."""

    @overload
    def forBoundary(self, skipBegins: tuple[int, int, int], skipEnds: tuple[int, int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements outside the given N-dimensional range `[skipBegins, skipEnds)`.
        """

class NDArray_1_float(NDArrayIndexer_1):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, other: NDArray_1_float) -> None: ...

    IndexerType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    @overload
    def setSizes(self, sizes: tuple[int]) -> None:
        """
        Set sizes of the array using an instance of SizesHolder (a tuple of ints in Python)
        """

    @overload
    def setSizes(self, *sizes: int) -> None:
        """Set sizes of the array using a sequence of ints"""

    def setLike(self, other: NDArray_1_float) -> None: ...

    def reset(self) -> None:
        """
        Reset the array to the empty state. The current data will be deallocated, thus all pointers and views to the array elements will become invalid.
        """

    def assign(self, arg: NDArray_1_float, /) -> NDArray_1_float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: float) -> None: ...

    def getStorageArray(self) -> Array_float:
        """Return a reference to the underlying storage array."""

    def __str__(self) -> str:
        """Returns a readable string representation of the array"""

    def __copy__(self) -> NDArray_1_float: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> NDArray_1_float: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this NDArray with shared memory (i.e. the data is not copied)
        """

    def __getitem__(self, indices: object) -> float: ...

    def __setitem__(self, indices: object, value: float) -> None: ...

    def forAll(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements of the array. The function is called with N indices, where N is the array dimension.
        """

    @overload
    def forInterior(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all interior elements of the array. Excludes one element from each side of each dimension.
        """

    @overload
    def forInterior(self, begins: tuple[int], ends: tuple[int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements inside the given N-dimensional range `[begins, ends)`.
        """

    @overload
    def forBoundary(self, f: Callable[..., Any]) -> None:
        """Evaluates the function `f` for all boundary elements of the array."""

    @overload
    def forBoundary(self, skipBegins: tuple[int], skipEnds: tuple[int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements outside the given N-dimensional range `[skipBegins, skipEnds)`.
        """

class NDArray_2_float(NDArrayIndexer_2):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, other: NDArray_2_float) -> None: ...

    IndexerType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    @overload
    def setSizes(self, sizes: tuple[int, int]) -> None:
        """
        Set sizes of the array using an instance of SizesHolder (a tuple of ints in Python)
        """

    @overload
    def setSizes(self, *sizes: int) -> None:
        """Set sizes of the array using a sequence of ints"""

    def setLike(self, other: NDArray_2_float) -> None: ...

    def reset(self) -> None:
        """
        Reset the array to the empty state. The current data will be deallocated, thus all pointers and views to the array elements will become invalid.
        """

    def assign(self, arg: NDArray_2_float, /) -> NDArray_2_float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: float) -> None: ...

    def getStorageArray(self) -> Array_float:
        """Return a reference to the underlying storage array."""

    def __str__(self) -> str:
        """Returns a readable string representation of the array"""

    def __copy__(self) -> NDArray_2_float: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> NDArray_2_float: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this NDArray with shared memory (i.e. the data is not copied)
        """

    def __getitem__(self, indices: object) -> float: ...

    def __setitem__(self, indices: object, value: float) -> None: ...

    def forAll(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements of the array. The function is called with N indices, where N is the array dimension.
        """

    @overload
    def forInterior(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all interior elements of the array. Excludes one element from each side of each dimension.
        """

    @overload
    def forInterior(self, begins: tuple[int, int], ends: tuple[int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements inside the given N-dimensional range `[begins, ends)`.
        """

    @overload
    def forBoundary(self, f: Callable[..., Any]) -> None:
        """Evaluates the function `f` for all boundary elements of the array."""

    @overload
    def forBoundary(self, skipBegins: tuple[int, int], skipEnds: tuple[int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements outside the given N-dimensional range `[skipBegins, skipEnds)`.
        """

class NDArray_3_float(NDArrayIndexer_3):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, other: NDArray_3_float) -> None: ...

    IndexerType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    @overload
    def setSizes(self, sizes: tuple[int, int, int]) -> None:
        """
        Set sizes of the array using an instance of SizesHolder (a tuple of ints in Python)
        """

    @overload
    def setSizes(self, *sizes: int) -> None:
        """Set sizes of the array using a sequence of ints"""

    def setLike(self, other: NDArray_3_float) -> None: ...

    def reset(self) -> None:
        """
        Reset the array to the empty state. The current data will be deallocated, thus all pointers and views to the array elements will become invalid.
        """

    def assign(self, arg: NDArray_3_float, /) -> NDArray_3_float: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: float) -> None: ...

    def getStorageArray(self) -> Array_float:
        """Return a reference to the underlying storage array."""

    def __str__(self) -> str:
        """Returns a readable string representation of the array"""

    def __copy__(self) -> NDArray_3_float: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> NDArray_3_float: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this NDArray with shared memory (i.e. the data is not copied)
        """

    def __getitem__(self, indices: object) -> float: ...

    def __setitem__(self, indices: object, value: float) -> None: ...

    def forAll(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements of the array. The function is called with N indices, where N is the array dimension.
        """

    @overload
    def forInterior(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all interior elements of the array. Excludes one element from each side of each dimension.
        """

    @overload
    def forInterior(self, begins: tuple[int, int, int], ends: tuple[int, int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements inside the given N-dimensional range `[begins, ends)`.
        """

    @overload
    def forBoundary(self, f: Callable[..., Any]) -> None:
        """Evaluates the function `f` for all boundary elements of the array."""

    @overload
    def forBoundary(self, skipBegins: tuple[int, int, int], skipEnds: tuple[int, int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements outside the given N-dimensional range `[skipBegins, skipEnds)`.
        """

class NDArray_1_complex(NDArrayIndexer_1):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, other: NDArray_1_complex) -> None: ...

    IndexerType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    @overload
    def setSizes(self, sizes: tuple[int]) -> None:
        """
        Set sizes of the array using an instance of SizesHolder (a tuple of ints in Python)
        """

    @overload
    def setSizes(self, *sizes: int) -> None:
        """Set sizes of the array using a sequence of ints"""

    def setLike(self, other: NDArray_1_complex) -> None: ...

    def reset(self) -> None:
        """
        Reset the array to the empty state. The current data will be deallocated, thus all pointers and views to the array elements will become invalid.
        """

    def assign(self, arg: NDArray_1_complex, /) -> NDArray_1_complex: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: complex) -> None: ...

    def getStorageArray(self) -> Array_complex:
        """Return a reference to the underlying storage array."""

    def __str__(self) -> str:
        """Returns a readable string representation of the array"""

    def __copy__(self) -> NDArray_1_complex: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> NDArray_1_complex: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this NDArray with shared memory (i.e. the data is not copied)
        """

    def __getitem__(self, indices: object) -> complex: ...

    def __setitem__(self, indices: object, value: complex) -> None: ...

    def forAll(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements of the array. The function is called with N indices, where N is the array dimension.
        """

    @overload
    def forInterior(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all interior elements of the array. Excludes one element from each side of each dimension.
        """

    @overload
    def forInterior(self, begins: tuple[int], ends: tuple[int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements inside the given N-dimensional range `[begins, ends)`.
        """

    @overload
    def forBoundary(self, f: Callable[..., Any]) -> None:
        """Evaluates the function `f` for all boundary elements of the array."""

    @overload
    def forBoundary(self, skipBegins: tuple[int], skipEnds: tuple[int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements outside the given N-dimensional range `[skipBegins, skipEnds)`.
        """

class NDArray_2_complex(NDArrayIndexer_2):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, other: NDArray_2_complex) -> None: ...

    IndexerType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    @overload
    def setSizes(self, sizes: tuple[int, int]) -> None:
        """
        Set sizes of the array using an instance of SizesHolder (a tuple of ints in Python)
        """

    @overload
    def setSizes(self, *sizes: int) -> None:
        """Set sizes of the array using a sequence of ints"""

    def setLike(self, other: NDArray_2_complex) -> None: ...

    def reset(self) -> None:
        """
        Reset the array to the empty state. The current data will be deallocated, thus all pointers and views to the array elements will become invalid.
        """

    def assign(self, arg: NDArray_2_complex, /) -> NDArray_2_complex: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: complex) -> None: ...

    def getStorageArray(self) -> Array_complex:
        """Return a reference to the underlying storage array."""

    def __str__(self) -> str:
        """Returns a readable string representation of the array"""

    def __copy__(self) -> NDArray_2_complex: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> NDArray_2_complex: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this NDArray with shared memory (i.e. the data is not copied)
        """

    def __getitem__(self, indices: object) -> complex: ...

    def __setitem__(self, indices: object, value: complex) -> None: ...

    def forAll(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements of the array. The function is called with N indices, where N is the array dimension.
        """

    @overload
    def forInterior(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all interior elements of the array. Excludes one element from each side of each dimension.
        """

    @overload
    def forInterior(self, begins: tuple[int, int], ends: tuple[int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements inside the given N-dimensional range `[begins, ends)`.
        """

    @overload
    def forBoundary(self, f: Callable[..., Any]) -> None:
        """Evaluates the function `f` for all boundary elements of the array."""

    @overload
    def forBoundary(self, skipBegins: tuple[int, int], skipEnds: tuple[int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements outside the given N-dimensional range `[skipBegins, skipEnds)`.
        """

class NDArray_3_complex(NDArrayIndexer_3):
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, other: NDArray_3_complex) -> None: ...

    IndexerType: type = ...
    """(arg: object, /) -> type"""

    ValueType: type = ...
    """(arg: object, /) -> type"""

    @overload
    def setSizes(self, sizes: tuple[int, int, int]) -> None:
        """
        Set sizes of the array using an instance of SizesHolder (a tuple of ints in Python)
        """

    @overload
    def setSizes(self, *sizes: int) -> None:
        """Set sizes of the array using a sequence of ints"""

    def setLike(self, other: NDArray_3_complex) -> None: ...

    def reset(self) -> None:
        """
        Reset the array to the empty state. The current data will be deallocated, thus all pointers and views to the array elements will become invalid.
        """

    def assign(self, arg: NDArray_3_complex, /) -> NDArray_3_complex: ...

    def __eq__(self, arg: object, /) -> bool: ...

    def __ne__(self, arg: object, /) -> bool: ...

    def setValue(self, value: complex) -> None: ...

    def getStorageArray(self) -> Array_complex:
        """Return a reference to the underlying storage array."""

    def __str__(self) -> str:
        """Returns a readable string representation of the array"""

    def __copy__(self) -> NDArray_3_complex: ...

    def __deepcopy__(self, memo: dict[str, Any]) -> NDArray_3_complex: ...

    def __dlpack__(self, **kwargs: Any) -> typing_extensions.CapsuleType: ...

    @staticmethod
    def __dlpack_device__() -> tuple[int, int]: ...

    def as_numpy(self) -> numpy.typing.NDArray[Any]:
        """
        Returns a NumPy ndarray for this NDArray with shared memory (i.e. the data is not copied)
        """

    def __getitem__(self, indices: object) -> complex: ...

    def __setitem__(self, indices: object, value: complex) -> None: ...

    def forAll(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements of the array. The function is called with N indices, where N is the array dimension.
        """

    @overload
    def forInterior(self, f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all interior elements of the array. Excludes one element from each side of each dimension.
        """

    @overload
    def forInterior(self, begins: tuple[int, int, int], ends: tuple[int, int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements inside the given N-dimensional range `[begins, ends)`.
        """

    @overload
    def forBoundary(self, f: Callable[..., Any]) -> None:
        """Evaluates the function `f` for all boundary elements of the array."""

    @overload
    def forBoundary(self, skipBegins: tuple[int, int, int], skipEnds: tuple[int, int, int], f: Callable[..., Any]) -> None:
        """
        Evaluates the function `f` for all elements outside the given N-dimensional range `[skipBegins, skipEnds)`.
        """
