
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was PyTNLConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../../platlib" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(PyTNL_PROJECT_NAME "PyTNL")

# CMake build configuration
set(PyTNL_BUILD_TYPE "Release")

# Compiler configuration
set(PyTNL_C_COMPILER "")
set(PyTNL_C_COMPILER_VERSION )
set(PyTNL_CXX_COMPILER "/usr/bin/g++")
set(PyTNL_CXX_COMPILER_VERSION 15.2.1)

set(PyTNL_C_FLAGS "")
set(PyTNL_C_FLAGS_DEBUG "")
set(PyTNL_C_FLAGS_RELEASE "")
set(PyTNL_C_FLAGS_RELWITHDEBINFO "")
set(PyTNL_CXX_FLAGS "-march=x86-64 -mtune=generic -O2 -pipe -fno-plt -fexceptions         -Wp,-D_FORTIFY_SOURCE=3 -Wformat -Werror=format-security         -fstack-clash-protection -fcf-protection         -fno-omit-frame-pointer -mno-omit-leaf-frame-pointer -Wp,-D_GLIBCXX_ASSERTIONS -g -ffile-prefix-map=/build/python-pytnl/src=/usr/src/debug/python-pytnl -flto=auto -pthread -Wall")
set(PyTNL_CXX_FLAGS_DEBUG "-g")
set(PyTNL_CXX_FLAGS_RELEASE "-O3 -DNDEBUG")
set(PyTNL_CXX_FLAGS_RELWITHDEBINFO "-O3 -DNDEBUG -g")

set(PyTNL_SHARED_LIBRARY_LINK_C_FLAGS "")
set(PyTNL_SHARED_LIBRARY_LINK_C_FLAGS_DEBUG "")
set(PyTNL_SHARED_LIBRARY_LINK_C_FLAGS_RELEASE "")
set(PyTNL_EXE_LINKER_FLAGS "-Wl,-O1 -Wl,--sort-common -Wl,--as-needed -Wl,-z,relro -Wl,-z,now          -Wl,-z,pack-relative-relocs -flto=auto")
set(PyTNL_EXE_LINKER_FLAGS_DEBUG "")
set(PyTNL_EXE_LINKER_FLAGS_RELEASE "")
set(PyTNL_SHARED_LINKER_FLAGS "-Wl,-O1 -Wl,--sort-common -Wl,--as-needed -Wl,-z,relro -Wl,-z,now          -Wl,-z,pack-relative-relocs -flto=auto")
set(PyTNL_SHARED_LINKER_FLAGS_DEBUG "")
set(PyTNL_SHARED_LINKER_FLAGS_RELEASE "")

# Find dependencies
find_package(Python 3 COMPONENTS Interpreter Development REQUIRED)
find_package(TNL REQUIRED)

# Set the install path for Python modules
set(PyTNL_PYTHON_SITE_PACKAGES_DIR lib/python${Python_VERSION_MAJOR}.${Python_VERSION_MINOR}/site-packages)

include(${CMAKE_CURRENT_LIST_DIR}/PyTNLTargets.cmake)
