
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir
_ods_cext.globals.register_traceback_file_exclusion(__file__)

import builtins
from typing import Sequence as _Sequence, Union as _Union, Optional as _Optional


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "arith"

@_ods_cext.register_operation(_Dialect)
class AddFOp(_ods_ir.OpView):
  r"""
  The `addf` operation takes two operands and returns one result, each of
  these is required to be the same type. This type may be a floating point
  scalar type, a vector whose element type is a floating point type, or a
  floating point tensor.
  
  Example:
  
  ```mlir
  // Scalar addition.
  %a = arith.addf %b, %c : f64
  
  // SIMD vector addition, e.g. for Intel SSE.
  %f = arith.addf %g, %h : vector<4xf32>
  
  // Tensor addition.
  %x = arith.addf %y, %z : tensor<4x?xbf16>
  ```
  
  TODO: In the distant future, this will accept optional attributes for fast
  math, contraction, rounding mode, and other controls.
  """

  OPERATION_NAME = "arith.addf"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def addf(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AddFOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AddIOp(_ods_ir.OpView):
  r"""
  Performs N-bit addition on the operands. The operands are interpreted as
  unsigned bitvectors. The result is represented by a bitvector containing the
  mathematical value of the addition modulo 2^n, where `n` is the bitwidth.
  Because `arith` integers use a two's complement representation, this operation
  is applicable on both signed and unsigned integer operands.
  
  The `addi` operation takes two operands and returns one result, each of
  these is required to be the same type. This type may be an integer scalar type,
  a vector whose element type is integer, or a tensor of integers.
  
  This op supports `nuw`/`nsw` overflow flags which stands for
  "No Unsigned Wrap" and "No Signed Wrap", respectively. If the `nuw` and/or
  `nsw` flags are present, and an unsigned/signed overflow occurs
  (respectively), the result is poison.
  
  Example:
  
  ```mlir
  // Scalar addition.
  %a = arith.addi %b, %c : i64
  
  // Scalar addition with overflow flags.
  %a = arith.addi %b, %c overflow<nsw, nuw> : i64
  
  // SIMD vector element-wise addition.
  %f = arith.addi %g, %h : vector<4xi32>
  
  // Tensor element-wise addition.
  %x = arith.addi %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.addi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, overflowFlags=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if overflowFlags is not None: attributes["overflowFlags"] = (overflowFlags if (
        isinstance(overflowFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_IntegerOverflowAttr')) else
          _ods_ir.AttrBuilder.get('Arith_IntegerOverflowAttr')(overflowFlags, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def overflowFlags(self) -> _ods_ir.Attribute:
    return self.operation.attributes["overflowFlags"]

  @overflowFlags.setter
  def overflowFlags(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["overflowFlags"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def addi(lhs, rhs, *, overflow_flags=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AddIOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AddUIExtendedOp(_ods_ir.OpView):
  r"""
  Performs (N+1)-bit addition on zero-extended operands. Returns two results:
  the N-bit sum (same type as both operands), and the overflow bit
  (boolean-like), where `1` indicates unsigned addition overflow, while `0`
  indicates no overflow.
  
  Example:
  
  ```mlir
  // Scalar addition.
  %sum, %overflow = arith.addui_extended %b, %c : i64, i1
  
  // Vector element-wise addition.
  %d:2 = arith.addui_extended %e, %f : vector<4xi32>, vector<4xi1>
  
  // Tensor element-wise addition.
  %x:2 = arith.addui_extended %y, %z : tensor<4x?xi8>, tensor<4x?xi1>
  ```
  """

  OPERATION_NAME = "arith.addui_extended"

  _ODS_REGIONS = (0, True)

  def __init__(self, sum, overflow, lhs, rhs, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(sum)
    results.append(overflow)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def sum(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

  @builtins.property
  def overflow(self) -> _ods_ir.OpResult:
    return self.operation.results[1]

def addui_extended(sum, overflow, lhs, rhs, *, loc=None, ip=None) -> _ods_ir.OpResultList:
  return AddUIExtendedOp(sum=sum, overflow=overflow, lhs=lhs, rhs=rhs, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class AndIOp(_ods_ir.OpView):
  r"""
  The `andi` operation takes two operands and returns one result, each of
  these is required to be the same type. This type may be an integer scalar
  type, a vector whose element type is integer, or a tensor of integers. It
  has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar integer bitwise and.
  %a = arith.andi %b, %c : i64
  
  // SIMD vector element-wise bitwise integer and.
  %f = arith.andi %g, %h : vector<4xi32>
  
  // Tensor element-wise bitwise integer and.
  %x = arith.andi %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.andi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def andi(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return AndIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class BitcastOp(_ods_ir.OpView):
  r"""
  Bitcast an integer or floating point value to an integer or floating point
  value of equal bit width. When operating on vectors, casts elementwise.
  
  Note that this implements a logical bitcast independent of target
  endianness. This allows constant folding without target information and is
  consitent with the bitcast constant folders in LLVM (see
  https://github.com/llvm/llvm-project/blob/18c19414eb/llvm/lib/IR/ConstantFold.cpp#L168)
  For targets where the source and target type have the same endianness (which
  is the standard), this cast will also change no bits at runtime, but it may
  still require an operation, for example if the machine has different
  floating point and integer register files. For targets that have a different
  endianness for the source and target types (e.g. float is big-endian and
  integer is little-endian) a proper lowering would add operations to swap the
  order of words in addition to the bitcast.
  """

  OPERATION_NAME = "arith.bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def bitcast(out, in_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return BitcastOp(out=out, in_=in_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CeilDivSIOp(_ods_ir.OpView):
  r"""
  Signed integer division. Rounds towards positive infinity, i.e. `7 / -2 = -3`.
  
  Divison by zero, or signed division overflow (minimum value divided by -1)
  is undefined behavior. When applied to `vector` and `tensor` values, the
  behavior is undefined if _any_ of its elements are divided by zero or has a
  signed division overflow.
  
  Example:
  
  ```mlir
  // Scalar signed integer division.
  %a = arith.ceildivsi %b, %c : i64
  ```
  """

  OPERATION_NAME = "arith.ceildivsi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def ceildivsi(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CeilDivSIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CeilDivUIOp(_ods_ir.OpView):
  r"""
  Unsigned integer division. Rounds towards positive infinity. Treats the
  leading bit as the most significant, i.e. for `i16` given two's complement
  representation, `6 / -2 = 6 / (2^16 - 2) = 1`.
  
  Division by zero is undefined behavior. When applied to `vector` and
  `tensor` values, the behavior is undefined if _any_ elements are divided by
  zero.
  
  Example:
  
  ```mlir
  // Scalar unsigned integer division.
  %a = arith.ceildivui %b, %c : i64
  ```
  """

  OPERATION_NAME = "arith.ceildivui"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def ceildivui(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CeilDivUIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CmpFOp(_ods_ir.OpView):
  r"""
  The `cmpf` operation compares its two operands according to the float
  comparison rules and the predicate specified by the respective attribute.
  The predicate defines the type of comparison: (un)orderedness, (in)equality
  and signed less/greater than (or equal to) as well as predicates that are
  always true or false.  The operands must have the same type, and this type
  must be a float type, or a vector or tensor thereof.  The result is an i1,
  or a vector/tensor thereof having the same shape as the inputs. Unlike cmpi,
  the operands are always treated as signed. The u prefix indicates
  *unordered* comparison, not unsigned comparison, so "une" means unordered or
  not equal. For the sake of readability by humans, custom assembly form for
  the operation uses a string-typed attribute for the predicate.  The value of
  this attribute corresponds to lower-cased name of the predicate constant,
  e.g., "one" means "ordered not equal".  The string representation of the
  attribute is merely a syntactic sugar and is converted to an integer
  attribute by the parser.
  
  Example:
  
  ```mlir
  %r1 = arith.cmpf oeq, %0, %1 : f32
  %r2 = arith.cmpf ult, %0, %1 : tensor<42x42xf64>
  %r3 = "arith.cmpf"(%0, %1) {predicate: 0} : (f8, f8) -> i1
  ```
  """

  OPERATION_NAME = "arith.cmpf"

  _ODS_REGIONS = (0, True)

  def __init__(self, predicate, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["predicate"] = (predicate if (
    isinstance(predicate, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Arith_CmpFPredicateAttr')) else
      _ods_ir.AttrBuilder.get('Arith_CmpFPredicateAttr')(predicate, context=_ods_context))
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def predicate(self) -> _ods_ir.Attribute:
    return self.operation.attributes["predicate"]

  @predicate.setter
  def predicate(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["predicate"] = value

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def cmpf(predicate, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CmpFOp(predicate=predicate, lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CmpIOp(_ods_ir.OpView):
  r"""
  The `cmpi` operation is a generic comparison for integer-like types. Its two
  arguments can be integers, vectors or tensors thereof as long as their types
  match. The operation produces an i1 for the former case, a vector or a
  tensor of i1 with the same shape as inputs in the other cases.
  
  Its first argument is an attribute that defines which type of comparison is
  performed. The following comparisons are supported:
  
  -   equal (mnemonic: `"eq"`; integer value: `0`)
  -   not equal (mnemonic: `"ne"`; integer value: `1`)
  -   signed less than (mnemonic: `"slt"`; integer value: `2`)
  -   signed less than or equal (mnemonic: `"sle"`; integer value: `3`)
  -   signed greater than (mnemonic: `"sgt"`; integer value: `4`)
  -   signed greater than or equal (mnemonic: `"sge"`; integer value: `5`)
  -   unsigned less than (mnemonic: `"ult"`; integer value: `6`)
  -   unsigned less than or equal (mnemonic: `"ule"`; integer value: `7`)
  -   unsigned greater than (mnemonic: `"ugt"`; integer value: `8`)
  -   unsigned greater than or equal (mnemonic: `"uge"`; integer value: `9`)
  
  The result is `1` if the comparison is true and `0` otherwise. For vector or
  tensor operands, the comparison is performed elementwise and the element of
  the result indicates whether the comparison is true for the operand elements
  with the same indices as those of the result.
  
  Note: while the custom assembly form uses strings, the actual underlying
  attribute has integer type (or rather enum class in C++ code) as seen from
  the generic assembly form. String literals are used to improve readability
  of the IR by humans.
  
  This operation only applies to integer-like operands, but not floats. The
  main reason being that comparison operations have diverging sets of
  attributes: integers require sign specification while floats require various
  floating point-related particularities, e.g., `-ffast-math` behavior,
  IEEE754 compliance, etc
  ([rationale](../Rationale/Rationale.md#splitting-floating-point-vs-integer-operations)).
  The type of comparison is specified as attribute to avoid introducing ten
  similar operations, taking into account that they are often implemented
  using the same operation downstream
  ([rationale](../Rationale/Rationale.md#specifying-comparison-kind-as-attribute)). The
  separation between signed and unsigned order comparisons is necessary
  because of integers being signless. The comparison operation must know how
  to interpret values with the foremost bit being set: negatives in two's
  complement or large positives
  ([rationale](../Rationale/Rationale.md#specifying-sign-in-integer-comparison-operations)).
  
  Example:
  
  ```mlir
  // Custom form of scalar "signed less than" comparison.
  %x = arith.cmpi slt, %lhs, %rhs : i32
  
  // Generic form of the same operation.
  %x = "arith.cmpi"(%lhs, %rhs) {predicate = 2 : i64} : (i32, i32) -> i1
  
  // Custom form of vector equality comparison.
  %x = arith.cmpi eq, %lhs, %rhs : vector<4xi64>
  
  // Generic form of the same operation.
  %x = "arith.cmpi"(%lhs, %rhs) {predicate = 0 : i64}
      : (vector<4xi64>, vector<4xi64>) -> vector<4xi1>
  ```
  """

  OPERATION_NAME = "arith.cmpi"

  _ODS_REGIONS = (0, True)

  def __init__(self, predicate, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["predicate"] = (predicate if (
    isinstance(predicate, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('Arith_CmpIPredicateAttr')) else
      _ods_ir.AttrBuilder.get('Arith_CmpIPredicateAttr')(predicate, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def predicate(self) -> _ods_ir.Attribute:
    return self.operation.attributes["predicate"]

  @predicate.setter
  def predicate(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["predicate"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def cmpi(predicate, lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return CmpIOp(predicate=predicate, lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ConstantOp(_ods_ir.OpView):
  r"""
  The `constant` operation produces an SSA value equal to some integer or
  floating-point constant specified by an attribute. This is the way MLIR
  forms simple integer and floating point constants.
  
  Example:
  
  ```
  // Integer constant
  %1 = arith.constant 42 : i32
  
  // Equivalent generic form
  %1 = "arith.constant"() {value = 42 : i32} : () -> i32
  ```
  """

  OPERATION_NAME = "arith.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypedAttrInterface')) else
      _ods_ir.AttrBuilder.get('TypedAttrInterface')(value, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def value(self) -> _ods_ir.Attribute:
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def constant(value, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ConstantOp(value=value, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DivFOp(_ods_ir.OpView):
  OPERATION_NAME = "arith.divf"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def divf(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return DivFOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DivSIOp(_ods_ir.OpView):
  r"""
  Signed integer division. Rounds towards zero. Treats the leading bit as
  sign, i.e. `6 / -2 = -3`.
  
  Divison by zero, or signed division overflow (minimum value divided by -1)
  is undefined behavior. When applied to `vector` and `tensor` values, the
  behavior is undefined if _any_ of its elements are divided by zero or has a
  signed division overflow.
  
  If the `exact` attribute is present, the result value is poison if `lhs` is
  not a multiple of `rhs`.
  
  Example:
  
  ```mlir
  // Scalar signed integer division.
  %a = arith.divsi %b, %c : i64
  
  // Scalar signed integer division where %b is known to be a multiple of %c.
  %a = arith.divsi %b, %c exact : i64
  
  // SIMD vector element-wise division.
  %f = arith.divsi %g, %h : vector<4xi32>
  
  // Tensor element-wise integer division.
  %x = arith.divsi %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.divsi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, isExact=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(isExact): attributes["isExact"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def isExact(self) -> bool:
    return "isExact" in self.operation.attributes

  @isExact.setter
  def isExact(self, value):
    if bool(value):
      self.operation.attributes["isExact"] = _ods_ir.UnitAttr.get()
    elif "isExact" in self.operation.attributes:
      del self.operation.attributes["isExact"]

  @isExact.deleter
  def isExact(self):
    del self.operation.attributes["isExact"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def divsi(lhs, rhs, *, is_exact=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return DivSIOp(lhs=lhs, rhs=rhs, isExact=is_exact, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class DivUIOp(_ods_ir.OpView):
  r"""
  Unsigned integer division. Rounds towards zero. Treats the leading bit as
  the most significant, i.e. for `i16` given two's complement representation,
  `6 / -2 = 6 / (2^16 - 2) = 0`.
  
  Division by zero is undefined behavior. When applied to `vector` and
  `tensor` values, the behavior is undefined if _any_ elements are divided by
  zero.
  
  If the `exact` attribute is present, the result value is poison if `lhs` is
  not a multiple of `rhs`.
  
  Example:
  
  ```mlir
  // Scalar unsigned integer division.
  %a = arith.divui %b, %c : i64
  
  // Scalar unsigned integer division where %b is known to be a multiple of %c.
  %a = arith.divui %b, %c exact : i64
  
  // SIMD vector element-wise division.
  %f = arith.divui %g, %h : vector<4xi32>
  
  // Tensor element-wise integer division.
  %x = arith.divui %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.divui"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, isExact=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(isExact): attributes["isExact"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def isExact(self) -> bool:
    return "isExact" in self.operation.attributes

  @isExact.setter
  def isExact(self, value):
    if bool(value):
      self.operation.attributes["isExact"] = _ods_ir.UnitAttr.get()
    elif "isExact" in self.operation.attributes:
      del self.operation.attributes["isExact"]

  @isExact.deleter
  def isExact(self):
    del self.operation.attributes["isExact"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def divui(lhs, rhs, *, is_exact=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return DivUIOp(lhs=lhs, rhs=rhs, isExact=is_exact, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExtFOp(_ods_ir.OpView):
  r"""
  Cast a floating-point value to a larger floating-point-typed value.
  The destination type must to be strictly wider than the source type.
  When operating on vectors, casts elementwise.
  """

  OPERATION_NAME = "arith.extf"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, fastmath=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _Optional[_ods_ir.Attribute]:
    if "fastmath" not in self.operation.attributes:
      return None
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["fastmath"] = value
    elif "fastmath" in self.operation.attributes:
      del self.operation.attributes["fastmath"]

  @fastmath.deleter
  def fastmath(self):
    del self.operation.attributes["fastmath"]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def extf(out, in_, *, fastmath=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ExtFOp(out=out, in_=in_, fastmath=fastmath, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExtSIOp(_ods_ir.OpView):
  r"""
  The integer sign extension operation takes an integer input of
  width M and an integer destination type of width N. The destination
  bit-width must be larger than the input bit-width (N > M).
  The top-most (N - M) bits of the output are filled with copies
  of the most-significant bit of the input.
  
  Example:
  
  ```mlir
  %1 = arith.constant 5 : i3      // %1 is 0b101
  %2 = arith.extsi %1 : i3 to i6  // %2 is 0b111101
  %3 = arith.constant 2 : i3      // %3 is 0b010
  %4 = arith.extsi %3 : i3 to i6  // %4 is 0b000010
  
  %5 = arith.extsi %0 : vector<2 x i32> to vector<2 x i64>
  ```
  """

  OPERATION_NAME = "arith.extsi"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def extsi(out, in_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return ExtSIOp(out=out, in_=in_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ExtUIOp(_ods_ir.OpView):
  r"""
  The integer zero extension operation takes an integer input of
  width M and an integer destination type of width N. The destination
  bit-width must be larger than the input bit-width (N > M).
  The top-most (N - M) bits of the output are filled with zeros.
  
  Example:
  
  ```mlir
    %1 = arith.constant 5 : i3      // %1 is 0b101
    %2 = arith.extui %1 : i3 to i6  // %2 is 0b000101
    %3 = arith.constant 2 : i3      // %3 is 0b010
    %4 = arith.extui %3 : i3 to i6  // %4 is 0b000010
  
    %5 = arith.extui %0 : vector<2 x i32> to vector<2 x i64>
  ```
  """

  OPERATION_NAME = "arith.extui"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def extui(out, in_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return ExtUIOp(out=out, in_=in_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FPToSIOp(_ods_ir.OpView):
  r"""
  Cast from a value interpreted as floating-point to the nearest (rounding
  towards zero) signed integer value. When operating on vectors, casts
  elementwise.
  """

  OPERATION_NAME = "arith.fptosi"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def fptosi(out, in_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return FPToSIOp(out=out, in_=in_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FPToUIOp(_ods_ir.OpView):
  r"""
  Cast from a value interpreted as floating-point to the nearest (rounding
  towards zero) unsigned integer value. When operating on vectors, casts
  elementwise.
  """

  OPERATION_NAME = "arith.fptoui"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def fptoui(out, in_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return FPToUIOp(out=out, in_=in_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class FloorDivSIOp(_ods_ir.OpView):
  r"""
  Signed integer division. Rounds towards negative infinity, i.e. `5 / -2 = -3`.
  
  Divison by zero, or signed division overflow (minimum value divided by -1)
  is undefined behavior. When applied to `vector` and `tensor` values, the
  behavior is undefined if _any_ of its elements are divided by zero or has a
  signed division overflow.
  
  Example:
  
  ```mlir
  // Scalar signed integer division.
  %a = arith.floordivsi %b, %c : i64
  
  ```
  """

  OPERATION_NAME = "arith.floordivsi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def floordivsi(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return FloorDivSIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IndexCastOp(_ods_ir.OpView):
  r"""
  Casts between scalar or vector integers and corresponding 'index' scalar or
  vectors. Index is an integer of platform-specific bit width. If casting to
  a wider integer, the value is sign-extended. If casting to a narrower
  integer, the value is truncated.
  """

  OPERATION_NAME = "arith.index_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def index_cast(out, in_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return IndexCastOp(out=out, in_=in_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class IndexCastUIOp(_ods_ir.OpView):
  r"""
  Casts between scalar or vector integers and corresponding 'index' scalar or
  vectors. Index is an integer of platform-specific bit width. If casting to
  a wider integer, the value is zero-extended. If casting to a narrower
  integer, the value is truncated.
  """

  OPERATION_NAME = "arith.index_castui"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def index_castui(out, in_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return IndexCastUIOp(out=out, in_=in_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MaxNumFOp(_ods_ir.OpView):
  r"""
  Returns the maximum of the two arguments.
  If the arguments are -0.0 and +0.0, then the result is either of them.
  If one of the arguments is NaN, then the result is the other argument.
  
  Example:
  
  ```mlir
  // Scalar floating-point maximum.
  %a = arith.maxnumf %b, %c : f64
  ```
  """

  OPERATION_NAME = "arith.maxnumf"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def maxnumf(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MaxNumFOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MaxSIOp(_ods_ir.OpView):
  OPERATION_NAME = "arith.maxsi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def maxsi(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MaxSIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MaxUIOp(_ods_ir.OpView):
  OPERATION_NAME = "arith.maxui"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def maxui(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MaxUIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MaximumFOp(_ods_ir.OpView):
  r"""
  Returns the maximum of the two arguments, treating -0.0 as less than +0.0.
  If one of the arguments is NaN, then the result is also NaN.
  
  Example:
  
  ```mlir
  // Scalar floating-point maximum.
  %a = arith.maximumf %b, %c : f64
  ```
  """

  OPERATION_NAME = "arith.maximumf"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def maximumf(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MaximumFOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MinNumFOp(_ods_ir.OpView):
  r"""
  Returns the minimum of the two arguments.
  If the arguments are -0.0 and +0.0, then the result is either of them.
  If one of the arguments is NaN, then the result is the other argument.
  
  Example:
  
  ```mlir
  // Scalar floating-point minimum.
  %a = arith.minnumf %b, %c : f64
  ```
  """

  OPERATION_NAME = "arith.minnumf"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def minnumf(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MinNumFOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MinSIOp(_ods_ir.OpView):
  OPERATION_NAME = "arith.minsi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def minsi(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MinSIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MinUIOp(_ods_ir.OpView):
  OPERATION_NAME = "arith.minui"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def minui(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MinUIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MinimumFOp(_ods_ir.OpView):
  r"""
  Returns the minimum of the two arguments, treating -0.0 as less than +0.0.
  If one of the arguments is NaN, then the result is also NaN.
  
  Example:
  
  ```mlir
  // Scalar floating-point minimum.
  %a = arith.minimumf %b, %c : f64
  ```
  """

  OPERATION_NAME = "arith.minimumf"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def minimumf(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MinimumFOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MulFOp(_ods_ir.OpView):
  r"""
  The `mulf` operation takes two operands and returns one result, each of
  these is required to be the same type. This type may be a floating point
  scalar type, a vector whose element type is a floating point type, or a
  floating point tensor.
  
  Example:
  
  ```mlir
  // Scalar multiplication.
  %a = arith.mulf %b, %c : f64
  
  // SIMD pointwise vector multiplication, e.g. for Intel SSE.
  %f = arith.mulf %g, %h : vector<4xf32>
  
  // Tensor pointwise multiplication.
  %x = arith.mulf %y, %z : tensor<4x?xbf16>
  ```
  
  TODO: In the distant future, this will accept optional attributes for fast
  math, contraction, rounding mode, and other controls.
  """

  OPERATION_NAME = "arith.mulf"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def mulf(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MulFOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MulIOp(_ods_ir.OpView):
  r"""
  Performs N-bit multiplication on the operands. The operands are interpreted as
  unsigned bitvectors. The result is represented by a bitvector containing the
  mathematical value of the multiplication modulo 2^n, where `n` is the bitwidth.
  Because `arith` integers use a two's complement representation, this operation is
  applicable on both signed and unsigned integer operands.
  
  The `muli` operation takes two operands and returns one result, each of
  these is required to be the same type. This type may be an integer scalar type,
  a vector whose element type is integer, or a tensor of integers.
  
  This op supports `nuw`/`nsw` overflow flags which stands for
  "No Unsigned Wrap" and "No Signed Wrap", respectively. If the `nuw` and/or
  `nsw` flags are present, and an unsigned/signed overflow occurs
  (respectively), the result is poison.
  
  Example:
  
  ```mlir
  // Scalar multiplication.
  %a = arith.muli %b, %c : i64
  
  // Scalar multiplication with overflow flags.
  %a = arith.muli %b, %c overflow<nsw, nuw> : i64
  
  // SIMD vector element-wise multiplication.
  %f = arith.muli %g, %h : vector<4xi32>
  
  // Tensor element-wise multiplication.
  %x = arith.muli %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.muli"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, overflowFlags=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if overflowFlags is not None: attributes["overflowFlags"] = (overflowFlags if (
        isinstance(overflowFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_IntegerOverflowAttr')) else
          _ods_ir.AttrBuilder.get('Arith_IntegerOverflowAttr')(overflowFlags, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def overflowFlags(self) -> _ods_ir.Attribute:
    return self.operation.attributes["overflowFlags"]

  @overflowFlags.setter
  def overflowFlags(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["overflowFlags"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def muli(lhs, rhs, *, overflow_flags=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return MulIOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class MulSIExtendedOp(_ods_ir.OpView):
  r"""
  Performs (2*N)-bit multiplication on sign-extended operands. Returns two
  N-bit results: the low and the high halves of the product. The low half has
  the same value as the result of regular multiplication `arith.muli` with
  the same operands.
  
  Example:
  
  ```mlir
  // Scalar multiplication.
  %low, %high = arith.mulsi_extended %a, %b : i32
  
  // Vector element-wise multiplication.
  %c:2 = arith.mulsi_extended %d, %e : vector<4xi32>
  
  // Tensor element-wise multiplication.
  %x:2 = arith.mulsi_extended %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.mulsi_extended"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def low(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

  @builtins.property
  def high(self) -> _ods_ir.OpResult:
    return self.operation.results[1]

def mulsi_extended(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResultList:
  return MulSIExtendedOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class MulUIExtendedOp(_ods_ir.OpView):
  r"""
  Performs (2*N)-bit multiplication on zero-extended operands. Returns two
  N-bit results: the low and the high halves of the product. The low half has
  the same value as the result of regular multiplication `arith.muli` with
  the same operands.
  
  Example:
  
  ```mlir
  // Scalar multiplication.
  %low, %high = arith.mului_extended %a, %b : i32
  
  // Vector element-wise multiplication.
  %c:2 = arith.mului_extended %d, %e : vector<4xi32>
  
  // Tensor element-wise multiplication.
  %x:2 = arith.mului_extended %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.mului_extended"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def low(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

  @builtins.property
  def high(self) -> _ods_ir.OpResult:
    return self.operation.results[1]

def mului_extended(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResultList:
  return MulUIExtendedOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).results

@_ods_cext.register_operation(_Dialect)
class NegFOp(_ods_ir.OpView):
  r"""
  The `negf` operation computes the negation of a given value. It takes one
  operand and returns one result of the same type. This type may be a float
  scalar type, a vector whose element type is float, or a tensor of floats.
  It has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar negation value.
  %a = arith.negf %b : f64
  
  // SIMD vector element-wise negation value.
  %f = arith.negf %g : vector<4xf32>
  
  // Tensor element-wise negation value.
  %x = arith.negf %y : tensor<4x?xf8>
  ```
  """

  OPERATION_NAME = "arith.negf"

  _ODS_REGIONS = (0, True)

  def __init__(self, operand, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def negf(operand, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return NegFOp(operand=operand, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class OrIOp(_ods_ir.OpView):
  r"""
  The `ori` operation takes two operands and returns one result, each of these
  is required to be the same type. This type may be an integer scalar type, a
  vector whose element type is integer, or a tensor of integers. It has no
  standard attributes.
  
  Example:
  
  ```mlir
  // Scalar integer bitwise or.
  %a = arith.ori %b, %c : i64
  
  // SIMD vector element-wise bitwise integer or.
  %f = arith.ori %g, %h : vector<4xi32>
  
  // Tensor element-wise bitwise integer or.
  %x = arith.ori %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.ori"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def ori(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return OrIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RemFOp(_ods_ir.OpView):
  r"""
  Returns the floating point division remainder.
  The remainder has the same sign as the dividend (lhs operand).
  """

  OPERATION_NAME = "arith.remf"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def remf(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return RemFOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RemSIOp(_ods_ir.OpView):
  r"""
  Signed integer division remainder. Treats the leading bit as sign, i.e. `6 %
  -2 = 0`.
  
  Division by zero is undefined behavior. When applied to `vector` and
  `tensor` values, the behavior is undefined if _any_ elements are divided by
  zero.
  
  Example:
  
  ```mlir
  // Scalar signed integer division remainder.
  %a = arith.remsi %b, %c : i64
  
  // SIMD vector element-wise division remainder.
  %f = arith.remsi %g, %h : vector<4xi32>
  
  // Tensor element-wise integer division remainder.
  %x = arith.remsi %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.remsi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def remsi(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return RemSIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class RemUIOp(_ods_ir.OpView):
  r"""
  Unsigned integer division remainder. Treats the leading bit as the most
  significant, i.e. for `i16`, `6 % -2 = 6 % (2^16 - 2) = 6`.
  
  Division by zero is undefined behavior. When applied to `vector` and
  `tensor` values, the behavior is undefined if _any_ elements are divided by
  zero.
  
  Example:
  
  ```mlir
  // Scalar unsigned integer division remainder.
  %a = arith.remui %b, %c : i64
  
  // SIMD vector element-wise division remainder.
  %f = arith.remui %g, %h : vector<4xi32>
  
  // Tensor element-wise integer division remainder.
  %x = arith.remui %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.remui"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def remui(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return RemUIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SIToFPOp(_ods_ir.OpView):
  r"""
  Cast from a value interpreted as a signed integer to the corresponding
  floating-point value. If the value cannot be exactly represented, it is
  rounded using the default rounding mode. When operating on vectors, casts
  elementwise.
  """

  OPERATION_NAME = "arith.sitofp"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def sitofp(out, in_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return SIToFPOp(out=out, in_=in_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ScalingExtFOp(_ods_ir.OpView):
  r"""
  This operation upcasts input floating-point values using provided scale
  values. It expects both scales and the input operand to be of the same shape,
  making the operation elementwise. Scales are usually calculated per block
  following the OCP MXFP spec as described in https://arxiv.org/abs/2310.10537.
  
  If scales are calculated per block where blockSize != 1, then scales may
  require broadcasting to make this operation elementwise. For example, let's
  say the input is of shape `<dim1 x dim2 x ... dimN>`. Given blockSize != 1 and
  assuming quantization happens on the last axis, the input can be reshaped to
  `<dim1 x dim2 x ... (dimN/blockSize) x blockSize>`. Scales will be calculated
  per block on the last axis. Therefore, scales will be of shape
  `<dim1 x dim2 x ... (dimN/blockSize) x 1>`. Scales could also be of some other
  shape as long as it is broadcast compatible with the input, e.g.,
  `<1 x 1 x ... (dimN/blockSize) x 1>`.
  
  In this example, before calling into `arith.scaling_extf`, scales must be
  broadcasted to `<dim1 x dim2 x dim3 ... (dimN/blockSize) x blockSize>`. Note
  that there could be multiple quantization axes. Internally,
  `arith.scaling_extf` would perform the following:
  
  ```mlir
  // Cast scale to result type.
  %0 = arith.truncf %1 : f32 to f8E8M0FNU
  %1 = arith.extf %0 : f8E8M0FNU to f16
  
  // Cast input to result type.
  %2 = arith.extf %3 : f4E2M1FN to f16
  
  // Perform scaling
  %3 = arith.mulf %2, %1 : f16
  ```
  It propagates NaN values. Therefore, if either scale or the input element
  contains NaN, then the output element value will also be a NaN.
  
  Example:
  
  ```mlir
  // Upcast from f4E2M1FN to f32.
  %a = arith.scaling_extf %b, %c : f4E2M1FN, f8E8M0FNU to f32
  
  // Element-wise upcast with broadcast (blockSize = 32).
  %f = vector.broadcast %g : vector<1xf8E8M0FNU> to vector<32xf8E8M0FNU>
  %h = arith.scaling_extf %i, %f : vector<32xf4E2M1FN>, vector<32xf8E8M0FNU> to vector<32xbf16>
  ```
  """

  OPERATION_NAME = "arith.scaling_extf"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, scale, *, fastmath=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    operands.append(scale)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def scale(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _Optional[_ods_ir.Attribute]:
    if "fastmath" not in self.operation.attributes:
      return None
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["fastmath"] = value
    elif "fastmath" in self.operation.attributes:
      del self.operation.attributes["fastmath"]

  @fastmath.deleter
  def fastmath(self):
    del self.operation.attributes["fastmath"]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def scaling_extf(out, in_, scale, *, fastmath=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ScalingExtFOp(out=out, in_=in_, scale=scale, fastmath=fastmath, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ScalingTruncFOp(_ods_ir.OpView):
  r"""
  This operation downcasts input using the provided scale values. It expects
  both scales and the input operand to be of the same shape and, therefore,
  makes the operation elementwise. Scales are usually calculated per block
  following the OCP MXFP spec as described in https://arxiv.org/abs/2310.10537.
  Users are required to normalize and clamp the scales as necessary before calling
  passing them to this operation.  OCP MXFP spec also does the flushing of denorms
  on the input operand, which should be handled during lowering by passing appropriate
  fastMath flag to this operation.
  
  If scales are calculated per block where blockSize != 1, scales may require
  broadcasting to make this operation elementwise. For example, let's say the
  input is of shape `<dim1 x dim2 x ... dimN>`. Given blockSize != 1 and
  assuming quantization happens on the last axis, the input can be reshaped to
  `<dim1 x dim2 x ... (dimN/blockSize) x blockSize>`. Scales will be calculated
  per block on the last axis. Therefore, scales will be of shape
  `<dim1 x dim2 x ... (dimN/blockSize) x 1>`. Scales could also be of some other
  shape as long as it is broadcast compatible with the input, e.g.,
  `<1 x 1 x ... (dimN/blockSize) x 1>`.
  
  In this example, before calling into `arith.scaling_truncf`, scales must be
  broadcasted to `<dim1 x dim2 x dim3 ... (dimN/blockSize) x blockSize>`. Note
  that there could be multiple quantization axes. Internally,
  `arith.scaling_truncf` would perform the following:
  
  ```mlir
  // Cast scale to input type.
  %0 = arith.truncf %1 : f32 to f8E8M0FNU
  %1 = arith.extf %0 : f8E8M0FNU to f16
  
  // Perform scaling.
  %3 = arith.divf %2, %1 : f16
  
  // Cast to result type.
  %4 = arith.truncf %3 : f16 to f4E2M1FN
  ```
  
  Example:
  
  ```mlir
  // Downcast from f32 to f4E2M1FN.
  %a = arith.scaling_truncf %b, %c : f32, f8E8M0FNU to f4E2M1FN
  
  // Element-wise downcast with broadcast (blockSize = 32).
  %f = vector.broadcast %g : vector<1xf8E8M0FNU> to vector<32xf8E8M0FNU>
  %h = arith.scaling_truncf %i, %f : vector<32xbf16>, vector<32xf8E8M0FNU> to vector<32xf4E2M1FN>
  ```
  """

  OPERATION_NAME = "arith.scaling_truncf"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, scale, *, roundingmode=None, fastmath=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    operands.append(scale)
    _ods_context = _ods_get_default_loc_context(loc)
    if roundingmode is not None: attributes["roundingmode"] = (roundingmode if (
        isinstance(roundingmode, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_RoundingModeAttr')) else
          _ods_ir.AttrBuilder.get('Arith_RoundingModeAttr')(roundingmode, context=_ods_context))
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def scale(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def roundingmode(self) -> _Optional[_ods_ir.Attribute]:
    if "roundingmode" not in self.operation.attributes:
      return None
    return self.operation.attributes["roundingmode"]

  @roundingmode.setter
  def roundingmode(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["roundingmode"] = value
    elif "roundingmode" in self.operation.attributes:
      del self.operation.attributes["roundingmode"]

  @roundingmode.deleter
  def roundingmode(self):
    del self.operation.attributes["roundingmode"]

  @builtins.property
  def fastmath(self) -> _Optional[_ods_ir.Attribute]:
    if "fastmath" not in self.operation.attributes:
      return None
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["fastmath"] = value
    elif "fastmath" in self.operation.attributes:
      del self.operation.attributes["fastmath"]

  @fastmath.deleter
  def fastmath(self):
    del self.operation.attributes["fastmath"]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def scaling_truncf(out, in_, scale, *, roundingmode=None, fastmath=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ScalingTruncFOp(out=out, in_=in_, scale=scale, roundingmode=roundingmode, fastmath=fastmath, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ShLIOp(_ods_ir.OpView):
  r"""
  The `shli` operation shifts the integer value of the first operand to the left
  by the integer value of the second operand. The second operand is interpreted as
  unsigned. The low order bits are filled with zeros. If the value of the second
  operand is greater or equal than the bitwidth of the first operand, then the
  operation returns poison.
  
  This op supports `nuw`/`nsw` overflow flags which stands for
  "No Unsigned Wrap" and "No Signed Wrap", respectively. If the `nuw` and/or
  `nsw` flags are present, and an unsigned/signed overflow occurs
  (respectively), the result is poison.
  
  Example:
  
  ```mlir
  %1 = arith.constant 5 : i8  // %1 is 0b00000101
  %2 = arith.constant 3 : i8
  %3 = arith.shli %1, %2 : i8 // %3 is 0b00101000
  %4 = arith.shli %1, %2 overflow<nsw, nuw> : i8
  ```
  """

  OPERATION_NAME = "arith.shli"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, overflowFlags=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if overflowFlags is not None: attributes["overflowFlags"] = (overflowFlags if (
        isinstance(overflowFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_IntegerOverflowAttr')) else
          _ods_ir.AttrBuilder.get('Arith_IntegerOverflowAttr')(overflowFlags, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def overflowFlags(self) -> _ods_ir.Attribute:
    return self.operation.attributes["overflowFlags"]

  @overflowFlags.setter
  def overflowFlags(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["overflowFlags"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def shli(lhs, rhs, *, overflow_flags=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ShLIOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ShRSIOp(_ods_ir.OpView):
  r"""
  The `shrsi` operation shifts an integer value of the first operand to the right
  by the value of the second operand. The first operand is interpreted as signed,
  and the second operand is interpreter as unsigned. The high order bits in the
  output are filled with copies of the most-significant bit of the shifted value
  (which means that the sign of the value is preserved). If the value of the second
  operand is greater or equal than bitwidth of the first operand, then the operation
  returns poison.
  
  If the `exact` attribute is present, the result value of shrsi is a poison
  value if any of the bits shifted out are non-zero.
  
  Example:
  
  ```mlir
  %1 = arith.constant 160 : i8         // %1 is 0b10100000
  %2 = arith.constant 3 : i8
  %3 = arith.shrsi %1, %2 exact : i8   // %3 is 0b11110100
  %4 = arith.constant 98 : i8          // %4 is 0b01100010
  %5 = arith.shrsi %4, %2 : i8         // %5 is 0b00001100
  ```
  """

  OPERATION_NAME = "arith.shrsi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, isExact=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(isExact): attributes["isExact"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def isExact(self) -> bool:
    return "isExact" in self.operation.attributes

  @isExact.setter
  def isExact(self, value):
    if bool(value):
      self.operation.attributes["isExact"] = _ods_ir.UnitAttr.get()
    elif "isExact" in self.operation.attributes:
      del self.operation.attributes["isExact"]

  @isExact.deleter
  def isExact(self):
    del self.operation.attributes["isExact"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def shrsi(lhs, rhs, *, is_exact=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ShRSIOp(lhs=lhs, rhs=rhs, isExact=is_exact, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class ShRUIOp(_ods_ir.OpView):
  r"""
  The `shrui` operation shifts an integer value of the first operand to the right
  by the value of the second operand. The first operand is interpreted as unsigned,
  and the second operand is interpreted as unsigned. The high order bits are always
  filled with zeros. If the value of the second operand is greater or equal than the
  bitwidth of the first operand, then the operation returns poison.
  
  If the `exact` attribute is present, the result value of shrui is a poison
  value if any of the bits shifted out are non-zero.
  
  Example:
  
  ```mlir
  %1 = arith.constant 160 : i8        // %1 is 0b10100000
  %2 = arith.constant 3 : i8
  %3 = arith.constant 6 : i8
  %4 = arith.shrui %1, %2 exact : i8  // %4 is 0b00010100
  %5 = arith.shrui %1, %3 : i8        // %3 is 0b00000010
  ```
  """

  OPERATION_NAME = "arith.shrui"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, isExact=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if bool(isExact): attributes["isExact"] = _ods_ir.UnitAttr.get(
      _ods_get_default_loc_context(loc))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def isExact(self) -> bool:
    return "isExact" in self.operation.attributes

  @isExact.setter
  def isExact(self, value):
    if bool(value):
      self.operation.attributes["isExact"] = _ods_ir.UnitAttr.get()
    elif "isExact" in self.operation.attributes:
      del self.operation.attributes["isExact"]

  @isExact.deleter
  def isExact(self):
    del self.operation.attributes["isExact"]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def shrui(lhs, rhs, *, is_exact=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return ShRUIOp(lhs=lhs, rhs=rhs, isExact=is_exact, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SubFOp(_ods_ir.OpView):
  r"""
  The `subf` operation takes two operands and returns one result, each of
  these is required to be the same type. This type may be a floating point
  scalar type, a vector whose element type is a floating point type, or a
  floating point tensor.
  
  Example:
  
  ```mlir
  // Scalar subtraction.
  %a = arith.subf %b, %c : f64
  
  // SIMD vector subtraction, e.g. for Intel SSE.
  %f = arith.subf %g, %h : vector<4xf32>
  
  // Tensor subtraction.
  %x = arith.subf %y, %z : tensor<4x?xbf16>
  ```
  
  TODO: In the distant future, this will accept optional attributes for fast
  math, contraction, rounding mode, and other controls.
  """

  OPERATION_NAME = "arith.subf"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def fastmath(self) -> _ods_ir.Attribute:
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fastmath"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def subf(lhs, rhs, *, fastmath=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return SubFOp(lhs=lhs, rhs=rhs, fastmath=fastmath, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SubIOp(_ods_ir.OpView):
  r"""
  Performs N-bit subtraction on the operands. The operands are interpreted as unsigned
  bitvectors. The result is represented by a bitvector containing the mathematical
  value of the subtraction modulo 2^n, where `n` is the bitwidth. Because `arith`
  integers use a two's complement representation, this operation is applicable on
  both signed and unsigned integer operands.
  
  The `subi` operation takes two operands and returns one result, each of
  these is required to be the same type. This type may be an integer scalar type,
  a vector whose element type is integer, or a tensor of integers.
  
  This op supports `nuw`/`nsw` overflow flags which stands for
  "No Unsigned Wrap" and "No Signed Wrap", respectively. If the `nuw` and/or
  `nsw` flags are present, and an unsigned/signed overflow occurs
  (respectively), the result is poison.
  
  Example:
  
  ```mlir
  // Scalar subtraction.
  %a = arith.subi %b, %c : i64
  
  // Scalar subtraction with overflow flags.
  %a = arith.subi %b, %c overflow<nsw, nuw> : i64
  
  // SIMD vector element-wise subtraction.
  %f = arith.subi %g, %h : vector<4xi32>
  
  // Tensor element-wise subtraction.
  %x = arith.subi %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.subi"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, overflowFlags=None, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if overflowFlags is not None: attributes["overflowFlags"] = (overflowFlags if (
        isinstance(overflowFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_IntegerOverflowAttr')) else
          _ods_ir.AttrBuilder.get('Arith_IntegerOverflowAttr')(overflowFlags, context=_ods_context))
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def overflowFlags(self) -> _ods_ir.Attribute:
    return self.operation.attributes["overflowFlags"]

  @overflowFlags.setter
  def overflowFlags(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["overflowFlags"] = value

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def subi(lhs, rhs, *, overflow_flags=None, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return SubIOp(lhs=lhs, rhs=rhs, overflowFlags=overflow_flags, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TruncFOp(_ods_ir.OpView):
  r"""
  Truncate a floating-point value to a smaller floating-point-typed value.
  The destination type must be strictly narrower than the source type.
  If the value cannot be exactly represented, it is rounded using the
  provided rounding mode or the default one if no rounding mode is provided.
  When operating on vectors, casts elementwise.
  """

  OPERATION_NAME = "arith.truncf"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, roundingmode=None, fastmath=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    if roundingmode is not None: attributes["roundingmode"] = (roundingmode if (
        isinstance(roundingmode, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_RoundingModeAttr')) else
          _ods_ir.AttrBuilder.get('Arith_RoundingModeAttr')(roundingmode, context=_ods_context))
    if fastmath is not None: attributes["fastmath"] = (fastmath if (
        isinstance(fastmath, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_FastMathAttr')) else
          _ods_ir.AttrBuilder.get('Arith_FastMathAttr')(fastmath, context=_ods_context))
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def roundingmode(self) -> _Optional[_ods_ir.Attribute]:
    if "roundingmode" not in self.operation.attributes:
      return None
    return self.operation.attributes["roundingmode"]

  @roundingmode.setter
  def roundingmode(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["roundingmode"] = value
    elif "roundingmode" in self.operation.attributes:
      del self.operation.attributes["roundingmode"]

  @roundingmode.deleter
  def roundingmode(self):
    del self.operation.attributes["roundingmode"]

  @builtins.property
  def fastmath(self) -> _Optional[_ods_ir.Attribute]:
    if "fastmath" not in self.operation.attributes:
      return None
    return self.operation.attributes["fastmath"]

  @fastmath.setter
  def fastmath(self, value: _Optional[_ods_ir.Attribute]):
    if value is not None:
      self.operation.attributes["fastmath"] = value
    elif "fastmath" in self.operation.attributes:
      del self.operation.attributes["fastmath"]

  @fastmath.deleter
  def fastmath(self):
    del self.operation.attributes["fastmath"]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def truncf(out, in_, *, roundingmode=None, fastmath=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return TruncFOp(out=out, in_=in_, roundingmode=roundingmode, fastmath=fastmath, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TruncIOp(_ods_ir.OpView):
  r"""
  The integer truncation operation takes an integer input of
  width M and an integer destination type of width N. The destination
  bit-width must be smaller than the input bit-width (N < M).
  The top-most (N - M) bits of the input are discarded.
  
  This op supports `nuw`/`nsw` overflow flags which stands for "No Unsigned
  Wrap" and "No Signed Wrap", respectively. If the nuw keyword is present,
  and any of the truncated bits are non-zero, the result is a poison value.
  If the nsw keyword is present, and any of the truncated bits are not the
  same as the top bit of the truncation result, the result is a poison value.
  
  Example:
  
  ```mlir
    // Scalar truncation.
    %1 = arith.constant 21 : i5     // %1 is 0b10101
    %2 = arith.trunci %1 : i5 to i4 // %2 is 0b0101
    %3 = arith.trunci %1 : i5 to i3 // %3 is 0b101
  
    // Vector truncation.
    %4 = arith.trunci %0 : vector<2 x i32> to vector<2 x i16>
  
    // Scalar truncation with overflow flags.
    %5 = arith.trunci %a overflow<nsw, nuw> : i32 to i16
  ```
  """

  OPERATION_NAME = "arith.trunci"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, overflowFlags=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    if overflowFlags is not None: attributes["overflowFlags"] = (overflowFlags if (
        isinstance(overflowFlags, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('Arith_IntegerOverflowAttr')) else
          _ods_ir.AttrBuilder.get('Arith_IntegerOverflowAttr')(overflowFlags, context=_ods_context))
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def overflowFlags(self) -> _ods_ir.Attribute:
    return self.operation.attributes["overflowFlags"]

  @overflowFlags.setter
  def overflowFlags(self, value: _ods_ir.Attribute):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["overflowFlags"] = value

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def trunci(out, in_, *, overflow_flags=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return TruncIOp(out=out, in_=in_, overflowFlags=overflow_flags, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class UIToFPOp(_ods_ir.OpView):
  r"""
  Cast from a value interpreted as unsigned integer to the corresponding
  floating-point value. If the value cannot be exactly represented, it is
  rounded using the default rounding mode. When operating on vectors, casts
  elementwise.
  """

  OPERATION_NAME = "arith.uitofp"

  _ODS_REGIONS = (0, True)

  def __init__(self, out, in_, *, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(in_)
    _ods_context = _ods_get_default_loc_context(loc)
    results = []
    results.append(out)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def in_(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def out(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def uitofp(out, in_, *, loc=None, ip=None) -> _ods_ir.OpResult:
  return UIToFPOp(out=out, in_=in_, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class XOrIOp(_ods_ir.OpView):
  r"""
  The `xori` operation takes two operands and returns one result, each of
  these is required to be the same type. This type may be an integer scalar
  type, a vector whose element type is integer, or a tensor of integers. It
  has no standard attributes.
  
  Example:
  
  ```mlir
  // Scalar integer bitwise xor.
  %a = arith.xori %b, %c : i64
  
  // SIMD vector element-wise bitwise integer xor.
  %f = arith.xori %g, %h : vector<4xi32>
  
  // Tensor element-wise bitwise integer xor.
  %x = arith.xori %y, %z : tensor<4x?xi8>
  ```
  """

  OPERATION_NAME = "arith.xori"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(lhs)
    operands.append(rhs)
    _ods_context = _ods_get_default_loc_context(loc)
    if results is None: results = [operands[0].type] * 1
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def lhs(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def rhs(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def xori(lhs, rhs, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return XOrIOp(lhs=lhs, rhs=rhs, results=results, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class SelectOp(_ods_ir.OpView):
  r"""
  The `arith.select` operation chooses one value based on a binary condition
  supplied as its first operand.
  
  If the value of the first operand (the condition) is `1`, then the second
  operand is returned, and the third operand is ignored, even if it was poison.
  
  If the value of the first operand (the condition) is `0`, then the third
  operand is returned, and the second operand is ignored, even if it was poison.
  
  If the value of the first operand (the condition) is poison, then the
  operation returns poison.
  
  The operation applies to vectors and tensors elementwise given the _shape_
  of all operands is identical. The choice is made for each element
  individually based on the value at the same position as the element in the
  condition operand. If an i1 is provided as the condition, the entire vector
  or tensor is chosen.
  
  Example:
  
  ```mlir
  // Custom form of scalar selection.
  %x = arith.select %cond, %true, %false : i32
  
  // Generic form of the same operation.
  %x = "arith.select"(%cond, %true, %false) : (i1, i32, i32) -> i32
  
  // Element-wise vector selection.
  %vx = arith.select %vcond, %vtrue, %vfalse : vector<42xi1>, vector<42xf32>
  
  // Full vector selection.
  %vx = arith.select %cond, %vtrue, %vfalse : vector<42xf32>
  ```
  """

  OPERATION_NAME = "arith.select"

  _ODS_REGIONS = (0, True)

  def __init__(self, condition, true_value, false_value, *, results=None, loc=None, ip=None):
    operands = []
    attributes = {}
    regions = None
    operands.append(condition)
    operands.append(true_value)
    operands.append(false_value)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def condition(self) -> _ods_ir.Value:
    return self.operation.operands[0]

  @builtins.property
  def true_value(self) -> _ods_ir.Value:
    return self.operation.operands[1]

  @builtins.property
  def false_value(self) -> _ods_ir.Value:
    return self.operation.operands[2]

  @builtins.property
  def result(self) -> _ods_ir.OpResult:
    return self.operation.results[0]

def select(condition, true_value, false_value, *, results=None, loc=None, ip=None) -> _ods_ir.OpResult:
  return SelectOp(condition=condition, true_value=true_value, false_value=false_value, results=results, loc=loc, ip=ip).result
