#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aoview_ AOVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aoview_ aoview
#endif
PETSC_EXTERN void aoview_(AO *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = AOView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aoviewfromoptions_ AOVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aoviewfromoptions_ aoviewfromoptions
#endif
PETSC_EXTERN void aoviewfromoptions_(AO *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = AOViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aodestroy_ AODESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aodestroy_ aodestroy
#endif
PETSC_EXTERN void aodestroy_(AO *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = AODestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aopetsctoapplicationis_ AOPETSCTOAPPLICATIONIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aopetsctoapplicationis_ aopetsctoapplicationis
#endif
PETSC_EXTERN void aopetsctoapplicationis_(AO *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = AOPetscToApplicationIS(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aoapplicationtopetscis_ AOAPPLICATIONTOPETSCIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aoapplicationtopetscis_ aoapplicationtopetscis
#endif
PETSC_EXTERN void aoapplicationtopetscis_(AO *a, IS *b, PetscErrorCode *ierr)
{
  *ierr = AOApplicationToPetscIS(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aopetsctoapplication_ AOPETSCTOAPPLICATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aopetsctoapplication_ aopetsctoapplication
#endif
PETSC_EXTERN void aopetsctoapplication_(AO *a, PetscInt *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = AOPetscToApplication(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aoapplicationtopetsc_ AOAPPLICATIONTOPETSC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aoapplicationtopetsc_ aoapplicationtopetsc
#endif
PETSC_EXTERN void aoapplicationtopetsc_(AO *a, PetscInt *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = AOApplicationToPetsc(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aopetsctoapplicationpermuteint_ AOPETSCTOAPPLICATIONPERMUTEINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aopetsctoapplicationpermuteint_ aopetsctoapplicationpermuteint
#endif
PETSC_EXTERN void aopetsctoapplicationpermuteint_(AO *a, PetscInt *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = AOPetscToApplicationPermuteInt(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aoapplicationtopetscpermuteint_ AOAPPLICATIONTOPETSCPERMUTEINT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aoapplicationtopetscpermuteint_ aoapplicationtopetscpermuteint
#endif
PETSC_EXTERN void aoapplicationtopetscpermuteint_(AO *a, PetscInt *b, PetscInt c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  *ierr = AOApplicationToPetscPermuteInt(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aopetsctoapplicationpermutereal_ AOPETSCTOAPPLICATIONPERMUTEREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aopetsctoapplicationpermutereal_ aopetsctoapplicationpermutereal
#endif
PETSC_EXTERN void aopetsctoapplicationpermutereal_(AO *a, PetscInt *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = AOPetscToApplicationPermuteReal(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aoapplicationtopetscpermutereal_ AOAPPLICATIONTOPETSCPERMUTEREAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aoapplicationtopetscpermutereal_ aoapplicationtopetscpermutereal
#endif
PETSC_EXTERN void aoapplicationtopetscpermutereal_(AO *a, PetscInt *b, PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(c);
  *ierr = AOApplicationToPetscPermuteReal(*a, *b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aosetfromoptions_ AOSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aosetfromoptions_ aosetfromoptions
#endif
PETSC_EXTERN void aosetfromoptions_(AO *a, PetscErrorCode *ierr)
{
  *ierr = AOSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aosetis_ AOSETIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aosetis_ aosetis
#endif
PETSC_EXTERN void aosetis_(AO *a, IS *b, IS *c, PetscErrorCode *ierr)
{
  *ierr = AOSetIS(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscvec.h>
#include <petscao.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define aocreate_ AOCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define aocreate_ aocreate
#endif
PETSC_EXTERN void aocreate_(MPI_Fint *a, AO *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = AOCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
