#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsroswregisterdestroy_ TSROSWREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsroswregisterdestroy_ tsroswregisterdestroy
#endif
PETSC_EXTERN void tsroswregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = TSRosWRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsroswinitializepackage_ TSROSWINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsroswinitializepackage_ tsroswinitializepackage
#endif
PETSC_EXTERN void tsroswinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSRosWInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsroswfinalizepackage_ TSROSWFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsroswfinalizepackage_ tsroswfinalizepackage
#endif
PETSC_EXTERN void tsroswfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSRosWFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsroswregister_ TSROSWREGISTER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsroswregister_ tsroswregister
#endif
PETSC_EXTERN void tsroswregister_(char *a, PetscInt *b, PetscInt *c, const PetscReal d[], const PetscReal e[], const PetscReal f[], const PetscReal g[], PetscInt *h, const PetscReal i[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLREAL(f);
  CHKFORTRANNULLREAL(g);
  CHKFORTRANNULLREAL(i);
  *ierr = TSRosWRegister(c_a, *b, *c, d, e, f, g, *h, i);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsroswregisterros4_ TSROSWREGISTERROS4
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsroswregisterros4_ tsroswregisterros4
#endif
PETSC_EXTERN void tsroswregisterros4_(char *a, PetscReal *b, PetscReal *c, PetscReal *d, PetscReal *e, PetscReal *f, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = TSRosWRegisterRos4(c_a, *b, *c, *d, *e, *f);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsroswsettype_ TSROSWSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsroswsettype_ tsroswsettype
#endif
PETSC_EXTERN void tsroswsettype_(TS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSRosWSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsroswgettype_ TSROSWGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsroswgettype_ tsroswgettype
#endif
PETSC_EXTERN void tsroswgettype_(TS *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = TSRosWGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsroswsetrecomputejacobian_ TSROSWSETRECOMPUTEJACOBIAN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsroswsetrecomputejacobian_ tsroswsetrecomputejacobian
#endif
PETSC_EXTERN void tsroswsetrecomputejacobian_(TS *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = TSRosWSetRecomputeJacobian(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
