#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsglleadaptfinalizepackage_ TSGLLEADAPTFINALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsglleadaptfinalizepackage_ tsglleadaptfinalizepackage
#endif
PETSC_EXTERN void tsglleadaptfinalizepackage_(PetscErrorCode *ierr)
{
  *ierr = TSGLLEAdaptFinalizePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsglleadaptinitializepackage_ TSGLLEADAPTINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsglleadaptinitializepackage_ tsglleadaptinitializepackage
#endif
PETSC_EXTERN void tsglleadaptinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = TSGLLEAdaptInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsglleadaptsettype_ TSGLLEADAPTSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsglleadaptsettype_ tsglleadaptsettype
#endif
PETSC_EXTERN void tsglleadaptsettype_(TSGLLEAdapt *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSGLLEAdaptSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsglleadaptsetoptionsprefix_ TSGLLEADAPTSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsglleadaptsetoptionsprefix_ tsglleadaptsetoptionsprefix
#endif
PETSC_EXTERN void tsglleadaptsetoptionsprefix_(TSGLLEAdapt *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = TSGLLEAdaptSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsglleadaptview_ TSGLLEADAPTVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsglleadaptview_ tsglleadaptview
#endif
PETSC_EXTERN void tsglleadaptview_(TSGLLEAdapt *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = TSGLLEAdaptView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsglleadaptdestroy_ TSGLLEADAPTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsglleadaptdestroy_ tsglleadaptdestroy
#endif
PETSC_EXTERN void tsglleadaptdestroy_(TSGLLEAdapt *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = TSGLLEAdaptDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsglleadaptsetfromoptions_ TSGLLEADAPTSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsglleadaptsetfromoptions_ tsglleadaptsetfromoptions
#endif
PETSC_EXTERN void tsglleadaptsetfromoptions_(TSGLLEAdapt *a, PetscOptionItems *b, PetscErrorCode *ierr)
{
  *ierr = TSGLLEAdaptSetFromOptions(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsglleadaptchoose_ TSGLLEADAPTCHOOSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsglleadaptchoose_ tsglleadaptchoose
#endif
PETSC_EXTERN void tsglleadaptchoose_(TSGLLEAdapt *a, PetscInt *b, const PetscInt c[], const PetscReal d[], const PetscReal e[], PetscInt *f, PetscReal *g, PetscReal *h, PetscInt *i, PetscReal *j, PetscBool *k, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLREAL(d);
  CHKFORTRANNULLREAL(e);
  CHKFORTRANNULLINTEGER(i);
  CHKFORTRANNULLREAL(j);
  CHKFORTRANNULLBOOL(k);
  *ierr = TSGLLEAdaptChoose(*a, *b, c, d, e, *f, *g, *h, i, j, k);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscts.h>
#include <petscts.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define tsglleadaptcreate_ TSGLLEADAPTCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define tsglleadaptcreate_ tsglleadaptcreate
#endif
PETSC_EXTERN void tsglleadaptcreate_(MPI_Fint *a, TSGLLEAdapt *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = TSGLLEAdaptCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
