#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscinitialized_ PETSCINITIALIZED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscinitialized_ petscinitialized
#endif
PETSC_EXTERN void petscinitialized_(PetscBool *a, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(a);
  *ierr = PetscInitialized(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfinalized_ PETSCFINALIZED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfinalized_ petscfinalized
#endif
PETSC_EXTERN void petscfinalized_(PetscBool *a, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(a);
  *ierr = PetscFinalized(a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscmaxsum_ PETSCMAXSUM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscmaxsum_ petscmaxsum
#endif
PETSC_EXTERN void petscmaxsum_(MPI_Fint *a, const PetscInt b[], PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = PetscMaxSum(MPI_Comm_f2c(*(a)), b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscsetprogramname_ PETSCSETPROGRAMNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscsetprogramname_ petscsetprogramname
#endif
PETSC_EXTERN void petscsetprogramname_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  *ierr = PetscSetProgramName(c_a);
  if (*ierr) return;
  FREECHAR(a, c_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgetprogramname_ PETSCGETPROGRAMNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgetprogramname_ petscgetprogramname
#endif
PETSC_EXTERN void petscgetprogramname_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  *ierr = PetscGetProgramName(a, l_a);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, a, l_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscfinalize_ PETSCFINALIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscfinalize_ petscfinalize
#endif
PETSC_EXTERN void petscfinalize_(PetscErrorCode *ierr)
{
  *ierr = PetscFinalize();
  if (*ierr) return;
}
