#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlercreate_ PETSCLOGHANDLERCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlercreate_ petscloghandlercreate
#endif
PETSC_EXTERN void petscloghandlercreate_(MPI_Fint *a, PetscLogHandler *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscLogHandlerCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerdestroy_ PETSCLOGHANDLERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerdestroy_ petscloghandlerdestroy
#endif
PETSC_EXTERN void petscloghandlerdestroy_(PetscLogHandler *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscLogHandlerDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlersetstate_ PETSCLOGHANDLERSETSTATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlersetstate_ petscloghandlersetstate
#endif
PETSC_EXTERN void petscloghandlersetstate_(PetscLogHandler *a, PetscLogState *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerSetState(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlergetstate_ PETSCLOGHANDLERGETSTATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlergetstate_ petscloghandlergetstate
#endif
PETSC_EXTERN void petscloghandlergetstate_(PetscLogHandler *a, PetscLogState *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscLogHandlerGetState(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlereventbegin_ PETSCLOGHANDLEREVENTBEGIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlereventbegin_ petscloghandlereventbegin
#endif
PETSC_EXTERN void petscloghandlereventbegin_(PetscLogHandler *a, PetscLogEvent *b, PetscObject *c, PetscObject *d, PetscObject *e, PetscObject *f, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerEventBegin(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlereventend_ PETSCLOGHANDLEREVENTEND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlereventend_ petscloghandlereventend
#endif
PETSC_EXTERN void petscloghandlereventend_(PetscLogHandler *a, PetscLogEvent *b, PetscObject *c, PetscObject *d, PetscObject *e, PetscObject *f, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerEventEnd(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlereventsync_ PETSCLOGHANDLEREVENTSYNC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlereventsync_ petscloghandlereventsync
#endif
PETSC_EXTERN void petscloghandlereventsync_(PetscLogHandler *a, PetscLogEvent *b, MPI_Fint *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerEventSync(*a, *b, MPI_Comm_f2c(*(c)));
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerobjectcreate_ PETSCLOGHANDLEROBJECTCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerobjectcreate_ petscloghandlerobjectcreate
#endif
PETSC_EXTERN void petscloghandlerobjectcreate_(PetscLogHandler *a, PetscObject *b, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_CREATE(b);
  *ierr = PetscLogHandlerObjectCreate(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerobjectdestroy_ PETSCLOGHANDLEROBJECTDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerobjectdestroy_ petscloghandlerobjectdestroy
#endif
PETSC_EXTERN void petscloghandlerobjectdestroy_(PetscLogHandler *a, PetscObject *b, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  *ierr = PetscLogHandlerObjectDestroy(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerstagepush_ PETSCLOGHANDLERSTAGEPUSH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerstagepush_ petscloghandlerstagepush
#endif
PETSC_EXTERN void petscloghandlerstagepush_(PetscLogHandler *a, PetscLogStage *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerStagePush(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerstagepop_ PETSCLOGHANDLERSTAGEPOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerstagepop_ petscloghandlerstagepop
#endif
PETSC_EXTERN void petscloghandlerstagepop_(PetscLogHandler *a, PetscLogStage *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerStagePop(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerview_ PETSCLOGHANDLERVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerview_ petscloghandlerview
#endif
PETSC_EXTERN void petscloghandlerview_(PetscLogHandler *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscLogHandlerView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlersetlogactions_ PETSCLOGHANDLERSETLOGACTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlersetlogactions_ petscloghandlersetlogactions
#endif
PETSC_EXTERN void petscloghandlersetlogactions_(PetscLogHandler *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerSetLogActions(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlersetlogobjects_ PETSCLOGHANDLERSETLOGOBJECTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlersetlogobjects_ petscloghandlersetlogobjects
#endif
PETSC_EXTERN void petscloghandlersetlogobjects_(PetscLogHandler *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerSetLogObjects(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlergetnumobjects_ PETSCLOGHANDLERGETNUMOBJECTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlergetnumobjects_ petscloghandlergetnumobjects
#endif
PETSC_EXTERN void petscloghandlergetnumobjects_(PetscLogHandler *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscLogHandlerGetNumObjects(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlereventdeactivatepush_ PETSCLOGHANDLEREVENTDEACTIVATEPUSH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlereventdeactivatepush_ petscloghandlereventdeactivatepush
#endif
PETSC_EXTERN void petscloghandlereventdeactivatepush_(PetscLogHandler *a, PetscLogStage *b, PetscLogEvent *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerEventDeactivatePush(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlereventdeactivatepop_ PETSCLOGHANDLEREVENTDEACTIVATEPOP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlereventdeactivatepop_ petscloghandlereventdeactivatepop
#endif
PETSC_EXTERN void petscloghandlereventdeactivatepop_(PetscLogHandler *a, PetscLogStage *b, PetscLogEvent *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerEventDeactivatePop(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlereventspause_ PETSCLOGHANDLEREVENTSPAUSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlereventspause_ petscloghandlereventspause
#endif
PETSC_EXTERN void petscloghandlereventspause_(PetscLogHandler *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerEventsPause(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlereventsresume_ PETSCLOGHANDLEREVENTSRESUME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlereventsresume_ petscloghandlereventsresume
#endif
PETSC_EXTERN void petscloghandlereventsresume_(PetscLogHandler *a, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerEventsResume(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerdump_ PETSCLOGHANDLERDUMP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerdump_ petscloghandlerdump
#endif
PETSC_EXTERN void petscloghandlerdump_(PetscLogHandler *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscLogHandlerDump(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerstagesetvisible_ PETSCLOGHANDLERSTAGESETVISIBLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerstagesetvisible_ petscloghandlerstagesetvisible
#endif
PETSC_EXTERN void petscloghandlerstagesetvisible_(PetscLogHandler *a, PetscLogStage *b, PetscBool *c, PetscErrorCode *ierr)
{
  *ierr = PetscLogHandlerStageSetVisible(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petsclog.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscloghandlerstagegetvisible_ PETSCLOGHANDLERSTAGEGETVISIBLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscloghandlerstagegetvisible_ petscloghandlerstagegetvisible
#endif
PETSC_EXTERN void petscloghandlerstagegetvisible_(PetscLogHandler *a, PetscLogStage *b, PetscBool *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscLogHandlerStageGetVisible(*a, *b, c);
  if (*ierr) return;
}
