#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorregisterall_ DMADAPTORREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorregisterall_ dmadaptorregisterall
#endif
PETSC_EXTERN void dmadaptorregisterall_(PetscErrorCode *ierr)
{
  *ierr = DMAdaptorRegisterAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorregisterdestroy_ DMADAPTORREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorregisterdestroy_ dmadaptorregisterdestroy
#endif
PETSC_EXTERN void dmadaptorregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = DMAdaptorRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptormonitorregisterdestroy_ DMADAPTORMONITORREGISTERDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptormonitorregisterdestroy_ dmadaptormonitorregisterdestroy
#endif
PETSC_EXTERN void dmadaptormonitorregisterdestroy_(PetscErrorCode *ierr)
{
  *ierr = DMAdaptorMonitorRegisterDestroy();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorcreate_ DMADAPTORCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorcreate_ dmadaptorcreate
#endif
PETSC_EXTERN void dmadaptorcreate_(MPI_Fint *a, DMAdaptor *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMAdaptorCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptordestroy_ DMADAPTORDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptordestroy_ dmadaptordestroy
#endif
PETSC_EXTERN void dmadaptordestroy_(DMAdaptor *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = DMAdaptorDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorsettype_ DMADAPTORSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorsettype_ dmadaptorsettype
#endif
PETSC_EXTERN void dmadaptorsettype_(DMAdaptor *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMAdaptorSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorgettype_ DMADAPTORGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorgettype_ dmadaptorgettype
#endif
PETSC_EXTERN void dmadaptorgettype_(DMAdaptor *a, char *b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMAdaptorGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptormonitorcancel_ DMADAPTORMONITORCANCEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptormonitorcancel_ dmadaptormonitorcancel
#endif
PETSC_EXTERN void dmadaptormonitorcancel_(DMAdaptor *a, PetscErrorCode *ierr)
{
  *ierr = DMAdaptorMonitorCancel(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptormonitorsetfromoptions_ DMADAPTORMONITORSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptormonitorsetfromoptions_ dmadaptormonitorsetfromoptions
#endif
PETSC_EXTERN void dmadaptormonitorsetfromoptions_(DMAdaptor *a, char b[], char c[], void *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = DMAdaptorMonitorSetFromOptions(*a, c_b, c_c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorsetoptionsprefix_ DMADAPTORSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorsetoptionsprefix_ dmadaptorsetoptionsprefix
#endif
PETSC_EXTERN void dmadaptorsetoptionsprefix_(DMAdaptor *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMAdaptorSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorsetfromoptions_ DMADAPTORSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorsetfromoptions_ dmadaptorsetfromoptions
#endif
PETSC_EXTERN void dmadaptorsetfromoptions_(DMAdaptor *a, PetscErrorCode *ierr)
{
  *ierr = DMAdaptorSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorview_ DMADAPTORVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorview_ dmadaptorview
#endif
PETSC_EXTERN void dmadaptorview_(DMAdaptor *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = DMAdaptorView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorgetsolver_ DMADAPTORGETSOLVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorgetsolver_ dmadaptorgetsolver
#endif
PETSC_EXTERN void dmadaptorgetsolver_(DMAdaptor *a, SNES *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMAdaptorGetSolver(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorsetsolver_ DMADAPTORSETSOLVER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorsetsolver_ dmadaptorsetsolver
#endif
PETSC_EXTERN void dmadaptorsetsolver_(DMAdaptor *a, SNES *b, PetscErrorCode *ierr)
{
  *ierr = DMAdaptorSetSolver(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorgetsequencelength_ DMADAPTORGETSEQUENCELENGTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorgetsequencelength_ dmadaptorgetsequencelength
#endif
PETSC_EXTERN void dmadaptorgetsequencelength_(DMAdaptor *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMAdaptorGetSequenceLength(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorsetsequencelength_ DMADAPTORSETSEQUENCELENGTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorsetsequencelength_ dmadaptorsetsequencelength
#endif
PETSC_EXTERN void dmadaptorsetsequencelength_(DMAdaptor *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMAdaptorSetSequenceLength(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorsetup_ DMADAPTORSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorsetup_ dmadaptorsetup
#endif
PETSC_EXTERN void dmadaptorsetup_(DMAdaptor *a, PetscErrorCode *ierr)
{
  *ierr = DMAdaptorSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptormonitor_ DMADAPTORMONITOR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptormonitor_ dmadaptormonitor
#endif
PETSC_EXTERN void dmadaptormonitor_(DMAdaptor *a, PetscInt *b, DM *c, DM *d, PetscInt *e, PetscReal f[], Vec *g, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  *ierr = DMAdaptorMonitor(*a, *b, *c, *d, *e, f, *g);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptormonitorsize_ DMADAPTORMONITORSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptormonitorsize_ dmadaptormonitorsize
#endif
PETSC_EXTERN void dmadaptormonitorsize_(DMAdaptor *a, PetscInt *b, DM *c, DM *d, PetscInt *e, PetscReal f[], Vec *g, PetscViewerAndFormat **h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  *ierr = DMAdaptorMonitorSize(*a, *b, *c, *d, *e, f, *g, *h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptormonitorerror_ DMADAPTORMONITORERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptormonitorerror_ dmadaptormonitorerror
#endif
PETSC_EXTERN void dmadaptormonitorerror_(DMAdaptor *a, PetscInt *b, DM *c, DM *d, PetscInt *e, PetscReal f[], Vec *g, PetscViewerAndFormat **h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  *ierr = DMAdaptorMonitorError(*a, *b, *c, *d, *e, f, *g, *h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptormonitorerrordraw_ DMADAPTORMONITORERRORDRAW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptormonitorerrordraw_ dmadaptormonitorerrordraw
#endif
PETSC_EXTERN void dmadaptormonitorerrordraw_(DMAdaptor *a, PetscInt *b, DM *c, DM *d, PetscInt *e, PetscReal f[], Vec *g, PetscViewerAndFormat **h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  *ierr = DMAdaptorMonitorErrorDraw(*a, *b, *c, *d, *e, f, *g, *h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptormonitorerrordrawlg_ DMADAPTORMONITORERRORDRAWLG
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptormonitorerrordrawlg_ dmadaptormonitorerrordrawlg
#endif
PETSC_EXTERN void dmadaptormonitorerrordrawlg_(DMAdaptor *a, PetscInt *b, DM *c, DM *d, PetscInt *e, PetscReal f[], Vec *g, PetscViewerAndFormat **h, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(f);
  *ierr = DMAdaptorMonitorErrorDrawLG(*a, *b, *c, *d, *e, f, *g, *h);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptormonitorregisterall_ DMADAPTORMONITORREGISTERALL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptormonitorregisterall_ dmadaptormonitorregisterall
#endif
PETSC_EXTERN void dmadaptormonitorregisterall_(PetscErrorCode *ierr)
{
  *ierr = DMAdaptorMonitorRegisterAll();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptoradapt_ DMADAPTORADAPT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptoradapt_ dmadaptoradapt
#endif
PETSC_EXTERN void dmadaptoradapt_(DMAdaptor *a, Vec *b, DMAdaptationStrategy *c, DM *d, Vec *e, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMAdaptorAdapt(*a, *b, *c, d, e);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorgetcriterion_ DMADAPTORGETCRITERION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorgetcriterion_ dmadaptorgetcriterion
#endif
PETSC_EXTERN void dmadaptorgetcriterion_(DMAdaptor *a, DMAdaptationCriterion *b, PetscErrorCode *ierr)
{
  *ierr = DMAdaptorGetCriterion(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmadaptor.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmadaptorsetcriterion_ DMADAPTORSETCRITERION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmadaptorsetcriterion_ dmadaptorsetcriterion
#endif
PETSC_EXTERN void dmadaptorsetcriterion_(DMAdaptor *a, DMAdaptationCriterion *b, PetscErrorCode *ierr)
{
  *ierr = DMAdaptorSetCriterion(*a, *b);
  if (*ierr) return;
}
