#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdensegetlocalmatrix_ MATDENSEGETLOCALMATRIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdensegetlocalmatrix_ matdensegetlocalmatrix
#endif
PETSC_EXTERN void matdensegetlocalmatrix_(Mat *a, Mat *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = MatDenseGetLocalMatrix(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matmpidensesetpreallocation_ MATMPIDENSESETPREALLOCATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matmpidensesetpreallocation_ matmpidensesetpreallocation
#endif
PETSC_EXTERN void matmpidensesetpreallocation_(Mat *a, PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatMPIDenseSetPreallocation(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdenseplacearray_ MATDENSEPLACEARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdenseplacearray_ matdenseplacearray
#endif
PETSC_EXTERN void matdenseplacearray_(Mat *a, const PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatDensePlaceArray(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdenseresetarray_ MATDENSERESETARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdenseresetarray_ matdenseresetarray
#endif
PETSC_EXTERN void matdenseresetarray_(Mat *a, PetscErrorCode *ierr)
{
  *ierr = MatDenseResetArray(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matdensereplacearray_ MATDENSEREPLACEARRAY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matdensereplacearray_ matdensereplacearray
#endif
PETSC_EXTERN void matdensereplacearray_(Mat *a, const PetscScalar *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLSCALAR(b);
  *ierr = MatDenseReplaceArray(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscmat.h>
#include <petscmat.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define matcreatedense_ MATCREATEDENSE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define matcreatedense_ matcreatedense
#endif
PETSC_EXTERN void matcreatedense_(MPI_Fint *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscInt *e, PetscScalar f[], Mat *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLSCALAR(f);
  CHKFORTRANNULLOBJECT(g);
  *ierr = MatCreateDense(MPI_Comm_f2c(*(a)), *b, *c, *d, *e, f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
