#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetlevels_ PCMGGETLEVELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetlevels_ pcmggetlevels
#endif
PETSC_EXTERN void pcmggetlevels_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PCMGGetLevels(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetgridcomplexity_ PCMGGETGRIDCOMPLEXITY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetgridcomplexity_ pcmggetgridcomplexity
#endif
PETSC_EXTERN void pcmggetgridcomplexity_(PC *a, PetscReal *b, PetscReal *c, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = PCMGGetGridComplexity(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsettype_ PCMGSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsettype_ pcmgsettype
#endif
PETSC_EXTERN void pcmgsettype_(PC *a, PCMGType *b, PetscErrorCode *ierr)
{
  *ierr = PCMGSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggettype_ PCMGGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggettype_ pcmggettype
#endif
PETSC_EXTERN void pcmggettype_(PC *a, PCMGType *b, PetscErrorCode *ierr)
{
  *ierr = PCMGGetType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetcycletype_ PCMGSETCYCLETYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetcycletype_ pcmgsetcycletype
#endif
PETSC_EXTERN void pcmgsetcycletype_(PC *a, PCMGCycleType *b, PetscErrorCode *ierr)
{
  *ierr = PCMGSetCycleType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgmultiplicativesetcycles_ PCMGMULTIPLICATIVESETCYCLES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgmultiplicativesetcycles_ pcmgmultiplicativesetcycles
#endif
PETSC_EXTERN void pcmgmultiplicativesetcycles_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCMGMultiplicativeSetCycles(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetgalerkin_ PCMGSETGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetgalerkin_ pcmgsetgalerkin
#endif
PETSC_EXTERN void pcmgsetgalerkin_(PC *a, PCMGGalerkinType *b, PetscErrorCode *ierr)
{
  *ierr = PCMGSetGalerkin(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetgalerkin_ PCMGGETGALERKIN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetgalerkin_ pcmggetgalerkin
#endif
PETSC_EXTERN void pcmggetgalerkin_(PC *a, PCMGGalerkinType *b, PetscErrorCode *ierr)
{
  *ierr = PCMGGetGalerkin(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetadaptcoarsespacetype_ PCMGSETADAPTCOARSESPACETYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetadaptcoarsespacetype_ pcmgsetadaptcoarsespacetype
#endif
PETSC_EXTERN void pcmgsetadaptcoarsespacetype_(PC *a, PCMGCoarseSpaceType *b, PetscErrorCode *ierr)
{
  *ierr = PCMGSetAdaptCoarseSpaceType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetadaptcoarsespacetype_ PCMGGETADAPTCOARSESPACETYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetadaptcoarsespacetype_ pcmggetadaptcoarsespacetype
#endif
PETSC_EXTERN void pcmggetadaptcoarsespacetype_(PC *a, PCMGCoarseSpaceType *b, PetscErrorCode *ierr)
{
  *ierr = PCMGGetAdaptCoarseSpaceType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetadaptinterpolation_ PCMGSETADAPTINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetadaptinterpolation_ pcmgsetadaptinterpolation
#endif
PETSC_EXTERN void pcmgsetadaptinterpolation_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCMGSetAdaptInterpolation(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetadaptinterpolation_ PCMGGETADAPTINTERPOLATION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetadaptinterpolation_ pcmggetadaptinterpolation
#endif
PETSC_EXTERN void pcmggetadaptinterpolation_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCMGGetAdaptInterpolation(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetadaptcr_ PCMGSETADAPTCR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetadaptcr_ pcmgsetadaptcr
#endif
PETSC_EXTERN void pcmgsetadaptcr_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCMGSetAdaptCR(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmggetadaptcr_ PCMGGETADAPTCR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmggetadaptcr_ pcmggetadaptcr
#endif
PETSC_EXTERN void pcmggetadaptcr_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCMGGetAdaptCR(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetnumbersmooth_ PCMGSETNUMBERSMOOTH
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetnumbersmooth_ pcmgsetnumbersmooth
#endif
PETSC_EXTERN void pcmgsetnumbersmooth_(PC *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PCMGSetNumberSmooth(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcmgsetdistinctsmoothup_ PCMGSETDISTINCTSMOOTHUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcmgsetdistinctsmoothup_ pcmgsetdistinctsmoothup
#endif
PETSC_EXTERN void pcmgsetdistinctsmoothup_(PC *a, PetscErrorCode *ierr)
{
  *ierr = PCMGSetDistinctSmoothUp(*a);
  if (*ierr) return;
}
