#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcjacobisetuseabs_ PCJACOBISETUSEABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcjacobisetuseabs_ pcjacobisetuseabs
#endif
PETSC_EXTERN void pcjacobisetuseabs_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCJacobiSetUseAbs(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcjacobigetuseabs_ PCJACOBIGETUSEABS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcjacobigetuseabs_ pcjacobigetuseabs
#endif
PETSC_EXTERN void pcjacobigetuseabs_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCJacobiGetUseAbs(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcjacobisetrowl1scale_ PCJACOBISETROWL1SCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcjacobisetrowl1scale_ pcjacobisetrowl1scale
#endif
PETSC_EXTERN void pcjacobisetrowl1scale_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  *ierr = PCJacobiSetRowl1Scale(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcjacobigetrowl1scale_ PCJACOBIGETROWL1SCALE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcjacobigetrowl1scale_ pcjacobigetrowl1scale
#endif
PETSC_EXTERN void pcjacobigetrowl1scale_(PC *a, PetscReal *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  *ierr = PCJacobiGetRowl1Scale(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcjacobisetfixdiagonal_ PCJACOBISETFIXDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcjacobisetfixdiagonal_ pcjacobisetfixdiagonal
#endif
PETSC_EXTERN void pcjacobisetfixdiagonal_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = PCJacobiSetFixDiagonal(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcjacobigetfixdiagonal_ PCJACOBIGETFIXDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcjacobigetfixdiagonal_ pcjacobigetfixdiagonal
#endif
PETSC_EXTERN void pcjacobigetfixdiagonal_(PC *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = PCJacobiGetFixDiagonal(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcjacobigetdiagonal_ PCJACOBIGETDIAGONAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcjacobigetdiagonal_ pcjacobigetdiagonal
#endif
PETSC_EXTERN void pcjacobigetdiagonal_(PC *a, Vec *b, Vec *c, PetscErrorCode *ierr)
{
  *ierr = PCJacobiGetDiagonal(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcjacobisettype_ PCJACOBISETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcjacobisettype_ pcjacobisettype
#endif
PETSC_EXTERN void pcjacobisettype_(PC *a, PCJacobiType *b, PetscErrorCode *ierr)
{
  *ierr = PCJacobiSetType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscpc.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define pcjacobigettype_ PCJACOBIGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define pcjacobigettype_ pcjacobigettype
#endif
PETSC_EXTERN void pcjacobigettype_(PC *a, PCJacobiType *b, PetscErrorCode *ierr)
{
  *ierr = PCJacobiGetType(*a, b);
  if (*ierr) return;
}
