#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetoptionsprefix_ KSPSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetoptionsprefix_ kspsetoptionsprefix
#endif
PETSC_EXTERN void kspsetoptionsprefix_(KSP *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = KSPSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspappendoptionsprefix_ KSPAPPENDOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspappendoptionsprefix_ kspappendoptionsprefix
#endif
PETSC_EXTERN void kspappendoptionsprefix_(KSP *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = KSPAppendOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetusefischerguess_ KSPSETUSEFISCHERGUESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetusefischerguess_ kspsetusefischerguess
#endif
PETSC_EXTERN void kspsetusefischerguess_(KSP *a, PetscInt *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = KSPSetUseFischerGuess(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetguess_ KSPSETGUESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetguess_ kspsetguess
#endif
PETSC_EXTERN void kspsetguess_(KSP *a, KSPGuess *b, PetscErrorCode *ierr)
{
  *ierr = KSPSetGuess(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetguess_ KSPGETGUESS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetguess_ kspgetguess
#endif
PETSC_EXTERN void kspgetguess_(KSP *a, KSPGuess *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = KSPGetGuess(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspgetoptionsprefix_ KSPGETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspgetoptionsprefix_ kspgetoptionsprefix
#endif
PETSC_EXTERN void kspgetoptionsprefix_(KSP *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = KSPGetOptionsPrefix(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspmonitorsetfromoptions_ KSPMONITORSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspmonitorsetfromoptions_ kspmonitorsetfromoptions
#endif
PETSC_EXTERN void kspmonitorsetfromoptions_(KSP *a, char b[], char c[], void *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = KSPMonitorSetFromOptions(*a, c_b, c_c, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspsetfromoptions_ KSPSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspsetfromoptions_ kspsetfromoptions
#endif
PETSC_EXTERN void kspsetfromoptions_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscksp.h>
#include <petscksp.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define kspresetfromoptions_ KSPRESETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define kspresetfromoptions_ kspresetfromoptions
#endif
PETSC_EXTERN void kspresetfromoptions_(KSP *a, PetscErrorCode *ierr)
{
  *ierr = KSPResetFromOptions(*a);
  if (*ierr) return;
}
