#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinatedm_ DMGETCOORDINATEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinatedm_ dmgetcoordinatedm
#endif
PETSC_EXTERN void dmgetcoordinatedm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCoordinateDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcoordinatedm_ DMSETCOORDINATEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcoordinatedm_ dmsetcoordinatedm
#endif
PETSC_EXTERN void dmsetcoordinatedm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCoordinateDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcellcoordinatedm_ DMGETCELLCOORDINATEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcellcoordinatedm_ dmgetcellcoordinatedm
#endif
PETSC_EXTERN void dmgetcellcoordinatedm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCellCoordinateDM(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcellcoordinatedm_ DMSETCELLCOORDINATEDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcellcoordinatedm_ dmsetcellcoordinatedm
#endif
PETSC_EXTERN void dmsetcellcoordinatedm_(DM *a, DM *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCellCoordinateDM(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinatedim_ DMGETCOORDINATEDIM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinatedim_ dmgetcoordinatedim
#endif
PETSC_EXTERN void dmgetcoordinatedim_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMGetCoordinateDim(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcoordinatedim_ DMSETCOORDINATEDIM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcoordinatedim_ dmsetcoordinatedim
#endif
PETSC_EXTERN void dmsetcoordinatedim_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCoordinateDim(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinatesection_ DMGETCOORDINATESECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinatesection_ dmgetcoordinatesection
#endif
PETSC_EXTERN void dmgetcoordinatesection_(DM *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCoordinateSection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcoordinatesection_ DMSETCOORDINATESECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcoordinatesection_ dmsetcoordinatesection
#endif
PETSC_EXTERN void dmsetcoordinatesection_(DM *a, PetscInt *b, PetscSection *c, PetscErrorCode *ierr)
{
  *ierr = DMSetCoordinateSection(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcellcoordinatesection_ DMGETCELLCOORDINATESECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcellcoordinatesection_ dmgetcellcoordinatesection
#endif
PETSC_EXTERN void dmgetcellcoordinatesection_(DM *a, PetscSection *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCellCoordinateSection(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcellcoordinatesection_ DMSETCELLCOORDINATESECTION
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcellcoordinatesection_ dmsetcellcoordinatesection
#endif
PETSC_EXTERN void dmsetcellcoordinatesection_(DM *a, PetscInt *b, PetscSection *c, PetscErrorCode *ierr)
{
  *ierr = DMSetCellCoordinateSection(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinates_ DMGETCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinates_ dmgetcoordinates
#endif
PETSC_EXTERN void dmgetcoordinates_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCoordinates(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcoordinates_ DMSETCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcoordinates_ dmsetcoordinates
#endif
PETSC_EXTERN void dmsetcoordinates_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCoordinates(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcellcoordinates_ DMGETCELLCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcellcoordinates_ dmgetcellcoordinates
#endif
PETSC_EXTERN void dmgetcellcoordinates_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCellCoordinates(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcellcoordinates_ DMSETCELLCOORDINATES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcellcoordinates_ dmsetcellcoordinates
#endif
PETSC_EXTERN void dmsetcellcoordinates_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCellCoordinates(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinateslocalsetup_ DMGETCOORDINATESLOCALSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinateslocalsetup_ dmgetcoordinateslocalsetup
#endif
PETSC_EXTERN void dmgetcoordinateslocalsetup_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMGetCoordinatesLocalSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinateslocal_ DMGETCOORDINATESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinateslocal_ dmgetcoordinateslocal
#endif
PETSC_EXTERN void dmgetcoordinateslocal_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCoordinatesLocal(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinateslocalnoncollective_ DMGETCOORDINATESLOCALNONCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinateslocalnoncollective_ dmgetcoordinateslocalnoncollective
#endif
PETSC_EXTERN void dmgetcoordinateslocalnoncollective_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCoordinatesLocalNoncollective(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinateslocaltuple_ DMGETCOORDINATESLOCALTUPLE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinateslocaltuple_ dmgetcoordinateslocaltuple
#endif
PETSC_EXTERN void dmgetcoordinateslocaltuple_(DM *a, IS *b, PetscSection *c, Vec *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMGetCoordinatesLocalTuple(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcoordinateslocal_ DMSETCOORDINATESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcoordinateslocal_ dmsetcoordinateslocal
#endif
PETSC_EXTERN void dmsetcoordinateslocal_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCoordinatesLocal(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcellcoordinateslocalsetup_ DMGETCELLCOORDINATESLOCALSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcellcoordinateslocalsetup_ dmgetcellcoordinateslocalsetup
#endif
PETSC_EXTERN void dmgetcellcoordinateslocalsetup_(DM *a, PetscErrorCode *ierr)
{
  *ierr = DMGetCellCoordinatesLocalSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcellcoordinateslocal_ DMGETCELLCOORDINATESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcellcoordinateslocal_ dmgetcellcoordinateslocal
#endif
PETSC_EXTERN void dmgetcellcoordinateslocal_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCellCoordinatesLocal(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcellcoordinateslocalnoncollective_ DMGETCELLCOORDINATESLOCALNONCOLLECTIVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcellcoordinateslocalnoncollective_ dmgetcellcoordinateslocalnoncollective
#endif
PETSC_EXTERN void dmgetcellcoordinateslocalnoncollective_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCellCoordinatesLocalNoncollective(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcellcoordinateslocal_ DMSETCELLCOORDINATESLOCAL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcellcoordinateslocal_ dmsetcellcoordinateslocal
#endif
PETSC_EXTERN void dmsetcellcoordinateslocal_(DM *a, Vec *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCellCoordinatesLocal(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetcoordinatefield_ DMGETCOORDINATEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetcoordinatefield_ dmgetcoordinatefield
#endif
PETSC_EXTERN void dmgetcoordinatefield_(DM *a, DMField *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMGetCoordinateField(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcoordinatefield_ DMSETCOORDINATEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcoordinatefield_ dmsetcoordinatefield
#endif
PETSC_EXTERN void dmsetcoordinatefield_(DM *a, DMField *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCoordinateField(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcellcoordinatefield_ DMSETCELLCOORDINATEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcellcoordinatefield_ dmsetcellcoordinatefield
#endif
PETSC_EXTERN void dmsetcellcoordinatefield_(DM *a, DMField *b, PetscErrorCode *ierr)
{
  *ierr = DMSetCellCoordinateField(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetlocalboundingbox_ DMGETLOCALBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetlocalboundingbox_ dmgetlocalboundingbox
#endif
PETSC_EXTERN void dmgetlocalboundingbox_(DM *a, PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = DMGetLocalBoundingBox(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmgetboundingbox_ DMGETBOUNDINGBOX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmgetboundingbox_ dmgetboundingbox
#endif
PETSC_EXTERN void dmgetboundingbox_(DM *a, PetscReal b[], PetscReal c[], PetscErrorCode *ierr)
{
  CHKFORTRANNULLREAL(b);
  CHKFORTRANNULLREAL(c);
  *ierr = DMGetBoundingBox(*a, b, c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmsetcoordinatedisc_ DMSETCOORDINATEDISC
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmsetcoordinatedisc_ dmsetcoordinatedisc
#endif
PETSC_EXTERN void dmsetcoordinatedisc_(DM *a, PetscFE *b, PetscBool *c, PetscBool *d, PetscErrorCode *ierr)
{
  *ierr = DMSetCoordinateDisc(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, *d ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmlocatepoints_ DMLOCATEPOINTS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmlocatepoints_ dmlocatepoints
#endif
PETSC_EXTERN void dmlocatepoints_(DM *a, Vec *b, DMPointLocationType *c, PetscSF *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMLocatePoints(*a, *b, *c, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
