#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmdatabucketgetdmswarmdatafieldidbyname_ DMSWARMDATABUCKETGETDMSWARMDATAFIELDIDBYNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmdatabucketgetdmswarmdatafieldidbyname_ dmswarmdatabucketgetdmswarmdatafieldidbyname
#endif
PETSC_EXTERN void dmswarmdatabucketgetdmswarmdatafieldidbyname_(DMSwarmDataBucket *a, char b[], PetscInt *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLINTEGER(c);
  *ierr = DMSwarmDataBucketGetDMSwarmDataFieldIdByName(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmdatabucketgetdmswarmdatafieldbyname_ DMSWARMDATABUCKETGETDMSWARMDATAFIELDBYNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmdatabucketgetdmswarmdatafieldbyname_ dmswarmdatabucketgetdmswarmdatafieldbyname
#endif
PETSC_EXTERN void dmswarmdatabucketgetdmswarmdatafieldbyname_(DMSwarmDataBucket *a, char b[], DMSwarmDataField *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMSwarmDataBucketGetDMSwarmDataFieldByName(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmswarm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmswarmdatabucketquerydmswarmdatafieldbyname_ DMSWARMDATABUCKETQUERYDMSWARMDATAFIELDBYNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmswarmdatabucketquerydmswarmdatafieldbyname_ dmswarmdatabucketquerydmswarmdatafieldbyname
#endif
PETSC_EXTERN void dmswarmdatabucketquerydmswarmdatafieldbyname_(DMSwarmDataBucket *a, char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(c);
  *ierr = DMSwarmDataBucketQueryDMSwarmDataFieldByName(*a, c_b, c);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
