#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateplyfromfile_ DMPLEXCREATEPLYFROMFILE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateplyfromfile_ dmplexcreateplyfromfile
#endif
PETSC_EXTERN void dmplexcreateplyfromfile_(MPI_Fint *a, char b[], PetscBool *c, DM *d, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreatePLYFromFile(MPI_Comm_f2c(*(a)), c_b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  FREECHAR(b, c_b);
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
