#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetelementscorners_ DMDAGETELEMENTSCORNERS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetelementscorners_ dmdagetelementscorners
#endif
PETSC_EXTERN void dmdagetelementscorners_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMDAGetElementsCorners(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetelementssizes_ DMDAGETELEMENTSSIZES
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetelementssizes_ dmdagetelementssizes
#endif
PETSC_EXTERN void dmdagetelementssizes_(DM *a, PetscInt *b, PetscInt *c, PetscInt *d, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  CHKFORTRANNULLINTEGER(c);
  CHKFORTRANNULLINTEGER(d);
  *ierr = DMDAGetElementsSizes(*a, b, c, d);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdasetelementtype_ DMDASETELEMENTTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdasetelementtype_ dmdasetelementtype
#endif
PETSC_EXTERN void dmdasetelementtype_(DM *a, DMDAElementType *b, PetscErrorCode *ierr)
{
  *ierr = DMDASetElementType(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetelementtype_ DMDAGETELEMENTTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetelementtype_ dmdagetelementtype
#endif
PETSC_EXTERN void dmdagetelementtype_(DM *a, DMDAElementType *b, PetscErrorCode *ierr)
{
  *ierr = DMDAGetElementType(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdagetsubdomaincornersis_ DMDAGETSUBDOMAINCORNERSIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdagetsubdomaincornersis_ dmdagetsubdomaincornersis
#endif
PETSC_EXTERN void dmdagetsubdomaincornersis_(DM *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMDAGetSubdomainCornersIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmda.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmdarestoresubdomaincornersis_ DMDARESTORESUBDOMAINCORNERSIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmdarestoresubdomaincornersis_ dmdarestoresubdomaincornersis
#endif
PETSC_EXTERN void dmdarestoresubdomaincornersis_(DM *a, IS *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  *ierr = DMDARestoreSubdomainCornersIS(*a, b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
