//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/layers/PCompositorBridgeChild.h"
#include "gfxipc/ShadowLayerUtils.h"
#include "mozilla/GfxMessageUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ProfilerMarkers.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/gfx/2D.h"
#include "mozilla/ipc/BigBuffer.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/layers/CompositorBridgeChild.h"
#include "mozilla/layers/CompositorBridgeParent.h"
#include "mozilla/layers/CompositorTypes.h"
#include "mozilla/layers/LayersMessageUtils.h"
#include "mozilla/layers/LayersTypes.h"
#include "mozilla/layers/ScrollableLayerGuid.h"
#include "mozilla/layers/WebRenderMessageUtils.h"
#include "nsPoint.h"
#include "nsRect.h"

#include "mozilla/layers/PAPZChild.h"
#include "mozilla/layers/PAPZCTreeManagerChild.h"
#include "mozilla/layers/PAPZInputBridgeChild.h"
#include "mozilla/dom/PBrowserChild.h"
#include "mozilla/layers/PCompositorManagerChild.h"
#include "mozilla/widget/PCompositorWidgetChild.h"
#include "mozilla/layers/PTextureChild.h"
#include "mozilla/layers/PUiCompositorControllerChild.h"
#include "mozilla/layers/PWebRenderBridgeChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace layers {


MOZ_IMPLICIT PCompositorBridgeChild::PCompositorBridgeChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PCompositorBridgeChild);
}

PCompositorBridgeChild::~PCompositorBridgeChild()
{
    MOZ_COUNT_DTOR(PCompositorBridgeChild);
}

auto PCompositorBridgeChild::ActorAlloc() -> void
{
    AddRef();
}

auto PCompositorBridgeChild::ActorDealloc() -> void
{
    Release();
}

auto PCompositorBridgeChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCompositorBridgeChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCompositorBridgeChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCompositorBridgeChild::Manager() const -> PCompositorManagerChild*
{
    return static_cast<PCompositorManagerChild*>(IProtocol::Manager());
}

auto PCompositorBridgeChild::ManagedPAPZChild(nsTArray<PAPZChild*>& aArr) const -> void
{
    mManagedPAPZChild.ToArray(aArr);
}

auto PCompositorBridgeChild::ManagedPAPZChild() const -> const ManagedContainer<PAPZChild>&
{
    return mManagedPAPZChild;
}

auto PCompositorBridgeChild::ManagedPAPZCTreeManagerChild(nsTArray<PAPZCTreeManagerChild*>& aArr) const -> void
{
    mManagedPAPZCTreeManagerChild.ToArray(aArr);
}

auto PCompositorBridgeChild::ManagedPAPZCTreeManagerChild() const -> const ManagedContainer<PAPZCTreeManagerChild>&
{
    return mManagedPAPZCTreeManagerChild;
}

auto PCompositorBridgeChild::ManagedPTextureChild(nsTArray<PTextureChild*>& aArr) const -> void
{
    mManagedPTextureChild.ToArray(aArr);
}

auto PCompositorBridgeChild::ManagedPTextureChild() const -> const ManagedContainer<PTextureChild>&
{
    return mManagedPTextureChild;
}

auto PCompositorBridgeChild::ManagedPCompositorWidgetChild(nsTArray<PCompositorWidgetChild*>& aArr) const -> void
{
    mManagedPCompositorWidgetChild.ToArray(aArr);
}

auto PCompositorBridgeChild::ManagedPCompositorWidgetChild() const -> const ManagedContainer<PCompositorWidgetChild>&
{
    return mManagedPCompositorWidgetChild;
}

auto PCompositorBridgeChild::ManagedPWebRenderBridgeChild(nsTArray<PWebRenderBridgeChild*>& aArr) const -> void
{
    mManagedPWebRenderBridgeChild.ToArray(aArr);
}

auto PCompositorBridgeChild::ManagedPWebRenderBridgeChild() const -> const ManagedContainer<PWebRenderBridgeChild>&
{
    return mManagedPWebRenderBridgeChild;
}

auto PCompositorBridgeChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PAPZMsgStart,
        PAPZCTreeManagerMsgStart,
        PTextureMsgStart,
        PCompositorWidgetMsgStart,
        PWebRenderBridgeMsgStart
    };
    return sIds;
}

auto PCompositorBridgeChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PAPZMsgStart:
        return (&(mManagedPAPZChild));
    case PAPZCTreeManagerMsgStart:
        return (&(mManagedPAPZCTreeManagerChild));
    case PTextureMsgStart:
        return (&(mManagedPTextureChild));
    case PCompositorWidgetMsgStart:
        return (&(mManagedPCompositorWidgetChild));
    case PWebRenderBridgeMsgStart:
        return (&(mManagedPWebRenderBridgeChild));
    default:
        return nullptr;
    }
}

auto PCompositorBridgeChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PCompositorBridgeChild::OpenPAPZEndpoint(PAPZChild* aActor) -> ManagedEndpoint<PAPZParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PAPZChild actor");
        return ManagedEndpoint<PAPZParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAPZChild actor");
        return ManagedEndpoint<PAPZParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PAPZParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorBridgeChild::BindPAPZEndpoint(
        ManagedEndpoint<PAPZChild> aEndpoint,
        PAPZChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorBridgeChild::OpenPAPZCTreeManagerEndpoint(PAPZCTreeManagerChild* aActor) -> ManagedEndpoint<PAPZCTreeManagerParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PAPZCTreeManagerChild actor");
        return ManagedEndpoint<PAPZCTreeManagerParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAPZCTreeManagerChild actor");
        return ManagedEndpoint<PAPZCTreeManagerParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PAPZCTreeManagerParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorBridgeChild::BindPAPZCTreeManagerEndpoint(
        ManagedEndpoint<PAPZCTreeManagerChild> aEndpoint,
        PAPZCTreeManagerChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorBridgeChild::OpenPTextureEndpoint(PTextureChild* aActor) -> ManagedEndpoint<PTextureParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PTextureChild actor");
        return ManagedEndpoint<PTextureParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTextureChild actor");
        return ManagedEndpoint<PTextureParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PTextureParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorBridgeChild::BindPTextureEndpoint(
        ManagedEndpoint<PTextureChild> aEndpoint,
        PTextureChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorBridgeChild::OpenPCompositorWidgetEndpoint(PCompositorWidgetChild* aActor) -> ManagedEndpoint<PCompositorWidgetParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PCompositorWidgetChild actor");
        return ManagedEndpoint<PCompositorWidgetParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCompositorWidgetChild actor");
        return ManagedEndpoint<PCompositorWidgetParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PCompositorWidgetParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorBridgeChild::BindPCompositorWidgetEndpoint(
        ManagedEndpoint<PCompositorWidgetChild> aEndpoint,
        PCompositorWidgetChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorBridgeChild::OpenPWebRenderBridgeEndpoint(PWebRenderBridgeChild* aActor) -> ManagedEndpoint<PWebRenderBridgeParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebRenderBridgeChild actor");
        return ManagedEndpoint<PWebRenderBridgeParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebRenderBridgeChild actor");
        return ManagedEndpoint<PWebRenderBridgeParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebRenderBridgeParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCompositorBridgeChild::BindPWebRenderBridgeEndpoint(
        ManagedEndpoint<PWebRenderBridgeChild> aEndpoint,
        PWebRenderBridgeChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCompositorBridgeChild::Send__delete__(PCompositorBridgeChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PCompositorBridgeChild::SendPCompositorWidgetConstructor(
        PCompositorWidgetChild* actor,
        const CompositorWidgetInitData& aInitData) -> PCompositorWidgetChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PCompositorWidgetChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCompositorWidgetChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_PCompositorWidgetConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aInitData);
    // Sentinel = 'aInitData'
    ((&(writer__)))->WriteSentinel(284296048);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_PCompositorWidgetConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PCompositorWidgetChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PCompositorBridgeChild::SendInitialize(const LayersId& rootLayerTreeId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_Initialize(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), rootLayerTreeId);
    // Sentinel = 'rootLayerTreeId'
    ((&(writer__)))->WriteSentinel(828507647);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_Initialize", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeChild::SendInitAPZInputBridge(Endpoint<::mozilla::layers::PAPZInputBridgeParent>&& endpoint) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_InitAPZInputBridge(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(endpoint));
    // Sentinel = 'endpoint'
    ((&(writer__)))->WriteSentinel(251724642);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_InitAPZInputBridge", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeChild::SendInitUiCompositorController(Endpoint<::mozilla::layers::PUiCompositorControllerParent>&& endpoint) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_InitUiCompositorController(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), std::move(endpoint));
    // Sentinel = 'endpoint'
    ((&(writer__)))->WriteSentinel(251724642);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_InitUiCompositorController", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeChild::SendPAPZConstructor(const LayersId& layersId) -> PAPZChild*
{
    PAPZChild* actor = (static_cast<CompositorBridgeChild*>(this))->AllocPAPZChild(layersId);
    return SendPAPZConstructor(std::move(actor), std::move(layersId));
}

auto PCompositorBridgeChild::SendPAPZConstructor(
        PAPZChild* actor,
        const LayersId& layersId) -> PAPZChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PAPZChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAPZChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_PAPZConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), layersId);
    // Sentinel = 'layersId'
    ((&(writer__)))->WriteSentinel(250938174);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_PAPZConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PAPZChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PCompositorBridgeChild::SendPAPZCTreeManagerConstructor(const LayersId& layersId) -> PAPZCTreeManagerChild*
{
    PAPZCTreeManagerChild* actor = (static_cast<CompositorBridgeChild*>(this))->AllocPAPZCTreeManagerChild(layersId);
    return SendPAPZCTreeManagerConstructor(std::move(actor), std::move(layersId));
}

auto PCompositorBridgeChild::SendPAPZCTreeManagerConstructor(
        PAPZCTreeManagerChild* actor,
        const LayersId& layersId) -> PAPZCTreeManagerChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PAPZCTreeManagerChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAPZCTreeManagerChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_PAPZCTreeManagerConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), layersId);
    // Sentinel = 'layersId'
    ((&(writer__)))->WriteSentinel(250938174);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_PAPZCTreeManagerConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PAPZCTreeManagerChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PCompositorBridgeChild::SendWillClose() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_WillClose(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};


    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_WillClose", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_WillClose", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    return true;
}

auto PCompositorBridgeChild::SendPause() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_Pause(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};


    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_Pause", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_Pause", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    return true;
}

auto PCompositorBridgeChild::SendResume() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_Resume(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};


    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_Resume", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_Resume", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    return true;
}

auto PCompositorBridgeChild::SendResumeAsync() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_ResumeAsync(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_ResumeAsync", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeChild::SendNotifyChildCreated(
        const LayersId& id,
        CompositorOptions* compositorOptions) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_NotifyChildCreated(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);

    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_NotifyChildCreated", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_NotifyChildCreated", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__compositorOptions__reply = IPC::ReadParam<CompositorOptions>((&(reader__)));
    if (!maybe__compositorOptions__reply) {
        FatalError("Error deserializing 'CompositorOptions'");
        return false;

    }
    auto& compositorOptions__reply = *maybe__compositorOptions__reply;
    // Sentinel = 'compositorOptions'
    if ((!(((&(reader__)))->ReadSentinel(1089275708)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'CompositorOptions'");
        return false;
    }
    (*(compositorOptions)) = std::move(compositorOptions__reply);
    reader__.EndRead();

    return true;
}

auto PCompositorBridgeChild::SendMapAndNotifyChildCreated(
        const LayersId& id,
        const ProcessId& owner,
        CompositorOptions* compositorOptions) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_MapAndNotifyChildCreated(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), owner);
    // Sentinel = 'owner'
    ((&(writer__)))->WriteSentinel(110232108);

    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_MapAndNotifyChildCreated", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_MapAndNotifyChildCreated", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__compositorOptions__reply = IPC::ReadParam<CompositorOptions>((&(reader__)));
    if (!maybe__compositorOptions__reply) {
        FatalError("Error deserializing 'CompositorOptions'");
        return false;

    }
    auto& compositorOptions__reply = *maybe__compositorOptions__reply;
    // Sentinel = 'compositorOptions'
    if ((!(((&(reader__)))->ReadSentinel(1089275708)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'CompositorOptions'");
        return false;
    }
    (*(compositorOptions)) = std::move(compositorOptions__reply);
    reader__.EndRead();

    return true;
}

auto PCompositorBridgeChild::SendAdoptChild(const LayersId& id) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_AdoptChild(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_AdoptChild", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeChild::SendNotifyChildRecreated(
        const LayersId& id,
        CompositorOptions* compositorOptions) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_NotifyChildRecreated(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);

    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_NotifyChildRecreated", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_NotifyChildRecreated", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__compositorOptions__reply = IPC::ReadParam<CompositorOptions>((&(reader__)));
    if (!maybe__compositorOptions__reply) {
        FatalError("Error deserializing 'CompositorOptions'");
        return false;

    }
    auto& compositorOptions__reply = *maybe__compositorOptions__reply;
    // Sentinel = 'compositorOptions'
    if ((!(((&(reader__)))->ReadSentinel(1089275708)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'CompositorOptions'");
        return false;
    }
    (*(compositorOptions)) = std::move(compositorOptions__reply);
    reader__.EndRead();

    return true;
}

auto PCompositorBridgeChild::SendNotifyMemoryPressure() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_NotifyMemoryPressure(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_NotifyMemoryPressure", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeChild::SendFlushRendering(const RenderReasons& aReasons) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_FlushRendering(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aReasons);
    // Sentinel = 'aReasons'
    ((&(writer__)))->WriteSentinel(234423101);

    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_FlushRendering", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_FlushRendering", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    return true;
}

auto PCompositorBridgeChild::SendFlushRenderingAsync(const RenderReasons& aReasons) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_FlushRenderingAsync(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aReasons);
    // Sentinel = 'aReasons'
    ((&(writer__)))->WriteSentinel(234423101);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_FlushRenderingAsync", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeChild::SendWaitOnTransactionProcessed() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_WaitOnTransactionProcessed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};


    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_WaitOnTransactionProcessed", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_WaitOnTransactionProcessed", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    return true;
}

auto PCompositorBridgeChild::SendForcePresent(const RenderReasons& aReasons) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_ForcePresent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aReasons);
    // Sentinel = 'aReasons'
    ((&(writer__)))->WriteSentinel(234423101);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_ForcePresent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeChild::SendStartFrameTimeRecording(
        const int32_t& bufferSize,
        uint32_t* startIndex) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_StartFrameTimeRecording(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), bufferSize);
    // Sentinel = 'bufferSize'
    ((&(writer__)))->WriteSentinel(376243222);

    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_StartFrameTimeRecording", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_StartFrameTimeRecording", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__startIndex__reply = IPC::ReadParam<uint32_t>((&(reader__)));
    if (!maybe__startIndex__reply) {
        FatalError("Error deserializing 'uint32_t'");
        return false;

    }
    auto& startIndex__reply = *maybe__startIndex__reply;
    // Sentinel = 'startIndex'
    if ((!(((&(reader__)))->ReadSentinel(386728999)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
        return false;
    }
    (*(startIndex)) = std::move(startIndex__reply);
    reader__.EndRead();

    return true;
}

auto PCompositorBridgeChild::SendStopFrameTimeRecording(
        const uint32_t& startIndex,
        nsTArray<float>* intervals) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_StopFrameTimeRecording(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), startIndex);
    // Sentinel = 'startIndex'
    ((&(writer__)))->WriteSentinel(386728999);

    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_StopFrameTimeRecording", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_StopFrameTimeRecording", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__intervals__reply = IPC::ReadParam<nsTArray<float>>((&(reader__)));
    if (!maybe__intervals__reply) {
        FatalError("Error deserializing 'float[]'");
        return false;

    }
    auto& intervals__reply = *maybe__intervals__reply;
    // Sentinel = 'intervals'
    if ((!(((&(reader__)))->ReadSentinel(322175961)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'float[]'");
        return false;
    }
    (*(intervals)) = std::move(intervals__reply);
    reader__.EndRead();

    return true;
}

auto PCompositorBridgeChild::SendPTextureConstructor(
        const SurfaceDescriptor& aSharedData,
        ReadLockDescriptor&& aReadLock,
        const LayersBackend& aBackend,
        const TextureFlags& aTextureFlags,
        const LayersId& id,
        const uint64_t& aSerial,
        const MaybeExternalImageId& aExternalImageId) -> PTextureChild*
{
    PTextureChild* actor = (static_cast<CompositorBridgeChild*>(this))->AllocPTextureChild(aSharedData, aReadLock, aBackend, aTextureFlags, id, aSerial, aExternalImageId);
    return SendPTextureConstructor(std::move(actor), std::move(aSharedData), std::move(aReadLock), std::move(aBackend), std::move(aTextureFlags), std::move(id), std::move(aSerial), std::move(aExternalImageId));
}

auto PCompositorBridgeChild::SendPTextureConstructor(
        PTextureChild* actor,
        const SurfaceDescriptor& aSharedData,
        ReadLockDescriptor&& aReadLock,
        const LayersBackend& aBackend,
        const TextureFlags& aTextureFlags,
        const LayersId& id,
        const uint64_t& aSerial,
        const MaybeExternalImageId& aExternalImageId) -> PTextureChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PTextureChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTextureChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_PTextureConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aSharedData);
    // Sentinel = 'aSharedData'
    ((&(writer__)))->WriteSentinel(420480051);
    IPC::WriteParam((&(writer__)), std::move(aReadLock));
    // Sentinel = 'aReadLock'
    ((&(writer__)))->WriteSentinel(279774055);
    IPC::WriteParam((&(writer__)), aBackend);
    // Sentinel = 'aBackend'
    ((&(writer__)))->WriteSentinel(221119242);
    IPC::WriteParam((&(writer__)), aTextureFlags);
    // Sentinel = 'aTextureFlags'
    ((&(writer__)))->WriteSentinel(614139200);
    IPC::WriteParam((&(writer__)), id);
    // Sentinel = 'id'
    ((&(writer__)))->WriteSentinel(20447438);
    IPC::WriteParam((&(writer__)), aSerial);
    // Sentinel = 'aSerial'
    ((&(writer__)))->WriteSentinel(181011138);
    IPC::WriteParam((&(writer__)), aExternalImageId);
    // Sentinel = 'aExternalImageId'
    ((&(writer__)))->WriteSentinel(898172469);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_PTextureConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PTextureChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PCompositorBridgeChild::SendSyncWithCompositor() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_SyncWithCompositor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};


    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_SyncWithCompositor", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_SyncWithCompositor", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    return true;
}

auto PCompositorBridgeChild::SendPWebRenderBridgeConstructor(
        const PipelineId& pipelineId,
        const LayoutDeviceIntSize& aSize,
        const WindowKind& aKind) -> PWebRenderBridgeChild*
{
    PWebRenderBridgeChild* actor = (static_cast<CompositorBridgeChild*>(this))->AllocPWebRenderBridgeChild(pipelineId, aSize, aKind);
    return SendPWebRenderBridgeConstructor(std::move(actor), std::move(pipelineId), std::move(aSize), std::move(aKind));
}

auto PCompositorBridgeChild::SendPWebRenderBridgeConstructor(
        PWebRenderBridgeChild* actor,
        const PipelineId& pipelineId,
        const LayoutDeviceIntSize& aSize,
        const WindowKind& aKind) -> PWebRenderBridgeChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PWebRenderBridgeChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebRenderBridgeChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_PWebRenderBridgeConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), pipelineId);
    // Sentinel = 'pipelineId'
    ((&(writer__)))->WriteSentinel(382731268);
    IPC::WriteParam((&(writer__)), aSize);
    // Sentinel = 'aSize'
    ((&(writer__)))->WriteSentinel(97124861);
    IPC::WriteParam((&(writer__)), aKind);
    // Sentinel = 'aKind'
    ((&(writer__)))->WriteSentinel(93389288);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_PWebRenderBridgeConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PWebRenderBridgeChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PCompositorBridgeChild::SendCheckContentOnlyTDR(
        const uint32_t& sequenceNum,
        bool* isContentOnlyTDR) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_CheckContentOnlyTDR(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), sequenceNum);
    // Sentinel = 'sequenceNum'
    ((&(writer__)))->WriteSentinel(464127114);

    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_CheckContentOnlyTDR", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCompositorBridge::Msg_CheckContentOnlyTDR", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__isContentOnlyTDR__reply = IPC::ReadParam<bool>((&(reader__)));
    if (!maybe__isContentOnlyTDR__reply) {
        FatalError("Error deserializing 'bool'");
        return false;

    }
    auto& isContentOnlyTDR__reply = *maybe__isContentOnlyTDR__reply;
    // Sentinel = 'isContentOnlyTDR'
    if ((!(((&(reader__)))->ReadSentinel(919668292)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
        return false;
    }
    (*(isContentOnlyTDR)) = std::move(isContentOnlyTDR__reply);
    reader__.EndRead();

    return true;
}

auto PCompositorBridgeChild::SendBeginRecording(
        const TimeStamp& aRecordingStart,
        mozilla::ipc::ResolveCallback<bool>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_BeginRecording(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aRecordingStart);
    // Sentinel = 'aRecordingStart'
    ((&(writer__)))->WriteSentinel(794428941);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_BeginRecording", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PCompositorBridge::Reply_BeginRecording__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__success = IPC::ReadParam<bool>(aReader);
            if (!maybe__success) {
                (aReader)->FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& success = *maybe__success;
            // Sentinel = 'success'
            if ((!((aReader)->ReadSentinel(200082170)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(success));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PCompositorBridgeChild::SendBeginRecording(const TimeStamp& aRecordingStart) -> RefPtr<BeginRecordingPromise>
{
    RefPtr<MozPromise<bool, ResponseRejectReason, true>::Private> promise__ = new MozPromise<bool, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendBeginRecording(std::move(aRecordingStart), [promise__](bool&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PCompositorBridgeChild::SendEndRecording(
        mozilla::ipc::ResolveCallback<mozilla::Maybe<FrameRecording>>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_EndRecording(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_EndRecording", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PCompositorBridge::Reply_EndRecording__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__recording = IPC::ReadParam<mozilla::Maybe<FrameRecording>>(aReader);
            if (!maybe__recording) {
                (aReader)->FatalError("Error deserializing 'FrameRecording?'");
                return MsgValueError;

            }
            auto& recording = *maybe__recording;
            // Sentinel = 'recording'
            if ((!((aReader)->ReadSentinel(315229118)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FrameRecording?'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(recording));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PCompositorBridgeChild::SendEndRecording() -> RefPtr<EndRecordingPromise>
{
    RefPtr<MozPromise<mozilla::Maybe<FrameRecording>, ResponseRejectReason, true>::Private> promise__ = new MozPromise<mozilla::Maybe<FrameRecording>, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendEndRecording([promise__](mozilla::Maybe<FrameRecording>&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PCompositorBridgeChild::SendRequestFxrOutput() -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_RequestFxrOutput(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_RequestFxrOutput", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeChild::SendDynamicToolbarOffsetChanged(const int32_t& aOffset) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCompositorBridge::Msg_DynamicToolbarOffsetChanged(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aOffset);
    // Sentinel = 'aOffset'
    ((&(writer__)))->WriteSentinel(179634889);


    if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCompositorBridgeChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCompositorBridge::Msg_DynamicToolbarOffsetChanged", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCompositorBridgeChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PAPZMsgStart:
        static_cast<CompositorBridgeChild*>(this)->DeallocPAPZChild(static_cast<PAPZChild*>(aListener));
        return;
    case PAPZCTreeManagerMsgStart:
        static_cast<CompositorBridgeChild*>(this)->DeallocPAPZCTreeManagerChild(static_cast<PAPZCTreeManagerChild*>(aListener));
        return;
    case PTextureMsgStart:
        static_cast<CompositorBridgeChild*>(this)->DeallocPTextureChild(static_cast<PTextureChild*>(aListener));
        return;
    case PWebRenderBridgeMsgStart:
        static_cast<CompositorBridgeChild*>(this)->DeallocPWebRenderBridgeChild(static_cast<PWebRenderBridgeChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PCompositorBridgeChild::OnMessageReceived(const Message& msg__) -> PCompositorBridgeChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PCompositorBridge::Msg_DidComposite__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_DidComposite", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            auto maybe__transactionId = IPC::ReadParam<nsTArray<TransactionId>>((&(reader__)));
            if (!maybe__transactionId) {
                FatalError("Error deserializing 'TransactionId[]'");
                return MsgValueError;

            }
            auto& transactionId = *maybe__transactionId;
            // Sentinel = 'transactionId'
            if ((!(((&(reader__)))->ReadSentinel(642319700)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TransactionId[]'");
                return MsgValueError;
            }
            auto maybe__compositeStart = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__compositeStart) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& compositeStart = *maybe__compositeStart;
            // Sentinel = 'compositeStart'
            if ((!(((&(reader__)))->ReadSentinel(740558306)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            auto maybe__compositeEnd = IPC::ReadParam<TimeStamp>((&(reader__)));
            if (!maybe__compositeEnd) {
                FatalError("Error deserializing 'TimeStamp'");
                return MsgValueError;

            }
            auto& compositeEnd = *maybe__compositeEnd;
            // Sentinel = 'compositeEnd'
            if ((!(((&(reader__)))->ReadSentinel(547423467)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TimeStamp'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeChild*>(this))->RecvDidComposite(std::move(id), std::move(transactionId), std::move(compositeStart), std::move(compositeEnd));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_NotifyFrameStats__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_NotifyFrameStats", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aFrameStats = IPC::ReadParam<nsTArray<FrameStats>>((&(reader__)));
            if (!maybe__aFrameStats) {
                FatalError("Error deserializing 'FrameStats[]'");
                return MsgValueError;

            }
            auto& aFrameStats = *maybe__aFrameStats;
            // Sentinel = 'aFrameStats'
            if ((!(((&(reader__)))->ReadSentinel(423756892)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FrameStats[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeChild*>(this))->RecvNotifyFrameStats(std::move(aFrameStats));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_ParentAsyncMessages__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_ParentAsyncMessages", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aMessages = IPC::ReadParam<nsTArray<AsyncParentMessageData>>((&(reader__)));
            if (!maybe__aMessages) {
                FatalError("Error deserializing 'AsyncParentMessageData[]'");
                return MsgValueError;

            }
            auto& aMessages = *maybe__aMessages;
            // Sentinel = 'aMessages'
            if ((!(((&(reader__)))->ReadSentinel(293864346)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'AsyncParentMessageData[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeChild*>(this))->RecvParentAsyncMessages(std::move(aMessages));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_ObserveLayersUpdate__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_ObserveLayersUpdate", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aLayersId = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__aLayersId) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& aLayersId = *maybe__aLayersId;
            // Sentinel = 'aLayersId'
            if ((!(((&(reader__)))->ReadSentinel(291439487)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            auto maybe__aActive = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__aActive) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& aActive = *maybe__aActive;
            // Sentinel = 'aActive'
            if ((!(((&(reader__)))->ReadSentinel(176095934)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeChild*>(this))->RecvObserveLayersUpdate(std::move(aLayersId), std::move(aActive));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_CompositorOptionsChanged__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_CompositorOptionsChanged", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            auto maybe__newOptions = IPC::ReadParam<CompositorOptions>((&(reader__)));
            if (!maybe__newOptions) {
                FatalError("Error deserializing 'CompositorOptions'");
                return MsgValueError;

            }
            auto& newOptions = *maybe__newOptions;
            // Sentinel = 'newOptions'
            if ((!(((&(reader__)))->ReadSentinel(384304183)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CompositorOptions'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeChild*>(this))->RecvCompositorOptionsChanged(std::move(id), std::move(newOptions));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Msg_NotifyJankedAnimations__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_NotifyJankedAnimations", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__id = IPC::ReadParam<LayersId>((&(reader__)));
            if (!maybe__id) {
                FatalError("Error deserializing 'LayersId'");
                return MsgValueError;

            }
            auto& id = *maybe__id;
            // Sentinel = 'id'
            if ((!(((&(reader__)))->ReadSentinel(20447438)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LayersId'");
                return MsgValueError;
            }
            auto maybe__aJankedAnimations = IPC::ReadParam<nsTArray<uint64_t>>((&(reader__)));
            if (!maybe__aJankedAnimations) {
                FatalError("Error deserializing 'uint64_t[]'");
                return MsgValueError;

            }
            auto& aJankedAnimations = *maybe__aJankedAnimations;
            // Sentinel = 'aJankedAnimations'
            if ((!(((&(reader__)))->ReadSentinel(985728706)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<CompositorBridgeChild*>(this))->RecvNotifyJankedAnimations(std::move(id), std::move(aJankedAnimations));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PCompositorBridge::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PCompositorBridge::Reply_PCompositorWidgetConstructor__ID:
        {
            return MsgProcessed;
        }
    case PCompositorBridge::Reply_PAPZConstructor__ID:
        {
            return MsgProcessed;
        }
    case PCompositorBridge::Reply_PAPZCTreeManagerConstructor__ID:
        {
            return MsgProcessed;
        }
    case PCompositorBridge::Reply_PTextureConstructor__ID:
        {
            return MsgProcessed;
        }
    case PCompositorBridge::Reply_PWebRenderBridgeConstructor__ID:
        {
            return MsgProcessed;
        }
    case PCompositorBridge::Reply_BeginRecording__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_BeginRecording", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PCompositorBridge::Reply_EndRecording__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PCompositorBridge", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCompositorBridgeChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PCompositorBridge::Msg_EndRecording", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    default:
        return MsgNotKnown;
    }
}

auto PCompositorBridgeChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCompositorBridgeChild::Result
{
    return MsgNotKnown;
}



} // namespace layers
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::layers::PCompositorBridgeChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PCompositorBridge'
    (aWriter)->WriteSentinel(1013581517);
}

auto ParamTraits<::mozilla::layers::PCompositorBridgeChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PCompositorBridge actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PCompositorBridge'
    if ((!((aReader)->ReadSentinel(1013581517)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PCompositorBridge actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PCompositorBridgeMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PCompositorBridge)");

        return {};
    }
    return static_cast<::mozilla::layers::PCompositorBridgeChild*>(actor);
}

} // namespace IPC
