// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanReputationserviceMetrics_h
#define mozilla_GleanReputationserviceMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace application_reputation {
  /**
   * generated from application_reputation.binary_archive
   */
  enum class BinaryArchiveLabel: uint16_t {
    eOtherbinaryfile = 0,
    eDmgfile = 1,
    eRarfile = 2,
    eZipfile = 3,
    e__Other__,
  };
  /**
   * Whether a binary file examined by download protection is one of the common archive formats.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram APPLICATION_REPUTATION_BINARY_ARCHIVE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, BinaryArchiveLabel> binary_archive(5388);

  /**
   * generated from application_reputation.binary_type
   */
  enum class BinaryTypeLabel: uint16_t {
    eBinaryfile = 0,
    eNonbinaryfile = 1,
    eMoznonbinaryfile = 2,
    eUnknownfile = 3,
    eMissingfilename = 4,
    e__Other__,
  };
  /**
   * Whether or not the file examined by download protection is a binary type (or it's not possible to tell because the filename is missing).
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram APPLICATION_REPUTATION_BINARY_TYPE.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, BinaryTypeLabel> binary_type(5389);

  /**
   * generated from application_reputation.local
   * Application reputation local results (0=ALLOW, 1=BLOCK, 2=NONE)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram APPLICATION_REPUTATION_LOCAL.
   */
  constexpr impl::CustomDistributionMetric local(5390);

  /**
   * generated from application_reputation.reason
   */
  enum class ReasonLabel: uint16_t {
    eNotset = 0,
    eLocalwhitelist = 1,
    eLocalblocklist = 2,
    eNonbinaryfile = 3,
    eVerdictsafe = 4,
    eVerdictunknown = 5,
    eVerdictdangerous = 6,
    eVerdictdangeroushost = 7,
    eVerdictunwanted = 8,
    eVerdictuncommon = 9,
    eVerdictunrecognized = 10,
    eDangerousprefoff = 11,
    eDangeroushostprefoff = 12,
    eUnwantedprefoff = 13,
    eUncommonprefoff = 14,
    eNetworkerror = 15,
    eRemotelookupdisabled = 16,
    eInternalerror = 17,
    eDpdisabled = 18,
    e__Other__,
  };
  /**
   * The reason application reputation service blocks or allows the download.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram APPLICATION_REPUTATION_REASON.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ReasonLabel> reason(5391);

  /**
   * generated from application_reputation.remote_lookup_response_time
   * Server response time to remote lookup request (ms).
   * This metric was generated to correspond to the Legacy Telemetry linear histogram APPLICATION_REPUTATION_REMOTE_LOOKUP_RESPONSE_TIME.
   */
  constexpr impl::TimingDistributionMetric remote_lookup_response_time(5392);

  /**
   * generated from application_reputation.remote_lookup_timeout
   */
  enum class RemoteLookupTimeoutLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Recorded when application reputation remote lookup is performed, `true` is recorded if the lookup times out.
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram APPLICATION_REPUTATION_REMOTE_LOOKUP_TIMEOUT.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, RemoteLookupTimeoutLabel> remote_lookup_timeout(5393);

  /**
   * generated from application_reputation.server
   * Status of the application reputation remote lookup (0=OK, 1=failed, 2=invalid protobuf response)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram APPLICATION_REPUTATION_SERVER.
   */
  constexpr impl::CustomDistributionMetric server(5394);

  /**
   * generated from application_reputation.server_2
   */
  enum class Server2Label: uint16_t {
    eErrothers = 0,
    eResponsevalid = 1,
    eFailgetchannel = 2,
    eFailgetresponse = 3,
    eHttp1xx = 4,
    eHttp2xx = 5,
    eHttp204 = 6,
    eHttp3xx = 7,
    eHttp400 = 8,
    eHttp4xx = 9,
    eHttp403 = 10,
    eHttp404 = 11,
    eHttp408 = 12,
    eHttp413 = 13,
    eHttp5xx = 14,
    eHttp502504511 = 15,
    eHttp503 = 16,
    eHttp505 = 17,
    eHttpothers = 18,
    eErralreadyconnected = 19,
    eErrnotconnected = 20,
    eErrconnectionrefused = 21,
    eErrnettimeout = 22,
    eErroffline = 23,
    eErrportaccess = 24,
    eErrnetreset = 25,
    eErrnetinterrupt = 26,
    eErrproxyconnection = 27,
    eErrnetpartial = 28,
    eErrnetinadequate = 29,
    eErrunknownhost = 30,
    eErrdnslookupqueue = 31,
    eErrunknownproxyhost = 32,
    e__Other__,
  };
  /**
   * Network status of the application reputation remote lookup
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram APPLICATION_REPUTATION_SERVER_2.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, Server2Label> server_2(5395);

  /**
   * generated from application_reputation.server_verdict
   * Application reputation remote verdict (0=SAFE, 1=DANGEROUS, 2=UNCOMMON, 3=POTENTIALLY_UNWANTED, 4=DANGEROUS_HOST, 5=UNKNOWN)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram APPLICATION_REPUTATION_SERVER_VERDICT.
   */
  constexpr impl::CustomDistributionMetric server_verdict(5396);

  /**
   * generated from application_reputation.server_verdict_2
   * Application reputation remote verdict, keyed by file extension
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram APPLICATION_REPUTATION_SERVER_VERDICT_2.
   */
  constexpr impl::DualLabeledCounterMetric server_verdict_2(5397);

  /**
   * generated from application_reputation.should_block
   */
  enum class ShouldBlockLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Overall (local or remote) application reputation verdict (shouldBlock=false is OK).
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram APPLICATION_REPUTATION_SHOULD_BLOCK.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ShouldBlockLabel> should_block(5398);
}

} // namespace mozilla::glean

#endif // mozilla_GleanReputationserviceMetrics_h
