// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_transform_guest
//
// (header) generated by ../mesa-25.2.5/src/gfxstream/codegen/scripts/genvk.py -registry ../mesa-25.2.5/src/vulkan/registry/vk.xml -registryGfxstream ../mesa-25.2.5/src/gfxstream/codegen/xml/vk_gfxstream.xml cereal -o /build/mesa/src/build/src/gfxstream/guest/vulkan_enc/host/vulkan/cereal
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//
#pragma once
#include <vulkan/vulkan.h>
#include "vulkan_gfxstream.h"
#include "vk_android_native_buffer_gfxstream.h"

#include "vk_platform_compat.h"

#include "goldfish_vk_private_defs.h"


namespace gfxstream {
namespace vk {

class ResourceTracker;
#define LIST_TRIVIAL_TRANSFORMED_TYPES(f) \
f(VkPhysicalDeviceExternalImageFormatInfo) \
f(VkPhysicalDeviceExternalBufferInfo) \
f(VkExternalMemoryImageCreateInfo) \
f(VkExternalMemoryBufferCreateInfo) \
f(VkExportMemoryAllocateInfo) \
f(VkExternalImageFormatProperties) \
f(VkExternalBufferProperties) \

#define LIST_NON_TRIVIAL_TRANSFORMED_TYPES(f) \
f(VkExternalMemoryProperties) \
f(VkImageCreateInfo) \

#define LIST_TRANSFORMED_TYPES(f) \
LIST_TRIVIAL_TRANSFORMED_TYPES(f) \
LIST_NON_TRIVIAL_TRANSFORMED_TYPES(f) \

#ifdef VK_VERSION_1_0
void transform_tohost_VkExtent2D(
    ResourceTracker* resourceTracker,
    VkExtent2D* toTransform);

void transform_fromhost_VkExtent2D(
    ResourceTracker* resourceTracker,
    VkExtent2D* toTransform);

void transform_tohost_VkExtent3D(
    ResourceTracker* resourceTracker,
    VkExtent3D* toTransform);

void transform_fromhost_VkExtent3D(
    ResourceTracker* resourceTracker,
    VkExtent3D* toTransform);

void transform_tohost_VkOffset2D(
    ResourceTracker* resourceTracker,
    VkOffset2D* toTransform);

void transform_fromhost_VkOffset2D(
    ResourceTracker* resourceTracker,
    VkOffset2D* toTransform);

void transform_tohost_VkOffset3D(
    ResourceTracker* resourceTracker,
    VkOffset3D* toTransform);

void transform_fromhost_VkOffset3D(
    ResourceTracker* resourceTracker,
    VkOffset3D* toTransform);

void transform_tohost_VkRect2D(
    ResourceTracker* resourceTracker,
    VkRect2D* toTransform);

void transform_fromhost_VkRect2D(
    ResourceTracker* resourceTracker,
    VkRect2D* toTransform);

void transform_tohost_VkBaseInStructure(
    ResourceTracker* resourceTracker,
    VkBaseInStructure* toTransform);

void transform_fromhost_VkBaseInStructure(
    ResourceTracker* resourceTracker,
    VkBaseInStructure* toTransform);

void transform_tohost_VkBaseOutStructure(
    ResourceTracker* resourceTracker,
    VkBaseOutStructure* toTransform);

void transform_fromhost_VkBaseOutStructure(
    ResourceTracker* resourceTracker,
    VkBaseOutStructure* toTransform);

void transform_tohost_VkBufferMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkBufferMemoryBarrier* toTransform);

void transform_fromhost_VkBufferMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkBufferMemoryBarrier* toTransform);

void transform_tohost_VkDispatchIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDispatchIndirectCommand* toTransform);

void transform_fromhost_VkDispatchIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDispatchIndirectCommand* toTransform);

void transform_tohost_VkDrawIndexedIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDrawIndexedIndirectCommand* toTransform);

void transform_fromhost_VkDrawIndexedIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDrawIndexedIndirectCommand* toTransform);

void transform_tohost_VkDrawIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDrawIndirectCommand* toTransform);

void transform_fromhost_VkDrawIndirectCommand(
    ResourceTracker* resourceTracker,
    VkDrawIndirectCommand* toTransform);

void transform_tohost_VkImageSubresourceRange(
    ResourceTracker* resourceTracker,
    VkImageSubresourceRange* toTransform);

void transform_fromhost_VkImageSubresourceRange(
    ResourceTracker* resourceTracker,
    VkImageSubresourceRange* toTransform);

void transform_tohost_VkImageMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkImageMemoryBarrier* toTransform);

void transform_fromhost_VkImageMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkImageMemoryBarrier* toTransform);

void transform_tohost_VkMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkMemoryBarrier* toTransform);

void transform_fromhost_VkMemoryBarrier(
    ResourceTracker* resourceTracker,
    VkMemoryBarrier* toTransform);

void transform_tohost_VkPipelineCacheHeaderVersionOne(
    ResourceTracker* resourceTracker,
    VkPipelineCacheHeaderVersionOne* toTransform);

void transform_fromhost_VkPipelineCacheHeaderVersionOne(
    ResourceTracker* resourceTracker,
    VkPipelineCacheHeaderVersionOne* toTransform);

void transform_tohost_VkAllocationCallbacks(
    ResourceTracker* resourceTracker,
    VkAllocationCallbacks* toTransform);

void transform_fromhost_VkAllocationCallbacks(
    ResourceTracker* resourceTracker,
    VkAllocationCallbacks* toTransform);

void transform_tohost_VkApplicationInfo(
    ResourceTracker* resourceTracker,
    VkApplicationInfo* toTransform);

void transform_fromhost_VkApplicationInfo(
    ResourceTracker* resourceTracker,
    VkApplicationInfo* toTransform);

void transform_tohost_VkFormatProperties(
    ResourceTracker* resourceTracker,
    VkFormatProperties* toTransform);

void transform_fromhost_VkFormatProperties(
    ResourceTracker* resourceTracker,
    VkFormatProperties* toTransform);

void transform_tohost_VkImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkImageFormatProperties* toTransform);

void transform_fromhost_VkImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkImageFormatProperties* toTransform);

void transform_tohost_VkInstanceCreateInfo(
    ResourceTracker* resourceTracker,
    VkInstanceCreateInfo* toTransform);

void transform_fromhost_VkInstanceCreateInfo(
    ResourceTracker* resourceTracker,
    VkInstanceCreateInfo* toTransform);

void transform_tohost_VkMemoryHeap(
    ResourceTracker* resourceTracker,
    VkMemoryHeap* toTransform);

void transform_fromhost_VkMemoryHeap(
    ResourceTracker* resourceTracker,
    VkMemoryHeap* toTransform);

void transform_tohost_VkMemoryType(
    ResourceTracker* resourceTracker,
    VkMemoryType* toTransform);

void transform_fromhost_VkMemoryType(
    ResourceTracker* resourceTracker,
    VkMemoryType* toTransform);

void transform_tohost_VkPhysicalDeviceFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceLimits(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLimits* toTransform);

void transform_fromhost_VkPhysicalDeviceLimits(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLimits* toTransform);

void transform_tohost_VkPhysicalDeviceMemoryProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceMemoryProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryProperties* toTransform);

void transform_tohost_VkPhysicalDeviceSparseProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSparseProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceSparseProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSparseProperties* toTransform);

void transform_tohost_VkPhysicalDeviceProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProperties* toTransform);

void transform_tohost_VkQueueFamilyProperties(
    ResourceTracker* resourceTracker,
    VkQueueFamilyProperties* toTransform);

void transform_fromhost_VkQueueFamilyProperties(
    ResourceTracker* resourceTracker,
    VkQueueFamilyProperties* toTransform);

void transform_tohost_VkDeviceQueueCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceQueueCreateInfo* toTransform);

void transform_fromhost_VkDeviceQueueCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceQueueCreateInfo* toTransform);

void transform_tohost_VkDeviceCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceCreateInfo* toTransform);

void transform_fromhost_VkDeviceCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceCreateInfo* toTransform);

void transform_tohost_VkExtensionProperties(
    ResourceTracker* resourceTracker,
    VkExtensionProperties* toTransform);

void transform_fromhost_VkExtensionProperties(
    ResourceTracker* resourceTracker,
    VkExtensionProperties* toTransform);

void transform_tohost_VkLayerProperties(
    ResourceTracker* resourceTracker,
    VkLayerProperties* toTransform);

void transform_fromhost_VkLayerProperties(
    ResourceTracker* resourceTracker,
    VkLayerProperties* toTransform);

void transform_tohost_VkSubmitInfo(
    ResourceTracker* resourceTracker,
    VkSubmitInfo* toTransform);

void transform_fromhost_VkSubmitInfo(
    ResourceTracker* resourceTracker,
    VkSubmitInfo* toTransform);

void transform_tohost_VkMappedMemoryRange(
    ResourceTracker* resourceTracker,
    VkMappedMemoryRange* toTransform);

void transform_fromhost_VkMappedMemoryRange(
    ResourceTracker* resourceTracker,
    VkMappedMemoryRange* toTransform);

void transform_tohost_VkMemoryAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryAllocateInfo* toTransform);

void transform_fromhost_VkMemoryAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryAllocateInfo* toTransform);

void transform_tohost_VkMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkMemoryRequirements* toTransform);

void transform_fromhost_VkMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkMemoryRequirements* toTransform);

void transform_tohost_VkSparseMemoryBind(
    ResourceTracker* resourceTracker,
    VkSparseMemoryBind* toTransform);

void transform_fromhost_VkSparseMemoryBind(
    ResourceTracker* resourceTracker,
    VkSparseMemoryBind* toTransform);

void transform_tohost_VkSparseBufferMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseBufferMemoryBindInfo* toTransform);

void transform_fromhost_VkSparseBufferMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseBufferMemoryBindInfo* toTransform);

void transform_tohost_VkSparseImageOpaqueMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseImageOpaqueMemoryBindInfo* toTransform);

void transform_fromhost_VkSparseImageOpaqueMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseImageOpaqueMemoryBindInfo* toTransform);

void transform_tohost_VkImageSubresource(
    ResourceTracker* resourceTracker,
    VkImageSubresource* toTransform);

void transform_fromhost_VkImageSubresource(
    ResourceTracker* resourceTracker,
    VkImageSubresource* toTransform);

void transform_tohost_VkSparseImageMemoryBind(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryBind* toTransform);

void transform_fromhost_VkSparseImageMemoryBind(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryBind* toTransform);

void transform_tohost_VkSparseImageMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryBindInfo* toTransform);

void transform_fromhost_VkSparseImageMemoryBindInfo(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryBindInfo* toTransform);

void transform_tohost_VkBindSparseInfo(
    ResourceTracker* resourceTracker,
    VkBindSparseInfo* toTransform);

void transform_fromhost_VkBindSparseInfo(
    ResourceTracker* resourceTracker,
    VkBindSparseInfo* toTransform);

void transform_tohost_VkSparseImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkSparseImageFormatProperties* toTransform);

void transform_fromhost_VkSparseImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkSparseImageFormatProperties* toTransform);

void transform_tohost_VkSparseImageMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryRequirements* toTransform);

void transform_fromhost_VkSparseImageMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryRequirements* toTransform);

void transform_tohost_VkFenceCreateInfo(
    ResourceTracker* resourceTracker,
    VkFenceCreateInfo* toTransform);

void transform_fromhost_VkFenceCreateInfo(
    ResourceTracker* resourceTracker,
    VkFenceCreateInfo* toTransform);

void transform_tohost_VkSemaphoreCreateInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreCreateInfo* toTransform);

void transform_fromhost_VkSemaphoreCreateInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreCreateInfo* toTransform);

void transform_tohost_VkEventCreateInfo(
    ResourceTracker* resourceTracker,
    VkEventCreateInfo* toTransform);

void transform_fromhost_VkEventCreateInfo(
    ResourceTracker* resourceTracker,
    VkEventCreateInfo* toTransform);

void transform_tohost_VkQueryPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkQueryPoolCreateInfo* toTransform);

void transform_fromhost_VkQueryPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkQueryPoolCreateInfo* toTransform);

void transform_tohost_VkBufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferCreateInfo* toTransform);

void transform_fromhost_VkBufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferCreateInfo* toTransform);

void transform_tohost_VkBufferViewCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferViewCreateInfo* toTransform);

void transform_fromhost_VkBufferViewCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferViewCreateInfo* toTransform);

void transform_tohost_VkImageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageCreateInfo* toTransform);

void transform_fromhost_VkImageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageCreateInfo* toTransform);

void transform_tohost_VkSubresourceLayout(
    ResourceTracker* resourceTracker,
    VkSubresourceLayout* toTransform);

void transform_fromhost_VkSubresourceLayout(
    ResourceTracker* resourceTracker,
    VkSubresourceLayout* toTransform);

void transform_tohost_VkComponentMapping(
    ResourceTracker* resourceTracker,
    VkComponentMapping* toTransform);

void transform_fromhost_VkComponentMapping(
    ResourceTracker* resourceTracker,
    VkComponentMapping* toTransform);

void transform_tohost_VkImageViewCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageViewCreateInfo* toTransform);

void transform_fromhost_VkImageViewCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageViewCreateInfo* toTransform);

void transform_tohost_VkShaderModuleCreateInfo(
    ResourceTracker* resourceTracker,
    VkShaderModuleCreateInfo* toTransform);

void transform_fromhost_VkShaderModuleCreateInfo(
    ResourceTracker* resourceTracker,
    VkShaderModuleCreateInfo* toTransform);

void transform_tohost_VkPipelineCacheCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCacheCreateInfo* toTransform);

void transform_fromhost_VkPipelineCacheCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCacheCreateInfo* toTransform);

void transform_tohost_VkSpecializationMapEntry(
    ResourceTracker* resourceTracker,
    VkSpecializationMapEntry* toTransform);

void transform_fromhost_VkSpecializationMapEntry(
    ResourceTracker* resourceTracker,
    VkSpecializationMapEntry* toTransform);

void transform_tohost_VkSpecializationInfo(
    ResourceTracker* resourceTracker,
    VkSpecializationInfo* toTransform);

void transform_fromhost_VkSpecializationInfo(
    ResourceTracker* resourceTracker,
    VkSpecializationInfo* toTransform);

void transform_tohost_VkPipelineShaderStageCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineShaderStageCreateInfo* toTransform);

void transform_fromhost_VkPipelineShaderStageCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineShaderStageCreateInfo* toTransform);

void transform_tohost_VkComputePipelineCreateInfo(
    ResourceTracker* resourceTracker,
    VkComputePipelineCreateInfo* toTransform);

void transform_fromhost_VkComputePipelineCreateInfo(
    ResourceTracker* resourceTracker,
    VkComputePipelineCreateInfo* toTransform);

void transform_tohost_VkVertexInputBindingDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputBindingDescription* toTransform);

void transform_fromhost_VkVertexInputBindingDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputBindingDescription* toTransform);

void transform_tohost_VkVertexInputAttributeDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputAttributeDescription* toTransform);

void transform_fromhost_VkVertexInputAttributeDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputAttributeDescription* toTransform);

void transform_tohost_VkPipelineVertexInputStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineVertexInputStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineVertexInputStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineVertexInputStateCreateInfo* toTransform);

void transform_tohost_VkPipelineInputAssemblyStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineInputAssemblyStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineInputAssemblyStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineInputAssemblyStateCreateInfo* toTransform);

void transform_tohost_VkPipelineTessellationStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineTessellationStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineTessellationStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineTessellationStateCreateInfo* toTransform);

void transform_tohost_VkViewport(
    ResourceTracker* resourceTracker,
    VkViewport* toTransform);

void transform_fromhost_VkViewport(
    ResourceTracker* resourceTracker,
    VkViewport* toTransform);

void transform_tohost_VkPipelineViewportStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineViewportStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineViewportStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineViewportStateCreateInfo* toTransform);

void transform_tohost_VkPipelineRasterizationStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineRasterizationStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationStateCreateInfo* toTransform);

void transform_tohost_VkPipelineMultisampleStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineMultisampleStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineMultisampleStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineMultisampleStateCreateInfo* toTransform);

void transform_tohost_VkStencilOpState(
    ResourceTracker* resourceTracker,
    VkStencilOpState* toTransform);

void transform_fromhost_VkStencilOpState(
    ResourceTracker* resourceTracker,
    VkStencilOpState* toTransform);

void transform_tohost_VkPipelineDepthStencilStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineDepthStencilStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineDepthStencilStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineDepthStencilStateCreateInfo* toTransform);

void transform_tohost_VkPipelineColorBlendAttachmentState(
    ResourceTracker* resourceTracker,
    VkPipelineColorBlendAttachmentState* toTransform);

void transform_fromhost_VkPipelineColorBlendAttachmentState(
    ResourceTracker* resourceTracker,
    VkPipelineColorBlendAttachmentState* toTransform);

void transform_tohost_VkPipelineColorBlendStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineColorBlendStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineColorBlendStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineColorBlendStateCreateInfo* toTransform);

void transform_tohost_VkPipelineDynamicStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineDynamicStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineDynamicStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineDynamicStateCreateInfo* toTransform);

void transform_tohost_VkGraphicsPipelineCreateInfo(
    ResourceTracker* resourceTracker,
    VkGraphicsPipelineCreateInfo* toTransform);

void transform_fromhost_VkGraphicsPipelineCreateInfo(
    ResourceTracker* resourceTracker,
    VkGraphicsPipelineCreateInfo* toTransform);

void transform_tohost_VkPushConstantRange(
    ResourceTracker* resourceTracker,
    VkPushConstantRange* toTransform);

void transform_fromhost_VkPushConstantRange(
    ResourceTracker* resourceTracker,
    VkPushConstantRange* toTransform);

void transform_tohost_VkPipelineLayoutCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineLayoutCreateInfo* toTransform);

void transform_fromhost_VkPipelineLayoutCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineLayoutCreateInfo* toTransform);

void transform_tohost_VkSamplerCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerCreateInfo* toTransform);

void transform_fromhost_VkSamplerCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerCreateInfo* toTransform);

void transform_tohost_VkCopyDescriptorSet(
    ResourceTracker* resourceTracker,
    VkCopyDescriptorSet* toTransform);

void transform_fromhost_VkCopyDescriptorSet(
    ResourceTracker* resourceTracker,
    VkCopyDescriptorSet* toTransform);

void transform_tohost_VkDescriptorBufferInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorBufferInfo* toTransform);

void transform_fromhost_VkDescriptorBufferInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorBufferInfo* toTransform);

void transform_tohost_VkDescriptorImageInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorImageInfo* toTransform);

void transform_fromhost_VkDescriptorImageInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorImageInfo* toTransform);

void transform_tohost_VkDescriptorPoolSize(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolSize* toTransform);

void transform_fromhost_VkDescriptorPoolSize(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolSize* toTransform);

void transform_tohost_VkDescriptorPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolCreateInfo* toTransform);

void transform_fromhost_VkDescriptorPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolCreateInfo* toTransform);

void transform_tohost_VkDescriptorSetAllocateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetAllocateInfo* toTransform);

void transform_fromhost_VkDescriptorSetAllocateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetAllocateInfo* toTransform);

void transform_tohost_VkDescriptorSetLayoutBinding(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutBinding* toTransform);

void transform_fromhost_VkDescriptorSetLayoutBinding(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutBinding* toTransform);

void transform_tohost_VkDescriptorSetLayoutCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutCreateInfo* toTransform);

void transform_fromhost_VkDescriptorSetLayoutCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutCreateInfo* toTransform);

void transform_tohost_VkWriteDescriptorSet(
    ResourceTracker* resourceTracker,
    VkWriteDescriptorSet* toTransform);

void transform_fromhost_VkWriteDescriptorSet(
    ResourceTracker* resourceTracker,
    VkWriteDescriptorSet* toTransform);

void transform_tohost_VkAttachmentDescription(
    ResourceTracker* resourceTracker,
    VkAttachmentDescription* toTransform);

void transform_fromhost_VkAttachmentDescription(
    ResourceTracker* resourceTracker,
    VkAttachmentDescription* toTransform);

void transform_tohost_VkAttachmentReference(
    ResourceTracker* resourceTracker,
    VkAttachmentReference* toTransform);

void transform_fromhost_VkAttachmentReference(
    ResourceTracker* resourceTracker,
    VkAttachmentReference* toTransform);

void transform_tohost_VkFramebufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferCreateInfo* toTransform);

void transform_fromhost_VkFramebufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferCreateInfo* toTransform);

void transform_tohost_VkSubpassDescription(
    ResourceTracker* resourceTracker,
    VkSubpassDescription* toTransform);

void transform_fromhost_VkSubpassDescription(
    ResourceTracker* resourceTracker,
    VkSubpassDescription* toTransform);

void transform_tohost_VkSubpassDependency(
    ResourceTracker* resourceTracker,
    VkSubpassDependency* toTransform);

void transform_fromhost_VkSubpassDependency(
    ResourceTracker* resourceTracker,
    VkSubpassDependency* toTransform);

void transform_tohost_VkRenderPassCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassCreateInfo* toTransform);

void transform_fromhost_VkRenderPassCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassCreateInfo* toTransform);

void transform_tohost_VkCommandPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkCommandPoolCreateInfo* toTransform);

void transform_fromhost_VkCommandPoolCreateInfo(
    ResourceTracker* resourceTracker,
    VkCommandPoolCreateInfo* toTransform);

void transform_tohost_VkCommandBufferAllocateInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferAllocateInfo* toTransform);

void transform_fromhost_VkCommandBufferAllocateInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferAllocateInfo* toTransform);

void transform_tohost_VkCommandBufferInheritanceInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferInheritanceInfo* toTransform);

void transform_fromhost_VkCommandBufferInheritanceInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferInheritanceInfo* toTransform);

void transform_tohost_VkCommandBufferBeginInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferBeginInfo* toTransform);

void transform_fromhost_VkCommandBufferBeginInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferBeginInfo* toTransform);

void transform_tohost_VkBufferCopy(
    ResourceTracker* resourceTracker,
    VkBufferCopy* toTransform);

void transform_fromhost_VkBufferCopy(
    ResourceTracker* resourceTracker,
    VkBufferCopy* toTransform);

void transform_tohost_VkImageSubresourceLayers(
    ResourceTracker* resourceTracker,
    VkImageSubresourceLayers* toTransform);

void transform_fromhost_VkImageSubresourceLayers(
    ResourceTracker* resourceTracker,
    VkImageSubresourceLayers* toTransform);

void transform_tohost_VkBufferImageCopy(
    ResourceTracker* resourceTracker,
    VkBufferImageCopy* toTransform);

void transform_fromhost_VkBufferImageCopy(
    ResourceTracker* resourceTracker,
    VkBufferImageCopy* toTransform);

void transform_tohost_VkClearColorValue(
    ResourceTracker* resourceTracker,
    VkClearColorValue* toTransform);

void transform_fromhost_VkClearColorValue(
    ResourceTracker* resourceTracker,
    VkClearColorValue* toTransform);

void transform_tohost_VkClearDepthStencilValue(
    ResourceTracker* resourceTracker,
    VkClearDepthStencilValue* toTransform);

void transform_fromhost_VkClearDepthStencilValue(
    ResourceTracker* resourceTracker,
    VkClearDepthStencilValue* toTransform);

void transform_tohost_VkClearValue(
    ResourceTracker* resourceTracker,
    VkClearValue* toTransform);

void transform_fromhost_VkClearValue(
    ResourceTracker* resourceTracker,
    VkClearValue* toTransform);

void transform_tohost_VkClearAttachment(
    ResourceTracker* resourceTracker,
    VkClearAttachment* toTransform);

void transform_fromhost_VkClearAttachment(
    ResourceTracker* resourceTracker,
    VkClearAttachment* toTransform);

void transform_tohost_VkClearRect(
    ResourceTracker* resourceTracker,
    VkClearRect* toTransform);

void transform_fromhost_VkClearRect(
    ResourceTracker* resourceTracker,
    VkClearRect* toTransform);

void transform_tohost_VkImageBlit(
    ResourceTracker* resourceTracker,
    VkImageBlit* toTransform);

void transform_fromhost_VkImageBlit(
    ResourceTracker* resourceTracker,
    VkImageBlit* toTransform);

void transform_tohost_VkImageCopy(
    ResourceTracker* resourceTracker,
    VkImageCopy* toTransform);

void transform_fromhost_VkImageCopy(
    ResourceTracker* resourceTracker,
    VkImageCopy* toTransform);

void transform_tohost_VkImageResolve(
    ResourceTracker* resourceTracker,
    VkImageResolve* toTransform);

void transform_fromhost_VkImageResolve(
    ResourceTracker* resourceTracker,
    VkImageResolve* toTransform);

void transform_tohost_VkRenderPassBeginInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassBeginInfo* toTransform);

void transform_fromhost_VkRenderPassBeginInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassBeginInfo* toTransform);

#endif
#ifdef VK_VERSION_1_1
void transform_tohost_VkPhysicalDeviceSubgroupProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceSubgroupProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupProperties* toTransform);

void transform_tohost_VkBindBufferMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindBufferMemoryInfo* toTransform);

void transform_fromhost_VkBindBufferMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindBufferMemoryInfo* toTransform);

void transform_tohost_VkBindImageMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindImageMemoryInfo* toTransform);

void transform_fromhost_VkBindImageMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindImageMemoryInfo* toTransform);

void transform_tohost_VkPhysicalDevice16BitStorageFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice16BitStorageFeatures* toTransform);

void transform_fromhost_VkPhysicalDevice16BitStorageFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice16BitStorageFeatures* toTransform);

void transform_tohost_VkMemoryDedicatedRequirements(
    ResourceTracker* resourceTracker,
    VkMemoryDedicatedRequirements* toTransform);

void transform_fromhost_VkMemoryDedicatedRequirements(
    ResourceTracker* resourceTracker,
    VkMemoryDedicatedRequirements* toTransform);

void transform_tohost_VkMemoryDedicatedAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryDedicatedAllocateInfo* toTransform);

void transform_fromhost_VkMemoryDedicatedAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryDedicatedAllocateInfo* toTransform);

void transform_tohost_VkMemoryAllocateFlagsInfo(
    ResourceTracker* resourceTracker,
    VkMemoryAllocateFlagsInfo* toTransform);

void transform_fromhost_VkMemoryAllocateFlagsInfo(
    ResourceTracker* resourceTracker,
    VkMemoryAllocateFlagsInfo* toTransform);

void transform_tohost_VkDeviceGroupRenderPassBeginInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupRenderPassBeginInfo* toTransform);

void transform_fromhost_VkDeviceGroupRenderPassBeginInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupRenderPassBeginInfo* toTransform);

void transform_tohost_VkDeviceGroupCommandBufferBeginInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupCommandBufferBeginInfo* toTransform);

void transform_fromhost_VkDeviceGroupCommandBufferBeginInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupCommandBufferBeginInfo* toTransform);

void transform_tohost_VkDeviceGroupSubmitInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupSubmitInfo* toTransform);

void transform_fromhost_VkDeviceGroupSubmitInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupSubmitInfo* toTransform);

void transform_tohost_VkDeviceGroupBindSparseInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupBindSparseInfo* toTransform);

void transform_fromhost_VkDeviceGroupBindSparseInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupBindSparseInfo* toTransform);

void transform_tohost_VkBindBufferMemoryDeviceGroupInfo(
    ResourceTracker* resourceTracker,
    VkBindBufferMemoryDeviceGroupInfo* toTransform);

void transform_fromhost_VkBindBufferMemoryDeviceGroupInfo(
    ResourceTracker* resourceTracker,
    VkBindBufferMemoryDeviceGroupInfo* toTransform);

void transform_tohost_VkBindImageMemoryDeviceGroupInfo(
    ResourceTracker* resourceTracker,
    VkBindImageMemoryDeviceGroupInfo* toTransform);

void transform_fromhost_VkBindImageMemoryDeviceGroupInfo(
    ResourceTracker* resourceTracker,
    VkBindImageMemoryDeviceGroupInfo* toTransform);

void transform_tohost_VkPhysicalDeviceGroupProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGroupProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceGroupProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGroupProperties* toTransform);

void transform_tohost_VkDeviceGroupDeviceCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupDeviceCreateInfo* toTransform);

void transform_fromhost_VkDeviceGroupDeviceCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceGroupDeviceCreateInfo* toTransform);

void transform_tohost_VkBufferMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkBufferMemoryRequirementsInfo2* toTransform);

void transform_fromhost_VkBufferMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkBufferMemoryRequirementsInfo2* toTransform);

void transform_tohost_VkImageMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkImageMemoryRequirementsInfo2* toTransform);

void transform_fromhost_VkImageMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkImageMemoryRequirementsInfo2* toTransform);

void transform_tohost_VkImageSparseMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkImageSparseMemoryRequirementsInfo2* toTransform);

void transform_fromhost_VkImageSparseMemoryRequirementsInfo2(
    ResourceTracker* resourceTracker,
    VkImageSparseMemoryRequirementsInfo2* toTransform);

void transform_tohost_VkMemoryRequirements2(
    ResourceTracker* resourceTracker,
    VkMemoryRequirements2* toTransform);

void transform_fromhost_VkMemoryRequirements2(
    ResourceTracker* resourceTracker,
    VkMemoryRequirements2* toTransform);

void transform_tohost_VkSparseImageMemoryRequirements2(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryRequirements2* toTransform);

void transform_fromhost_VkSparseImageMemoryRequirements2(
    ResourceTracker* resourceTracker,
    VkSparseImageMemoryRequirements2* toTransform);

void transform_tohost_VkPhysicalDeviceFeatures2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFeatures2* toTransform);

void transform_fromhost_VkPhysicalDeviceFeatures2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFeatures2* toTransform);

void transform_tohost_VkPhysicalDeviceProperties2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProperties2* toTransform);

void transform_fromhost_VkPhysicalDeviceProperties2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProperties2* toTransform);

void transform_tohost_VkFormatProperties2(
    ResourceTracker* resourceTracker,
    VkFormatProperties2* toTransform);

void transform_fromhost_VkFormatProperties2(
    ResourceTracker* resourceTracker,
    VkFormatProperties2* toTransform);

void transform_tohost_VkImageFormatProperties2(
    ResourceTracker* resourceTracker,
    VkImageFormatProperties2* toTransform);

void transform_fromhost_VkImageFormatProperties2(
    ResourceTracker* resourceTracker,
    VkImageFormatProperties2* toTransform);

void transform_tohost_VkPhysicalDeviceImageFormatInfo2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageFormatInfo2* toTransform);

void transform_fromhost_VkPhysicalDeviceImageFormatInfo2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageFormatInfo2* toTransform);

void transform_tohost_VkQueueFamilyProperties2(
    ResourceTracker* resourceTracker,
    VkQueueFamilyProperties2* toTransform);

void transform_fromhost_VkQueueFamilyProperties2(
    ResourceTracker* resourceTracker,
    VkQueueFamilyProperties2* toTransform);

void transform_tohost_VkPhysicalDeviceMemoryProperties2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryProperties2* toTransform);

void transform_fromhost_VkPhysicalDeviceMemoryProperties2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryProperties2* toTransform);

void transform_tohost_VkSparseImageFormatProperties2(
    ResourceTracker* resourceTracker,
    VkSparseImageFormatProperties2* toTransform);

void transform_fromhost_VkSparseImageFormatProperties2(
    ResourceTracker* resourceTracker,
    VkSparseImageFormatProperties2* toTransform);

void transform_tohost_VkPhysicalDeviceSparseImageFormatInfo2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSparseImageFormatInfo2* toTransform);

void transform_fromhost_VkPhysicalDeviceSparseImageFormatInfo2(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSparseImageFormatInfo2* toTransform);

void transform_tohost_VkPhysicalDevicePointClippingProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePointClippingProperties* toTransform);

void transform_fromhost_VkPhysicalDevicePointClippingProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePointClippingProperties* toTransform);

void transform_tohost_VkInputAttachmentAspectReference(
    ResourceTracker* resourceTracker,
    VkInputAttachmentAspectReference* toTransform);

void transform_fromhost_VkInputAttachmentAspectReference(
    ResourceTracker* resourceTracker,
    VkInputAttachmentAspectReference* toTransform);

void transform_tohost_VkRenderPassInputAttachmentAspectCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassInputAttachmentAspectCreateInfo* toTransform);

void transform_fromhost_VkRenderPassInputAttachmentAspectCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassInputAttachmentAspectCreateInfo* toTransform);

void transform_tohost_VkImageViewUsageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageViewUsageCreateInfo* toTransform);

void transform_fromhost_VkImageViewUsageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageViewUsageCreateInfo* toTransform);

void transform_tohost_VkPipelineTessellationDomainOriginStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineTessellationDomainOriginStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineTessellationDomainOriginStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineTessellationDomainOriginStateCreateInfo* toTransform);

void transform_tohost_VkRenderPassMultiviewCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassMultiviewCreateInfo* toTransform);

void transform_fromhost_VkRenderPassMultiviewCreateInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassMultiviewCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceMultiviewFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMultiviewFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceMultiviewFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMultiviewFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceMultiviewProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMultiviewProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceMultiviewProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMultiviewProperties* toTransform);

void transform_tohost_VkPhysicalDeviceVariablePointersFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVariablePointersFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceVariablePointersFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVariablePointersFeatures* toTransform);

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceVariablePointersFeatures, transform_tohost_VkPhysicalDeviceVariablePointerFeatures)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceVariablePointersFeatures, transform_fromhost_VkPhysicalDeviceVariablePointerFeatures)

void transform_tohost_VkPhysicalDeviceProtectedMemoryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProtectedMemoryFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceProtectedMemoryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProtectedMemoryFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceProtectedMemoryProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProtectedMemoryProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceProtectedMemoryProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProtectedMemoryProperties* toTransform);

void transform_tohost_VkDeviceQueueInfo2(
    ResourceTracker* resourceTracker,
    VkDeviceQueueInfo2* toTransform);

void transform_fromhost_VkDeviceQueueInfo2(
    ResourceTracker* resourceTracker,
    VkDeviceQueueInfo2* toTransform);

void transform_tohost_VkProtectedSubmitInfo(
    ResourceTracker* resourceTracker,
    VkProtectedSubmitInfo* toTransform);

void transform_fromhost_VkProtectedSubmitInfo(
    ResourceTracker* resourceTracker,
    VkProtectedSubmitInfo* toTransform);

void transform_tohost_VkSamplerYcbcrConversionCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionCreateInfo* toTransform);

void transform_fromhost_VkSamplerYcbcrConversionCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionCreateInfo* toTransform);

void transform_tohost_VkSamplerYcbcrConversionInfo(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionInfo* toTransform);

void transform_fromhost_VkSamplerYcbcrConversionInfo(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionInfo* toTransform);

void transform_tohost_VkBindImagePlaneMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindImagePlaneMemoryInfo* toTransform);

void transform_fromhost_VkBindImagePlaneMemoryInfo(
    ResourceTracker* resourceTracker,
    VkBindImagePlaneMemoryInfo* toTransform);

void transform_tohost_VkImagePlaneMemoryRequirementsInfo(
    ResourceTracker* resourceTracker,
    VkImagePlaneMemoryRequirementsInfo* toTransform);

void transform_fromhost_VkImagePlaneMemoryRequirementsInfo(
    ResourceTracker* resourceTracker,
    VkImagePlaneMemoryRequirementsInfo* toTransform);

void transform_tohost_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* toTransform);

void transform_tohost_VkSamplerYcbcrConversionImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionImageFormatProperties* toTransform);

void transform_fromhost_VkSamplerYcbcrConversionImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkSamplerYcbcrConversionImageFormatProperties* toTransform);

void transform_tohost_VkDescriptorUpdateTemplateEntry(
    ResourceTracker* resourceTracker,
    VkDescriptorUpdateTemplateEntry* toTransform);

void transform_fromhost_VkDescriptorUpdateTemplateEntry(
    ResourceTracker* resourceTracker,
    VkDescriptorUpdateTemplateEntry* toTransform);

void transform_tohost_VkDescriptorUpdateTemplateCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorUpdateTemplateCreateInfo* toTransform);

void transform_fromhost_VkDescriptorUpdateTemplateCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorUpdateTemplateCreateInfo* toTransform);

void transform_tohost_VkExternalMemoryProperties(
    ResourceTracker* resourceTracker,
    VkExternalMemoryProperties* toTransform);

void transform_fromhost_VkExternalMemoryProperties(
    ResourceTracker* resourceTracker,
    VkExternalMemoryProperties* toTransform);

void transform_tohost_VkPhysicalDeviceExternalImageFormatInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalImageFormatInfo* toTransform);

void transform_fromhost_VkPhysicalDeviceExternalImageFormatInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalImageFormatInfo* toTransform);

void transform_tohost_VkExternalImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkExternalImageFormatProperties* toTransform);

void transform_fromhost_VkExternalImageFormatProperties(
    ResourceTracker* resourceTracker,
    VkExternalImageFormatProperties* toTransform);

void transform_tohost_VkPhysicalDeviceExternalBufferInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalBufferInfo* toTransform);

void transform_fromhost_VkPhysicalDeviceExternalBufferInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalBufferInfo* toTransform);

void transform_tohost_VkExternalBufferProperties(
    ResourceTracker* resourceTracker,
    VkExternalBufferProperties* toTransform);

void transform_fromhost_VkExternalBufferProperties(
    ResourceTracker* resourceTracker,
    VkExternalBufferProperties* toTransform);

void transform_tohost_VkPhysicalDeviceIDProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceIDProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceIDProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceIDProperties* toTransform);

void transform_tohost_VkExternalMemoryImageCreateInfo(
    ResourceTracker* resourceTracker,
    VkExternalMemoryImageCreateInfo* toTransform);

void transform_fromhost_VkExternalMemoryImageCreateInfo(
    ResourceTracker* resourceTracker,
    VkExternalMemoryImageCreateInfo* toTransform);

void transform_tohost_VkExternalMemoryBufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkExternalMemoryBufferCreateInfo* toTransform);

void transform_fromhost_VkExternalMemoryBufferCreateInfo(
    ResourceTracker* resourceTracker,
    VkExternalMemoryBufferCreateInfo* toTransform);

void transform_tohost_VkExportMemoryAllocateInfo(
    ResourceTracker* resourceTracker,
    VkExportMemoryAllocateInfo* toTransform);

void transform_fromhost_VkExportMemoryAllocateInfo(
    ResourceTracker* resourceTracker,
    VkExportMemoryAllocateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceExternalFenceInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalFenceInfo* toTransform);

void transform_fromhost_VkPhysicalDeviceExternalFenceInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalFenceInfo* toTransform);

void transform_tohost_VkExternalFenceProperties(
    ResourceTracker* resourceTracker,
    VkExternalFenceProperties* toTransform);

void transform_fromhost_VkExternalFenceProperties(
    ResourceTracker* resourceTracker,
    VkExternalFenceProperties* toTransform);

void transform_tohost_VkExportFenceCreateInfo(
    ResourceTracker* resourceTracker,
    VkExportFenceCreateInfo* toTransform);

void transform_fromhost_VkExportFenceCreateInfo(
    ResourceTracker* resourceTracker,
    VkExportFenceCreateInfo* toTransform);

void transform_tohost_VkExportSemaphoreCreateInfo(
    ResourceTracker* resourceTracker,
    VkExportSemaphoreCreateInfo* toTransform);

void transform_fromhost_VkExportSemaphoreCreateInfo(
    ResourceTracker* resourceTracker,
    VkExportSemaphoreCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceExternalSemaphoreInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalSemaphoreInfo* toTransform);

void transform_fromhost_VkPhysicalDeviceExternalSemaphoreInfo(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExternalSemaphoreInfo* toTransform);

void transform_tohost_VkExternalSemaphoreProperties(
    ResourceTracker* resourceTracker,
    VkExternalSemaphoreProperties* toTransform);

void transform_fromhost_VkExternalSemaphoreProperties(
    ResourceTracker* resourceTracker,
    VkExternalSemaphoreProperties* toTransform);

void transform_tohost_VkPhysicalDeviceMaintenance3Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance3Properties* toTransform);

void transform_fromhost_VkPhysicalDeviceMaintenance3Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance3Properties* toTransform);

void transform_tohost_VkDescriptorSetLayoutSupport(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutSupport* toTransform);

void transform_fromhost_VkDescriptorSetLayoutSupport(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutSupport* toTransform);

void transform_tohost_VkPhysicalDeviceShaderDrawParametersFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderDrawParametersFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderDrawParametersFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderDrawParametersFeatures* toTransform);

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceShaderDrawParametersFeatures, transform_tohost_VkPhysicalDeviceShaderDrawParameterFeatures)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceShaderDrawParametersFeatures, transform_fromhost_VkPhysicalDeviceShaderDrawParameterFeatures)

#endif
#ifdef VK_VERSION_1_2
void transform_tohost_VkPhysicalDeviceVulkan11Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan11Features* toTransform);

void transform_fromhost_VkPhysicalDeviceVulkan11Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan11Features* toTransform);

void transform_tohost_VkPhysicalDeviceVulkan11Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan11Properties* toTransform);

void transform_fromhost_VkPhysicalDeviceVulkan11Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan11Properties* toTransform);

void transform_tohost_VkPhysicalDeviceVulkan12Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan12Features* toTransform);

void transform_fromhost_VkPhysicalDeviceVulkan12Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan12Features* toTransform);

void transform_tohost_VkConformanceVersion(
    ResourceTracker* resourceTracker,
    VkConformanceVersion* toTransform);

void transform_fromhost_VkConformanceVersion(
    ResourceTracker* resourceTracker,
    VkConformanceVersion* toTransform);

void transform_tohost_VkPhysicalDeviceVulkan12Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan12Properties* toTransform);

void transform_fromhost_VkPhysicalDeviceVulkan12Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan12Properties* toTransform);

void transform_tohost_VkImageFormatListCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageFormatListCreateInfo* toTransform);

void transform_fromhost_VkImageFormatListCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageFormatListCreateInfo* toTransform);

void transform_tohost_VkAttachmentDescription2(
    ResourceTracker* resourceTracker,
    VkAttachmentDescription2* toTransform);

void transform_fromhost_VkAttachmentDescription2(
    ResourceTracker* resourceTracker,
    VkAttachmentDescription2* toTransform);

void transform_tohost_VkAttachmentReference2(
    ResourceTracker* resourceTracker,
    VkAttachmentReference2* toTransform);

void transform_fromhost_VkAttachmentReference2(
    ResourceTracker* resourceTracker,
    VkAttachmentReference2* toTransform);

void transform_tohost_VkSubpassDescription2(
    ResourceTracker* resourceTracker,
    VkSubpassDescription2* toTransform);

void transform_fromhost_VkSubpassDescription2(
    ResourceTracker* resourceTracker,
    VkSubpassDescription2* toTransform);

void transform_tohost_VkSubpassDependency2(
    ResourceTracker* resourceTracker,
    VkSubpassDependency2* toTransform);

void transform_fromhost_VkSubpassDependency2(
    ResourceTracker* resourceTracker,
    VkSubpassDependency2* toTransform);

void transform_tohost_VkRenderPassCreateInfo2(
    ResourceTracker* resourceTracker,
    VkRenderPassCreateInfo2* toTransform);

void transform_fromhost_VkRenderPassCreateInfo2(
    ResourceTracker* resourceTracker,
    VkRenderPassCreateInfo2* toTransform);

void transform_tohost_VkSubpassBeginInfo(
    ResourceTracker* resourceTracker,
    VkSubpassBeginInfo* toTransform);

void transform_fromhost_VkSubpassBeginInfo(
    ResourceTracker* resourceTracker,
    VkSubpassBeginInfo* toTransform);

void transform_tohost_VkSubpassEndInfo(
    ResourceTracker* resourceTracker,
    VkSubpassEndInfo* toTransform);

void transform_fromhost_VkSubpassEndInfo(
    ResourceTracker* resourceTracker,
    VkSubpassEndInfo* toTransform);

void transform_tohost_VkPhysicalDevice8BitStorageFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice8BitStorageFeatures* toTransform);

void transform_fromhost_VkPhysicalDevice8BitStorageFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice8BitStorageFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceDriverProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDriverProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceDriverProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDriverProperties* toTransform);

void transform_tohost_VkPhysicalDeviceShaderAtomicInt64Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderAtomicInt64Features* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderAtomicInt64Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderAtomicInt64Features* toTransform);

void transform_tohost_VkPhysicalDeviceShaderFloat16Int8Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderFloat16Int8Features* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderFloat16Int8Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderFloat16Int8Features* toTransform);

void transform_tohost_VkPhysicalDeviceFloatControlsProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFloatControlsProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceFloatControlsProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFloatControlsProperties* toTransform);

void transform_tohost_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* toTransform);

void transform_fromhost_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceDescriptorIndexingFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceDescriptorIndexingFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceDescriptorIndexingProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceDescriptorIndexingProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDescriptorIndexingProperties* toTransform);

void transform_tohost_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* toTransform);

void transform_fromhost_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* toTransform);

void transform_tohost_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    ResourceTracker* resourceTracker,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* toTransform);

void transform_fromhost_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    ResourceTracker* resourceTracker,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* toTransform);

void transform_tohost_VkSubpassDescriptionDepthStencilResolve(
    ResourceTracker* resourceTracker,
    VkSubpassDescriptionDepthStencilResolve* toTransform);

void transform_fromhost_VkSubpassDescriptionDepthStencilResolve(
    ResourceTracker* resourceTracker,
    VkSubpassDescriptionDepthStencilResolve* toTransform);

void transform_tohost_VkPhysicalDeviceDepthStencilResolveProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDepthStencilResolveProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceDepthStencilResolveProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDepthStencilResolveProperties* toTransform);

void transform_tohost_VkPhysicalDeviceScalarBlockLayoutFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceScalarBlockLayoutFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceScalarBlockLayoutFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceScalarBlockLayoutFeatures* toTransform);

void transform_tohost_VkImageStencilUsageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageStencilUsageCreateInfo* toTransform);

void transform_fromhost_VkImageStencilUsageCreateInfo(
    ResourceTracker* resourceTracker,
    VkImageStencilUsageCreateInfo* toTransform);

void transform_tohost_VkSamplerReductionModeCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerReductionModeCreateInfo* toTransform);

void transform_fromhost_VkSamplerReductionModeCreateInfo(
    ResourceTracker* resourceTracker,
    VkSamplerReductionModeCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* toTransform);

void transform_tohost_VkPhysicalDeviceVulkanMemoryModelFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkanMemoryModelFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceVulkanMemoryModelFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkanMemoryModelFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceImagelessFramebufferFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImagelessFramebufferFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceImagelessFramebufferFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImagelessFramebufferFeatures* toTransform);

void transform_tohost_VkFramebufferAttachmentImageInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferAttachmentImageInfo* toTransform);

void transform_fromhost_VkFramebufferAttachmentImageInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferAttachmentImageInfo* toTransform);

void transform_tohost_VkFramebufferAttachmentsCreateInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferAttachmentsCreateInfo* toTransform);

void transform_fromhost_VkFramebufferAttachmentsCreateInfo(
    ResourceTracker* resourceTracker,
    VkFramebufferAttachmentsCreateInfo* toTransform);

void transform_tohost_VkRenderPassAttachmentBeginInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassAttachmentBeginInfo* toTransform);

void transform_fromhost_VkRenderPassAttachmentBeginInfo(
    ResourceTracker* resourceTracker,
    VkRenderPassAttachmentBeginInfo* toTransform);

void transform_tohost_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* toTransform);

void transform_tohost_VkAttachmentReferenceStencilLayout(
    ResourceTracker* resourceTracker,
    VkAttachmentReferenceStencilLayout* toTransform);

void transform_fromhost_VkAttachmentReferenceStencilLayout(
    ResourceTracker* resourceTracker,
    VkAttachmentReferenceStencilLayout* toTransform);

void transform_tohost_VkAttachmentDescriptionStencilLayout(
    ResourceTracker* resourceTracker,
    VkAttachmentDescriptionStencilLayout* toTransform);

void transform_fromhost_VkAttachmentDescriptionStencilLayout(
    ResourceTracker* resourceTracker,
    VkAttachmentDescriptionStencilLayout* toTransform);

void transform_tohost_VkPhysicalDeviceHostQueryResetFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostQueryResetFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceHostQueryResetFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostQueryResetFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceTimelineSemaphoreFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTimelineSemaphoreFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceTimelineSemaphoreFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTimelineSemaphoreFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceTimelineSemaphoreProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTimelineSemaphoreProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceTimelineSemaphoreProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTimelineSemaphoreProperties* toTransform);

void transform_tohost_VkSemaphoreTypeCreateInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreTypeCreateInfo* toTransform);

void transform_fromhost_VkSemaphoreTypeCreateInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreTypeCreateInfo* toTransform);

void transform_tohost_VkTimelineSemaphoreSubmitInfo(
    ResourceTracker* resourceTracker,
    VkTimelineSemaphoreSubmitInfo* toTransform);

void transform_fromhost_VkTimelineSemaphoreSubmitInfo(
    ResourceTracker* resourceTracker,
    VkTimelineSemaphoreSubmitInfo* toTransform);

void transform_tohost_VkSemaphoreWaitInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreWaitInfo* toTransform);

void transform_fromhost_VkSemaphoreWaitInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreWaitInfo* toTransform);

void transform_tohost_VkSemaphoreSignalInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreSignalInfo* toTransform);

void transform_fromhost_VkSemaphoreSignalInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreSignalInfo* toTransform);

void transform_tohost_VkPhysicalDeviceBufferDeviceAddressFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceBufferDeviceAddressFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceBufferDeviceAddressFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceBufferDeviceAddressFeatures* toTransform);

void transform_tohost_VkBufferDeviceAddressInfo(
    ResourceTracker* resourceTracker,
    VkBufferDeviceAddressInfo* toTransform);

void transform_fromhost_VkBufferDeviceAddressInfo(
    ResourceTracker* resourceTracker,
    VkBufferDeviceAddressInfo* toTransform);

void transform_tohost_VkBufferOpaqueCaptureAddressCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferOpaqueCaptureAddressCreateInfo* toTransform);

void transform_fromhost_VkBufferOpaqueCaptureAddressCreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferOpaqueCaptureAddressCreateInfo* toTransform);

void transform_tohost_VkMemoryOpaqueCaptureAddressAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryOpaqueCaptureAddressAllocateInfo* toTransform);

void transform_fromhost_VkMemoryOpaqueCaptureAddressAllocateInfo(
    ResourceTracker* resourceTracker,
    VkMemoryOpaqueCaptureAddressAllocateInfo* toTransform);

void transform_tohost_VkDeviceMemoryOpaqueCaptureAddressInfo(
    ResourceTracker* resourceTracker,
    VkDeviceMemoryOpaqueCaptureAddressInfo* toTransform);

void transform_fromhost_VkDeviceMemoryOpaqueCaptureAddressInfo(
    ResourceTracker* resourceTracker,
    VkDeviceMemoryOpaqueCaptureAddressInfo* toTransform);

#endif
#ifdef VK_VERSION_1_3
void transform_tohost_VkPhysicalDeviceVulkan13Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan13Features* toTransform);

void transform_fromhost_VkPhysicalDeviceVulkan13Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan13Features* toTransform);

void transform_tohost_VkPhysicalDeviceVulkan13Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan13Properties* toTransform);

void transform_fromhost_VkPhysicalDeviceVulkan13Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan13Properties* toTransform);

void transform_tohost_VkPipelineCreationFeedback(
    ResourceTracker* resourceTracker,
    VkPipelineCreationFeedback* toTransform);

void transform_fromhost_VkPipelineCreationFeedback(
    ResourceTracker* resourceTracker,
    VkPipelineCreationFeedback* toTransform);

void transform_tohost_VkPipelineCreationFeedbackCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCreationFeedbackCreateInfo* toTransform);

void transform_fromhost_VkPipelineCreationFeedbackCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCreationFeedbackCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceToolProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceToolProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceToolProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceToolProperties* toTransform);

void transform_tohost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* toTransform);

void transform_tohost_VkPhysicalDevicePrivateDataFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePrivateDataFeatures* toTransform);

void transform_fromhost_VkPhysicalDevicePrivateDataFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePrivateDataFeatures* toTransform);

void transform_tohost_VkDevicePrivateDataCreateInfo(
    ResourceTracker* resourceTracker,
    VkDevicePrivateDataCreateInfo* toTransform);

void transform_fromhost_VkDevicePrivateDataCreateInfo(
    ResourceTracker* resourceTracker,
    VkDevicePrivateDataCreateInfo* toTransform);

void transform_tohost_VkPrivateDataSlotCreateInfo(
    ResourceTracker* resourceTracker,
    VkPrivateDataSlotCreateInfo* toTransform);

void transform_fromhost_VkPrivateDataSlotCreateInfo(
    ResourceTracker* resourceTracker,
    VkPrivateDataSlotCreateInfo* toTransform);

void transform_tohost_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* toTransform);

void transform_fromhost_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* toTransform);

void transform_tohost_VkMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkMemoryBarrier2* toTransform);

void transform_fromhost_VkMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkMemoryBarrier2* toTransform);

void transform_tohost_VkBufferMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkBufferMemoryBarrier2* toTransform);

void transform_fromhost_VkBufferMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkBufferMemoryBarrier2* toTransform);

void transform_tohost_VkImageMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkImageMemoryBarrier2* toTransform);

void transform_fromhost_VkImageMemoryBarrier2(
    ResourceTracker* resourceTracker,
    VkImageMemoryBarrier2* toTransform);

void transform_tohost_VkDependencyInfo(
    ResourceTracker* resourceTracker,
    VkDependencyInfo* toTransform);

void transform_fromhost_VkDependencyInfo(
    ResourceTracker* resourceTracker,
    VkDependencyInfo* toTransform);

void transform_tohost_VkSemaphoreSubmitInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreSubmitInfo* toTransform);

void transform_fromhost_VkSemaphoreSubmitInfo(
    ResourceTracker* resourceTracker,
    VkSemaphoreSubmitInfo* toTransform);

void transform_tohost_VkCommandBufferSubmitInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferSubmitInfo* toTransform);

void transform_fromhost_VkCommandBufferSubmitInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferSubmitInfo* toTransform);

void transform_tohost_VkSubmitInfo2(
    ResourceTracker* resourceTracker,
    VkSubmitInfo2* toTransform);

void transform_fromhost_VkSubmitInfo2(
    ResourceTracker* resourceTracker,
    VkSubmitInfo2* toTransform);

void transform_tohost_VkPhysicalDeviceSynchronization2Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSynchronization2Features* toTransform);

void transform_fromhost_VkPhysicalDeviceSynchronization2Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSynchronization2Features* toTransform);

void transform_tohost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceImageRobustnessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageRobustnessFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceImageRobustnessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageRobustnessFeatures* toTransform);

void transform_tohost_VkBufferCopy2(
    ResourceTracker* resourceTracker,
    VkBufferCopy2* toTransform);

void transform_fromhost_VkBufferCopy2(
    ResourceTracker* resourceTracker,
    VkBufferCopy2* toTransform);

void transform_tohost_VkCopyBufferInfo2(
    ResourceTracker* resourceTracker,
    VkCopyBufferInfo2* toTransform);

void transform_fromhost_VkCopyBufferInfo2(
    ResourceTracker* resourceTracker,
    VkCopyBufferInfo2* toTransform);

void transform_tohost_VkImageCopy2(
    ResourceTracker* resourceTracker,
    VkImageCopy2* toTransform);

void transform_fromhost_VkImageCopy2(
    ResourceTracker* resourceTracker,
    VkImageCopy2* toTransform);

void transform_tohost_VkCopyImageInfo2(
    ResourceTracker* resourceTracker,
    VkCopyImageInfo2* toTransform);

void transform_fromhost_VkCopyImageInfo2(
    ResourceTracker* resourceTracker,
    VkCopyImageInfo2* toTransform);

void transform_tohost_VkBufferImageCopy2(
    ResourceTracker* resourceTracker,
    VkBufferImageCopy2* toTransform);

void transform_fromhost_VkBufferImageCopy2(
    ResourceTracker* resourceTracker,
    VkBufferImageCopy2* toTransform);

void transform_tohost_VkCopyBufferToImageInfo2(
    ResourceTracker* resourceTracker,
    VkCopyBufferToImageInfo2* toTransform);

void transform_fromhost_VkCopyBufferToImageInfo2(
    ResourceTracker* resourceTracker,
    VkCopyBufferToImageInfo2* toTransform);

void transform_tohost_VkCopyImageToBufferInfo2(
    ResourceTracker* resourceTracker,
    VkCopyImageToBufferInfo2* toTransform);

void transform_fromhost_VkCopyImageToBufferInfo2(
    ResourceTracker* resourceTracker,
    VkCopyImageToBufferInfo2* toTransform);

void transform_tohost_VkImageBlit2(
    ResourceTracker* resourceTracker,
    VkImageBlit2* toTransform);

void transform_fromhost_VkImageBlit2(
    ResourceTracker* resourceTracker,
    VkImageBlit2* toTransform);

void transform_tohost_VkBlitImageInfo2(
    ResourceTracker* resourceTracker,
    VkBlitImageInfo2* toTransform);

void transform_fromhost_VkBlitImageInfo2(
    ResourceTracker* resourceTracker,
    VkBlitImageInfo2* toTransform);

void transform_tohost_VkImageResolve2(
    ResourceTracker* resourceTracker,
    VkImageResolve2* toTransform);

void transform_fromhost_VkImageResolve2(
    ResourceTracker* resourceTracker,
    VkImageResolve2* toTransform);

void transform_tohost_VkResolveImageInfo2(
    ResourceTracker* resourceTracker,
    VkResolveImageInfo2* toTransform);

void transform_fromhost_VkResolveImageInfo2(
    ResourceTracker* resourceTracker,
    VkResolveImageInfo2* toTransform);

void transform_tohost_VkPhysicalDeviceSubgroupSizeControlFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceSubgroupSizeControlFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceSubgroupSizeControlProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceSubgroupSizeControlProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceSubgroupSizeControlProperties* toTransform);

void transform_tohost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* toTransform);

void transform_fromhost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceInlineUniformBlockFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceInlineUniformBlockFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceInlineUniformBlockProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceInlineUniformBlockProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceInlineUniformBlockProperties* toTransform);

void transform_tohost_VkWriteDescriptorSetInlineUniformBlock(
    ResourceTracker* resourceTracker,
    VkWriteDescriptorSetInlineUniformBlock* toTransform);

void transform_fromhost_VkWriteDescriptorSetInlineUniformBlock(
    ResourceTracker* resourceTracker,
    VkWriteDescriptorSetInlineUniformBlock* toTransform);

void transform_tohost_VkDescriptorPoolInlineUniformBlockCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolInlineUniformBlockCreateInfo* toTransform);

void transform_fromhost_VkDescriptorPoolInlineUniformBlockCreateInfo(
    ResourceTracker* resourceTracker,
    VkDescriptorPoolInlineUniformBlockCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* toTransform);

void transform_tohost_VkRenderingAttachmentInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAttachmentInfo* toTransform);

void transform_fromhost_VkRenderingAttachmentInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAttachmentInfo* toTransform);

void transform_tohost_VkRenderingInfo(
    ResourceTracker* resourceTracker,
    VkRenderingInfo* toTransform);

void transform_fromhost_VkRenderingInfo(
    ResourceTracker* resourceTracker,
    VkRenderingInfo* toTransform);

void transform_tohost_VkPipelineRenderingCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRenderingCreateInfo* toTransform);

void transform_fromhost_VkPipelineRenderingCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRenderingCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceDynamicRenderingFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDynamicRenderingFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceDynamicRenderingFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDynamicRenderingFeatures* toTransform);

void transform_tohost_VkCommandBufferInheritanceRenderingInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferInheritanceRenderingInfo* toTransform);

void transform_fromhost_VkCommandBufferInheritanceRenderingInfo(
    ResourceTracker* resourceTracker,
    VkCommandBufferInheritanceRenderingInfo* toTransform);

void transform_tohost_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceShaderIntegerDotProductProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderIntegerDotProductProperties* toTransform);

void transform_tohost_VkPhysicalDeviceTexelBufferAlignmentProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentProperties* toTransform);

void transform_tohost_VkFormatProperties3(
    ResourceTracker* resourceTracker,
    VkFormatProperties3* toTransform);

void transform_fromhost_VkFormatProperties3(
    ResourceTracker* resourceTracker,
    VkFormatProperties3* toTransform);

void transform_tohost_VkPhysicalDeviceMaintenance4Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance4Features* toTransform);

void transform_fromhost_VkPhysicalDeviceMaintenance4Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance4Features* toTransform);

void transform_tohost_VkPhysicalDeviceMaintenance4Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance4Properties* toTransform);

void transform_fromhost_VkPhysicalDeviceMaintenance4Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance4Properties* toTransform);

void transform_tohost_VkDeviceBufferMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkDeviceBufferMemoryRequirements* toTransform);

void transform_fromhost_VkDeviceBufferMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkDeviceBufferMemoryRequirements* toTransform);

void transform_tohost_VkDeviceImageMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkDeviceImageMemoryRequirements* toTransform);

void transform_fromhost_VkDeviceImageMemoryRequirements(
    ResourceTracker* resourceTracker,
    VkDeviceImageMemoryRequirements* toTransform);

#endif
#ifdef VK_VERSION_1_4
void transform_tohost_VkPhysicalDeviceVulkan14Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan14Features* toTransform);

void transform_fromhost_VkPhysicalDeviceVulkan14Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan14Features* toTransform);

void transform_tohost_VkPhysicalDeviceVulkan14Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan14Properties* toTransform);

void transform_fromhost_VkPhysicalDeviceVulkan14Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVulkan14Properties* toTransform);

void transform_tohost_VkDeviceQueueGlobalPriorityCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceQueueGlobalPriorityCreateInfo* toTransform);

void transform_fromhost_VkDeviceQueueGlobalPriorityCreateInfo(
    ResourceTracker* resourceTracker,
    VkDeviceQueueGlobalPriorityCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGlobalPriorityQueryFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGlobalPriorityQueryFeatures* toTransform);

void transform_tohost_VkQueueFamilyGlobalPriorityProperties(
    ResourceTracker* resourceTracker,
    VkQueueFamilyGlobalPriorityProperties* toTransform);

void transform_fromhost_VkQueueFamilyGlobalPriorityProperties(
    ResourceTracker* resourceTracker,
    VkQueueFamilyGlobalPriorityProperties* toTransform);

void transform_tohost_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderSubgroupRotateFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderSubgroupRotateFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceShaderFloatControls2Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderFloatControls2Features* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderFloatControls2Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderFloatControls2Features* toTransform);

void transform_tohost_VkPhysicalDeviceShaderExpectAssumeFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderExpectAssumeFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceShaderExpectAssumeFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceShaderExpectAssumeFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceLineRasterizationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLineRasterizationFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceLineRasterizationFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLineRasterizationFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceLineRasterizationProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLineRasterizationProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceLineRasterizationProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceLineRasterizationProperties* toTransform);

void transform_tohost_VkPipelineRasterizationLineStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationLineStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineRasterizationLineStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationLineStateCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceVertexAttributeDivisorProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorProperties* toTransform);

void transform_tohost_VkVertexInputBindingDivisorDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputBindingDivisorDescription* toTransform);

void transform_fromhost_VkVertexInputBindingDivisorDescription(
    ResourceTracker* resourceTracker,
    VkVertexInputBindingDivisorDescription* toTransform);

void transform_tohost_VkPipelineVertexInputDivisorStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineVertexInputDivisorStateCreateInfo* toTransform);

void transform_fromhost_VkPipelineVertexInputDivisorStateCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineVertexInputDivisorStateCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceIndexTypeUint8Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceIndexTypeUint8Features* toTransform);

void transform_fromhost_VkPhysicalDeviceIndexTypeUint8Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceIndexTypeUint8Features* toTransform);

void transform_tohost_VkMemoryMapInfo(
    ResourceTracker* resourceTracker,
    VkMemoryMapInfo* toTransform);

void transform_fromhost_VkMemoryMapInfo(
    ResourceTracker* resourceTracker,
    VkMemoryMapInfo* toTransform);

void transform_tohost_VkMemoryUnmapInfo(
    ResourceTracker* resourceTracker,
    VkMemoryUnmapInfo* toTransform);

void transform_fromhost_VkMemoryUnmapInfo(
    ResourceTracker* resourceTracker,
    VkMemoryUnmapInfo* toTransform);

void transform_tohost_VkPhysicalDeviceMaintenance5Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance5Features* toTransform);

void transform_fromhost_VkPhysicalDeviceMaintenance5Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance5Features* toTransform);

void transform_tohost_VkPhysicalDeviceMaintenance5Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance5Properties* toTransform);

void transform_fromhost_VkPhysicalDeviceMaintenance5Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance5Properties* toTransform);

void transform_tohost_VkRenderingAreaInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAreaInfo* toTransform);

void transform_fromhost_VkRenderingAreaInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAreaInfo* toTransform);

void transform_tohost_VkImageSubresource2(
    ResourceTracker* resourceTracker,
    VkImageSubresource2* toTransform);

void transform_fromhost_VkImageSubresource2(
    ResourceTracker* resourceTracker,
    VkImageSubresource2* toTransform);

void transform_tohost_VkDeviceImageSubresourceInfo(
    ResourceTracker* resourceTracker,
    VkDeviceImageSubresourceInfo* toTransform);

void transform_fromhost_VkDeviceImageSubresourceInfo(
    ResourceTracker* resourceTracker,
    VkDeviceImageSubresourceInfo* toTransform);

void transform_tohost_VkSubresourceLayout2(
    ResourceTracker* resourceTracker,
    VkSubresourceLayout2* toTransform);

void transform_fromhost_VkSubresourceLayout2(
    ResourceTracker* resourceTracker,
    VkSubresourceLayout2* toTransform);

void transform_tohost_VkPipelineCreateFlags2CreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCreateFlags2CreateInfo* toTransform);

void transform_fromhost_VkPipelineCreateFlags2CreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineCreateFlags2CreateInfo* toTransform);

void transform_tohost_VkBufferUsageFlags2CreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferUsageFlags2CreateInfo* toTransform);

void transform_fromhost_VkBufferUsageFlags2CreateInfo(
    ResourceTracker* resourceTracker,
    VkBufferUsageFlags2CreateInfo* toTransform);

void transform_tohost_VkPhysicalDevicePushDescriptorProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePushDescriptorProperties* toTransform);

void transform_fromhost_VkPhysicalDevicePushDescriptorProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePushDescriptorProperties* toTransform);

void transform_tohost_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDynamicRenderingLocalReadFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDynamicRenderingLocalReadFeatures* toTransform);

void transform_tohost_VkRenderingAttachmentLocationInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAttachmentLocationInfo* toTransform);

void transform_fromhost_VkRenderingAttachmentLocationInfo(
    ResourceTracker* resourceTracker,
    VkRenderingAttachmentLocationInfo* toTransform);

void transform_tohost_VkRenderingInputAttachmentIndexInfo(
    ResourceTracker* resourceTracker,
    VkRenderingInputAttachmentIndexInfo* toTransform);

void transform_fromhost_VkRenderingInputAttachmentIndexInfo(
    ResourceTracker* resourceTracker,
    VkRenderingInputAttachmentIndexInfo* toTransform);

void transform_tohost_VkPhysicalDeviceMaintenance6Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance6Features* toTransform);

void transform_fromhost_VkPhysicalDeviceMaintenance6Features(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance6Features* toTransform);

void transform_tohost_VkPhysicalDeviceMaintenance6Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance6Properties* toTransform);

void transform_fromhost_VkPhysicalDeviceMaintenance6Properties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMaintenance6Properties* toTransform);

void transform_tohost_VkBindMemoryStatus(
    ResourceTracker* resourceTracker,
    VkBindMemoryStatus* toTransform);

void transform_fromhost_VkBindMemoryStatus(
    ResourceTracker* resourceTracker,
    VkBindMemoryStatus* toTransform);

void transform_tohost_VkBindDescriptorSetsInfo(
    ResourceTracker* resourceTracker,
    VkBindDescriptorSetsInfo* toTransform);

void transform_fromhost_VkBindDescriptorSetsInfo(
    ResourceTracker* resourceTracker,
    VkBindDescriptorSetsInfo* toTransform);

void transform_tohost_VkPushConstantsInfo(
    ResourceTracker* resourceTracker,
    VkPushConstantsInfo* toTransform);

void transform_fromhost_VkPushConstantsInfo(
    ResourceTracker* resourceTracker,
    VkPushConstantsInfo* toTransform);

void transform_tohost_VkPushDescriptorSetInfo(
    ResourceTracker* resourceTracker,
    VkPushDescriptorSetInfo* toTransform);

void transform_fromhost_VkPushDescriptorSetInfo(
    ResourceTracker* resourceTracker,
    VkPushDescriptorSetInfo* toTransform);

void transform_tohost_VkPushDescriptorSetWithTemplateInfo(
    ResourceTracker* resourceTracker,
    VkPushDescriptorSetWithTemplateInfo* toTransform);

void transform_fromhost_VkPushDescriptorSetWithTemplateInfo(
    ResourceTracker* resourceTracker,
    VkPushDescriptorSetWithTemplateInfo* toTransform);

void transform_tohost_VkPhysicalDevicePipelineProtectedAccessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineProtectedAccessFeatures* toTransform);

void transform_fromhost_VkPhysicalDevicePipelineProtectedAccessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineProtectedAccessFeatures* toTransform);

void transform_tohost_VkPhysicalDevicePipelineRobustnessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineRobustnessFeatures* toTransform);

void transform_fromhost_VkPhysicalDevicePipelineRobustnessFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineRobustnessFeatures* toTransform);

void transform_tohost_VkPhysicalDevicePipelineRobustnessProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineRobustnessProperties* toTransform);

void transform_fromhost_VkPhysicalDevicePipelineRobustnessProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineRobustnessProperties* toTransform);

void transform_tohost_VkPipelineRobustnessCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRobustnessCreateInfo* toTransform);

void transform_fromhost_VkPipelineRobustnessCreateInfo(
    ResourceTracker* resourceTracker,
    VkPipelineRobustnessCreateInfo* toTransform);

void transform_tohost_VkPhysicalDeviceHostImageCopyFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostImageCopyFeatures* toTransform);

void transform_fromhost_VkPhysicalDeviceHostImageCopyFeatures(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostImageCopyFeatures* toTransform);

void transform_tohost_VkPhysicalDeviceHostImageCopyProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostImageCopyProperties* toTransform);

void transform_fromhost_VkPhysicalDeviceHostImageCopyProperties(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceHostImageCopyProperties* toTransform);

void transform_tohost_VkMemoryToImageCopy(
    ResourceTracker* resourceTracker,
    VkMemoryToImageCopy* toTransform);

void transform_fromhost_VkMemoryToImageCopy(
    ResourceTracker* resourceTracker,
    VkMemoryToImageCopy* toTransform);

void transform_tohost_VkImageToMemoryCopy(
    ResourceTracker* resourceTracker,
    VkImageToMemoryCopy* toTransform);

void transform_fromhost_VkImageToMemoryCopy(
    ResourceTracker* resourceTracker,
    VkImageToMemoryCopy* toTransform);

void transform_tohost_VkCopyMemoryToImageInfo(
    ResourceTracker* resourceTracker,
    VkCopyMemoryToImageInfo* toTransform);

void transform_fromhost_VkCopyMemoryToImageInfo(
    ResourceTracker* resourceTracker,
    VkCopyMemoryToImageInfo* toTransform);

void transform_tohost_VkCopyImageToMemoryInfo(
    ResourceTracker* resourceTracker,
    VkCopyImageToMemoryInfo* toTransform);

void transform_fromhost_VkCopyImageToMemoryInfo(
    ResourceTracker* resourceTracker,
    VkCopyImageToMemoryInfo* toTransform);

void transform_tohost_VkCopyImageToImageInfo(
    ResourceTracker* resourceTracker,
    VkCopyImageToImageInfo* toTransform);

void transform_fromhost_VkCopyImageToImageInfo(
    ResourceTracker* resourceTracker,
    VkCopyImageToImageInfo* toTransform);

void transform_tohost_VkHostImageLayoutTransitionInfo(
    ResourceTracker* resourceTracker,
    VkHostImageLayoutTransitionInfo* toTransform);

void transform_fromhost_VkHostImageLayoutTransitionInfo(
    ResourceTracker* resourceTracker,
    VkHostImageLayoutTransitionInfo* toTransform);

void transform_tohost_VkSubresourceHostMemcpySize(
    ResourceTracker* resourceTracker,
    VkSubresourceHostMemcpySize* toTransform);

void transform_fromhost_VkSubresourceHostMemcpySize(
    ResourceTracker* resourceTracker,
    VkSubresourceHostMemcpySize* toTransform);

void transform_tohost_VkHostImageCopyDevicePerformanceQuery(
    ResourceTracker* resourceTracker,
    VkHostImageCopyDevicePerformanceQuery* toTransform);

void transform_fromhost_VkHostImageCopyDevicePerformanceQuery(
    ResourceTracker* resourceTracker,
    VkHostImageCopyDevicePerformanceQuery* toTransform);

#endif
#ifdef VK_KHR_dynamic_rendering
DEFINE_ALIAS_FUNCTION(transform_tohost_VkRenderingInfo, transform_tohost_VkRenderingInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkRenderingInfo, transform_fromhost_VkRenderingInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkRenderingAttachmentInfo, transform_tohost_VkRenderingAttachmentInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkRenderingAttachmentInfo, transform_fromhost_VkRenderingAttachmentInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPipelineRenderingCreateInfo, transform_tohost_VkPipelineRenderingCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPipelineRenderingCreateInfo, transform_fromhost_VkPipelineRenderingCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceDynamicRenderingFeatures, transform_tohost_VkPhysicalDeviceDynamicRenderingFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceDynamicRenderingFeatures, transform_fromhost_VkPhysicalDeviceDynamicRenderingFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkCommandBufferInheritanceRenderingInfo, transform_tohost_VkCommandBufferInheritanceRenderingInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkCommandBufferInheritanceRenderingInfo, transform_fromhost_VkCommandBufferInheritanceRenderingInfoKHR)

#endif
#ifdef VK_KHR_multiview
DEFINE_ALIAS_FUNCTION(transform_tohost_VkRenderPassMultiviewCreateInfo, transform_tohost_VkRenderPassMultiviewCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkRenderPassMultiviewCreateInfo, transform_fromhost_VkRenderPassMultiviewCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceMultiviewFeatures, transform_tohost_VkPhysicalDeviceMultiviewFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceMultiviewFeatures, transform_fromhost_VkPhysicalDeviceMultiviewFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceMultiviewProperties, transform_tohost_VkPhysicalDeviceMultiviewPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceMultiviewProperties, transform_fromhost_VkPhysicalDeviceMultiviewPropertiesKHR)

#endif
#ifdef VK_KHR_get_physical_device_properties2
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceFeatures2, transform_tohost_VkPhysicalDeviceFeatures2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceFeatures2, transform_fromhost_VkPhysicalDeviceFeatures2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceProperties2, transform_tohost_VkPhysicalDeviceProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceProperties2, transform_fromhost_VkPhysicalDeviceProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkFormatProperties2, transform_tohost_VkFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkFormatProperties2, transform_fromhost_VkFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageFormatProperties2, transform_tohost_VkImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageFormatProperties2, transform_fromhost_VkImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceImageFormatInfo2, transform_tohost_VkPhysicalDeviceImageFormatInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceImageFormatInfo2, transform_fromhost_VkPhysicalDeviceImageFormatInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkQueueFamilyProperties2, transform_tohost_VkQueueFamilyProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkQueueFamilyProperties2, transform_fromhost_VkQueueFamilyProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceMemoryProperties2, transform_tohost_VkPhysicalDeviceMemoryProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceMemoryProperties2, transform_fromhost_VkPhysicalDeviceMemoryProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSparseImageFormatProperties2, transform_tohost_VkSparseImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSparseImageFormatProperties2, transform_fromhost_VkSparseImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceSparseImageFormatInfo2, transform_tohost_VkPhysicalDeviceSparseImageFormatInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceSparseImageFormatInfo2, transform_fromhost_VkPhysicalDeviceSparseImageFormatInfo2KHR)

#endif
#ifdef VK_KHR_external_memory_capabilities
DEFINE_ALIAS_FUNCTION(transform_tohost_VkExternalMemoryProperties, transform_tohost_VkExternalMemoryPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkExternalMemoryProperties, transform_fromhost_VkExternalMemoryPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceExternalImageFormatInfo, transform_tohost_VkPhysicalDeviceExternalImageFormatInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceExternalImageFormatInfo, transform_fromhost_VkPhysicalDeviceExternalImageFormatInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkExternalImageFormatProperties, transform_tohost_VkExternalImageFormatPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkExternalImageFormatProperties, transform_fromhost_VkExternalImageFormatPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceExternalBufferInfo, transform_tohost_VkPhysicalDeviceExternalBufferInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceExternalBufferInfo, transform_fromhost_VkPhysicalDeviceExternalBufferInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkExternalBufferProperties, transform_tohost_VkExternalBufferPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkExternalBufferProperties, transform_fromhost_VkExternalBufferPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceIDProperties, transform_tohost_VkPhysicalDeviceIDPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceIDProperties, transform_fromhost_VkPhysicalDeviceIDPropertiesKHR)

#endif
#ifdef VK_KHR_external_memory
DEFINE_ALIAS_FUNCTION(transform_tohost_VkExternalMemoryImageCreateInfo, transform_tohost_VkExternalMemoryImageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkExternalMemoryImageCreateInfo, transform_fromhost_VkExternalMemoryImageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkExternalMemoryBufferCreateInfo, transform_tohost_VkExternalMemoryBufferCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkExternalMemoryBufferCreateInfo, transform_fromhost_VkExternalMemoryBufferCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkExportMemoryAllocateInfo, transform_tohost_VkExportMemoryAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkExportMemoryAllocateInfo, transform_fromhost_VkExportMemoryAllocateInfoKHR)

#endif
#ifdef VK_KHR_external_semaphore_capabilities
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceExternalSemaphoreInfo, transform_tohost_VkPhysicalDeviceExternalSemaphoreInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceExternalSemaphoreInfo, transform_fromhost_VkPhysicalDeviceExternalSemaphoreInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkExternalSemaphoreProperties, transform_tohost_VkExternalSemaphorePropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkExternalSemaphoreProperties, transform_fromhost_VkExternalSemaphorePropertiesKHR)

#endif
#ifdef VK_KHR_external_semaphore
DEFINE_ALIAS_FUNCTION(transform_tohost_VkExportSemaphoreCreateInfo, transform_tohost_VkExportSemaphoreCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkExportSemaphoreCreateInfo, transform_fromhost_VkExportSemaphoreCreateInfoKHR)

#endif
#ifdef VK_KHR_external_semaphore_fd
void transform_tohost_VkImportSemaphoreFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkImportSemaphoreFdInfoKHR* toTransform);

void transform_fromhost_VkImportSemaphoreFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkImportSemaphoreFdInfoKHR* toTransform);

void transform_tohost_VkSemaphoreGetFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkSemaphoreGetFdInfoKHR* toTransform);

void transform_fromhost_VkSemaphoreGetFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkSemaphoreGetFdInfoKHR* toTransform);

#endif
#ifdef VK_KHR_shader_float16_int8
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceShaderFloat16Int8Features, transform_tohost_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceShaderFloat16Int8Features, transform_fromhost_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceShaderFloat16Int8Features, transform_tohost_VkPhysicalDeviceFloat16Int8FeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceShaderFloat16Int8Features, transform_fromhost_VkPhysicalDeviceFloat16Int8FeaturesKHR)

#endif
#ifdef VK_KHR_incremental_present
void transform_tohost_VkRectLayerKHR(
    ResourceTracker* resourceTracker,
    VkRectLayerKHR* toTransform);

void transform_fromhost_VkRectLayerKHR(
    ResourceTracker* resourceTracker,
    VkRectLayerKHR* toTransform);

void transform_tohost_VkPresentRegionKHR(
    ResourceTracker* resourceTracker,
    VkPresentRegionKHR* toTransform);

void transform_fromhost_VkPresentRegionKHR(
    ResourceTracker* resourceTracker,
    VkPresentRegionKHR* toTransform);

void transform_tohost_VkPresentRegionsKHR(
    ResourceTracker* resourceTracker,
    VkPresentRegionsKHR* toTransform);

void transform_fromhost_VkPresentRegionsKHR(
    ResourceTracker* resourceTracker,
    VkPresentRegionsKHR* toTransform);

#endif
#ifdef VK_KHR_descriptor_update_template
DEFINE_ALIAS_FUNCTION(transform_tohost_VkDescriptorUpdateTemplateEntry, transform_tohost_VkDescriptorUpdateTemplateEntryKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDescriptorUpdateTemplateEntry, transform_fromhost_VkDescriptorUpdateTemplateEntryKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkDescriptorUpdateTemplateCreateInfo, transform_tohost_VkDescriptorUpdateTemplateCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDescriptorUpdateTemplateCreateInfo, transform_fromhost_VkDescriptorUpdateTemplateCreateInfoKHR)

#endif
#ifdef VK_KHR_imageless_framebuffer
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceImagelessFramebufferFeatures, transform_tohost_VkPhysicalDeviceImagelessFramebufferFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceImagelessFramebufferFeatures, transform_fromhost_VkPhysicalDeviceImagelessFramebufferFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkFramebufferAttachmentsCreateInfo, transform_tohost_VkFramebufferAttachmentsCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkFramebufferAttachmentsCreateInfo, transform_fromhost_VkFramebufferAttachmentsCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkFramebufferAttachmentImageInfo, transform_tohost_VkFramebufferAttachmentImageInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkFramebufferAttachmentImageInfo, transform_fromhost_VkFramebufferAttachmentImageInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkRenderPassAttachmentBeginInfo, transform_tohost_VkRenderPassAttachmentBeginInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkRenderPassAttachmentBeginInfo, transform_fromhost_VkRenderPassAttachmentBeginInfoKHR)

#endif
#ifdef VK_KHR_create_renderpass2
DEFINE_ALIAS_FUNCTION(transform_tohost_VkRenderPassCreateInfo2, transform_tohost_VkRenderPassCreateInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkRenderPassCreateInfo2, transform_fromhost_VkRenderPassCreateInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkAttachmentDescription2, transform_tohost_VkAttachmentDescription2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkAttachmentDescription2, transform_fromhost_VkAttachmentDescription2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkAttachmentReference2, transform_tohost_VkAttachmentReference2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkAttachmentReference2, transform_fromhost_VkAttachmentReference2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSubpassDescription2, transform_tohost_VkSubpassDescription2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSubpassDescription2, transform_fromhost_VkSubpassDescription2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSubpassDependency2, transform_tohost_VkSubpassDependency2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSubpassDependency2, transform_fromhost_VkSubpassDependency2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSubpassBeginInfo, transform_tohost_VkSubpassBeginInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSubpassBeginInfo, transform_fromhost_VkSubpassBeginInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSubpassEndInfo, transform_tohost_VkSubpassEndInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSubpassEndInfo, transform_fromhost_VkSubpassEndInfoKHR)

#endif
#ifdef VK_KHR_external_fence_capabilities
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceExternalFenceInfo, transform_tohost_VkPhysicalDeviceExternalFenceInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceExternalFenceInfo, transform_fromhost_VkPhysicalDeviceExternalFenceInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkExternalFenceProperties, transform_tohost_VkExternalFencePropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkExternalFenceProperties, transform_fromhost_VkExternalFencePropertiesKHR)

#endif
#ifdef VK_KHR_external_fence
DEFINE_ALIAS_FUNCTION(transform_tohost_VkExportFenceCreateInfo, transform_tohost_VkExportFenceCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkExportFenceCreateInfo, transform_fromhost_VkExportFenceCreateInfoKHR)

#endif
#ifdef VK_KHR_external_fence_fd
void transform_tohost_VkImportFenceFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkImportFenceFdInfoKHR* toTransform);

void transform_fromhost_VkImportFenceFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkImportFenceFdInfoKHR* toTransform);

void transform_tohost_VkFenceGetFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkFenceGetFdInfoKHR* toTransform);

void transform_fromhost_VkFenceGetFdInfoKHR(
    ResourceTracker* resourceTracker,
    VkFenceGetFdInfoKHR* toTransform);

#endif
#ifdef VK_KHR_maintenance2
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDevicePointClippingProperties, transform_tohost_VkPhysicalDevicePointClippingPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDevicePointClippingProperties, transform_fromhost_VkPhysicalDevicePointClippingPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkRenderPassInputAttachmentAspectCreateInfo, transform_tohost_VkRenderPassInputAttachmentAspectCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkRenderPassInputAttachmentAspectCreateInfo, transform_fromhost_VkRenderPassInputAttachmentAspectCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkInputAttachmentAspectReference, transform_tohost_VkInputAttachmentAspectReferenceKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkInputAttachmentAspectReference, transform_fromhost_VkInputAttachmentAspectReferenceKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageViewUsageCreateInfo, transform_tohost_VkImageViewUsageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageViewUsageCreateInfo, transform_fromhost_VkImageViewUsageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPipelineTessellationDomainOriginStateCreateInfo, transform_tohost_VkPipelineTessellationDomainOriginStateCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPipelineTessellationDomainOriginStateCreateInfo, transform_fromhost_VkPipelineTessellationDomainOriginStateCreateInfoKHR)

#endif
#ifdef VK_KHR_dedicated_allocation
DEFINE_ALIAS_FUNCTION(transform_tohost_VkMemoryDedicatedRequirements, transform_tohost_VkMemoryDedicatedRequirementsKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkMemoryDedicatedRequirements, transform_fromhost_VkMemoryDedicatedRequirementsKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkMemoryDedicatedAllocateInfo, transform_tohost_VkMemoryDedicatedAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkMemoryDedicatedAllocateInfo, transform_fromhost_VkMemoryDedicatedAllocateInfoKHR)

#endif
#ifdef VK_KHR_get_memory_requirements2
DEFINE_ALIAS_FUNCTION(transform_tohost_VkBufferMemoryRequirementsInfo2, transform_tohost_VkBufferMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBufferMemoryRequirementsInfo2, transform_fromhost_VkBufferMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageMemoryRequirementsInfo2, transform_tohost_VkImageMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageMemoryRequirementsInfo2, transform_fromhost_VkImageMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageSparseMemoryRequirementsInfo2, transform_tohost_VkImageSparseMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageSparseMemoryRequirementsInfo2, transform_fromhost_VkImageSparseMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkMemoryRequirements2, transform_tohost_VkMemoryRequirements2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkMemoryRequirements2, transform_fromhost_VkMemoryRequirements2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSparseImageMemoryRequirements2, transform_tohost_VkSparseImageMemoryRequirements2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSparseImageMemoryRequirements2, transform_fromhost_VkSparseImageMemoryRequirements2KHR)

#endif
#ifdef VK_KHR_image_format_list
DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageFormatListCreateInfo, transform_tohost_VkImageFormatListCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageFormatListCreateInfo, transform_fromhost_VkImageFormatListCreateInfoKHR)

#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
DEFINE_ALIAS_FUNCTION(transform_tohost_VkSamplerYcbcrConversionCreateInfo, transform_tohost_VkSamplerYcbcrConversionCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSamplerYcbcrConversionCreateInfo, transform_fromhost_VkSamplerYcbcrConversionCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSamplerYcbcrConversionInfo, transform_tohost_VkSamplerYcbcrConversionInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSamplerYcbcrConversionInfo, transform_fromhost_VkSamplerYcbcrConversionInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkBindImagePlaneMemoryInfo, transform_tohost_VkBindImagePlaneMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBindImagePlaneMemoryInfo, transform_fromhost_VkBindImagePlaneMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImagePlaneMemoryRequirementsInfo, transform_tohost_VkImagePlaneMemoryRequirementsInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImagePlaneMemoryRequirementsInfo, transform_fromhost_VkImagePlaneMemoryRequirementsInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceSamplerYcbcrConversionFeatures, transform_tohost_VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceSamplerYcbcrConversionFeatures, transform_fromhost_VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSamplerYcbcrConversionImageFormatProperties, transform_tohost_VkSamplerYcbcrConversionImageFormatPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSamplerYcbcrConversionImageFormatProperties, transform_fromhost_VkSamplerYcbcrConversionImageFormatPropertiesKHR)

#endif
#ifdef VK_KHR_bind_memory2
DEFINE_ALIAS_FUNCTION(transform_tohost_VkBindBufferMemoryInfo, transform_tohost_VkBindBufferMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBindBufferMemoryInfo, transform_fromhost_VkBindBufferMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkBindImageMemoryInfo, transform_tohost_VkBindImageMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBindImageMemoryInfo, transform_fromhost_VkBindImageMemoryInfoKHR)

#endif
#ifdef VK_KHR_maintenance3
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceMaintenance3Properties, transform_tohost_VkPhysicalDeviceMaintenance3PropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceMaintenance3Properties, transform_fromhost_VkPhysicalDeviceMaintenance3PropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkDescriptorSetLayoutSupport, transform_tohost_VkDescriptorSetLayoutSupportKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDescriptorSetLayoutSupport, transform_fromhost_VkDescriptorSetLayoutSupportKHR)

#endif
#ifdef VK_KHR_shader_subgroup_extended_types
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, transform_tohost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, transform_fromhost_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR)

#endif
#ifdef VK_KHR_global_priority
DEFINE_ALIAS_FUNCTION(transform_tohost_VkDeviceQueueGlobalPriorityCreateInfo, transform_tohost_VkDeviceQueueGlobalPriorityCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDeviceQueueGlobalPriorityCreateInfo, transform_fromhost_VkDeviceQueueGlobalPriorityCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceGlobalPriorityQueryFeatures, transform_tohost_VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceGlobalPriorityQueryFeatures, transform_fromhost_VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkQueueFamilyGlobalPriorityProperties, transform_tohost_VkQueueFamilyGlobalPriorityPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkQueueFamilyGlobalPriorityProperties, transform_fromhost_VkQueueFamilyGlobalPriorityPropertiesKHR)

#endif
#ifdef VK_KHR_vulkan_memory_model
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceVulkanMemoryModelFeatures, transform_tohost_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceVulkanMemoryModelFeatures, transform_fromhost_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR)

#endif
#ifdef VK_KHR_shader_terminate_invocation
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceShaderTerminateInvocationFeatures, transform_tohost_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceShaderTerminateInvocationFeatures, transform_fromhost_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR)

#endif
#ifdef VK_KHR_buffer_device_address
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceBufferDeviceAddressFeatures, transform_tohost_VkPhysicalDeviceBufferDeviceAddressFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceBufferDeviceAddressFeatures, transform_fromhost_VkPhysicalDeviceBufferDeviceAddressFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkBufferDeviceAddressInfo, transform_tohost_VkBufferDeviceAddressInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBufferDeviceAddressInfo, transform_fromhost_VkBufferDeviceAddressInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkBufferOpaqueCaptureAddressCreateInfo, transform_tohost_VkBufferOpaqueCaptureAddressCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBufferOpaqueCaptureAddressCreateInfo, transform_fromhost_VkBufferOpaqueCaptureAddressCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkMemoryOpaqueCaptureAddressAllocateInfo, transform_tohost_VkMemoryOpaqueCaptureAddressAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkMemoryOpaqueCaptureAddressAllocateInfo, transform_fromhost_VkMemoryOpaqueCaptureAddressAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkDeviceMemoryOpaqueCaptureAddressInfo, transform_tohost_VkDeviceMemoryOpaqueCaptureAddressInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDeviceMemoryOpaqueCaptureAddressInfo, transform_fromhost_VkDeviceMemoryOpaqueCaptureAddressInfoKHR)

#endif
#ifdef VK_KHR_pipeline_executable_properties
void transform_tohost_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* toTransform);

void transform_fromhost_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* toTransform);

void transform_tohost_VkPipelineInfoKHR(
    ResourceTracker* resourceTracker,
    VkPipelineInfoKHR* toTransform);

void transform_fromhost_VkPipelineInfoKHR(
    ResourceTracker* resourceTracker,
    VkPipelineInfoKHR* toTransform);

void transform_tohost_VkPipelineExecutablePropertiesKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutablePropertiesKHR* toTransform);

void transform_fromhost_VkPipelineExecutablePropertiesKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutablePropertiesKHR* toTransform);

void transform_tohost_VkPipelineExecutableInfoKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableInfoKHR* toTransform);

void transform_fromhost_VkPipelineExecutableInfoKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableInfoKHR* toTransform);

void transform_tohost_VkPipelineExecutableStatisticValueKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableStatisticValueKHR* toTransform);

void transform_fromhost_VkPipelineExecutableStatisticValueKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableStatisticValueKHR* toTransform);

void transform_tohost_VkPipelineExecutableStatisticKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableStatisticKHR* toTransform);

void transform_fromhost_VkPipelineExecutableStatisticKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableStatisticKHR* toTransform);

void transform_tohost_VkPipelineExecutableInternalRepresentationKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableInternalRepresentationKHR* toTransform);

void transform_fromhost_VkPipelineExecutableInternalRepresentationKHR(
    ResourceTracker* resourceTracker,
    VkPipelineExecutableInternalRepresentationKHR* toTransform);

#endif
#ifdef VK_KHR_shader_integer_dot_product
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceShaderIntegerDotProductFeatures, transform_tohost_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductFeatures, transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceShaderIntegerDotProductProperties, transform_tohost_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductProperties, transform_fromhost_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR)

#endif
#ifdef VK_KHR_synchronization2
DEFINE_ALIAS_FUNCTION(transform_tohost_VkMemoryBarrier2, transform_tohost_VkMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkMemoryBarrier2, transform_fromhost_VkMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkBufferMemoryBarrier2, transform_tohost_VkBufferMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBufferMemoryBarrier2, transform_fromhost_VkBufferMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageMemoryBarrier2, transform_tohost_VkImageMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageMemoryBarrier2, transform_fromhost_VkImageMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkDependencyInfo, transform_tohost_VkDependencyInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDependencyInfo, transform_fromhost_VkDependencyInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSubmitInfo2, transform_tohost_VkSubmitInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSubmitInfo2, transform_fromhost_VkSubmitInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSemaphoreSubmitInfo, transform_tohost_VkSemaphoreSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSemaphoreSubmitInfo, transform_fromhost_VkSemaphoreSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkCommandBufferSubmitInfo, transform_tohost_VkCommandBufferSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkCommandBufferSubmitInfo, transform_fromhost_VkCommandBufferSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceSynchronization2Features, transform_tohost_VkPhysicalDeviceSynchronization2FeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceSynchronization2Features, transform_fromhost_VkPhysicalDeviceSynchronization2FeaturesKHR)

#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures, transform_tohost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures, transform_fromhost_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR)

#endif
#ifdef VK_KHR_copy_commands2
DEFINE_ALIAS_FUNCTION(transform_tohost_VkCopyBufferInfo2, transform_tohost_VkCopyBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkCopyBufferInfo2, transform_fromhost_VkCopyBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkCopyImageInfo2, transform_tohost_VkCopyImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkCopyImageInfo2, transform_fromhost_VkCopyImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkCopyBufferToImageInfo2, transform_tohost_VkCopyBufferToImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkCopyBufferToImageInfo2, transform_fromhost_VkCopyBufferToImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkCopyImageToBufferInfo2, transform_tohost_VkCopyImageToBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkCopyImageToBufferInfo2, transform_fromhost_VkCopyImageToBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkBlitImageInfo2, transform_tohost_VkBlitImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBlitImageInfo2, transform_fromhost_VkBlitImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkResolveImageInfo2, transform_tohost_VkResolveImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkResolveImageInfo2, transform_fromhost_VkResolveImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkBufferCopy2, transform_tohost_VkBufferCopy2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBufferCopy2, transform_fromhost_VkBufferCopy2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageCopy2, transform_tohost_VkImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageCopy2, transform_fromhost_VkImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageBlit2, transform_tohost_VkImageBlit2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageBlit2, transform_fromhost_VkImageBlit2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkBufferImageCopy2, transform_tohost_VkBufferImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBufferImageCopy2, transform_fromhost_VkBufferImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageResolve2, transform_tohost_VkImageResolve2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageResolve2, transform_fromhost_VkImageResolve2KHR)

#endif
#ifdef VK_KHR_format_feature_flags2
DEFINE_ALIAS_FUNCTION(transform_tohost_VkFormatProperties3, transform_tohost_VkFormatProperties3KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkFormatProperties3, transform_fromhost_VkFormatProperties3KHR)

#endif
#ifdef VK_KHR_maintenance4
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceMaintenance4Features, transform_tohost_VkPhysicalDeviceMaintenance4FeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceMaintenance4Features, transform_fromhost_VkPhysicalDeviceMaintenance4FeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceMaintenance4Properties, transform_tohost_VkPhysicalDeviceMaintenance4PropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceMaintenance4Properties, transform_fromhost_VkPhysicalDeviceMaintenance4PropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkDeviceBufferMemoryRequirements, transform_tohost_VkDeviceBufferMemoryRequirementsKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDeviceBufferMemoryRequirements, transform_fromhost_VkDeviceBufferMemoryRequirementsKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkDeviceImageMemoryRequirements, transform_tohost_VkDeviceImageMemoryRequirementsKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDeviceImageMemoryRequirements, transform_fromhost_VkDeviceImageMemoryRequirementsKHR)

#endif
#ifdef VK_KHR_maintenance5
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceMaintenance5Features, transform_tohost_VkPhysicalDeviceMaintenance5FeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceMaintenance5Features, transform_fromhost_VkPhysicalDeviceMaintenance5FeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceMaintenance5Properties, transform_tohost_VkPhysicalDeviceMaintenance5PropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceMaintenance5Properties, transform_fromhost_VkPhysicalDeviceMaintenance5PropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkRenderingAreaInfo, transform_tohost_VkRenderingAreaInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkRenderingAreaInfo, transform_fromhost_VkRenderingAreaInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkDeviceImageSubresourceInfo, transform_tohost_VkDeviceImageSubresourceInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDeviceImageSubresourceInfo, transform_fromhost_VkDeviceImageSubresourceInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageSubresource2, transform_tohost_VkImageSubresource2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageSubresource2, transform_fromhost_VkImageSubresource2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSubresourceLayout2, transform_tohost_VkSubresourceLayout2KHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSubresourceLayout2, transform_fromhost_VkSubresourceLayout2KHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPipelineCreateFlags2CreateInfo, transform_tohost_VkPipelineCreateFlags2CreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPipelineCreateFlags2CreateInfo, transform_fromhost_VkPipelineCreateFlags2CreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkBufferUsageFlags2CreateInfo, transform_tohost_VkBufferUsageFlags2CreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkBufferUsageFlags2CreateInfo, transform_fromhost_VkBufferUsageFlags2CreateInfoKHR)

#endif
#ifdef VK_KHR_line_rasterization
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceLineRasterizationFeatures, transform_tohost_VkPhysicalDeviceLineRasterizationFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceLineRasterizationFeatures, transform_fromhost_VkPhysicalDeviceLineRasterizationFeaturesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceLineRasterizationProperties, transform_tohost_VkPhysicalDeviceLineRasterizationPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceLineRasterizationProperties, transform_fromhost_VkPhysicalDeviceLineRasterizationPropertiesKHR)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPipelineRasterizationLineStateCreateInfo, transform_tohost_VkPipelineRasterizationLineStateCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPipelineRasterizationLineStateCreateInfo, transform_fromhost_VkPipelineRasterizationLineStateCreateInfoKHR)

#endif
#ifdef VK_ANDROID_native_buffer
void transform_tohost_VkNativeBufferUsage2ANDROID(
    ResourceTracker* resourceTracker,
    VkNativeBufferUsage2ANDROID* toTransform);

void transform_fromhost_VkNativeBufferUsage2ANDROID(
    ResourceTracker* resourceTracker,
    VkNativeBufferUsage2ANDROID* toTransform);

void transform_tohost_VkNativeBufferANDROID(
    ResourceTracker* resourceTracker,
    VkNativeBufferANDROID* toTransform);

void transform_fromhost_VkNativeBufferANDROID(
    ResourceTracker* resourceTracker,
    VkNativeBufferANDROID* toTransform);

void transform_tohost_VkSwapchainImageCreateInfoANDROID(
    ResourceTracker* resourceTracker,
    VkSwapchainImageCreateInfoANDROID* toTransform);

void transform_fromhost_VkSwapchainImageCreateInfoANDROID(
    ResourceTracker* resourceTracker,
    VkSwapchainImageCreateInfoANDROID* toTransform);

void transform_tohost_VkPhysicalDevicePresentationPropertiesANDROID(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePresentationPropertiesANDROID* toTransform);

void transform_fromhost_VkPhysicalDevicePresentationPropertiesANDROID(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePresentationPropertiesANDROID* toTransform);

#endif
#ifdef VK_EXT_transform_feedback
void transform_tohost_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* toTransform);

void transform_tohost_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* toTransform);

void transform_tohost_VkPipelineRasterizationStateStreamCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationStateStreamCreateInfoEXT* toTransform);

void transform_fromhost_VkPipelineRasterizationStateStreamCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationStateStreamCreateInfoEXT* toTransform);

#endif
#ifdef VK_EXT_texture_compression_astc_hdr
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures, transform_tohost_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceTextureCompressionASTCHDRFeatures, transform_fromhost_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT)

#endif
#ifdef VK_EXT_depth_clip_enable
void transform_tohost_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDepthClipEnableFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDepthClipEnableFeaturesEXT* toTransform);

void transform_tohost_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationDepthClipStateCreateInfoEXT* toTransform);

void transform_fromhost_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationDepthClipStateCreateInfoEXT* toTransform);

#endif
#ifdef VK_EXT_inline_uniform_block
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceInlineUniformBlockFeatures, transform_tohost_VkPhysicalDeviceInlineUniformBlockFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceInlineUniformBlockFeatures, transform_fromhost_VkPhysicalDeviceInlineUniformBlockFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceInlineUniformBlockProperties, transform_tohost_VkPhysicalDeviceInlineUniformBlockPropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceInlineUniformBlockProperties, transform_fromhost_VkPhysicalDeviceInlineUniformBlockPropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkWriteDescriptorSetInlineUniformBlock, transform_tohost_VkWriteDescriptorSetInlineUniformBlockEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkWriteDescriptorSetInlineUniformBlock, transform_fromhost_VkWriteDescriptorSetInlineUniformBlockEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkDescriptorPoolInlineUniformBlockCreateInfo, transform_tohost_VkDescriptorPoolInlineUniformBlockCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDescriptorPoolInlineUniformBlockCreateInfo, transform_fromhost_VkDescriptorPoolInlineUniformBlockCreateInfoEXT)

#endif
#ifdef VK_EXT_image_drm_format_modifier
void transform_tohost_VkDrmFormatModifierPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesEXT* toTransform);

void transform_fromhost_VkDrmFormatModifierPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesEXT* toTransform);

void transform_tohost_VkDrmFormatModifierPropertiesListEXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesListEXT* toTransform);

void transform_fromhost_VkDrmFormatModifierPropertiesListEXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesListEXT* toTransform);

void transform_tohost_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageDrmFormatModifierInfoEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageDrmFormatModifierInfoEXT* toTransform);

void transform_tohost_VkImageDrmFormatModifierListCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierListCreateInfoEXT* toTransform);

void transform_fromhost_VkImageDrmFormatModifierListCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierListCreateInfoEXT* toTransform);

void transform_tohost_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierExplicitCreateInfoEXT* toTransform);

void transform_fromhost_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierExplicitCreateInfoEXT* toTransform);

void transform_tohost_VkImageDrmFormatModifierPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierPropertiesEXT* toTransform);

void transform_fromhost_VkImageDrmFormatModifierPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkImageDrmFormatModifierPropertiesEXT* toTransform);

void transform_tohost_VkDrmFormatModifierProperties2EXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierProperties2EXT* toTransform);

void transform_fromhost_VkDrmFormatModifierProperties2EXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierProperties2EXT* toTransform);

void transform_tohost_VkDrmFormatModifierPropertiesList2EXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesList2EXT* toTransform);

void transform_fromhost_VkDrmFormatModifierPropertiesList2EXT(
    ResourceTracker* resourceTracker,
    VkDrmFormatModifierPropertiesList2EXT* toTransform);

#endif
#ifdef VK_EXT_vertex_attribute_divisor
void transform_tohost_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* toTransform);

DEFINE_ALIAS_FUNCTION(transform_tohost_VkVertexInputBindingDivisorDescription, transform_tohost_VkVertexInputBindingDivisorDescriptionEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkVertexInputBindingDivisorDescription, transform_fromhost_VkVertexInputBindingDivisorDescriptionEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPipelineVertexInputDivisorStateCreateInfo, transform_tohost_VkPipelineVertexInputDivisorStateCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPipelineVertexInputDivisorStateCreateInfo, transform_fromhost_VkPipelineVertexInputDivisorStateCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceVertexAttributeDivisorFeatures, transform_tohost_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorFeatures, transform_fromhost_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT)

#endif
#ifdef VK_EXT_pipeline_creation_feedback
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPipelineCreationFeedbackCreateInfo, transform_tohost_VkPipelineCreationFeedbackCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPipelineCreationFeedbackCreateInfo, transform_fromhost_VkPipelineCreationFeedbackCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPipelineCreationFeedback, transform_tohost_VkPipelineCreationFeedbackEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPipelineCreationFeedback, transform_fromhost_VkPipelineCreationFeedbackEXT)

#endif
#ifdef VK_EXT_fragment_density_map
void transform_tohost_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFragmentDensityMapFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFragmentDensityMapFeaturesEXT* toTransform);

void transform_tohost_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFragmentDensityMapPropertiesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceFragmentDensityMapPropertiesEXT* toTransform);

void transform_tohost_VkRenderPassFragmentDensityMapCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkRenderPassFragmentDensityMapCreateInfoEXT* toTransform);

void transform_fromhost_VkRenderPassFragmentDensityMapCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkRenderPassFragmentDensityMapCreateInfoEXT* toTransform);

void transform_tohost_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    ResourceTracker* resourceTracker,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* toTransform);

void transform_fromhost_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    ResourceTracker* resourceTracker,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* toTransform);

#endif
#ifdef VK_EXT_scalar_block_layout
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceScalarBlockLayoutFeatures, transform_tohost_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceScalarBlockLayoutFeatures, transform_fromhost_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT)

#endif
#ifdef VK_EXT_subgroup_size_control
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceSubgroupSizeControlFeatures, transform_tohost_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceSubgroupSizeControlFeatures, transform_fromhost_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceSubgroupSizeControlProperties, transform_tohost_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceSubgroupSizeControlProperties, transform_fromhost_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo, transform_tohost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo, transform_fromhost_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT)

#endif
#ifdef VK_EXT_memory_budget
void transform_tohost_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryBudgetPropertiesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceMemoryBudgetPropertiesEXT* toTransform);

#endif
#ifdef VK_EXT_tooling_info
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceToolProperties, transform_tohost_VkPhysicalDeviceToolPropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceToolProperties, transform_fromhost_VkPhysicalDeviceToolPropertiesEXT)

#endif
#ifdef VK_EXT_provoking_vertex
void transform_tohost_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* toTransform);

void transform_tohost_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* toTransform);

void transform_tohost_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* toTransform);

void transform_fromhost_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* toTransform);

#endif
#ifdef VK_EXT_line_rasterization
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceLineRasterizationFeatures, transform_tohost_VkPhysicalDeviceLineRasterizationFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceLineRasterizationFeatures, transform_fromhost_VkPhysicalDeviceLineRasterizationFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceLineRasterizationProperties, transform_tohost_VkPhysicalDeviceLineRasterizationPropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceLineRasterizationProperties, transform_fromhost_VkPhysicalDeviceLineRasterizationPropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPipelineRasterizationLineStateCreateInfo, transform_tohost_VkPipelineRasterizationLineStateCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPipelineRasterizationLineStateCreateInfo, transform_fromhost_VkPipelineRasterizationLineStateCreateInfoEXT)

#endif
#ifdef VK_EXT_index_type_uint8
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceIndexTypeUint8Features, transform_tohost_VkPhysicalDeviceIndexTypeUint8FeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceIndexTypeUint8Features, transform_fromhost_VkPhysicalDeviceIndexTypeUint8FeaturesEXT)

#endif
#ifdef VK_EXT_extended_dynamic_state
void transform_tohost_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* toTransform);

#endif
#ifdef VK_EXT_host_image_copy
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceHostImageCopyFeatures, transform_tohost_VkPhysicalDeviceHostImageCopyFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceHostImageCopyFeatures, transform_fromhost_VkPhysicalDeviceHostImageCopyFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceHostImageCopyProperties, transform_tohost_VkPhysicalDeviceHostImageCopyPropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceHostImageCopyProperties, transform_fromhost_VkPhysicalDeviceHostImageCopyPropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkMemoryToImageCopy, transform_tohost_VkMemoryToImageCopyEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkMemoryToImageCopy, transform_fromhost_VkMemoryToImageCopyEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageToMemoryCopy, transform_tohost_VkImageToMemoryCopyEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageToMemoryCopy, transform_fromhost_VkImageToMemoryCopyEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkCopyMemoryToImageInfo, transform_tohost_VkCopyMemoryToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkCopyMemoryToImageInfo, transform_fromhost_VkCopyMemoryToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkCopyImageToMemoryInfo, transform_tohost_VkCopyImageToMemoryInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkCopyImageToMemoryInfo, transform_fromhost_VkCopyImageToMemoryInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkCopyImageToImageInfo, transform_tohost_VkCopyImageToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkCopyImageToImageInfo, transform_fromhost_VkCopyImageToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkHostImageLayoutTransitionInfo, transform_tohost_VkHostImageLayoutTransitionInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkHostImageLayoutTransitionInfo, transform_fromhost_VkHostImageLayoutTransitionInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSubresourceHostMemcpySize, transform_tohost_VkSubresourceHostMemcpySizeEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSubresourceHostMemcpySize, transform_fromhost_VkSubresourceHostMemcpySizeEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkHostImageCopyDevicePerformanceQuery, transform_tohost_VkHostImageCopyDevicePerformanceQueryEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkHostImageCopyDevicePerformanceQuery, transform_fromhost_VkHostImageCopyDevicePerformanceQueryEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkSubresourceLayout2, transform_tohost_VkSubresourceLayout2EXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkSubresourceLayout2, transform_fromhost_VkSubresourceLayout2EXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkImageSubresource2, transform_tohost_VkImageSubresource2EXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkImageSubresource2, transform_fromhost_VkImageSubresource2EXT)

#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, transform_tohost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, transform_fromhost_VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT)

#endif
#ifdef VK_EXT_texel_buffer_alignment
void transform_tohost_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* toTransform);

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceTexelBufferAlignmentProperties, transform_tohost_VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentProperties, transform_fromhost_VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT)

#endif
#ifdef VK_EXT_device_memory_report
void transform_tohost_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* toTransform);

void transform_tohost_VkDeviceMemoryReportCallbackDataEXT(
    ResourceTracker* resourceTracker,
    VkDeviceMemoryReportCallbackDataEXT* toTransform);

void transform_fromhost_VkDeviceMemoryReportCallbackDataEXT(
    ResourceTracker* resourceTracker,
    VkDeviceMemoryReportCallbackDataEXT* toTransform);

void transform_tohost_VkDeviceDeviceMemoryReportCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkDeviceDeviceMemoryReportCreateInfoEXT* toTransform);

void transform_fromhost_VkDeviceDeviceMemoryReportCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkDeviceDeviceMemoryReportCreateInfoEXT* toTransform);

#endif
#ifdef VK_EXT_robustness2
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceRobustness2FeaturesKHR, transform_tohost_VkPhysicalDeviceRobustness2FeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceRobustness2FeaturesKHR, transform_fromhost_VkPhysicalDeviceRobustness2FeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceRobustness2PropertiesKHR, transform_tohost_VkPhysicalDeviceRobustness2PropertiesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceRobustness2PropertiesKHR, transform_fromhost_VkPhysicalDeviceRobustness2PropertiesEXT)

#endif
#ifdef VK_EXT_custom_border_color
void transform_tohost_VkSamplerCustomBorderColorCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkSamplerCustomBorderColorCreateInfoEXT* toTransform);

void transform_fromhost_VkSamplerCustomBorderColorCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkSamplerCustomBorderColorCreateInfoEXT* toTransform);

void transform_tohost_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* toTransform);

void transform_tohost_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* toTransform);

#endif
#ifdef VK_EXT_private_data
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDevicePrivateDataFeatures, transform_tohost_VkPhysicalDevicePrivateDataFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDevicePrivateDataFeatures, transform_fromhost_VkPhysicalDevicePrivateDataFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkDevicePrivateDataCreateInfo, transform_tohost_VkDevicePrivateDataCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkDevicePrivateDataCreateInfo, transform_fromhost_VkDevicePrivateDataCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_tohost_VkPrivateDataSlotCreateInfo, transform_tohost_VkPrivateDataSlotCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPrivateDataSlotCreateInfo, transform_fromhost_VkPrivateDataSlotCreateInfoEXT)

#endif
#ifdef VK_EXT_pipeline_creation_cache_control
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDevicePipelineCreationCacheControlFeatures, transform_tohost_VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDevicePipelineCreationCacheControlFeatures, transform_fromhost_VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT)

#endif
#ifdef VK_EXT_graphics_pipeline_library
void transform_tohost_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* toTransform);

void transform_tohost_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* toTransform);

void transform_tohost_VkGraphicsPipelineLibraryCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkGraphicsPipelineLibraryCreateInfoEXT* toTransform);

void transform_fromhost_VkGraphicsPipelineLibraryCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkGraphicsPipelineLibraryCreateInfoEXT* toTransform);

#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void transform_tohost_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* toTransform);

#endif
#ifdef VK_EXT_image_robustness
DEFINE_ALIAS_FUNCTION(transform_tohost_VkPhysicalDeviceImageRobustnessFeatures, transform_tohost_VkPhysicalDeviceImageRobustnessFeaturesEXT)

DEFINE_ALIAS_FUNCTION(transform_fromhost_VkPhysicalDeviceImageRobustnessFeatures, transform_fromhost_VkPhysicalDeviceImageRobustnessFeaturesEXT)

#endif
#ifdef VK_EXT_image_compression_control
void transform_tohost_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* toTransform);

void transform_tohost_VkImageCompressionControlEXT(
    ResourceTracker* resourceTracker,
    VkImageCompressionControlEXT* toTransform);

void transform_fromhost_VkImageCompressionControlEXT(
    ResourceTracker* resourceTracker,
    VkImageCompressionControlEXT* toTransform);

void transform_tohost_VkImageCompressionPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkImageCompressionPropertiesEXT* toTransform);

void transform_fromhost_VkImageCompressionPropertiesEXT(
    ResourceTracker* resourceTracker,
    VkImageCompressionPropertiesEXT* toTransform);

#endif
#ifdef VK_EXT_4444_formats
void transform_tohost_VkPhysicalDevice4444FormatsFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice4444FormatsFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDevice4444FormatsFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDevice4444FormatsFeaturesEXT* toTransform);

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void transform_tohost_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* toTransform);

#endif
#ifdef VK_EXT_extended_dynamic_state2
void transform_tohost_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* toTransform);

#endif
#ifdef VK_EXT_color_write_enable
void transform_tohost_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceColorWriteEnableFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceColorWriteEnableFeaturesEXT* toTransform);

void transform_tohost_VkPipelineColorWriteCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineColorWriteCreateInfoEXT* toTransform);

void transform_fromhost_VkPipelineColorWriteCreateInfoEXT(
    ResourceTracker* resourceTracker,
    VkPipelineColorWriteCreateInfoEXT* toTransform);

#endif
#ifdef VK_GOOGLE_gfxstream
void transform_tohost_VkImportColorBufferGOOGLE(
    ResourceTracker* resourceTracker,
    VkImportColorBufferGOOGLE* toTransform);

void transform_fromhost_VkImportColorBufferGOOGLE(
    ResourceTracker* resourceTracker,
    VkImportColorBufferGOOGLE* toTransform);

void transform_tohost_VkImportBufferGOOGLE(
    ResourceTracker* resourceTracker,
    VkImportBufferGOOGLE* toTransform);

void transform_fromhost_VkImportBufferGOOGLE(
    ResourceTracker* resourceTracker,
    VkImportBufferGOOGLE* toTransform);

void transform_tohost_VkCreateBlobGOOGLE(
    ResourceTracker* resourceTracker,
    VkCreateBlobGOOGLE* toTransform);

void transform_fromhost_VkCreateBlobGOOGLE(
    ResourceTracker* resourceTracker,
    VkCreateBlobGOOGLE* toTransform);

#endif
#ifdef VK_EXT_image_compression_control_swapchain
void transform_tohost_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* toTransform);

void transform_fromhost_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    ResourceTracker* resourceTracker,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* toTransform);

#endif
}  // namespace vk
}  // namespace gfxstream
