import { Type } from '@nestjs/common';
import { CommandMetadata, CommandRunner, HelpOptions, OptionChoiceForMetadata, OptionMetadata, QuestionMetadata, QuestionNameMetadata, RootCommandMetadata } from './command-runner.interface';
type CommandDecorator = <TFunction extends Type<CommandRunner>>(target: TFunction) => void | TFunction;
export declare const Command: (options: CommandMetadata) => CommandDecorator;
export declare const SubCommand: (options: CommandMetadata) => CommandDecorator;
export declare const RootCommand: (options: RootCommandMetadata) => CommandDecorator;
export declare const DefaultCommand: (options: RootCommandMetadata) => CommandDecorator;
export declare const Option: (options: OptionMetadata) => MethodDecorator;
export declare const OptionChoiceFor: (options: OptionChoiceForMetadata) => MethodDecorator;
export declare const QuestionSet: (options: QuestionNameMetadata) => ClassDecorator;
export declare const Question: (options: QuestionMetadata) => MethodDecorator;
export declare const ValidateFor: (options: QuestionNameMetadata) => MethodDecorator;
export declare const TransformFor: (options: QuestionNameMetadata) => MethodDecorator;
export declare const WhenFor: (options: QuestionNameMetadata) => MethodDecorator;
export declare const MessageFor: (options: QuestionNameMetadata) => MethodDecorator;
export declare const ChoicesFor: (options: QuestionNameMetadata) => MethodDecorator;
export declare const DefaultFor: (options: QuestionNameMetadata) => MethodDecorator;
export declare const Help: (options: HelpOptions) => MethodDecorator;
export declare const InjectCommander: () => PropertyDecorator & ParameterDecorator;
export {};
