import { ExifToolTask } from "./ExifToolTask";
import { RawTags } from "./RawTags";
export declare const ReadRawTaskOptionFields: ["readArgs", "ignoreMinorErrors", "useMWG"];
export declare const DefaultReadRawTaskOptions: {
    readonly useMWG: boolean;
    readonly ignoreMinorErrors: boolean;
    readonly readArgs: string[];
};
export type ReadRawTaskOptions = Partial<typeof DefaultReadRawTaskOptions>;
export declare class ReadRawTask extends ExifToolTask<RawTags> {
    readonly sourceFile: string;
    readonly args: string[];
    static for(filename: string, options?: ReadRawTaskOptions): ReadRawTask;
    private constructor();
    toString(): string;
    protected parse(data: string, err?: Error): RawTags;
}
