import { Logger } from "batch-cluster";
/**
 * This implementation relies on the fact that both `exiftool-vendored.pl` and
 * `exiftool-vendored.exe` both export the path to their respective exiftool
 * binary.
 *
 * When running in node, this method should suffice.
 *
 * When running in Electron, all bets are off, due to ASAR packaging and other
 * nonsense. As perl can't run from within an ASAR archive, `electron-builder`
 * must be configured to `asarUnpack`
 * "**&#47;node_modules/exiftool-vendored.{pl,exe}/". See
 * <https://www.electron.build/generated/platformspecificbuildoptions#configuration-asarUnpack>
 * for details.
 *
 * If you're using `electron-forge`, add something like the following to your
 * ForgeConfig.packagerConfig.extraResource array: `fs.join(".", "node_modules",
 * "exiftool-vendored." + (isWin ? "exe" : "pl"))` but then you must specify a
 * custom exiftoolPath in your options hash, as subprocesses that use
 * ELECTRON_RUN_AS_NODE will no longer have process.resourcesPath set.
 *
 * If none of the above work for your use case, you can provide your own
 * `exiftoolPath` implementation to your instance of ExifTool
 *
 * @return the path to the exiftool binary, preferring the vendored version in
 * node_modules.
 */
export declare function exiftoolPath(logger?: Logger): Promise<string>;
