import * as bc from "batch-cluster";
import { ExifToolOptions } from "./ExifToolOptions";
import { Omit } from "./Omit";
import { Tags } from "./Tags";
export declare const ConsoleLogger: bc.Logger;
/**
 * Default values for `ExifToolOptions`, except for `processFactory` (which is
 * created by the ExifTool constructor) and `ignoreShebang` (which is set
 * dynamically based on OS). See {@link ExifToolOptions} for details.
 */
export declare const DefaultExifToolOptions: Omit<ExifToolOptions, "processFactory" | "ignoreShebang">;
/**
 * Returns a timezone offset adjustment for Nikon cameras that set DaylightSavings.
 * @param t - the tags to check for DaylightSavings and Make
 * @returns 60 (minutes) if Nikon camera with DaylightSavings=true, otherwise undefined
 * @see https://github.com/photostructure/exiftool-vendored.js/issues/215
 */
export declare function defaultAdjustTimeZoneIfDaylightSavings(t: Tags): number | undefined;
