var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var __accessCheck = (obj, member, msg) => {
  if (!member.has(obj))
    throw TypeError("Cannot " + msg);
};
var __privateGet = (obj, member, getter) => {
  __accessCheck(obj, member, "read from private field");
  return getter ? getter.call(obj) : member.get(obj);
};
var __privateAdd = (obj, member, value) => {
  if (member.has(obj))
    throw TypeError("Cannot add the same private member more than once");
  member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
};
var __privateSet = (obj, member, value, setter) => {
  __accessCheck(obj, member, "write to private field");
  setter ? setter.call(obj, value) : member.set(obj, value);
  return value;
};
var __privateMethod = (obj, member, method) => {
  __accessCheck(obj, member, "access private method");
  return method;
};

// node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "node_modules/balanced-match/index.js"(exports, module) {
    "use strict";
    module.exports = balanced;
    function balanced(a, b, str) {
      if (a instanceof RegExp)
        a = maybeMatch(a, str);
      if (b instanceof RegExp)
        b = maybeMatch(b, str);
      var r = range(a, b, str);
      return r && {
        start: r[0],
        end: r[1],
        pre: str.slice(0, r[0]),
        body: str.slice(r[0] + a.length, r[1]),
        post: str.slice(r[1] + b.length)
      };
    }
    function maybeMatch(reg, str) {
      var m = str.match(reg);
      return m ? m[0] : null;
    }
    balanced.range = range;
    function range(a, b, str) {
      var begs, beg, left, right, result;
      var ai = str.indexOf(a);
      var bi = str.indexOf(b, ai + 1);
      var i = ai;
      if (ai >= 0 && bi > 0) {
        if (a === b) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i >= 0 && !result) {
          if (i == ai) {
            begs.push(i);
            ai = str.indexOf(a, i + 1);
          } else if (begs.length == 1) {
            result = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b, i + 1);
          }
          i = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result = [left, right];
        }
      }
      return result;
    }
  }
});

// node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "node_modules/brace-expansion/index.js"(exports, module) {
    var balanced = require_balanced_match();
    module.exports = expandTop;
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    function numeric(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    function escapeBraces(str) {
      return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
    }
    function unescapeBraces(str) {
      return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
    }
    function parseCommaParts(str) {
      if (!str)
        return [""];
      var parts = [];
      var m = balanced("{", "}", str);
      if (!m)
        return str.split(",");
      var pre = m.pre;
      var body = m.body;
      var post = m.post;
      var p = pre.split(",");
      p[p.length - 1] += "{" + body + "}";
      var postParts = parseCommaParts(post);
      if (post.length) {
        p[p.length - 1] += postParts.shift();
        p.push.apply(p, postParts);
      }
      parts.push.apply(parts, p);
      return parts;
    }
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand2(escapeBraces(str), true).map(unescapeBraces);
    }
    function embrace(str) {
      return "{" + str + "}";
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    function lte(i, y) {
      return i <= y;
    }
    function gte(i, y) {
      return i >= y;
    }
    function expand2(str, isTop) {
      var expansions = [];
      var m = balanced("{", "}", str);
      if (!m)
        return [str];
      var pre = m.pre;
      var post = m.post.length ? expand2(m.post, false) : [""];
      if (/\$$/.test(m.pre)) {
        for (var k = 0; k < post.length; k++) {
          var expansion = pre + "{" + m.body + "}" + post[k];
          expansions.push(expansion);
        }
      } else {
        var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
        var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
        var isSequence = isNumericSequence || isAlphaSequence;
        var isOptions = m.body.indexOf(",") >= 0;
        if (!isSequence && !isOptions) {
          if (m.post.match(/,.*\}/)) {
            str = m.pre + "{" + m.body + escClose + m.post;
            return expand2(str);
          }
          return [str];
        }
        var n;
        if (isSequence) {
          n = m.body.split(/\.\./);
        } else {
          n = parseCommaParts(m.body);
          if (n.length === 1) {
            n = expand2(n[0], false).map(embrace);
            if (n.length === 1) {
              return post.map(function(p) {
                return m.pre + n[0] + p;
              });
            }
          }
        }
        var N;
        if (isSequence) {
          var x = numeric(n[0]);
          var y = numeric(n[1]);
          var width = Math.max(n[0].length, n[1].length);
          var incr = n.length == 3 ? Math.abs(numeric(n[2])) : 1;
          var test = lte;
          var reverse = y < x;
          if (reverse) {
            incr *= -1;
            test = gte;
          }
          var pad = n.some(isPadded);
          N = [];
          for (var i = x; test(i, y); i += incr) {
            var c;
            if (isAlphaSequence) {
              c = String.fromCharCode(i);
              if (c === "\\")
                c = "";
            } else {
              c = String(i);
              if (pad) {
                var need = width - c.length;
                if (need > 0) {
                  var z = new Array(need + 1).join("0");
                  if (i < 0)
                    c = "-" + z + c.slice(1);
                  else
                    c = z + c;
                }
              }
            }
            N.push(c);
          }
        } else {
          N = [];
          for (var j = 0; j < n.length; j++) {
            N.push.apply(N, expand2(n[j], false));
          }
        }
        for (var j = 0; j < N.length; j++) {
          for (var k = 0; k < post.length; k++) {
            var expansion = pre + N[j] + post[k];
            if (!isTop || isSequence || expansion)
              expansions.push(expansion);
          }
        }
      }
      return expansions;
    }
  }
});

// src/polyfills/node-capabilities.ts
var WebAssembly2 = globalThis.WebAssembly || {};
var CAPABILITIES = {
  supportsJSPromiseInterface: typeof WebAssembly2.Suspending === "function" && typeof WebAssembly2.promising === "function",
  allowSharedBufferCodec: false,
  manifestSupportsPaths: true,
  crossOriginChecksEnforced: false,
  fsAccess: true,
  hasWorkerCapability: true,
  supportsWasiPreview1: true,
  supportsTimeouts: true,
  extismStdoutEnvVarSet: Boolean(process.env.EXTISM_ENABLE_WASI_OUTPUT)
};

// src/interfaces.ts
var _decoder, _bytes;
var _PluginOutput = class extends DataView {
  constructor(buffer) {
    super(buffer);
    __privateAdd(this, _bytes, null);
  }
  json() {
    return JSON.parse(this.string());
  }
  arrayBuffer() {
    return this.buffer;
  }
  text() {
    return this.string();
  }
  string() {
    return __privateGet(_PluginOutput, _decoder).decode(this.buffer);
  }
  bytes() {
    __privateGet(this, _bytes) ?? __privateSet(this, _bytes, new Uint8Array(this.buffer));
    return __privateGet(this, _bytes);
  }
  setInt8(_byteOffset, _value) {
    throw new Error("Cannot set values on output");
  }
  setInt16(_byteOffset, _value, _littleEndian) {
    throw new Error("Cannot set values on output");
  }
  setInt32(_byteOffset, _value, _littleEndian) {
    throw new Error("Cannot set values on output");
  }
  setUint8(_byteOffset, _value) {
    throw new Error("Cannot set values on output");
  }
  setUint16(_byteOffset, _value, _littleEndian) {
    throw new Error("Cannot set values on output");
  }
  setUint32(_byteOffset, _value, _littleEndian) {
    throw new Error("Cannot set values on output");
  }
  setFloat32(_byteOffset, _value, _littleEndian) {
    throw new Error("Cannot set values on output");
  }
  setFloat64(_byteOffset, _value, _littleEndian) {
    throw new Error("Cannot set values on output");
  }
  setBigInt64(_byteOffset, _value, _littleEndian) {
    throw new Error("Cannot set values on output");
  }
  setBigUint64(_byteOffset, _value, _littleEndian) {
    throw new Error("Cannot set values on output");
  }
};
var PluginOutput = _PluginOutput;
_decoder = new WeakMap();
_bytes = new WeakMap();
__privateAdd(PluginOutput, _decoder, new TextDecoder());
var SAB_BASE_OFFSET = 4;
function logLevelToPriority(level) {
  switch (level) {
    case "trace":
      return 0;
    case "debug":
      return 1;
    case "info":
      return 2;
    case "warn":
      return 3;
    case "error":
      return 4;
    case "silent":
      return 2147483647;
    default:
      throw new TypeError(
        `unrecognized log level "${level}"; expected one of "trace", "debug", "info", "warn", "error", "silent"`
      );
  }
}
function priorityToLogLevel(level) {
  switch (level) {
    case 0:
      return "trace";
    case 1:
      return "debug";
    case 2:
      return "info";
    case 3:
      return "warn";
    case 4:
      return "error";
    case 2147483647:
      return "silent";
    default:
      throw new TypeError(
        `unrecognized log level "${level}"; expected one of "trace", "debug", "info", "warn", "error", "silent"`
      );
  }
}

// src/manifest.ts
import { readFile } from "node:fs/promises";

// src/polyfills/response-to-module.ts
async function responseToModule(response, hasHash) {
  if (String(response.headers.get("Content-Type")).split(";")[0] === "application/octet-stream") {
    const headers = new Headers(response.headers);
    headers.set("Content-Type", "application/wasm");
    response = new Response(response.body, {
      status: response.status,
      statusText: response.statusText,
      headers
    });
  }
  const data = hasHash ? await response.clone().arrayBuffer() : void 0;
  const module = await WebAssembly.compileStreaming(response);
  return { module, data };
}

// src/manifest.ts
async function _populateWasmField(candidate, _fetch) {
  if (candidate instanceof ArrayBuffer) {
    return { wasm: [{ data: new Uint8Array(candidate) }] };
  }
  if (candidate instanceof WebAssembly.Module) {
    return { wasm: [{ module: candidate }] };
  }
  if (typeof candidate === "string") {
    if (candidate.search(/^\s*\{/g) === 0) {
      return parseManifestFromJson(candidate);
    }
    if (candidate.search(/^(https?|file):\/\//) !== 0) {
      return { wasm: [{ path: candidate }] };
    }
    candidate = new URL(candidate);
  }
  if (candidate instanceof Response || candidate?.constructor?.name === "Response") {
    const response = candidate;
    const contentType = response.headers.get("content-type") || "application/octet-stream";
    switch (contentType.split(";")[0]) {
      case "application/octet-stream":
      case "application/wasm":
        return { wasm: [{ response }] };
      case "application/json":
      case "text/json":
        return _populateWasmField(parseManifestFromJson(await response.text()), _fetch);
      default:
        throw new TypeError(
          `While processing manifest URL "${response.url}"; expected content-type of "text/json", "application/json", "application/octet-stream", or "application/wasm"; got "${contentType}" after stripping off charset.`
        );
    }
  }
  if (candidate instanceof URL) {
    return _populateWasmField(await _fetch(candidate, { redirect: "follow" }), _fetch);
  }
  if (!("wasm" in candidate)) {
    throw new TypeError('Expected "wasm" key in manifest');
  }
  if (!Array.isArray(candidate.wasm)) {
    throw new TypeError('Expected "manifest.wasm" to be array');
  }
  const badItemIdx = candidate.wasm.findIndex(
    (item) => !("data" in item) && !("url" in item) && !("path" in item) && !("module" in item) && !("response" in item)
  );
  if (badItemIdx > -1) {
    throw new TypeError(
      `Expected every item in "manifest.wasm" to include either a "data", "url", or "path" key; got bad item at index ${badItemIdx}`
    );
  }
  return { ...candidate };
}
function parseManifestFromJson(json) {
  const parsed = JSON.parse(json);
  return {
    wasm: parsed.wasm,
    timeoutMs: parsed.timeoutMs ?? parsed.timeout_ms,
    allowedPaths: parsed.allowedPaths ?? parsed.allowed_paths,
    allowedHosts: parsed.allowedHosts ?? parsed.allowed_hosts,
    config: parsed.config,
    ...parsed.memory ? {
      maxHttpResponseBytes: parsed.memory.maxHttpResponseBytes ?? parsed.memory.max_http_response_bytes,
      maxPages: parsed.memory.maxPages ?? parsed.memory.max_pages,
      maxVarBytes: parsed.memory.maxVarBytes ?? parsed.memory.max_var_bytes
    } : {}
  };
}
async function intoManifest(candidate, _fetch = fetch) {
  const manifest = await _populateWasmField(candidate, _fetch);
  manifest.config ??= {};
  return manifest;
}
async function toWasmModuleData(input, _fetch) {
  const names = [];
  const manifest = await intoManifest(input, _fetch);
  const manifestOpts = {
    allowedPaths: manifest.allowedPaths,
    allowedHosts: manifest.allowedHosts,
    config: manifest.config,
    memory: manifest.memory
  };
  const manifestsWasm = await Promise.all(
    manifest.wasm.map(async (item, idx, all) => {
      let module;
      let buffer;
      if (item.data) {
        const data = item.data;
        buffer = data.buffer ? data.buffer : data;
        module = await WebAssembly.compile(data);
      } else if (item.path) {
        const path2 = item.path;
        const data = await readFile(path2);
        buffer = data.buffer;
        module = await WebAssembly.compile(data);
      } else if (item.url) {
        const response = await _fetch(item.url, {
          headers: {
            accept: "application/wasm;q=0.9,application/octet-stream;q=0.8"
          }
        });
        const result = await responseToModule(response, Boolean(item.hash));
        buffer = result.data;
        module = result.module;
      } else if (item.response) {
        const result = await responseToModule(item.response, Boolean(item.hash));
        buffer = result.data;
        module = result.module;
      } else if (item.module) {
        names[idx] = item.name ?? String(idx);
        module = item.module;
      } else {
        throw new Error(
          `Unrecognized wasm item at index ${idx}. Keys include: "${Object.keys(item).sort().join(",")}"`
        );
      }
      let potentialName = String(idx);
      if (item.hash) {
        if (!buffer) {
          throw new Error("Item specified a hash but WebAssembly.Module source data is unavailable for hashing");
        }
        const hashBuffer = new Uint8Array(await crypto.subtle.digest("SHA-256", buffer));
        const checkBuffer = new Uint8Array(32);
        let eq = true;
        for (let i = 0; i < 32; ++i) {
          checkBuffer[i] = parseInt(item.hash.slice(i << 1, (i << 1) + 2), 16);
          eq = eq && checkBuffer[i] === hashBuffer[i];
        }
        const hashAsString = () => [...hashBuffer].map((xs) => xs.toString(16).padStart(2, "0")).join("");
        if (!eq) {
          throw new Error(`Plugin error: hash mismatch. Expected: ${item.hash}. Actual: ${hashAsString()}`);
        }
        potentialName = hashAsString();
      }
      names[idx] = item.name ?? (idx === all.length - 1 ? "main" : potentialName);
      return module;
    })
  );
  if (!names.includes("main")) {
    throw new Error('manifest with multiple modules must designate one "main" module');
  }
  return [manifestOpts, names, manifestsWasm];
}

// src/call-context.ts
var BEGIN = Symbol("begin");
var END = Symbol("end");
var ENV = Symbol("env");
var SET_HOST_CONTEXT = Symbol("set-host-context");
var GET_BLOCK = Symbol("get-block");
var IMPORT_STATE = Symbol("import-state");
var EXPORT_STATE = Symbol("export-state");
var STORE = Symbol("store-value");
var RESET = Symbol("reset");
var Block = class {
  get byteLength() {
    return this.buffer.byteLength;
  }
  constructor(arrayBuffer, local) {
    this.buffer = arrayBuffer;
    this.view = new DataView(this.buffer);
    this.local = local;
  }
  static indexToAddress(idx) {
    return BigInt(idx) << 48n;
  }
  static addressToIndex(addr) {
    return Number(BigInt(addr) >> 48n);
  }
  static maskAddress(addr) {
    return Number(BigInt(addr) & (1n << 48n) - 1n);
  }
};
var _a;
var CallContext = class {
  constructor(type, logger, logLevel, config, memoryOptions) {
    this.#blocks = [];
    this.#vars = /* @__PURE__ */ new Map();
    this[_a] = {
      alloc: (n) => {
        return this.alloc(n);
      },
      free: (addr) => {
        this.#blocks[Block.addressToIndex(addr)] = null;
      },
      load_u8: (addr) => {
        const blockIdx = Block.addressToIndex(addr);
        const offset = Block.maskAddress(addr);
        const block = this.#blocks[blockIdx];
        return block?.view.getUint8(Number(offset));
      },
      load_u64: (addr) => {
        const blockIdx = Block.addressToIndex(addr);
        const offset = Block.maskAddress(addr);
        const block = this.#blocks[blockIdx];
        return block?.view.getBigUint64(Number(offset), true);
      },
      store_u8: (addr, n) => {
        const blockIdx = Block.addressToIndex(addr);
        const offset = Block.maskAddress(addr);
        const block = this.#blocks[blockIdx];
        block?.view.setUint8(Number(offset), Number(n));
      },
      store_u64: (addr, n) => {
        const blockIdx = Block.addressToIndex(addr);
        const offset = Block.maskAddress(addr);
        const block = this.#blocks[blockIdx];
        block?.view.setBigUint64(Number(offset), n, true);
      },
      input_offset: () => {
        const blockIdx = this.#stack[this.#stack.length - 1][0];
        return Block.indexToAddress(blockIdx || 0);
      },
      input_length: () => {
        return BigInt(this.#input?.byteLength ?? 0);
      },
      input_load_u8: (addr) => {
        const offset = Block.maskAddress(addr);
        return this.#input?.view.getUint8(Number(offset));
      },
      input_load_u64: (addr) => {
        const offset = Block.maskAddress(addr);
        return this.#input?.view.getBigUint64(Number(offset), true);
      },
      output_set: (addr, length) => {
        const blockIdx = Block.addressToIndex(addr);
        const block = this.#blocks[blockIdx];
        if (!block) {
          throw new Error(`cannot assign to this block (addr=${addr.toString(16).padStart(16, "0")}; length=${length})`);
        }
        if (length > block.buffer.byteLength) {
          throw new Error("length longer than target block");
        }
        this.#stack[this.#stack.length - 1][1] = blockIdx;
      },
      error_set: (addr) => {
        const blockIdx = Block.addressToIndex(addr);
        const block = this.#blocks[blockIdx];
        if (!block) {
          throw new Error("cannot assign error to this block");
        }
        this.#stack[this.#stack.length - 1][2] = blockIdx;
      },
      error_get: () => {
        const error = this.#stack[this.#stack.length - 1][2];
        if (error) {
          return Block.indexToAddress(error);
        }
        return 0n;
      },
      config_get: (addr) => {
        const item = this.read(addr);
        if (item === null) {
          return 0n;
        }
        try {
          const key = item.string();
          if (key in this.#config) {
            return this.store(this.#config[key]);
          }
        } finally {
          this[ENV].free(addr);
        }
        return 0n;
      },
      var_get: (addr) => {
        const item = this.read(addr);
        if (item === null) {
          return 0n;
        }
        try {
          const key = item.string();
          const result = this.getVariable(key);
          const stored = result ? this[STORE](result.bytes()) || 0 : 0;
          return Block.indexToAddress(stored);
        } finally {
          this[ENV].free(addr);
        }
      },
      var_set: (addr, valueaddr) => {
        const item = this.read(addr);
        if (item === null) {
          this.#logger.error(`attempted to set variable using invalid key address (addr="${addr.toString(16)}H")`);
          return;
        }
        const key = item.string();
        if (valueaddr === 0n) {
          this.deleteVariable(key);
          return;
        }
        const valueBlock = this.#blocks[Block.addressToIndex(valueaddr)];
        if (!valueBlock) {
          this.#logger.error(
            `attempted to set variable to invalid address (key="${key}"; addr="${valueaddr.toString(16)}H")`
          );
          return;
        }
        try {
          const copied = new Uint8Array(valueBlock.buffer.byteLength);
          copied.set(new Uint8Array(valueBlock.buffer), 0);
          this.setVariable(key, copied);
        } catch (err) {
          this.#logger.error(err.message);
          this.setError(err);
          return;
        }
      },
      http_request: (_requestOffset, _bodyOffset) => {
        this.#logger.error("http_request is not enabled");
        return 0n;
      },
      http_status_code: () => {
        this.#logger.error("http_status_code is not enabled");
        return 0;
      },
      http_headers: () => {
        this.#logger.error("http_headers is not enabled");
        return 0n;
      },
      length: (addr) => {
        return this.length(addr);
      },
      length_unsafe: (addr) => {
        return this.length(addr);
      },
      log_warn: this.#handleLog.bind(this, logLevelToPriority("warn"), "warn"),
      log_info: this.#handleLog.bind(this, logLevelToPriority("info"), "info"),
      log_debug: this.#handleLog.bind(this, logLevelToPriority("debug"), "debug"),
      log_error: this.#handleLog.bind(this, logLevelToPriority("error"), "error"),
      log_trace: this.#handleLog.bind(this, logLevelToPriority("trace"), "trace"),
      get_log_level: () => {
        return isFinite(this.#logLevel) ? this.#logLevel : 4294967295;
      }
    };
    this.#arrayBufferType = type;
    this.#logger = logger;
    this.#logLevel = logLevel ?? 2147483647;
    this.#decoder = new TextDecoder();
    this.#encoder = new TextEncoder();
    this.#memoryOptions = memoryOptions;
    this.#varsSize = 0;
    this.#stack = [];
    this.alloc(1);
    this.#config = config;
  }
  #stack;
  #blocks;
  #logger;
  #logLevel;
  #decoder;
  #encoder;
  #arrayBufferType;
  #config;
  #vars;
  #varsSize;
  #memoryOptions;
  #hostContext;
  hostContext() {
    return this.#hostContext;
  }
  alloc(size) {
    const block = new Block(new this.#arrayBufferType(Number(size)), true);
    const index = this.#blocks.length;
    this.#blocks.push(block);
    if (this.#memoryOptions.maxPages) {
      const pageSize = 64 * 1024;
      const totalBytes = this.#blocks.reduce((acc, block2) => acc + (block2?.buffer.byteLength ?? 0), 0);
      const totalPages = Math.ceil(totalBytes / pageSize);
      if (totalPages > this.#memoryOptions.maxPages) {
        this.#logger.error(
          `memory limit exceeded: ${totalPages} pages requested, ${this.#memoryOptions.maxPages} allowed`
        );
        return 0n;
      }
    }
    return Block.indexToAddress(index);
  }
  getVariable(name) {
    if (!this.#vars.has(name)) {
      return null;
    }
    return new PluginOutput(this.#vars.get(name).buffer);
  }
  setVariable(name, value) {
    const buffer = typeof value === "string" ? this.#encoder.encode(value) : value;
    const variable = this.#vars.get(name);
    const newSize = this.#varsSize + buffer.byteLength - (variable?.byteLength || 0);
    if (newSize > (this.#memoryOptions?.maxVarBytes || Infinity)) {
      throw new Error(
        `var memory limit exceeded: ${newSize} bytes requested, ${this.#memoryOptions.maxVarBytes} allowed`
      );
    }
    this.#varsSize = newSize;
    this.#vars.set(name, buffer);
  }
  deleteVariable(name) {
    const variable = this.#vars.get(name);
    if (!variable) {
      return;
    }
    this.#vars.delete(name);
    this.#varsSize -= variable.byteLength;
  }
  read(addr) {
    const blockIdx = Block.addressToIndex(addr);
    const block = this.#blocks[blockIdx];
    if (!block) {
      return null;
    }
    const buffer = !(block.buffer instanceof ArrayBuffer) && !CAPABILITIES.allowSharedBufferCodec ? new Uint8Array(block.buffer).slice().buffer : block.buffer;
    return new PluginOutput(buffer);
  }
  store(input) {
    const idx = this[STORE](input);
    if (!idx) {
      throw new Error("failed to store output");
    }
    return Block.indexToAddress(idx);
  }
  length(addr) {
    const blockIdx = Block.addressToIndex(addr);
    const block = this.#blocks[blockIdx];
    if (!block) {
      return 0n;
    }
    return BigInt(block.buffer.byteLength);
  }
  setError(err = null) {
    const blockIdx = err ? this[STORE](err instanceof Error ? err.message : err) : 0;
    if (!blockIdx) {
      throw new Error("could not store error value");
    }
    this.#stack[this.#stack.length - 1][2] = blockIdx;
  }
  get logLevel() {
    return priorityToLogLevel(this.#logLevel);
  }
  set logLevel(v) {
    this.#logLevel = logLevelToPriority(v);
  }
  #handleLog(incomingLevel, level, addr) {
    const blockIdx = Block.addressToIndex(addr);
    const block = this.#blocks[blockIdx];
    if (!block) {
      this.#logger.error(
        `failed to log(${level}): bad block reference in addr 0x${addr.toString(16).padStart(64, "0")}`
      );
      return;
    }
    try {
      if (this.#logLevel <= incomingLevel) {
        const text = this.#decoder.decode(block.buffer);
        this.#logger[level](text);
      }
    } finally {
      this.#blocks[blockIdx] = null;
    }
  }
  get #input() {
    const idx = this.#stack[this.#stack.length - 1][0];
    if (idx === null) {
      return null;
    }
    return this.#blocks[idx];
  }
  [(_a = ENV, RESET)]() {
    this.#hostContext = null;
    this.#blocks.length = 1;
    this.#stack.length = 0;
  }
  [GET_BLOCK](index) {
    const block = this.#blocks[index];
    if (!block) {
      throw new Error(`invalid block index: ${index}`);
    }
    return block;
  }
  [IMPORT_STATE](state, copy = false) {
    for (let [buf, idx] of state.blocks) {
      if (buf && copy) {
        const dst = new Uint8Array(new this.#arrayBufferType(Number(buf.byteLength)));
        dst.set(new Uint8Array(buf));
        buf = dst.buffer;
      }
      this.#blocks[idx] = buf ? new Block(buf, false) : null;
    }
    this.#stack = state.stack;
  }
  [EXPORT_STATE]() {
    return {
      stack: this.#stack.slice(),
      blocks: this.#blocks.map((block, idx) => {
        if (!block) {
          return [null, idx];
        }
        if (block.local) {
          block.local = false;
          return [block.buffer, idx];
        }
        return null;
      }).filter(Boolean)
    };
  }
  [STORE](input) {
    if (typeof input === "string") {
      input = this.#encoder.encode(input);
    }
    if (!input) {
      return null;
    }
    if (input instanceof Uint8Array) {
      if (input.buffer.constructor === this.#arrayBufferType && input.byteOffset === 0 && input.byteLength === input.buffer.byteLength) {
        const idx2 = this.#blocks.length;
        this.#blocks.push(new Block(input.buffer, true));
        return idx2;
      }
      const idx = Block.addressToIndex(this.alloc(input.length));
      const block = this.#blocks[idx];
      const buf = new Uint8Array(block.buffer);
      buf.set(input, 0);
      return idx;
    }
    return input;
  }
  [SET_HOST_CONTEXT](hostContext) {
    this.#hostContext = hostContext;
  }
  [BEGIN](input) {
    this.#stack.push([input, null, null]);
  }
  [END]() {
    this.#hostContext = null;
    const [, outputIdx, errorIdx] = this.#stack.pop();
    const outputPosition = errorIdx === null ? 1 : 0;
    const idx = errorIdx ?? outputIdx;
    const result = [null, null];
    if (idx === null) {
      return result;
    }
    const block = this.#blocks[idx];
    if (block === null) {
      return result;
    }
    result[outputPosition] = idx;
    return result;
  }
};

// src/polyfills/node-wasi.ts
import { WASI } from "wasi";
import { devNull } from "node:os";
import { open } from "node:fs/promises";
import { closeSync } from "node:fs";
async function createDevNullFDs() {
  const [stdin, stdout] = await Promise.all([open(devNull, "r"), open(devNull, "w")]);
  let needsClose = true;
  let close = async () => {
    closeSync(stdin);
    closeSync(stdout);
  };
  if (typeof stdin !== "number") {
    const fr = new globalThis.FinalizationRegistry((held) => {
      try {
        if (needsClose)
          closeSync(held);
      } catch {
      }
    });
    fr.register(stdin, stdin.fd);
    fr.register(stdout, stdout.fd);
    close = async () => {
      needsClose = false;
      await Promise.all([stdin.close(), stdout.close()]).catch(() => {
      });
    };
  }
  return {
    close,
    fds: [stdin.fd, stdout.fd, stdout.fd]
  };
}
async function loadWasi(allowedPaths, enableWasiOutput) {
  const {
    close,
    fds: [stdin, stdout, stderr]
  } = enableWasiOutput ? { async close() {
  }, fds: [0, 1, 2] } : await createDevNullFDs();
  const context = new WASI({
    version: "preview1",
    preopens: allowedPaths,
    stdin,
    stdout,
    stderr
  });
  return {
    async importObject() {
      return context.wasiImport;
    },
    async close() {
      await close();
    },
    async initialize(instance) {
      const memory = instance.exports.memory;
      if (!memory) {
        throw new Error("The module has to export a default memory.");
      }
      if (instance.exports._initialize) {
        const init = instance.exports._initialize;
        if (context.initialize) {
          context.initialize({
            exports: {
              memory,
              _initialize: () => {
                init();
              }
            }
          });
        } else {
          init();
        }
      } else {
        context.start({
          exports: {
            memory,
            _start: () => {
            }
          }
        });
      }
    }
  };
}

// node_modules/minimatch/dist/mjs/index.js
var import_brace_expansion = __toESM(require_brace_expansion(), 1);

// node_modules/minimatch/dist/mjs/assert-valid-pattern.js
var MAX_PATTERN_LENGTH = 1024 * 64;
var assertValidPattern = (pattern) => {
  if (typeof pattern !== "string") {
    throw new TypeError("invalid pattern");
  }
  if (pattern.length > MAX_PATTERN_LENGTH) {
    throw new TypeError("pattern is too long");
  }
};

// node_modules/minimatch/dist/mjs/brace-expressions.js
var posixClasses = {
  "[:alnum:]": ["\\p{L}\\p{Nl}\\p{Nd}", true],
  "[:alpha:]": ["\\p{L}\\p{Nl}", true],
  "[:ascii:]": ["\\x00-\\x7f", false],
  "[:blank:]": ["\\p{Zs}\\t", true],
  "[:cntrl:]": ["\\p{Cc}", true],
  "[:digit:]": ["\\p{Nd}", true],
  "[:graph:]": ["\\p{Z}\\p{C}", true, true],
  "[:lower:]": ["\\p{Ll}", true],
  "[:print:]": ["\\p{C}", true],
  "[:punct:]": ["\\p{P}", true],
  "[:space:]": ["\\p{Z}\\t\\r\\n\\v\\f", true],
  "[:upper:]": ["\\p{Lu}", true],
  "[:word:]": ["\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}", true],
  "[:xdigit:]": ["A-Fa-f0-9", false]
};
var braceEscape = (s) => s.replace(/[[\]\\-]/g, "\\$&");
var regexpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
var rangesToString = (ranges) => ranges.join("");
var parseClass = (glob, position) => {
  const pos = position;
  if (glob.charAt(pos) !== "[") {
    throw new Error("not in a brace expression");
  }
  const ranges = [];
  const negs = [];
  let i = pos + 1;
  let sawStart = false;
  let uflag = false;
  let escaping = false;
  let negate = false;
  let endPos = pos;
  let rangeStart = "";
  WHILE:
    while (i < glob.length) {
      const c = glob.charAt(i);
      if ((c === "!" || c === "^") && i === pos + 1) {
        negate = true;
        i++;
        continue;
      }
      if (c === "]" && sawStart && !escaping) {
        endPos = i + 1;
        break;
      }
      sawStart = true;
      if (c === "\\") {
        if (!escaping) {
          escaping = true;
          i++;
          continue;
        }
      }
      if (c === "[" && !escaping) {
        for (const [cls, [unip, u, neg]] of Object.entries(posixClasses)) {
          if (glob.startsWith(cls, i)) {
            if (rangeStart) {
              return ["$.", false, glob.length - pos, true];
            }
            i += cls.length;
            if (neg)
              negs.push(unip);
            else
              ranges.push(unip);
            uflag = uflag || u;
            continue WHILE;
          }
        }
      }
      escaping = false;
      if (rangeStart) {
        if (c > rangeStart) {
          ranges.push(braceEscape(rangeStart) + "-" + braceEscape(c));
        } else if (c === rangeStart) {
          ranges.push(braceEscape(c));
        }
        rangeStart = "";
        i++;
        continue;
      }
      if (glob.startsWith("-]", i + 1)) {
        ranges.push(braceEscape(c + "-"));
        i += 2;
        continue;
      }
      if (glob.startsWith("-", i + 1)) {
        rangeStart = c;
        i += 2;
        continue;
      }
      ranges.push(braceEscape(c));
      i++;
    }
  if (endPos < i) {
    return ["", false, 0, false];
  }
  if (!ranges.length && !negs.length) {
    return ["$.", false, glob.length - pos, true];
  }
  if (negs.length === 0 && ranges.length === 1 && /^\\?.$/.test(ranges[0]) && !negate) {
    const r = ranges[0].length === 2 ? ranges[0].slice(-1) : ranges[0];
    return [regexpEscape(r), false, endPos - pos, false];
  }
  const sranges = "[" + (negate ? "^" : "") + rangesToString(ranges) + "]";
  const snegs = "[" + (negate ? "" : "^") + rangesToString(negs) + "]";
  const comb = ranges.length && negs.length ? "(" + sranges + "|" + snegs + ")" : ranges.length ? sranges : snegs;
  return [comb, uflag, endPos - pos, true];
};

// node_modules/minimatch/dist/mjs/unescape.js
var unescape = (s, { windowsPathsNoEscape = false } = {}) => {
  return windowsPathsNoEscape ? s.replace(/\[([^\/\\])\]/g, "$1") : s.replace(/((?!\\).|^)\[([^\/\\])\]/g, "$1$2").replace(/\\([^\/])/g, "$1");
};

// node_modules/minimatch/dist/mjs/ast.js
var types = /* @__PURE__ */ new Set(["!", "?", "+", "*", "@"]);
var isExtglobType = (c) => types.has(c);
var startNoTraversal = "(?!(?:^|/)\\.\\.?(?:$|/))";
var startNoDot = "(?!\\.)";
var addPatternStart = /* @__PURE__ */ new Set(["[", "."]);
var justDots = /* @__PURE__ */ new Set(["..", "."]);
var reSpecials = new Set("().*{}+?[]^$\\!");
var regExpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
var qmark = "[^/]";
var star = qmark + "*?";
var starNoEmpty = qmark + "+?";
var _root, _hasMagic, _uflag, _parts, _parent, _parentIndex, _negs, _filledNegs, _options, _toString, _emptyExt, _fillNegs, fillNegs_fn, _parseAST, parseAST_fn, _partsToRegExp, partsToRegExp_fn, _parseGlob, parseGlob_fn;
var _AST = class {
  constructor(type, parent, options = {}) {
    __privateAdd(this, _fillNegs);
    __privateAdd(this, _partsToRegExp);
    __publicField(this, "type");
    __privateAdd(this, _root, void 0);
    __privateAdd(this, _hasMagic, void 0);
    __privateAdd(this, _uflag, false);
    __privateAdd(this, _parts, []);
    __privateAdd(this, _parent, void 0);
    __privateAdd(this, _parentIndex, void 0);
    __privateAdd(this, _negs, void 0);
    __privateAdd(this, _filledNegs, false);
    __privateAdd(this, _options, void 0);
    __privateAdd(this, _toString, void 0);
    __privateAdd(this, _emptyExt, false);
    this.type = type;
    if (type)
      __privateSet(this, _hasMagic, true);
    __privateSet(this, _parent, parent);
    __privateSet(this, _root, __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _root) : this);
    __privateSet(this, _options, __privateGet(this, _root) === this ? options : __privateGet(__privateGet(this, _root), _options));
    __privateSet(this, _negs, __privateGet(this, _root) === this ? [] : __privateGet(__privateGet(this, _root), _negs));
    if (type === "!" && !__privateGet(__privateGet(this, _root), _filledNegs))
      __privateGet(this, _negs).push(this);
    __privateSet(this, _parentIndex, __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _parts).length : 0);
  }
  get hasMagic() {
    if (__privateGet(this, _hasMagic) !== void 0)
      return __privateGet(this, _hasMagic);
    for (const p of __privateGet(this, _parts)) {
      if (typeof p === "string")
        continue;
      if (p.type || p.hasMagic)
        return __privateSet(this, _hasMagic, true);
    }
    return __privateGet(this, _hasMagic);
  }
  toString() {
    if (__privateGet(this, _toString) !== void 0)
      return __privateGet(this, _toString);
    if (!this.type) {
      return __privateSet(this, _toString, __privateGet(this, _parts).map((p) => String(p)).join(""));
    } else {
      return __privateSet(this, _toString, this.type + "(" + __privateGet(this, _parts).map((p) => String(p)).join("|") + ")");
    }
  }
  push(...parts) {
    for (const p of parts) {
      if (p === "")
        continue;
      if (typeof p !== "string" && !(p instanceof _AST && __privateGet(p, _parent) === this)) {
        throw new Error("invalid part: " + p);
      }
      __privateGet(this, _parts).push(p);
    }
  }
  toJSON() {
    const ret = this.type === null ? __privateGet(this, _parts).slice().map((p) => typeof p === "string" ? p : p.toJSON()) : [this.type, ...__privateGet(this, _parts).map((p) => p.toJSON())];
    if (this.isStart() && !this.type)
      ret.unshift([]);
    if (this.isEnd() && (this === __privateGet(this, _root) || __privateGet(__privateGet(this, _root), _filledNegs) && __privateGet(this, _parent)?.type === "!")) {
      ret.push({});
    }
    return ret;
  }
  isStart() {
    if (__privateGet(this, _root) === this)
      return true;
    if (!__privateGet(this, _parent)?.isStart())
      return false;
    if (__privateGet(this, _parentIndex) === 0)
      return true;
    const p = __privateGet(this, _parent);
    for (let i = 0; i < __privateGet(this, _parentIndex); i++) {
      const pp = __privateGet(p, _parts)[i];
      if (!(pp instanceof _AST && pp.type === "!")) {
        return false;
      }
    }
    return true;
  }
  isEnd() {
    if (__privateGet(this, _root) === this)
      return true;
    if (__privateGet(this, _parent)?.type === "!")
      return true;
    if (!__privateGet(this, _parent)?.isEnd())
      return false;
    if (!this.type)
      return __privateGet(this, _parent)?.isEnd();
    const pl = __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _parts).length : 0;
    return __privateGet(this, _parentIndex) === pl - 1;
  }
  copyIn(part) {
    if (typeof part === "string")
      this.push(part);
    else
      this.push(part.clone(this));
  }
  clone(parent) {
    const c = new _AST(this.type, parent);
    for (const p of __privateGet(this, _parts)) {
      c.copyIn(p);
    }
    return c;
  }
  static fromGlob(pattern, options = {}) {
    var _a2;
    const ast = new _AST(null, void 0, options);
    __privateMethod(_a2 = _AST, _parseAST, parseAST_fn).call(_a2, pattern, ast, 0, options);
    return ast;
  }
  toMMPattern() {
    if (this !== __privateGet(this, _root))
      return __privateGet(this, _root).toMMPattern();
    const glob = this.toString();
    const [re, body, hasMagic, uflag] = this.toRegExpSource();
    const anyMagic = hasMagic || __privateGet(this, _hasMagic) || __privateGet(this, _options).nocase && !__privateGet(this, _options).nocaseMagicOnly && glob.toUpperCase() !== glob.toLowerCase();
    if (!anyMagic) {
      return body;
    }
    const flags = (__privateGet(this, _options).nocase ? "i" : "") + (uflag ? "u" : "");
    return Object.assign(new RegExp(`^${re}$`, flags), {
      _src: re,
      _glob: glob
    });
  }
  toRegExpSource(allowDot) {
    const dot = allowDot ?? !!__privateGet(this, _options).dot;
    if (__privateGet(this, _root) === this)
      __privateMethod(this, _fillNegs, fillNegs_fn).call(this);
    if (!this.type) {
      const noEmpty = this.isStart() && this.isEnd();
      const src = __privateGet(this, _parts).map((p) => {
        var _a2;
        const [re, _, hasMagic, uflag] = typeof p === "string" ? __privateMethod(_a2 = _AST, _parseGlob, parseGlob_fn).call(_a2, p, __privateGet(this, _hasMagic), noEmpty) : p.toRegExpSource(allowDot);
        __privateSet(this, _hasMagic, __privateGet(this, _hasMagic) || hasMagic);
        __privateSet(this, _uflag, __privateGet(this, _uflag) || uflag);
        return re;
      }).join("");
      let start2 = "";
      if (this.isStart()) {
        if (typeof __privateGet(this, _parts)[0] === "string") {
          const dotTravAllowed = __privateGet(this, _parts).length === 1 && justDots.has(__privateGet(this, _parts)[0]);
          if (!dotTravAllowed) {
            const aps = addPatternStart;
            const needNoTrav = dot && aps.has(src.charAt(0)) || src.startsWith("\\.") && aps.has(src.charAt(2)) || src.startsWith("\\.\\.") && aps.has(src.charAt(4));
            const needNoDot = !dot && !allowDot && aps.has(src.charAt(0));
            start2 = needNoTrav ? startNoTraversal : needNoDot ? startNoDot : "";
          }
        }
      }
      let end = "";
      if (this.isEnd() && __privateGet(__privateGet(this, _root), _filledNegs) && __privateGet(this, _parent)?.type === "!") {
        end = "(?:$|\\/)";
      }
      const final2 = start2 + src + end;
      return [
        final2,
        unescape(src),
        __privateSet(this, _hasMagic, !!__privateGet(this, _hasMagic)),
        __privateGet(this, _uflag)
      ];
    }
    const repeated = this.type === "*" || this.type === "+";
    const start = this.type === "!" ? "(?:(?!(?:" : "(?:";
    let body = __privateMethod(this, _partsToRegExp, partsToRegExp_fn).call(this, dot);
    if (this.isStart() && this.isEnd() && !body && this.type !== "!") {
      const s = this.toString();
      __privateSet(this, _parts, [s]);
      this.type = null;
      __privateSet(this, _hasMagic, void 0);
      return [s, unescape(this.toString()), false, false];
    }
    let bodyDotAllowed = !repeated || allowDot || dot || !startNoDot ? "" : __privateMethod(this, _partsToRegExp, partsToRegExp_fn).call(this, true);
    if (bodyDotAllowed === body) {
      bodyDotAllowed = "";
    }
    if (bodyDotAllowed) {
      body = `(?:${body})(?:${bodyDotAllowed})*?`;
    }
    let final = "";
    if (this.type === "!" && __privateGet(this, _emptyExt)) {
      final = (this.isStart() && !dot ? startNoDot : "") + starNoEmpty;
    } else {
      const close = this.type === "!" ? "))" + (this.isStart() && !dot && !allowDot ? startNoDot : "") + star + ")" : this.type === "@" ? ")" : this.type === "?" ? ")?" : this.type === "+" && bodyDotAllowed ? ")" : this.type === "*" && bodyDotAllowed ? `)?` : `)${this.type}`;
      final = start + body + close;
    }
    return [
      final,
      unescape(body),
      __privateSet(this, _hasMagic, !!__privateGet(this, _hasMagic)),
      __privateGet(this, _uflag)
    ];
  }
};
var AST = _AST;
_root = new WeakMap();
_hasMagic = new WeakMap();
_uflag = new WeakMap();
_parts = new WeakMap();
_parent = new WeakMap();
_parentIndex = new WeakMap();
_negs = new WeakMap();
_filledNegs = new WeakMap();
_options = new WeakMap();
_toString = new WeakMap();
_emptyExt = new WeakMap();
_fillNegs = new WeakSet();
fillNegs_fn = function() {
  if (this !== __privateGet(this, _root))
    throw new Error("should only call on root");
  if (__privateGet(this, _filledNegs))
    return this;
  this.toString();
  __privateSet(this, _filledNegs, true);
  let n;
  while (n = __privateGet(this, _negs).pop()) {
    if (n.type !== "!")
      continue;
    let p = n;
    let pp = __privateGet(p, _parent);
    while (pp) {
      for (let i = __privateGet(p, _parentIndex) + 1; !pp.type && i < __privateGet(pp, _parts).length; i++) {
        for (const part of __privateGet(n, _parts)) {
          if (typeof part === "string") {
            throw new Error("string part in extglob AST??");
          }
          part.copyIn(__privateGet(pp, _parts)[i]);
        }
      }
      p = pp;
      pp = __privateGet(p, _parent);
    }
  }
  return this;
};
_parseAST = new WeakSet();
parseAST_fn = function(str, ast, pos, opt) {
  var _a2, _b;
  let escaping = false;
  let inBrace = false;
  let braceStart = -1;
  let braceNeg = false;
  if (ast.type === null) {
    let i2 = pos;
    let acc2 = "";
    while (i2 < str.length) {
      const c = str.charAt(i2++);
      if (escaping || c === "\\") {
        escaping = !escaping;
        acc2 += c;
        continue;
      }
      if (inBrace) {
        if (i2 === braceStart + 1) {
          if (c === "^" || c === "!") {
            braceNeg = true;
          }
        } else if (c === "]" && !(i2 === braceStart + 2 && braceNeg)) {
          inBrace = false;
        }
        acc2 += c;
        continue;
      } else if (c === "[") {
        inBrace = true;
        braceStart = i2;
        braceNeg = false;
        acc2 += c;
        continue;
      }
      if (!opt.noext && isExtglobType(c) && str.charAt(i2) === "(") {
        ast.push(acc2);
        acc2 = "";
        const ext2 = new _AST(c, ast);
        i2 = __privateMethod(_a2 = _AST, _parseAST, parseAST_fn).call(_a2, str, ext2, i2, opt);
        ast.push(ext2);
        continue;
      }
      acc2 += c;
    }
    ast.push(acc2);
    return i2;
  }
  let i = pos + 1;
  let part = new _AST(null, ast);
  const parts = [];
  let acc = "";
  while (i < str.length) {
    const c = str.charAt(i++);
    if (escaping || c === "\\") {
      escaping = !escaping;
      acc += c;
      continue;
    }
    if (inBrace) {
      if (i === braceStart + 1) {
        if (c === "^" || c === "!") {
          braceNeg = true;
        }
      } else if (c === "]" && !(i === braceStart + 2 && braceNeg)) {
        inBrace = false;
      }
      acc += c;
      continue;
    } else if (c === "[") {
      inBrace = true;
      braceStart = i;
      braceNeg = false;
      acc += c;
      continue;
    }
    if (isExtglobType(c) && str.charAt(i) === "(") {
      part.push(acc);
      acc = "";
      const ext2 = new _AST(c, part);
      part.push(ext2);
      i = __privateMethod(_b = _AST, _parseAST, parseAST_fn).call(_b, str, ext2, i, opt);
      continue;
    }
    if (c === "|") {
      part.push(acc);
      acc = "";
      parts.push(part);
      part = new _AST(null, ast);
      continue;
    }
    if (c === ")") {
      if (acc === "" && __privateGet(ast, _parts).length === 0) {
        __privateSet(ast, _emptyExt, true);
      }
      part.push(acc);
      acc = "";
      ast.push(...parts, part);
      return i;
    }
    acc += c;
  }
  ast.type = null;
  __privateSet(ast, _hasMagic, void 0);
  __privateSet(ast, _parts, [str.substring(pos - 1)]);
  return i;
};
_partsToRegExp = new WeakSet();
partsToRegExp_fn = function(dot) {
  return __privateGet(this, _parts).map((p) => {
    if (typeof p === "string") {
      throw new Error("string type in extglob ast??");
    }
    const [re, _, _hasMagic2, uflag] = p.toRegExpSource(dot);
    __privateSet(this, _uflag, __privateGet(this, _uflag) || uflag);
    return re;
  }).filter((p) => !(this.isStart() && this.isEnd()) || !!p).join("|");
};
_parseGlob = new WeakSet();
parseGlob_fn = function(glob, hasMagic, noEmpty = false) {
  let escaping = false;
  let re = "";
  let uflag = false;
  for (let i = 0; i < glob.length; i++) {
    const c = glob.charAt(i);
    if (escaping) {
      escaping = false;
      re += (reSpecials.has(c) ? "\\" : "") + c;
      continue;
    }
    if (c === "\\") {
      if (i === glob.length - 1) {
        re += "\\\\";
      } else {
        escaping = true;
      }
      continue;
    }
    if (c === "[") {
      const [src, needUflag, consumed, magic] = parseClass(glob, i);
      if (consumed) {
        re += src;
        uflag = uflag || needUflag;
        i += consumed - 1;
        hasMagic = hasMagic || magic;
        continue;
      }
    }
    if (c === "*") {
      if (noEmpty && glob === "*")
        re += starNoEmpty;
      else
        re += star;
      hasMagic = true;
      continue;
    }
    if (c === "?") {
      re += qmark;
      hasMagic = true;
      continue;
    }
    re += regExpEscape(c);
  }
  return [re, unescape(glob), !!hasMagic, uflag];
};
__privateAdd(AST, _parseAST);
__privateAdd(AST, _parseGlob);

// node_modules/minimatch/dist/mjs/escape.js
var escape = (s, { windowsPathsNoEscape = false } = {}) => {
  return windowsPathsNoEscape ? s.replace(/[?*()[\]]/g, "[$&]") : s.replace(/[?*()[\]\\]/g, "\\$&");
};

// node_modules/minimatch/dist/mjs/index.js
var minimatch = (p, pattern, options = {}) => {
  assertValidPattern(pattern);
  if (!options.nocomment && pattern.charAt(0) === "#") {
    return false;
  }
  return new Minimatch(pattern, options).match(p);
};
var starDotExtRE = /^\*+([^+@!?\*\[\(]*)$/;
var starDotExtTest = (ext2) => (f) => !f.startsWith(".") && f.endsWith(ext2);
var starDotExtTestDot = (ext2) => (f) => f.endsWith(ext2);
var starDotExtTestNocase = (ext2) => {
  ext2 = ext2.toLowerCase();
  return (f) => !f.startsWith(".") && f.toLowerCase().endsWith(ext2);
};
var starDotExtTestNocaseDot = (ext2) => {
  ext2 = ext2.toLowerCase();
  return (f) => f.toLowerCase().endsWith(ext2);
};
var starDotStarRE = /^\*+\.\*+$/;
var starDotStarTest = (f) => !f.startsWith(".") && f.includes(".");
var starDotStarTestDot = (f) => f !== "." && f !== ".." && f.includes(".");
var dotStarRE = /^\.\*+$/;
var dotStarTest = (f) => f !== "." && f !== ".." && f.startsWith(".");
var starRE = /^\*+$/;
var starTest = (f) => f.length !== 0 && !f.startsWith(".");
var starTestDot = (f) => f.length !== 0 && f !== "." && f !== "..";
var qmarksRE = /^\?+([^+@!?\*\[\(]*)?$/;
var qmarksTestNocase = ([$0, ext2 = ""]) => {
  const noext = qmarksTestNoExt([$0]);
  if (!ext2)
    return noext;
  ext2 = ext2.toLowerCase();
  return (f) => noext(f) && f.toLowerCase().endsWith(ext2);
};
var qmarksTestNocaseDot = ([$0, ext2 = ""]) => {
  const noext = qmarksTestNoExtDot([$0]);
  if (!ext2)
    return noext;
  ext2 = ext2.toLowerCase();
  return (f) => noext(f) && f.toLowerCase().endsWith(ext2);
};
var qmarksTestDot = ([$0, ext2 = ""]) => {
  const noext = qmarksTestNoExtDot([$0]);
  return !ext2 ? noext : (f) => noext(f) && f.endsWith(ext2);
};
var qmarksTest = ([$0, ext2 = ""]) => {
  const noext = qmarksTestNoExt([$0]);
  return !ext2 ? noext : (f) => noext(f) && f.endsWith(ext2);
};
var qmarksTestNoExt = ([$0]) => {
  const len = $0.length;
  return (f) => f.length === len && !f.startsWith(".");
};
var qmarksTestNoExtDot = ([$0]) => {
  const len = $0.length;
  return (f) => f.length === len && f !== "." && f !== "..";
};
var defaultPlatform = typeof process === "object" && process ? typeof process.env === "object" && process.env && process.env.__MINIMATCH_TESTING_PLATFORM__ || process.platform : "posix";
var path = {
  win32: { sep: "\\" },
  posix: { sep: "/" }
};
var sep = defaultPlatform === "win32" ? path.win32.sep : path.posix.sep;
minimatch.sep = sep;
var GLOBSTAR = Symbol("globstar **");
minimatch.GLOBSTAR = GLOBSTAR;
var qmark2 = "[^/]";
var star2 = qmark2 + "*?";
var twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
var twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
var filter = (pattern, options = {}) => (p) => minimatch(p, pattern, options);
minimatch.filter = filter;
var ext = (a, b = {}) => Object.assign({}, a, b);
var defaults = (def) => {
  if (!def || typeof def !== "object" || !Object.keys(def).length) {
    return minimatch;
  }
  const orig = minimatch;
  const m = (p, pattern, options = {}) => orig(p, pattern, ext(def, options));
  return Object.assign(m, {
    Minimatch: class Minimatch extends orig.Minimatch {
      constructor(pattern, options = {}) {
        super(pattern, ext(def, options));
      }
      static defaults(options) {
        return orig.defaults(ext(def, options)).Minimatch;
      }
    },
    AST: class AST extends orig.AST {
      constructor(type, parent, options = {}) {
        super(type, parent, ext(def, options));
      }
      static fromGlob(pattern, options = {}) {
        return orig.AST.fromGlob(pattern, ext(def, options));
      }
    },
    unescape: (s, options = {}) => orig.unescape(s, ext(def, options)),
    escape: (s, options = {}) => orig.escape(s, ext(def, options)),
    filter: (pattern, options = {}) => orig.filter(pattern, ext(def, options)),
    defaults: (options) => orig.defaults(ext(def, options)),
    makeRe: (pattern, options = {}) => orig.makeRe(pattern, ext(def, options)),
    braceExpand: (pattern, options = {}) => orig.braceExpand(pattern, ext(def, options)),
    match: (list, pattern, options = {}) => orig.match(list, pattern, ext(def, options)),
    sep: orig.sep,
    GLOBSTAR
  });
};
minimatch.defaults = defaults;
var braceExpand = (pattern, options = {}) => {
  assertValidPattern(pattern);
  if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
    return [pattern];
  }
  return (0, import_brace_expansion.default)(pattern);
};
minimatch.braceExpand = braceExpand;
var makeRe = (pattern, options = {}) => new Minimatch(pattern, options).makeRe();
minimatch.makeRe = makeRe;
var match = (list, pattern, options = {}) => {
  const mm = new Minimatch(pattern, options);
  list = list.filter((f) => mm.match(f));
  if (mm.options.nonull && !list.length) {
    list.push(pattern);
  }
  return list;
};
minimatch.match = match;
var globMagic = /[?*]|[+@!]\(.*?\)|\[|\]/;
var regExpEscape2 = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
var Minimatch = class {
  options;
  set;
  pattern;
  windowsPathsNoEscape;
  nonegate;
  negate;
  comment;
  empty;
  preserveMultipleSlashes;
  partial;
  globSet;
  globParts;
  nocase;
  isWindows;
  platform;
  windowsNoMagicRoot;
  regexp;
  constructor(pattern, options = {}) {
    assertValidPattern(pattern);
    options = options || {};
    this.options = options;
    this.pattern = pattern;
    this.platform = options.platform || defaultPlatform;
    this.isWindows = this.platform === "win32";
    this.windowsPathsNoEscape = !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
    if (this.windowsPathsNoEscape) {
      this.pattern = this.pattern.replace(/\\/g, "/");
    }
    this.preserveMultipleSlashes = !!options.preserveMultipleSlashes;
    this.regexp = null;
    this.negate = false;
    this.nonegate = !!options.nonegate;
    this.comment = false;
    this.empty = false;
    this.partial = !!options.partial;
    this.nocase = !!this.options.nocase;
    this.windowsNoMagicRoot = options.windowsNoMagicRoot !== void 0 ? options.windowsNoMagicRoot : !!(this.isWindows && this.nocase);
    this.globSet = [];
    this.globParts = [];
    this.set = [];
    this.make();
  }
  hasMagic() {
    if (this.options.magicalBraces && this.set.length > 1) {
      return true;
    }
    for (const pattern of this.set) {
      for (const part of pattern) {
        if (typeof part !== "string")
          return true;
      }
    }
    return false;
  }
  debug(..._) {
  }
  make() {
    const pattern = this.pattern;
    const options = this.options;
    if (!options.nocomment && pattern.charAt(0) === "#") {
      this.comment = true;
      return;
    }
    if (!pattern) {
      this.empty = true;
      return;
    }
    this.parseNegate();
    this.globSet = [...new Set(this.braceExpand())];
    if (options.debug) {
      this.debug = (...args) => console.error(...args);
    }
    this.debug(this.pattern, this.globSet);
    const rawGlobParts = this.globSet.map((s) => this.slashSplit(s));
    this.globParts = this.preprocess(rawGlobParts);
    this.debug(this.pattern, this.globParts);
    let set = this.globParts.map((s, _, __) => {
      if (this.isWindows && this.windowsNoMagicRoot) {
        const isUNC = s[0] === "" && s[1] === "" && (s[2] === "?" || !globMagic.test(s[2])) && !globMagic.test(s[3]);
        const isDrive = /^[a-z]:/i.test(s[0]);
        if (isUNC) {
          return [...s.slice(0, 4), ...s.slice(4).map((ss) => this.parse(ss))];
        } else if (isDrive) {
          return [s[0], ...s.slice(1).map((ss) => this.parse(ss))];
        }
      }
      return s.map((ss) => this.parse(ss));
    });
    this.debug(this.pattern, set);
    this.set = set.filter((s) => s.indexOf(false) === -1);
    if (this.isWindows) {
      for (let i = 0; i < this.set.length; i++) {
        const p = this.set[i];
        if (p[0] === "" && p[1] === "" && this.globParts[i][2] === "?" && typeof p[3] === "string" && /^[a-z]:$/i.test(p[3])) {
          p[2] = "?";
        }
      }
    }
    this.debug(this.pattern, this.set);
  }
  preprocess(globParts) {
    if (this.options.noglobstar) {
      for (let i = 0; i < globParts.length; i++) {
        for (let j = 0; j < globParts[i].length; j++) {
          if (globParts[i][j] === "**") {
            globParts[i][j] = "*";
          }
        }
      }
    }
    const { optimizationLevel = 1 } = this.options;
    if (optimizationLevel >= 2) {
      globParts = this.firstPhasePreProcess(globParts);
      globParts = this.secondPhasePreProcess(globParts);
    } else if (optimizationLevel >= 1) {
      globParts = this.levelOneOptimize(globParts);
    } else {
      globParts = this.adjascentGlobstarOptimize(globParts);
    }
    return globParts;
  }
  adjascentGlobstarOptimize(globParts) {
    return globParts.map((parts) => {
      let gs = -1;
      while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
        let i = gs;
        while (parts[i + 1] === "**") {
          i++;
        }
        if (i !== gs) {
          parts.splice(gs, i - gs);
        }
      }
      return parts;
    });
  }
  levelOneOptimize(globParts) {
    return globParts.map((parts) => {
      parts = parts.reduce((set, part) => {
        const prev = set[set.length - 1];
        if (part === "**" && prev === "**") {
          return set;
        }
        if (part === "..") {
          if (prev && prev !== ".." && prev !== "." && prev !== "**") {
            set.pop();
            return set;
          }
        }
        set.push(part);
        return set;
      }, []);
      return parts.length === 0 ? [""] : parts;
    });
  }
  levelTwoFileOptimize(parts) {
    if (!Array.isArray(parts)) {
      parts = this.slashSplit(parts);
    }
    let didSomething = false;
    do {
      didSomething = false;
      if (!this.preserveMultipleSlashes) {
        for (let i = 1; i < parts.length - 1; i++) {
          const p = parts[i];
          if (i === 1 && p === "" && parts[0] === "")
            continue;
          if (p === "." || p === "") {
            didSomething = true;
            parts.splice(i, 1);
            i--;
          }
        }
        if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
          didSomething = true;
          parts.pop();
        }
      }
      let dd = 0;
      while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
        const p = parts[dd - 1];
        if (p && p !== "." && p !== ".." && p !== "**") {
          didSomething = true;
          parts.splice(dd - 1, 2);
          dd -= 2;
        }
      }
    } while (didSomething);
    return parts.length === 0 ? [""] : parts;
  }
  firstPhasePreProcess(globParts) {
    let didSomething = false;
    do {
      didSomething = false;
      for (let parts of globParts) {
        let gs = -1;
        while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
          let gss = gs;
          while (parts[gss + 1] === "**") {
            gss++;
          }
          if (gss > gs) {
            parts.splice(gs + 1, gss - gs);
          }
          let next = parts[gs + 1];
          const p = parts[gs + 2];
          const p2 = parts[gs + 3];
          if (next !== "..")
            continue;
          if (!p || p === "." || p === ".." || !p2 || p2 === "." || p2 === "..") {
            continue;
          }
          didSomething = true;
          parts.splice(gs, 1);
          const other = parts.slice(0);
          other[gs] = "**";
          globParts.push(other);
          gs--;
        }
        if (!this.preserveMultipleSlashes) {
          for (let i = 1; i < parts.length - 1; i++) {
            const p = parts[i];
            if (i === 1 && p === "" && parts[0] === "")
              continue;
            if (p === "." || p === "") {
              didSomething = true;
              parts.splice(i, 1);
              i--;
            }
          }
          if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
            didSomething = true;
            parts.pop();
          }
        }
        let dd = 0;
        while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
          const p = parts[dd - 1];
          if (p && p !== "." && p !== ".." && p !== "**") {
            didSomething = true;
            const needDot = dd === 1 && parts[dd + 1] === "**";
            const splin = needDot ? ["."] : [];
            parts.splice(dd - 1, 2, ...splin);
            if (parts.length === 0)
              parts.push("");
            dd -= 2;
          }
        }
      }
    } while (didSomething);
    return globParts;
  }
  secondPhasePreProcess(globParts) {
    for (let i = 0; i < globParts.length - 1; i++) {
      for (let j = i + 1; j < globParts.length; j++) {
        const matched = this.partsMatch(globParts[i], globParts[j], !this.preserveMultipleSlashes);
        if (!matched)
          continue;
        globParts[i] = matched;
        globParts[j] = [];
      }
    }
    return globParts.filter((gs) => gs.length);
  }
  partsMatch(a, b, emptyGSMatch = false) {
    let ai = 0;
    let bi = 0;
    let result = [];
    let which = "";
    while (ai < a.length && bi < b.length) {
      if (a[ai] === b[bi]) {
        result.push(which === "b" ? b[bi] : a[ai]);
        ai++;
        bi++;
      } else if (emptyGSMatch && a[ai] === "**" && b[bi] === a[ai + 1]) {
        result.push(a[ai]);
        ai++;
      } else if (emptyGSMatch && b[bi] === "**" && a[ai] === b[bi + 1]) {
        result.push(b[bi]);
        bi++;
      } else if (a[ai] === "*" && b[bi] && (this.options.dot || !b[bi].startsWith(".")) && b[bi] !== "**") {
        if (which === "b")
          return false;
        which = "a";
        result.push(a[ai]);
        ai++;
        bi++;
      } else if (b[bi] === "*" && a[ai] && (this.options.dot || !a[ai].startsWith(".")) && a[ai] !== "**") {
        if (which === "a")
          return false;
        which = "b";
        result.push(b[bi]);
        ai++;
        bi++;
      } else {
        return false;
      }
    }
    return a.length === b.length && result;
  }
  parseNegate() {
    if (this.nonegate)
      return;
    const pattern = this.pattern;
    let negate = false;
    let negateOffset = 0;
    for (let i = 0; i < pattern.length && pattern.charAt(i) === "!"; i++) {
      negate = !negate;
      negateOffset++;
    }
    if (negateOffset)
      this.pattern = pattern.slice(negateOffset);
    this.negate = negate;
  }
  matchOne(file, pattern, partial = false) {
    const options = this.options;
    if (this.isWindows) {
      const fileDrive = typeof file[0] === "string" && /^[a-z]:$/i.test(file[0]);
      const fileUNC = !fileDrive && file[0] === "" && file[1] === "" && file[2] === "?" && /^[a-z]:$/i.test(file[3]);
      const patternDrive = typeof pattern[0] === "string" && /^[a-z]:$/i.test(pattern[0]);
      const patternUNC = !patternDrive && pattern[0] === "" && pattern[1] === "" && pattern[2] === "?" && typeof pattern[3] === "string" && /^[a-z]:$/i.test(pattern[3]);
      const fdi = fileUNC ? 3 : fileDrive ? 0 : void 0;
      const pdi = patternUNC ? 3 : patternDrive ? 0 : void 0;
      if (typeof fdi === "number" && typeof pdi === "number") {
        const [fd, pd] = [file[fdi], pattern[pdi]];
        if (fd.toLowerCase() === pd.toLowerCase()) {
          pattern[pdi] = fd;
          if (pdi > fdi) {
            pattern = pattern.slice(pdi);
          } else if (fdi > pdi) {
            file = file.slice(fdi);
          }
        }
      }
    }
    const { optimizationLevel = 1 } = this.options;
    if (optimizationLevel >= 2) {
      file = this.levelTwoFileOptimize(file);
    }
    this.debug("matchOne", this, { file, pattern });
    this.debug("matchOne", file.length, pattern.length);
    for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
      this.debug("matchOne loop");
      var p = pattern[pi];
      var f = file[fi];
      this.debug(pattern, p, f);
      if (p === false) {
        return false;
      }
      if (p === GLOBSTAR) {
        this.debug("GLOBSTAR", [pattern, p, f]);
        var fr = fi;
        var pr = pi + 1;
        if (pr === pl) {
          this.debug("** at the end");
          for (; fi < fl; fi++) {
            if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".")
              return false;
          }
          return true;
        }
        while (fr < fl) {
          var swallowee = file[fr];
          this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
          if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
            this.debug("globstar found match!", fr, fl, swallowee);
            return true;
          } else {
            if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
              this.debug("dot detected!", file, fr, pattern, pr);
              break;
            }
            this.debug("globstar swallow a segment, and continue");
            fr++;
          }
        }
        if (partial) {
          this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
          if (fr === fl) {
            return true;
          }
        }
        return false;
      }
      let hit;
      if (typeof p === "string") {
        hit = f === p;
        this.debug("string match", p, f, hit);
      } else {
        hit = p.test(f);
        this.debug("pattern match", p, f, hit);
      }
      if (!hit)
        return false;
    }
    if (fi === fl && pi === pl) {
      return true;
    } else if (fi === fl) {
      return partial;
    } else if (pi === pl) {
      return fi === fl - 1 && file[fi] === "";
    } else {
      throw new Error("wtf?");
    }
  }
  braceExpand() {
    return braceExpand(this.pattern, this.options);
  }
  parse(pattern) {
    assertValidPattern(pattern);
    const options = this.options;
    if (pattern === "**")
      return GLOBSTAR;
    if (pattern === "")
      return "";
    let m;
    let fastTest = null;
    if (m = pattern.match(starRE)) {
      fastTest = options.dot ? starTestDot : starTest;
    } else if (m = pattern.match(starDotExtRE)) {
      fastTest = (options.nocase ? options.dot ? starDotExtTestNocaseDot : starDotExtTestNocase : options.dot ? starDotExtTestDot : starDotExtTest)(m[1]);
    } else if (m = pattern.match(qmarksRE)) {
      fastTest = (options.nocase ? options.dot ? qmarksTestNocaseDot : qmarksTestNocase : options.dot ? qmarksTestDot : qmarksTest)(m);
    } else if (m = pattern.match(starDotStarRE)) {
      fastTest = options.dot ? starDotStarTestDot : starDotStarTest;
    } else if (m = pattern.match(dotStarRE)) {
      fastTest = dotStarTest;
    }
    const re = AST.fromGlob(pattern, this.options).toMMPattern();
    return fastTest ? Object.assign(re, { test: fastTest }) : re;
  }
  makeRe() {
    if (this.regexp || this.regexp === false)
      return this.regexp;
    const set = this.set;
    if (!set.length) {
      this.regexp = false;
      return this.regexp;
    }
    const options = this.options;
    const twoStar = options.noglobstar ? star2 : options.dot ? twoStarDot : twoStarNoDot;
    const flags = new Set(options.nocase ? ["i"] : []);
    let re = set.map((pattern) => {
      const pp = pattern.map((p) => {
        if (p instanceof RegExp) {
          for (const f of p.flags.split(""))
            flags.add(f);
        }
        return typeof p === "string" ? regExpEscape2(p) : p === GLOBSTAR ? GLOBSTAR : p._src;
      });
      pp.forEach((p, i) => {
        const next = pp[i + 1];
        const prev = pp[i - 1];
        if (p !== GLOBSTAR || prev === GLOBSTAR) {
          return;
        }
        if (prev === void 0) {
          if (next !== void 0 && next !== GLOBSTAR) {
            pp[i + 1] = "(?:\\/|" + twoStar + "\\/)?" + next;
          } else {
            pp[i] = twoStar;
          }
        } else if (next === void 0) {
          pp[i - 1] = prev + "(?:\\/|" + twoStar + ")?";
        } else if (next !== GLOBSTAR) {
          pp[i - 1] = prev + "(?:\\/|\\/" + twoStar + "\\/)" + next;
          pp[i + 1] = GLOBSTAR;
        }
      });
      return pp.filter((p) => p !== GLOBSTAR).join("/");
    }).join("|");
    const [open2, close] = set.length > 1 ? ["(?:", ")"] : ["", ""];
    re = "^" + open2 + re + close + "$";
    if (this.negate)
      re = "^(?!" + re + ").+$";
    try {
      this.regexp = new RegExp(re, [...flags].join(""));
    } catch (ex) {
      this.regexp = false;
    }
    return this.regexp;
  }
  slashSplit(p) {
    if (this.preserveMultipleSlashes) {
      return p.split("/");
    } else if (this.isWindows && /^\/\/[^\/]+/.test(p)) {
      return ["", ...p.split(/\/+/)];
    } else {
      return p.split(/\/+/);
    }
  }
  match(f, partial = this.partial) {
    this.debug("match", f, this.pattern);
    if (this.comment) {
      return false;
    }
    if (this.empty) {
      return f === "";
    }
    if (f === "/" && partial) {
      return true;
    }
    const options = this.options;
    if (this.isWindows) {
      f = f.split("\\").join("/");
    }
    const ff = this.slashSplit(f);
    this.debug(this.pattern, "split", ff);
    const set = this.set;
    this.debug(this.pattern, "set", set);
    let filename = ff[ff.length - 1];
    if (!filename) {
      for (let i = ff.length - 2; !filename && i >= 0; i--) {
        filename = ff[i];
      }
    }
    for (let i = 0; i < set.length; i++) {
      const pattern = set[i];
      let file = ff;
      if (options.matchBase && pattern.length === 1) {
        file = [filename];
      }
      const hit = this.matchOne(file, pattern, partial);
      if (hit) {
        if (options.flipNegate) {
          return true;
        }
        return !this.negate;
      }
    }
    if (options.flipNegate) {
      return false;
    }
    return this.negate;
  }
  static defaults(def) {
    return minimatch.defaults(def).Minimatch;
  }
};
minimatch.AST = AST;
minimatch.Minimatch = Minimatch;
minimatch.escape = escape;
minimatch.unescape = unescape;

// src/polyfills/node-minimatch.ts
function matches(text, pattern) {
  return minimatch(text, pattern);
}

// src/http-context.ts
var HttpContext = class {
  constructor(_fetch, allowedHosts, memoryOptions, allowResponseHeaders) {
    this.fetch = _fetch;
    this.allowedHosts = allowedHosts;
    this.lastStatusCode = 0;
    this.memoryOptions = memoryOptions;
    this.lastHeaders = allowResponseHeaders ? {} : null;
  }
  contribute(functions) {
    functions[EXTISM_ENV] ??= {};
    functions[EXTISM_ENV].http_request = (callContext, reqaddr, bodyaddr) => this.makeRequest(callContext, reqaddr, bodyaddr);
    functions[EXTISM_ENV].http_status_code = () => this.lastStatusCode;
    functions[EXTISM_ENV].http_headers = (callContext) => {
      if (this.lastHeaders === null) {
        return 0n;
      }
      return callContext.store(JSON.stringify(this.lastHeaders));
    };
  }
  async makeRequest(callContext, reqaddr, bodyaddr) {
    if (this.lastHeaders !== null) {
      this.lastHeaders = {};
    }
    this.lastStatusCode = 0;
    const req = callContext.read(reqaddr);
    if (req === null) {
      return 0n;
    }
    const { headers, header, url: rawUrl, method: m } = req.json();
    const method = m?.toUpperCase() ?? "GET";
    const url = new URL(rawUrl);
    const isAllowed = this.allowedHosts.some((allowedHost) => {
      return allowedHost === url.hostname || matches(url.hostname, allowedHost);
    });
    if (!isAllowed) {
      throw new Error(`Call error: HTTP request to "${url}" is not allowed (no allowedHosts match "${url.hostname}")`);
    }
    const body = bodyaddr === 0n || method === "GET" || method === "HEAD" ? null : callContext.read(bodyaddr)?.bytes();
    const fetch2 = this.fetch;
    const response = await fetch2(rawUrl, {
      headers: headers || header,
      method,
      ...body ? { body: body.slice() } : {}
    });
    this.lastStatusCode = response.status;
    if (this.lastHeaders !== null) {
      this.lastHeaders = Object.fromEntries(response.headers);
    }
    try {
      const bytes = this.memoryOptions.maxHttpResponseBytes ? await readBodyUpTo(response, this.memoryOptions.maxHttpResponseBytes) : new Uint8Array(await response.arrayBuffer());
      const result = callContext.store(bytes);
      return result;
    } catch (err) {
      if (err instanceof Error) {
        const ptr = callContext.store(new TextEncoder().encode(err.message));
        callContext[ENV].log_error(ptr);
        return 0n;
      }
      return 0n;
    }
  }
};
async function readBodyUpTo(response, maxBytes) {
  const reader = response.body?.getReader();
  if (!reader) {
    return new Uint8Array(0);
  }
  let receivedLength = 0;
  const chunks = [];
  while (receivedLength < maxBytes) {
    const { done, value } = await reader.read();
    if (done) {
      break;
    }
    chunks.push(value);
    receivedLength += value.length;
    if (receivedLength >= maxBytes) {
      throw new Error(`Response body exceeded ${maxBytes} bytes`);
    }
  }
  const limitedResponseBody = new Uint8Array(receivedLength);
  let position = 0;
  for (const chunk of chunks) {
    limitedResponseBody.set(chunk, position);
    position += chunk.length;
  }
  return limitedResponseBody;
}

// src/foreground-plugin.ts
var EXTISM_ENV = "extism:host/env";
var AsyncFunction = (async () => {
}).constructor;
var Suspending = WebAssembly.Suspending;
var promising = WebAssembly.promising;
var ForegroundPlugin = class {
  #context;
  #instancePair;
  #active = false;
  #wasi;
  #opts;
  #suspendsOnInvoke;
  constructor(opts, context, instancePair, wasi, suspendsOnInvoke) {
    this.#context = context;
    this.#instancePair = instancePair;
    this.#wasi = wasi;
    this.#opts = opts;
    this.#suspendsOnInvoke = suspendsOnInvoke;
  }
  async reset() {
    if (this.isActive()) {
      return false;
    }
    this.#context[RESET]();
    return true;
  }
  isActive() {
    return this.#active;
  }
  async functionExists(funcName) {
    return typeof this.#instancePair[1].exports[funcName] === "function";
  }
  async callBlock(funcName, input) {
    this.#active = true;
    const func = this.#instancePair[1].exports[funcName];
    if (!func) {
      throw Error(`Plugin error: function "${funcName}" does not exist`);
    }
    if (typeof func !== "function") {
      throw Error(`Plugin error: export "${funcName}" is not a function`);
    }
    this.#context[BEGIN](input ?? null);
    try {
      this.#suspendsOnInvoke ? await promising(func)() : func();
      return this.#context[END]();
    } catch (err) {
      this.#context[END]();
      throw err;
    } finally {
      this.#active = false;
    }
  }
  async call(funcName, input, hostContext) {
    this.#context[RESET]();
    const inputIdx = this.#context[STORE](input);
    this.#context[SET_HOST_CONTEXT](hostContext);
    const [errorIdx, outputIdx] = await this.callBlock(funcName, inputIdx);
    const shouldThrow = errorIdx !== null;
    const idx = errorIdx ?? outputIdx;
    if (idx === null) {
      return null;
    }
    const block = this.#context[GET_BLOCK](idx);
    if (!block) {
      return null;
    }
    const output = new PluginOutput(block.buffer);
    if (shouldThrow) {
      throw new Error(`Plugin-originated error: ${output.string()}`);
    }
    return output;
  }
  async getExports() {
    return WebAssembly.Module.exports(this.#instancePair[0]) || [];
  }
  async getImports() {
    return WebAssembly.Module.imports(this.#instancePair[0]) || [];
  }
  async getInstance() {
    return this.#instancePair[1];
  }
  async close() {
    await Promise.all(this.#wasi.map((xs) => xs.close()));
    this.#wasi.length = 0;
  }
};
async function createForegroundPlugin(opts, names, modules, context = new CallContext(ArrayBuffer, opts.logger, opts.logLevel, opts.config, opts.memory)) {
  const imports = {
    [EXTISM_ENV]: context[ENV],
    env: {}
  };
  let suspendsOnInvoke = false;
  for (const namespace in opts.functions) {
    imports[namespace] = imports[namespace] || {};
    for (const [name, func] of Object.entries(opts.functions[namespace])) {
      const isAsync = func.constructor === AsyncFunction;
      suspendsOnInvoke ||= isAsync;
      const wrapped = func.bind(null, context);
      imports[namespace][name] = isAsync ? new Suspending(wrapped) : wrapped;
    }
  }
  if (suspendsOnInvoke && (!Suspending || !promising)) {
    throw new TypeError(
      "This platform does not support async function imports on the main thread; consider using `runInWorker`."
    );
  }
  const mainIndex = names.indexOf("main");
  if (mainIndex === -1) {
    throw new Error('Unreachable: manifests must have at least one "main" module. Enforced by "src/manifest.ts")');
  }
  const seen = /* @__PURE__ */ new Map();
  const wasiList = [];
  const mutableFlags = { suspendsOnInvoke };
  const instance = await instantiateModule(
    context,
    ["main"],
    modules[mainIndex],
    imports,
    opts,
    wasiList,
    names,
    modules,
    seen,
    mutableFlags
  );
  return new ForegroundPlugin(opts, context, [modules[mainIndex], instance], wasiList, mutableFlags.suspendsOnInvoke);
}
async function instantiateModule(context, current, module, imports, opts, wasiList, names, modules, linked, mutableFlags) {
  linked.set(module, null);
  const instantiationImports = {};
  const requested = WebAssembly.Module.imports(module);
  let wasi = null;
  for (const { kind, module: module2, name } of requested) {
    const nameIdx = names.indexOf(module2);
    if (nameIdx === -1) {
      if (module2 === "wasi_snapshot_preview1" && wasi === null) {
        if (!CAPABILITIES.supportsWasiPreview1) {
          throw new Error("WASI is not supported on this platform");
        }
        if (!opts.wasiEnabled) {
          throw new Error('WASI is not enabled; see the "useWasi" plugin option');
        }
        if (wasi === null) {
          wasi = await loadWasi(opts.allowedPaths, opts.enableWasiOutput);
          wasiList.push(wasi);
          imports.wasi_snapshot_preview1 = await wasi.importObject();
        }
      }
      if (!Object.hasOwnProperty.call(imports, module2)) {
        throw new Error(
          `from module "${current.join(
            '"/"'
          )}": cannot resolve import "${module2}" "${name}": not provided by host imports nor linked manifest items`
        );
      }
      if (!Object.hasOwnProperty.call(imports[module2], name)) {
        throw new Error(
          `from module "${current.join(
            '"/"'
          )}": cannot resolve import "${module2}" "${name}" ("${module2}" is a host module, but does not contain "${name}")`
        );
      }
      if (module2 === EXTISM_ENV && name === "http_request" && promising && imports[module2][name] === context[ENV].http_request && !opts.executingInWorker) {
        const httpContext = new HttpContext(opts.fetch, opts.allowedHosts, opts.memory, opts.allowHttpResponseHeaders);
        mutableFlags.suspendsOnInvoke = true;
        const contributions = {};
        httpContext.contribute(contributions);
        for (const [key, entry] of Object.entries(contributions[EXTISM_ENV])) {
          imports[module2][key] = entry.bind(null, context);
        }
        imports[module2][name] = new Suspending(imports[module2][name]);
      }
      switch (kind) {
        case `function`: {
          instantiationImports[module2] ??= {};
          instantiationImports[module2][name] = imports[module2][name];
          break;
        }
        default:
          throw new Error(
            `from module "${current.join(
              '"/"'
            )}": in import "${module2}" "${name}", "${kind}"-typed host imports are not supported yet`
          );
      }
    } else {
      const provider = modules[nameIdx];
      const providerExports = WebAssembly.Module.exports(provider);
      const target = providerExports.find((xs) => {
        return xs.name === name && xs.kind === kind;
      });
      if (!target) {
        throw new Error(
          `from module "${current.join('"/"')}": cannot import "${module2}" "${name}"; no export matched request`
        );
      }
      const instance2 = providerExports.find((xs) => xs.name === "_start") ? await instantiateModule(
        context,
        [...current, module2],
        provider,
        imports,
        opts,
        wasiList,
        names,
        modules,
        /* @__PURE__ */ new Map(),
        mutableFlags
      ) : !linked.has(provider) ? (await instantiateModule(
        context,
        [...current, module2],
        provider,
        imports,
        opts,
        wasiList,
        names,
        modules,
        linked,
        mutableFlags
      ), linked.get(provider)) : linked.get(provider);
      if (!instance2) {
        if (kind === "function") {
          instantiationImports[module2] = {};
          let cached = null;
          instantiationImports[module2][name] = (...args) => {
            if (cached) {
              return cached(...args);
            }
            const instance3 = linked.get(modules[nameIdx]);
            if (!instance3) {
              throw new Error(
                `from module instance "${current.join('"/"')}": target module "${module2}" was never instantiated`
              );
            }
            cached = instance3.exports[name];
            return cached(...args);
          };
        } else {
          throw new Error(
            `from module "${current.join(
              '"/"'
            )}": cannot import "${module2}" "${name}"; circular imports of type="${kind}" are not supported`
          );
        }
      } else {
        instantiationImports[module2] ??= {};
        instantiationImports[module2][name] = instance2.exports[name];
      }
    }
  }
  const instance = await WebAssembly.instantiate(module, instantiationImports);
  const guestType = instance.exports.hs_init ? "haskell" : instance.exports._initialize ? "reactor" : instance.exports._start ? "command" : "none";
  if (wasi) {
    await wasi?.initialize(instance);
    if (instance.exports.hs_init) {
      instance.exports.hs_init();
    }
  } else {
    switch (guestType) {
      case "command":
        if (instance.exports._initialize) {
          instance.exports._initialize();
        }
        instance.exports._start();
        break;
      case "reactor":
        instance.exports._initialize();
        break;
      case "haskell":
        instance.exports.hs_init();
        break;
    }
  }
  linked.set(module, instance);
  return instance;
}

// dist/worker/node/worker-url.ts
var WORKER_URL = new URL("data:text/javascript;base64,dmFyIHZlPU9iamVjdC5jcmVhdGU7dmFyIHZ0PU9iamVjdC5kZWZpbmVQcm9wZXJ0eTt2YXIgRWU9T2JqZWN0LmdldE93blByb3BlcnR5RGVzY3JpcHRvcjt2YXIgQWU9T2JqZWN0LmdldE93blByb3BlcnR5TmFtZXM7dmFyIGtlPU9iamVjdC5nZXRQcm90b3R5cGVPZixTZT1PYmplY3QucHJvdG90eXBlLmhhc093blByb3BlcnR5O3ZhciBUZT0ocix0LGUpPT50IGluIHI/dnQocix0LHtlbnVtZXJhYmxlOiEwLGNvbmZpZ3VyYWJsZTohMCx3cml0YWJsZTohMCx2YWx1ZTplfSk6clt0XT1lO3ZhciBCdD0ocix0KT0+KCk9Pih0fHxyKCh0PXtleHBvcnRzOnt9fSkuZXhwb3J0cyx0KSx0LmV4cG9ydHMpO3ZhciBDZT0ocix0LGUscyk9PntpZih0JiZ0eXBlb2YgdD09Im9iamVjdCJ8fHR5cGVvZiB0PT0iZnVuY3Rpb24iKWZvcihsZXQgbiBvZiBBZSh0KSkhU2UuY2FsbChyLG4pJiZuIT09ZSYmdnQocixuLHtnZXQ6KCk9PnRbbl0sZW51bWVyYWJsZTohKHM9RWUodCxuKSl8fHMuZW51bWVyYWJsZX0pO3JldHVybiByfTt2YXIgT2U9KHIsdCxlKT0+KGU9ciE9bnVsbD92ZShrZShyKSk6e30sQ2UodHx8IXJ8fCFyLl9fZXNNb2R1bGU/dnQoZSwiZGVmYXVsdCIse3ZhbHVlOnIsZW51bWVyYWJsZTohMH0pOmUscikpO3ZhciBVdD0ocix0LGUpPT4oVGUocix0eXBlb2YgdCE9InN5bWJvbCI/dCsiIjp0LGUpLGUpLEV0PShyLHQsZSk9PntpZighdC5oYXMocikpdGhyb3cgVHlwZUVycm9yKCJDYW5ub3QgIitlKX07dmFyIGg9KHIsdCxlKT0+KEV0KHIsdCwicmVhZCBmcm9tIHByaXZhdGUgZmllbGQiKSxlP2UuY2FsbChyKTp0LmdldChyKSksRT0ocix0LGUpPT57aWYodC5oYXMocikpdGhyb3cgVHlwZUVycm9yKCJDYW5ub3QgYWRkIHRoZSBzYW1lIHByaXZhdGUgbWVtYmVyIG1vcmUgdGhhbiBvbmNlIik7dCBpbnN0YW5jZW9mIFdlYWtTZXQ/dC5hZGQocik6dC5zZXQocixlKX0seD0ocix0LGUscyk9PihFdChyLHQsIndyaXRlIHRvIHByaXZhdGUgZmllbGQiKSxzP3MuY2FsbChyLGUpOnQuc2V0KHIsZSksZSk7dmFyIEQ9KHIsdCxlKT0+KEV0KHIsdCwiYWNjZXNzIHByaXZhdGUgbWV0aG9kIiksZSk7dmFyIEp0PUJ0KChEcyxYdCk9PnsidXNlIHN0cmljdCI7WHQuZXhwb3J0cz1HdDtmdW5jdGlvbiBHdChyLHQsZSl7ciBpbnN0YW5jZW9mIFJlZ0V4cCYmKHI9VnQocixlKSksdCBpbnN0YW5jZW9mIFJlZ0V4cCYmKHQ9VnQodCxlKSk7dmFyIHM9cXQocix0LGUpO3JldHVybiBzJiZ7c3RhcnQ6c1swXSxlbmQ6c1sxXSxwcmU6ZS5zbGljZSgwLHNbMF0pLGJvZHk6ZS5zbGljZShzWzBdK3IubGVuZ3RoLHNbMV0pLHBvc3Q6ZS5zbGljZShzWzFdK3QubGVuZ3RoKX19ZnVuY3Rpb24gVnQocix0KXt2YXIgZT10Lm1hdGNoKHIpO3JldHVybiBlP2VbMF06bnVsbH1HdC5yYW5nZT1xdDtmdW5jdGlvbiBxdChyLHQsZSl7dmFyIHMsbixpLG8sYSxsPWUuaW5kZXhPZihyKSx1PWUuaW5kZXhPZih0LGwrMSksYz1sO2lmKGw+PTAmJnU+MCl7aWYocj09PXQpcmV0dXJuW2wsdV07Zm9yKHM9W10saT1lLmxlbmd0aDtjPj0wJiYhYTspYz09bD8ocy5wdXNoKGMpLGw9ZS5pbmRleE9mKHIsYysxKSk6cy5sZW5ndGg9PTE/YT1bcy5wb3AoKSx1XToobj1zLnBvcCgpLG48aSYmKGk9bixvPXUpLHU9ZS5pbmRleE9mKHQsYysxKSksYz1sPHUmJmw+PTA/bDp1O3MubGVuZ3RoJiYoYT1baSxvXSl9cmV0dXJuIGF9fSk7dmFyIG5lPUJ0KChqcyxzZSk9Pnt2YXIgS3Q9SnQoKTtzZS5leHBvcnRzPVdlO3ZhciBadD0iXDBTTEFTSCIrTWF0aC5yYW5kb20oKSsiXDAiLFl0PSJcME9QRU4iK01hdGgucmFuZG9tKCkrIlwwIixJdD0iXDBDTE9TRSIrTWF0aC5yYW5kb20oKSsiXDAiLFF0PSJcMENPTU1BIitNYXRoLnJhbmRvbSgpKyJcMCIsdGU9IlwwUEVSSU9EIitNYXRoLnJhbmRvbSgpKyJcMCI7ZnVuY3Rpb24gT3Qocil7cmV0dXJuIHBhcnNlSW50KHIsMTApPT1yP3BhcnNlSW50KHIsMTApOnIuY2hhckNvZGVBdCgwKX1mdW5jdGlvbiBMZShyKXtyZXR1cm4gci5zcGxpdCgiXFxcXCIpLmpvaW4oWnQpLnNwbGl0KCJcXHsiKS5qb2luKFl0KS5zcGxpdCgiXFx9Iikuam9pbihJdCkuc3BsaXQoIlxcLCIpLmpvaW4oUXQpLnNwbGl0KCJcXC4iKS5qb2luKHRlKX1mdW5jdGlvbiBQZShyKXtyZXR1cm4gci5zcGxpdChadCkuam9pbigiXFwiKS5zcGxpdChZdCkuam9pbigieyIpLnNwbGl0KEl0KS5qb2luKCJ9Iikuc3BsaXQoUXQpLmpvaW4oIiwiKS5zcGxpdCh0ZSkuam9pbigiLiIpfWZ1bmN0aW9uIGVlKHIpe2lmKCFyKXJldHVyblsiIl07dmFyIHQ9W10sZT1LdCgieyIsIn0iLHIpO2lmKCFlKXJldHVybiByLnNwbGl0KCIsIik7dmFyIHM9ZS5wcmUsbj1lLmJvZHksaT1lLnBvc3Qsbz1zLnNwbGl0KCIsIik7b1tvLmxlbmd0aC0xXSs9InsiK24rIn0iO3ZhciBhPWVlKGkpO3JldHVybiBpLmxlbmd0aCYmKG9bby5sZW5ndGgtMV0rPWEuc2hpZnQoKSxvLnB1c2guYXBwbHkobyxhKSksdC5wdXNoLmFwcGx5KHQsbyksdH1mdW5jdGlvbiBXZShyKXtyZXR1cm4gcj8oci5zdWJzdHIoMCwyKT09PSJ7fSImJihyPSJcXHtcXH0iK3Iuc3Vic3RyKDIpKSxydChMZShyKSwhMCkubWFwKFBlKSk6W119ZnVuY3Rpb24gJGUocil7cmV0dXJuInsiK3IrIn0ifWZ1bmN0aW9uIFJlKHIpe3JldHVybi9eLT8wXGQvLnRlc3Qocil9ZnVuY3Rpb24gTmUocix0KXtyZXR1cm4gcjw9dH1mdW5jdGlvbiBCZShyLHQpe3JldHVybiByPj10fWZ1bmN0aW9uIHJ0KHIsdCl7dmFyIGU9W10scz1LdCgieyIsIn0iLHIpO2lmKCFzKXJldHVybltyXTt2YXIgbj1zLnByZSxpPXMucG9zdC5sZW5ndGg/cnQocy5wb3N0LCExKTpbIiJdO2lmKC9cJCQvLnRlc3Qocy5wcmUpKWZvcih2YXIgbz0wO288aS5sZW5ndGg7bysrKXt2YXIgYT1uKyJ7IitzLmJvZHkrIn0iK2lbb107ZS5wdXNoKGEpfWVsc2V7dmFyIGw9L14tP1xkK1wuXC4tP1xkKyg/OlwuXC4tP1xkKyk/JC8udGVzdChzLmJvZHkpLHU9L15bYS16QS1aXVwuXC5bYS16QS1aXSg/OlwuXC4tP1xkKyk/JC8udGVzdChzLmJvZHkpLGM9bHx8dSxtPXMuYm9keS5pbmRleE9mKCIsIik+PTA7aWYoIWMmJiFtKXJldHVybiBzLnBvc3QubWF0Y2goLywuKlx9Lyk/KHI9cy5wcmUrInsiK3MuYm9keStJdCtzLnBvc3QscnQocikpOltyXTt2YXIgcDtpZihjKXA9cy5ib2R5LnNwbGl0KC9cLlwuLyk7ZWxzZSBpZihwPWVlKHMuYm9keSkscC5sZW5ndGg9PT0xJiYocD1ydChwWzBdLCExKS5tYXAoJGUpLHAubGVuZ3RoPT09MSkpcmV0dXJuIGkubWFwKGZ1bmN0aW9uKHhlKXtyZXR1cm4gcy5wcmUrcFswXSt4ZX0pO3ZhciBkO2lmKGMpe3ZhciB5PU90KHBbMF0pLGY9T3QocFsxXSksZz1NYXRoLm1heChwWzBdLmxlbmd0aCxwWzFdLmxlbmd0aCksYj1wLmxlbmd0aD09Mz9NYXRoLmFicyhPdChwWzJdKSk6MSxJPU5lLFM9Zjx5O1MmJihiKj0tMSxJPUJlKTt2YXIgTT1wLnNvbWUoUmUpO2Q9W107Zm9yKHZhciAkPXk7SSgkLGYpOyQrPWIpe3ZhciBDO2lmKHUpQz1TdHJpbmcuZnJvbUNoYXJDb2RlKCQpLEM9PT0iXFwiJiYoQz0iIik7ZWxzZSBpZihDPVN0cmluZygkKSxNKXt2YXIgTD1nLUMubGVuZ3RoO2lmKEw+MCl7dmFyIHN0PW5ldyBBcnJheShMKzEpLmpvaW4oIjAiKTskPDA/Qz0iLSIrc3QrQy5zbGljZSgxKTpDPXN0K0N9fWQucHVzaChDKX19ZWxzZXtkPVtdO2Zvcih2YXIgUj0wO1I8cC5sZW5ndGg7UisrKWQucHVzaC5hcHBseShkLHJ0KHBbUl0sITEpKX1mb3IodmFyIFI9MDtSPGQubGVuZ3RoO1IrKylmb3IodmFyIG89MDtvPGkubGVuZ3RoO28rKyl7dmFyIGE9bitkW1JdK2lbb107KCF0fHxjfHxhKSYmZS5wdXNoKGEpfX1yZXR1cm4gZX19KTtpbXBvcnR7cGFyZW50UG9ydCBhcyBBc31mcm9tIm5vZGU6d29ya2VyX3RocmVhZHMiO3ZhciB1dCxudCxBdD1jbGFzcyBleHRlbmRzIERhdGFWaWV3e2NvbnN0cnVjdG9yKGUpe3N1cGVyKGUpO0UodGhpcyxudCxudWxsKX1qc29uKCl7cmV0dXJuIEpTT04ucGFyc2UodGhpcy5zdHJpbmcoKSl9YXJyYXlCdWZmZXIoKXtyZXR1cm4gdGhpcy5idWZmZXJ9dGV4dCgpe3JldHVybiB0aGlzLnN0cmluZygpfXN0cmluZygpe3JldHVybiBoKEF0LHV0KS5kZWNvZGUodGhpcy5idWZmZXIpfWJ5dGVzKCl7cmV0dXJuIGgodGhpcyxudCk/P3godGhpcyxudCxuZXcgVWludDhBcnJheSh0aGlzLmJ1ZmZlcikpLGgodGhpcyxudCl9c2V0SW50OChlLHMpe3Rocm93IG5ldyBFcnJvcigiQ2Fubm90IHNldCB2YWx1ZXMgb24gb3V0cHV0Iil9c2V0SW50MTYoZSxzLG4pe3Rocm93IG5ldyBFcnJvcigiQ2Fubm90IHNldCB2YWx1ZXMgb24gb3V0cHV0Iil9c2V0SW50MzIoZSxzLG4pe3Rocm93IG5ldyBFcnJvcigiQ2Fubm90IHNldCB2YWx1ZXMgb24gb3V0cHV0Iil9c2V0VWludDgoZSxzKXt0aHJvdyBuZXcgRXJyb3IoIkNhbm5vdCBzZXQgdmFsdWVzIG9uIG91dHB1dCIpfXNldFVpbnQxNihlLHMsbil7dGhyb3cgbmV3IEVycm9yKCJDYW5ub3Qgc2V0IHZhbHVlcyBvbiBvdXRwdXQiKX1zZXRVaW50MzIoZSxzLG4pe3Rocm93IG5ldyBFcnJvcigiQ2Fubm90IHNldCB2YWx1ZXMgb24gb3V0cHV0Iil9c2V0RmxvYXQzMihlLHMsbil7dGhyb3cgbmV3IEVycm9yKCJDYW5ub3Qgc2V0IHZhbHVlcyBvbiBvdXRwdXQiKX1zZXRGbG9hdDY0KGUscyxuKXt0aHJvdyBuZXcgRXJyb3IoIkNhbm5vdCBzZXQgdmFsdWVzIG9uIG91dHB1dCIpfXNldEJpZ0ludDY0KGUscyxuKXt0aHJvdyBuZXcgRXJyb3IoIkNhbm5vdCBzZXQgdmFsdWVzIG9uIG91dHB1dCIpfXNldEJpZ1VpbnQ2NChlLHMsbil7dGhyb3cgbmV3IEVycm9yKCJDYW5ub3Qgc2V0IHZhbHVlcyBvbiBvdXRwdXQiKX19LGo9QXQ7dXQ9bmV3IFdlYWtNYXAsbnQ9bmV3IFdlYWtNYXAsRShqLHV0LG5ldyBUZXh0RGVjb2Rlcik7dmFyIE49NDtmdW5jdGlvbiBYKHIpe3N3aXRjaChyKXtjYXNlInRyYWNlIjpyZXR1cm4gMDtjYXNlImRlYnVnIjpyZXR1cm4gMTtjYXNlImluZm8iOnJldHVybiAyO2Nhc2Uid2FybiI6cmV0dXJuIDM7Y2FzZSJlcnJvciI6cmV0dXJuIDQ7Y2FzZSJzaWxlbnQiOnJldHVybiAyMTQ3NDgzNjQ3O2RlZmF1bHQ6dGhyb3cgbmV3IFR5cGVFcnJvcihgdW5yZWNvZ25pemVkIGxvZyBsZXZlbCAiJHtyfSI7IGV4cGVjdGVkIG9uZSBvZiAidHJhY2UiLCAiZGVidWciLCAiaW5mbyIsICJ3YXJuIiwgImVycm9yIiwgInNpbGVudCJgKX19ZnVuY3Rpb24gRHQocil7c3dpdGNoKHIpe2Nhc2UgMDpyZXR1cm4idHJhY2UiO2Nhc2UgMTpyZXR1cm4iZGVidWciO2Nhc2UgMjpyZXR1cm4iaW5mbyI7Y2FzZSAzOnJldHVybiJ3YXJuIjtjYXNlIDQ6cmV0dXJuImVycm9yIjtjYXNlIDIxNDc0ODM2NDc6cmV0dXJuInNpbGVudCI7ZGVmYXVsdDp0aHJvdyBuZXcgVHlwZUVycm9yKGB1bnJlY29nbml6ZWQgbG9nIGxldmVsICIke3J9IjsgZXhwZWN0ZWQgb25lIG9mICJ0cmFjZSIsICJkZWJ1ZyIsICJpbmZvIiwgIndhcm4iLCAiZXJyb3IiLCAic2lsZW50ImApfX12YXIganQ9Z2xvYmFsVGhpcy5XZWJBc3NlbWJseXx8e30saHQ9e3N1cHBvcnRzSlNQcm9taXNlSW50ZXJmYWNlOnR5cGVvZiBqdC5TdXNwZW5kaW5nPT0iZnVuY3Rpb24iJiZ0eXBlb2YganQucHJvbWlzaW5nPT0iZnVuY3Rpb24iLGFsbG93U2hhcmVkQnVmZmVyQ29kZWM6ITEsbWFuaWZlc3RTdXBwb3J0c1BhdGhzOiEwLGNyb3NzT3JpZ2luQ2hlY2tzRW5mb3JjZWQ6ITEsZnNBY2Nlc3M6ITAsaGFzV29ya2VyQ2FwYWJpbGl0eTohMCxzdXBwb3J0c1dhc2lQcmV2aWV3MTohMCxzdXBwb3J0c1RpbWVvdXRzOiEwLGV4dGlzbVN0ZG91dEVudlZhclNldDpCb29sZWFuKHByb2Nlc3MuZW52LkVYVElTTV9FTkFCTEVfV0FTSV9PVVRQVVQpfTt2YXIga3Q9U3ltYm9sKCJiZWdpbiIpLGN0PVN5bWJvbCgiZW5kIiksej1TeW1ib2woImVudiIpLFN0PVN5bWJvbCgic2V0LWhvc3QtY29udGV4dCIpLFR0PVN5bWJvbCgiZ2V0LWJsb2NrIiksZnQ9U3ltYm9sKCJpbXBvcnQtc3RhdGUiKSxwdD1TeW1ib2woImV4cG9ydC1zdGF0ZSIpLFo9U3ltYm9sKCJzdG9yZS12YWx1ZSIpLGR0PVN5bWJvbCgicmVzZXQiKSx3PWNsYXNze2dldCBieXRlTGVuZ3RoKCl7cmV0dXJuIHRoaXMuYnVmZmVyLmJ5dGVMZW5ndGh9Y29uc3RydWN0b3IodCxlKXt0aGlzLmJ1ZmZlcj10LHRoaXMudmlldz1uZXcgRGF0YVZpZXcodGhpcy5idWZmZXIpLHRoaXMubG9jYWw9ZX1zdGF0aWMgaW5kZXhUb0FkZHJlc3ModCl7cmV0dXJuIEJpZ0ludCh0KTw8NDhufXN0YXRpYyBhZGRyZXNzVG9JbmRleCh0KXtyZXR1cm4gTnVtYmVyKEJpZ0ludCh0KT4+NDhuKX1zdGF0aWMgbWFza0FkZHJlc3ModCl7cmV0dXJuIE51bWJlcihCaWdJbnQodCkmKDFuPDw0OG4pLTFuKX19LEllLFk9Y2xhc3N7Y29uc3RydWN0b3IodCxlLHMsbixpKXt0aGlzLiN0PVtdO3RoaXMuI2k9bmV3IE1hcDt0aGlzW0llXT17YWxsb2M6dD0+dGhpcy5hbGxvYyh0KSxmcmVlOnQ9Pnt0aGlzLiN0W3cuYWRkcmVzc1RvSW5kZXgodCldPW51bGx9LGxvYWRfdTg6dD0+e2xldCBlPXcuYWRkcmVzc1RvSW5kZXgodCkscz13Lm1hc2tBZGRyZXNzKHQpO3JldHVybiB0aGlzLiN0W2VdPy52aWV3LmdldFVpbnQ4KE51bWJlcihzKSl9LGxvYWRfdTY0OnQ9PntsZXQgZT13LmFkZHJlc3NUb0luZGV4KHQpLHM9dy5tYXNrQWRkcmVzcyh0KTtyZXR1cm4gdGhpcy4jdFtlXT8udmlldy5nZXRCaWdVaW50NjQoTnVtYmVyKHMpLCEwKX0sc3RvcmVfdTg6KHQsZSk9PntsZXQgcz13LmFkZHJlc3NUb0luZGV4KHQpLG49dy5tYXNrQWRkcmVzcyh0KTt0aGlzLiN0W3NdPy52aWV3LnNldFVpbnQ4KE51bWJlcihuKSxOdW1iZXIoZSkpfSxzdG9yZV91NjQ6KHQsZSk9PntsZXQgcz13LmFkZHJlc3NUb0luZGV4KHQpLG49dy5tYXNrQWRkcmVzcyh0KTt0aGlzLiN0W3NdPy52aWV3LnNldEJpZ1VpbnQ2NChOdW1iZXIobiksZSwhMCl9LGlucHV0X29mZnNldDooKT0+e2xldCB0PXRoaXMuI2VbdGhpcy4jZS5sZW5ndGgtMV1bMF07cmV0dXJuIHcuaW5kZXhUb0FkZHJlc3ModHx8MCl9LGlucHV0X2xlbmd0aDooKT0+QmlnSW50KHRoaXMuI3A/LmJ5dGVMZW5ndGg/PzApLGlucHV0X2xvYWRfdTg6dD0+e2xldCBlPXcubWFza0FkZHJlc3ModCk7cmV0dXJuIHRoaXMuI3A/LnZpZXcuZ2V0VWludDgoTnVtYmVyKGUpKX0saW5wdXRfbG9hZF91NjQ6dD0+e2xldCBlPXcubWFza0FkZHJlc3ModCk7cmV0dXJuIHRoaXMuI3A/LnZpZXcuZ2V0QmlnVWludDY0KE51bWJlcihlKSwhMCl9LG91dHB1dF9zZXQ6KHQsZSk9PntsZXQgcz13LmFkZHJlc3NUb0luZGV4KHQpLG49dGhpcy4jdFtzXTtpZighbil0aHJvdyBuZXcgRXJyb3IoYGNhbm5vdCBhc3NpZ24gdG8gdGhpcyBibG9jayAoYWRkcj0ke3QudG9TdHJpbmcoMTYpLnBhZFN0YXJ0KDE2LCIwIil9OyBsZW5ndGg9JHtlfSlgKTtpZihlPm4uYnVmZmVyLmJ5dGVMZW5ndGgpdGhyb3cgbmV3IEVycm9yKCJsZW5ndGggbG9uZ2VyIHRoYW4gdGFyZ2V0IGJsb2NrIik7dGhpcy4jZVt0aGlzLiNlLmxlbmd0aC0xXVsxXT1zfSxlcnJvcl9zZXQ6dD0+e2xldCBlPXcuYWRkcmVzc1RvSW5kZXgodCk7aWYoIXRoaXMuI3RbZV0pdGhyb3cgbmV3IEVycm9yKCJjYW5ub3QgYXNzaWduIGVycm9yIHRvIHRoaXMgYmxvY2siKTt0aGlzLiNlW3RoaXMuI2UubGVuZ3RoLTFdWzJdPWV9LGVycm9yX2dldDooKT0+e2xldCB0PXRoaXMuI2VbdGhpcy4jZS5sZW5ndGgtMV1bMl07cmV0dXJuIHQ/dy5pbmRleFRvQWRkcmVzcyh0KTowbn0sY29uZmlnX2dldDp0PT57bGV0IGU9dGhpcy5yZWFkKHQpO2lmKGU9PT1udWxsKXJldHVybiAwbjt0cnl7bGV0IHM9ZS5zdHJpbmcoKTtpZihzIGluIHRoaXMuI2YpcmV0dXJuIHRoaXMuc3RvcmUodGhpcy4jZltzXSl9ZmluYWxseXt0aGlzW3pdLmZyZWUodCl9cmV0dXJuIDBufSx2YXJfZ2V0OnQ9PntsZXQgZT10aGlzLnJlYWQodCk7aWYoZT09PW51bGwpcmV0dXJuIDBuO3RyeXtsZXQgcz1lLnN0cmluZygpLG49dGhpcy5nZXRWYXJpYWJsZShzKSxpPW4mJnRoaXNbWl0obi5ieXRlcygpKXx8MDtyZXR1cm4gdy5pbmRleFRvQWRkcmVzcyhpKX1maW5hbGx5e3RoaXNbel0uZnJlZSh0KX19LHZhcl9zZXQ6KHQsZSk9PntsZXQgcz10aGlzLnJlYWQodCk7aWYocz09PW51bGwpe3RoaXMuI3MuZXJyb3IoYGF0dGVtcHRlZCB0byBzZXQgdmFyaWFibGUgdXNpbmcgaW52YWxpZCBrZXkgYWRkcmVzcyAoYWRkcj0iJHt0LnRvU3RyaW5nKDE2KX1IIilgKTtyZXR1cm59bGV0IG49cy5zdHJpbmcoKTtpZihlPT09MG4pe3RoaXMuZGVsZXRlVmFyaWFibGUobik7cmV0dXJufWxldCBpPXRoaXMuI3Rbdy5hZGRyZXNzVG9JbmRleChlKV07aWYoIWkpe3RoaXMuI3MuZXJyb3IoYGF0dGVtcHRlZCB0byBzZXQgdmFyaWFibGUgdG8gaW52YWxpZCBhZGRyZXNzIChrZXk9IiR7bn0iOyBhZGRyPSIke2UudG9TdHJpbmcoMTYpfUgiKWApO3JldHVybn10cnl7bGV0IG89bmV3IFVpbnQ4QXJyYXkoaS5idWZmZXIuYnl0ZUxlbmd0aCk7by5zZXQobmV3IFVpbnQ4QXJyYXkoaS5idWZmZXIpLDApLHRoaXMuc2V0VmFyaWFibGUobixvKX1jYXRjaChvKXt0aGlzLiNzLmVycm9yKG8ubWVzc2FnZSksdGhpcy5zZXRFcnJvcihvKTtyZXR1cm59fSxodHRwX3JlcXVlc3Q6KHQsZSk9Pih0aGlzLiNzLmVycm9yKCJodHRwX3JlcXVlc3QgaXMgbm90IGVuYWJsZWQiKSwwbiksaHR0cF9zdGF0dXNfY29kZTooKT0+KHRoaXMuI3MuZXJyb3IoImh0dHBfc3RhdHVzX2NvZGUgaXMgbm90IGVuYWJsZWQiKSwwKSxodHRwX2hlYWRlcnM6KCk9Pih0aGlzLiNzLmVycm9yKCJodHRwX2hlYWRlcnMgaXMgbm90IGVuYWJsZWQiKSwwbiksbGVuZ3RoOnQ9PnRoaXMubGVuZ3RoKHQpLGxlbmd0aF91bnNhZmU6dD0+dGhpcy5sZW5ndGgodCksbG9nX3dhcm46dGhpcy4jYS5iaW5kKHRoaXMsWCgid2FybiIpLCJ3YXJuIiksbG9nX2luZm86dGhpcy4jYS5iaW5kKHRoaXMsWCgiaW5mbyIpLCJpbmZvIiksbG9nX2RlYnVnOnRoaXMuI2EuYmluZCh0aGlzLFgoImRlYnVnIiksImRlYnVnIiksbG9nX2Vycm9yOnRoaXMuI2EuYmluZCh0aGlzLFgoImVycm9yIiksImVycm9yIiksbG9nX3RyYWNlOnRoaXMuI2EuYmluZCh0aGlzLFgoInRyYWNlIiksInRyYWNlIiksZ2V0X2xvZ19sZXZlbDooKT0+aXNGaW5pdGUodGhpcy4jbik/dGhpcy4jbjo0Mjk0OTY3Mjk1fTt0aGlzLiN1PXQsdGhpcy4jcz1lLHRoaXMuI249cz8/MjE0NzQ4MzY0Nyx0aGlzLiNsPW5ldyBUZXh0RGVjb2Rlcix0aGlzLiNyPW5ldyBUZXh0RW5jb2Rlcix0aGlzLiNvPWksdGhpcy4jaD0wLHRoaXMuI2U9W10sdGhpcy5hbGxvYygxKSx0aGlzLiNmPW59I2U7I3Q7I3M7I247I2w7I3I7I3U7I2Y7I2k7I2g7I287I2M7aG9zdENvbnRleHQoKXtyZXR1cm4gdGhpcy4jY31hbGxvYyh0KXtsZXQgZT1uZXcgdyhuZXcgdGhpcy4jdShOdW1iZXIodCkpLCEwKSxzPXRoaXMuI3QubGVuZ3RoO2lmKHRoaXMuI3QucHVzaChlKSx0aGlzLiNvLm1heFBhZ2VzKXtsZXQgaT10aGlzLiN0LnJlZHVjZSgoYSxsKT0+YSsobD8uYnVmZmVyLmJ5dGVMZW5ndGg/PzApLDApLG89TWF0aC5jZWlsKGkvNjU1MzYpO2lmKG8+dGhpcy4jby5tYXhQYWdlcylyZXR1cm4gdGhpcy4jcy5lcnJvcihgbWVtb3J5IGxpbWl0IGV4Y2VlZGVkOiAke299IHBhZ2VzIHJlcXVlc3RlZCwgJHt0aGlzLiNvLm1heFBhZ2VzfSBhbGxvd2VkYCksMG59cmV0dXJuIHcuaW5kZXhUb0FkZHJlc3Mocyl9Z2V0VmFyaWFibGUodCl7cmV0dXJuIHRoaXMuI2kuaGFzKHQpP25ldyBqKHRoaXMuI2kuZ2V0KHQpLmJ1ZmZlcik6bnVsbH1zZXRWYXJpYWJsZSh0LGUpe2xldCBzPXR5cGVvZiBlPT0ic3RyaW5nIj90aGlzLiNyLmVuY29kZShlKTplLG49dGhpcy4jaS5nZXQodCksaT10aGlzLiNoK3MuYnl0ZUxlbmd0aC0obj8uYnl0ZUxlbmd0aHx8MCk7aWYoaT4odGhpcy4jbz8ubWF4VmFyQnl0ZXN8fDEvMCkpdGhyb3cgbmV3IEVycm9yKGB2YXIgbWVtb3J5IGxpbWl0IGV4Y2VlZGVkOiAke2l9IGJ5dGVzIHJlcXVlc3RlZCwgJHt0aGlzLiNvLm1heFZhckJ5dGVzfSBhbGxvd2VkYCk7dGhpcy4jaD1pLHRoaXMuI2kuc2V0KHQscyl9ZGVsZXRlVmFyaWFibGUodCl7bGV0IGU9dGhpcy4jaS5nZXQodCk7IWV8fCh0aGlzLiNpLmRlbGV0ZSh0KSx0aGlzLiNoLT1lLmJ5dGVMZW5ndGgpfXJlYWQodCl7bGV0IGU9dy5hZGRyZXNzVG9JbmRleCh0KSxzPXRoaXMuI3RbZV07aWYoIXMpcmV0dXJuIG51bGw7bGV0IG49IShzLmJ1ZmZlciBpbnN0YW5jZW9mIEFycmF5QnVmZmVyKSYmIWh0LmFsbG93U2hhcmVkQnVmZmVyQ29kZWM/bmV3IFVpbnQ4QXJyYXkocy5idWZmZXIpLnNsaWNlKCkuYnVmZmVyOnMuYnVmZmVyO3JldHVybiBuZXcgaihuKX1zdG9yZSh0KXtsZXQgZT10aGlzW1pdKHQpO2lmKCFlKXRocm93IG5ldyBFcnJvcigiZmFpbGVkIHRvIHN0b3JlIG91dHB1dCIpO3JldHVybiB3LmluZGV4VG9BZGRyZXNzKGUpfWxlbmd0aCh0KXtsZXQgZT13LmFkZHJlc3NUb0luZGV4KHQpLHM9dGhpcy4jdFtlXTtyZXR1cm4gcz9CaWdJbnQocy5idWZmZXIuYnl0ZUxlbmd0aCk6MG59c2V0RXJyb3IodD1udWxsKXtsZXQgZT10P3RoaXNbWl0odCBpbnN0YW5jZW9mIEVycm9yP3QubWVzc2FnZTp0KTowO2lmKCFlKXRocm93IG5ldyBFcnJvcigiY291bGQgbm90IHN0b3JlIGVycm9yIHZhbHVlIik7dGhpcy4jZVt0aGlzLiNlLmxlbmd0aC0xXVsyXT1lfWdldCBsb2dMZXZlbCgpe3JldHVybiBEdCh0aGlzLiNuKX1zZXQgbG9nTGV2ZWwodCl7dGhpcy4jbj1YKHQpfSNhKHQsZSxzKXtsZXQgbj13LmFkZHJlc3NUb0luZGV4KHMpLGk9dGhpcy4jdFtuXTtpZighaSl7dGhpcy4jcy5lcnJvcihgZmFpbGVkIHRvIGxvZygke2V9KTogYmFkIGJsb2NrIHJlZmVyZW5jZSBpbiBhZGRyIDB4JHtzLnRvU3RyaW5nKDE2KS5wYWRTdGFydCg2NCwiMCIpfWApO3JldHVybn10cnl7aWYodGhpcy4jbjw9dCl7bGV0IG89dGhpcy4jbC5kZWNvZGUoaS5idWZmZXIpO3RoaXMuI3NbZV0obyl9fWZpbmFsbHl7dGhpcy4jdFtuXT1udWxsfX1nZXQjcCgpe2xldCB0PXRoaXMuI2VbdGhpcy4jZS5sZW5ndGgtMV1bMF07cmV0dXJuIHQ9PT1udWxsP251bGw6dGhpcy4jdFt0XX1bKEllPXosZHQpXSgpe3RoaXMuI2M9bnVsbCx0aGlzLiN0Lmxlbmd0aD0xLHRoaXMuI2UubGVuZ3RoPTB9W1R0XSh0KXtsZXQgZT10aGlzLiN0W3RdO2lmKCFlKXRocm93IG5ldyBFcnJvcihgaW52YWxpZCBibG9jayBpbmRleDogJHt0fWApO3JldHVybiBlfVtmdF0odCxlPSExKXtmb3IobGV0W3Msbl1vZiB0LmJsb2Nrcyl7aWYocyYmZSl7bGV0IGk9bmV3IFVpbnQ4QXJyYXkobmV3IHRoaXMuI3UoTnVtYmVyKHMuYnl0ZUxlbmd0aCkpKTtpLnNldChuZXcgVWludDhBcnJheShzKSkscz1pLmJ1ZmZlcn10aGlzLiN0W25dPXM/bmV3IHcocywhMSk6bnVsbH10aGlzLiNlPXQuc3RhY2t9W3B0XSgpe3JldHVybntzdGFjazp0aGlzLiNlLnNsaWNlKCksYmxvY2tzOnRoaXMuI3QubWFwKCh0LGUpPT50P3QubG9jYWw/KHQubG9jYWw9ITEsW3QuYnVmZmVyLGVdKTpudWxsOltudWxsLGVdKS5maWx0ZXIoQm9vbGVhbil9fVtaXSh0KXtpZih0eXBlb2YgdD09InN0cmluZyImJih0PXRoaXMuI3IuZW5jb2RlKHQpKSwhdClyZXR1cm4gbnVsbDtpZih0IGluc3RhbmNlb2YgVWludDhBcnJheSl7aWYodC5idWZmZXIuY29uc3RydWN0b3I9PT10aGlzLiN1JiZ0LmJ5dGVPZmZzZXQ9PT0wJiZ0LmJ5dGVMZW5ndGg9PT10LmJ1ZmZlci5ieXRlTGVuZ3RoKXtsZXQgaT10aGlzLiN0Lmxlbmd0aDtyZXR1cm4gdGhpcy4jdC5wdXNoKG5ldyB3KHQuYnVmZmVyLCEwKSksaX1sZXQgZT13LmFkZHJlc3NUb0luZGV4KHRoaXMuYWxsb2ModC5sZW5ndGgpKSxzPXRoaXMuI3RbZV07cmV0dXJuIG5ldyBVaW50OEFycmF5KHMuYnVmZmVyKS5zZXQodCwwKSxlfXJldHVybiB0fVtTdF0odCl7dGhpcy4jYz10fVtrdF0odCl7dGhpcy4jZS5wdXNoKFt0LG51bGwsbnVsbF0pfVtjdF0oKXt0aGlzLiNjPW51bGw7bGV0Wyx0LGVdPXRoaXMuI2UucG9wKCkscz1lPT09bnVsbD8xOjAsbj1lPz90LGk9W251bGwsbnVsbF07cmV0dXJuIG49PT1udWxsfHx0aGlzLiN0W25dPT09bnVsbHx8KGlbc109biksaX19O2ltcG9ydHtXQVNJIGFzIE1lfWZyb20id2FzaSI7aW1wb3J0e2Rldk51bGwgYXMgenR9ZnJvbSJub2RlOm9zIjtpbXBvcnR7b3BlbiBhcyBGdH1mcm9tIm5vZGU6ZnMvcHJvbWlzZXMiO2ltcG9ydHtjbG9zZVN5bmMgYXMgQ3R9ZnJvbSJub2RlOmZzIjthc3luYyBmdW5jdGlvbiBfZSgpe2xldFtyLHRdPWF3YWl0IFByb21pc2UuYWxsKFtGdCh6dCwiciIpLEZ0KHp0LCJ3IildKSxlPSEwLHM9YXN5bmMoKT0+e0N0KHIpLEN0KHQpfTtpZih0eXBlb2YgciE9Im51bWJlciIpe2xldCBuPW5ldyBnbG9iYWxUaGlzLkZpbmFsaXphdGlvblJlZ2lzdHJ5KGk9Pnt0cnl7ZSYmQ3QoaSl9Y2F0Y2h7fX0pO24ucmVnaXN0ZXIocixyLmZkKSxuLnJlZ2lzdGVyKHQsdC5mZCkscz1hc3luYygpPT57ZT0hMSxhd2FpdCBQcm9taXNlLmFsbChbci5jbG9zZSgpLHQuY2xvc2UoKV0pLmNhdGNoKCgpPT57fSl9fXJldHVybntjbG9zZTpzLGZkczpbci5mZCx0LmZkLHQuZmRdfX1hc3luYyBmdW5jdGlvbiBIdChyLHQpe2xldHtjbG9zZTplLGZkczpbcyxuLGldfT10P3thc3luYyBjbG9zZSgpe30sZmRzOlswLDEsMl19OmF3YWl0IF9lKCksbz1uZXcgTWUoe3ZlcnNpb246InByZXZpZXcxIixwcmVvcGVuczpyLHN0ZGluOnMsc3Rkb3V0Om4sc3RkZXJyOml9KTtyZXR1cm57YXN5bmMgaW1wb3J0T2JqZWN0KCl7cmV0dXJuIG8ud2FzaUltcG9ydH0sYXN5bmMgY2xvc2UoKXthd2FpdCBlKCl9LGFzeW5jIGluaXRpYWxpemUoYSl7bGV0IGw9YS5leHBvcnRzLm1lbW9yeTtpZighbCl0aHJvdyBuZXcgRXJyb3IoIlRoZSBtb2R1bGUgaGFzIHRvIGV4cG9ydCBhIGRlZmF1bHQgbWVtb3J5LiIpO2lmKGEuZXhwb3J0cy5faW5pdGlhbGl6ZSl7bGV0IHU9YS5leHBvcnRzLl9pbml0aWFsaXplO28uaW5pdGlhbGl6ZT9vLmluaXRpYWxpemUoe2V4cG9ydHM6e21lbW9yeTpsLF9pbml0aWFsaXplOigpPT57dSgpfX19KTp1KCl9ZWxzZSBvLnN0YXJ0KHtleHBvcnRzOnttZW1vcnk6bCxfc3RhcnQ6KCk9Pnt9fX0pfX19dmFyIHBlPU9lKG5lKCksMSk7dmFyIGl0PXI9PntpZih0eXBlb2YgciE9InN0cmluZyIpdGhyb3cgbmV3IFR5cGVFcnJvcigiaW52YWxpZCBwYXR0ZXJuIik7aWYoci5sZW5ndGg+NjU1MzYpdGhyb3cgbmV3IFR5cGVFcnJvcigicGF0dGVybiBpcyB0b28gbG9uZyIpfTt2YXIgVWU9eyJbOmFsbnVtOl0iOlsiXFxwe0x9XFxwe05sfVxccHtOZH0iLCEwXSwiWzphbHBoYTpdIjpbIlxccHtMfVxccHtObH0iLCEwXSwiWzphc2NpaTpdIjpbIlxceDAwLVxceDdmIiwhMV0sIls6Ymxhbms6XSI6WyJcXHB7WnN9XFx0IiwhMF0sIls6Y250cmw6XSI6WyJcXHB7Q2N9IiwhMF0sIls6ZGlnaXQ6XSI6WyJcXHB7TmR9IiwhMF0sIls6Z3JhcGg6XSI6WyJcXHB7Wn1cXHB7Q30iLCEwLCEwXSwiWzpsb3dlcjpdIjpbIlxccHtMbH0iLCEwXSwiWzpwcmludDpdIjpbIlxccHtDfSIsITBdLCJbOnB1bmN0Ol0iOlsiXFxwe1B9IiwhMF0sIls6c3BhY2U6XSI6WyJcXHB7Wn1cXHRcXHJcXG5cXHZcXGYiLCEwXSwiWzp1cHBlcjpdIjpbIlxccHtMdX0iLCEwXSwiWzp3b3JkOl0iOlsiXFxwe0x9XFxwe05sfVxccHtOZH1cXHB7UGN9IiwhMF0sIls6eGRpZ2l0Ol0iOlsiQS1GYS1mMC05IiwhMV19LG90PXI9PnIucmVwbGFjZSgvW1tcXVxcLV0vZywiXFwkJiIpLERlPXI9PnIucmVwbGFjZSgvWy1bXF17fSgpKis/LixcXF4kfCNcc10vZywiXFwkJiIpLHJlPXI9PnIuam9pbigiIiksaWU9KHIsdCk9PntsZXQgZT10O2lmKHIuY2hhckF0KGUpIT09IlsiKXRocm93IG5ldyBFcnJvcigibm90IGluIGEgYnJhY2UgZXhwcmVzc2lvbiIpO2xldCBzPVtdLG49W10saT1lKzEsbz0hMSxhPSExLGw9ITEsdT0hMSxjPWUsbT0iIjt0OmZvcig7aTxyLmxlbmd0aDspe2xldCBmPXIuY2hhckF0KGkpO2lmKChmPT09IiEifHxmPT09Il4iKSYmaT09PWUrMSl7dT0hMCxpKys7Y29udGludWV9aWYoZj09PSJdIiYmbyYmIWwpe2M9aSsxO2JyZWFrfWlmKG89ITAsZj09PSJcXCImJiFsKXtsPSEwLGkrKztjb250aW51ZX1pZihmPT09IlsiJiYhbCl7Zm9yKGxldFtnLFtiLEksU11db2YgT2JqZWN0LmVudHJpZXMoVWUpKWlmKHIuc3RhcnRzV2l0aChnLGkpKXtpZihtKXJldHVyblsiJC4iLCExLHIubGVuZ3RoLWUsITBdO2krPWcubGVuZ3RoLFM/bi5wdXNoKGIpOnMucHVzaChiKSxhPWF8fEk7Y29udGludWUgdH19aWYobD0hMSxtKXtmPm0/cy5wdXNoKG90KG0pKyItIitvdChmKSk6Zj09PW0mJnMucHVzaChvdChmKSksbT0iIixpKys7Y29udGludWV9aWYoci5zdGFydHNXaXRoKCItXSIsaSsxKSl7cy5wdXNoKG90KGYrIi0iKSksaSs9Mjtjb250aW51ZX1pZihyLnN0YXJ0c1dpdGgoIi0iLGkrMSkpe209ZixpKz0yO2NvbnRpbnVlfXMucHVzaChvdChmKSksaSsrfWlmKGM8aSlyZXR1cm5bIiIsITEsMCwhMV07aWYoIXMubGVuZ3RoJiYhbi5sZW5ndGgpcmV0dXJuWyIkLiIsITEsci5sZW5ndGgtZSwhMF07aWYobi5sZW5ndGg9PT0wJiZzLmxlbmd0aD09PTEmJi9eXFw/LiQvLnRlc3Qoc1swXSkmJiF1KXtsZXQgZj1zWzBdLmxlbmd0aD09PTI/c1swXS5zbGljZSgtMSk6c1swXTtyZXR1cm5bRGUoZiksITEsYy1lLCExXX1sZXQgcD0iWyIrKHU/Il4iOiIiKStyZShzKSsiXSIsZD0iWyIrKHU/IiI6Il4iKStyZShuKSsiXSI7cmV0dXJuW3MubGVuZ3RoJiZuLmxlbmd0aD8iKCIrcCsifCIrZCsiKSI6cy5sZW5ndGg/cDpkLGEsYy1lLCEwXX07dmFyIEY9KHIse3dpbmRvd3NQYXRoc05vRXNjYXBlOnQ9ITF9PXt9KT0+dD9yLnJlcGxhY2UoL1xbKFteXC9cXF0pXF0vZywiJDEiKTpyLnJlcGxhY2UoLygoPyFcXCkufF4pXFsoW15cL1xcXSlcXS9nLCIkMSQyIikucmVwbGFjZSgvXFwoW15cL10pL2csIiQxIik7dmFyIGplPW5ldyBTZXQoWyIhIiwiPyIsIisiLCIqIiwiQCJdKSxvZT1yPT5qZS5oYXMociksemU9Iig/ISg/Ol58LylcXC5cXC4/KD86JHwvKSkiLGd0PSIoPyFcXC4pIixGZT1uZXcgU2V0KFsiWyIsIi4iXSksSGU9bmV3IFNldChbIi4uIiwiLiJdKSxWZT1uZXcgU2V0KCIoKS4qe30rP1tdXiRcXCEiKSxHZT1yPT5yLnJlcGxhY2UoL1stW1xde30oKSorPy4sXFxeJHwjXHNdL2csIlxcJCYiKSxfdD0iW14vXSIsYWU9X3QrIio/IixsZT1fdCsiKz8iLGssVCxCLHYsQSxILEosVixVLEssYXQsYnQsdWUsUSxtdCxsdCxNdCx5dCxoZSxfPWNsYXNze2NvbnN0cnVjdG9yKHQsZSxzPXt9KXtFKHRoaXMsYnQpO0UodGhpcyxsdCk7VXQodGhpcywidHlwZSIpO0UodGhpcyxrLHZvaWQgMCk7RSh0aGlzLFQsdm9pZCAwKTtFKHRoaXMsQiwhMSk7RSh0aGlzLHYsW10pO0UodGhpcyxBLHZvaWQgMCk7RSh0aGlzLEgsdm9pZCAwKTtFKHRoaXMsSix2b2lkIDApO0UodGhpcyxWLCExKTtFKHRoaXMsVSx2b2lkIDApO0UodGhpcyxLLHZvaWQgMCk7RSh0aGlzLGF0LCExKTt0aGlzLnR5cGU9dCx0JiZ4KHRoaXMsVCwhMCkseCh0aGlzLEEsZSkseCh0aGlzLGssaCh0aGlzLEEpP2goaCh0aGlzLEEpLGspOnRoaXMpLHgodGhpcyxVLGgodGhpcyxrKT09PXRoaXM/czpoKGgodGhpcyxrKSxVKSkseCh0aGlzLEosaCh0aGlzLGspPT09dGhpcz9bXTpoKGgodGhpcyxrKSxKKSksdD09PSIhIiYmIWgoaCh0aGlzLGspLFYpJiZoKHRoaXMsSikucHVzaCh0aGlzKSx4KHRoaXMsSCxoKHRoaXMsQSk/aChoKHRoaXMsQSksdikubGVuZ3RoOjApfWdldCBoYXNNYWdpYygpe2lmKGgodGhpcyxUKSE9PXZvaWQgMClyZXR1cm4gaCh0aGlzLFQpO2ZvcihsZXQgdCBvZiBoKHRoaXMsdikpaWYodHlwZW9mIHQhPSJzdHJpbmciJiYodC50eXBlfHx0Lmhhc01hZ2ljKSlyZXR1cm4geCh0aGlzLFQsITApO3JldHVybiBoKHRoaXMsVCl9dG9TdHJpbmcoKXtyZXR1cm4gaCh0aGlzLEspIT09dm9pZCAwP2godGhpcyxLKTp0aGlzLnR5cGU/eCh0aGlzLEssdGhpcy50eXBlKyIoIitoKHRoaXMsdikubWFwKHQ9PlN0cmluZyh0KSkuam9pbigifCIpKyIpIik6eCh0aGlzLEssaCh0aGlzLHYpLm1hcCh0PT5TdHJpbmcodCkpLmpvaW4oIiIpKX1wdXNoKC4uLnQpe2ZvcihsZXQgZSBvZiB0KWlmKGUhPT0iIil7aWYodHlwZW9mIGUhPSJzdHJpbmciJiYhKGUgaW5zdGFuY2VvZiBfJiZoKGUsQSk9PT10aGlzKSl0aHJvdyBuZXcgRXJyb3IoImludmFsaWQgcGFydDogIitlKTtoKHRoaXMsdikucHVzaChlKX19dG9KU09OKCl7bGV0IHQ9dGhpcy50eXBlPT09bnVsbD9oKHRoaXMsdikuc2xpY2UoKS5tYXAoZT0+dHlwZW9mIGU9PSJzdHJpbmciP2U6ZS50b0pTT04oKSk6W3RoaXMudHlwZSwuLi5oKHRoaXMsdikubWFwKGU9PmUudG9KU09OKCkpXTtyZXR1cm4gdGhpcy5pc1N0YXJ0KCkmJiF0aGlzLnR5cGUmJnQudW5zaGlmdChbXSksdGhpcy5pc0VuZCgpJiYodGhpcz09PWgodGhpcyxrKXx8aChoKHRoaXMsayksVikmJmgodGhpcyxBKT8udHlwZT09PSIhIikmJnQucHVzaCh7fSksdH1pc1N0YXJ0KCl7aWYoaCh0aGlzLGspPT09dGhpcylyZXR1cm4hMDtpZighaCh0aGlzLEEpPy5pc1N0YXJ0KCkpcmV0dXJuITE7aWYoaCh0aGlzLEgpPT09MClyZXR1cm4hMDtsZXQgdD1oKHRoaXMsQSk7Zm9yKGxldCBlPTA7ZTxoKHRoaXMsSCk7ZSsrKXtsZXQgcz1oKHQsdilbZV07aWYoIShzIGluc3RhbmNlb2YgXyYmcy50eXBlPT09IiEiKSlyZXR1cm4hMX1yZXR1cm4hMH1pc0VuZCgpe2lmKGgodGhpcyxrKT09PXRoaXN8fGgodGhpcyxBKT8udHlwZT09PSIhIilyZXR1cm4hMDtpZighaCh0aGlzLEEpPy5pc0VuZCgpKXJldHVybiExO2lmKCF0aGlzLnR5cGUpcmV0dXJuIGgodGhpcyxBKT8uaXNFbmQoKTtsZXQgdD1oKHRoaXMsQSk/aChoKHRoaXMsQSksdikubGVuZ3RoOjA7cmV0dXJuIGgodGhpcyxIKT09PXQtMX1jb3B5SW4odCl7dHlwZW9mIHQ9PSJzdHJpbmciP3RoaXMucHVzaCh0KTp0aGlzLnB1c2godC5jbG9uZSh0aGlzKSl9Y2xvbmUodCl7bGV0IGU9bmV3IF8odGhpcy50eXBlLHQpO2ZvcihsZXQgcyBvZiBoKHRoaXMsdikpZS5jb3B5SW4ocyk7cmV0dXJuIGV9c3RhdGljIGZyb21HbG9iKHQsZT17fSl7dmFyIG47bGV0IHM9bmV3IF8obnVsbCx2b2lkIDAsZSk7cmV0dXJuIEQobj1fLFEsbXQpLmNhbGwobix0LHMsMCxlKSxzfXRvTU1QYXR0ZXJuKCl7aWYodGhpcyE9PWgodGhpcyxrKSlyZXR1cm4gaCh0aGlzLGspLnRvTU1QYXR0ZXJuKCk7bGV0IHQ9dGhpcy50b1N0cmluZygpLFtlLHMsbixpXT10aGlzLnRvUmVnRXhwU291cmNlKCk7aWYoIShufHxoKHRoaXMsVCl8fGgodGhpcyxVKS5ub2Nhc2UmJiFoKHRoaXMsVSkubm9jYXNlTWFnaWNPbmx5JiZ0LnRvVXBwZXJDYXNlKCkhPT10LnRvTG93ZXJDYXNlKCkpKXJldHVybiBzO2xldCBhPShoKHRoaXMsVSkubm9jYXNlPyJpIjoiIikrKGk/InUiOiIiKTtyZXR1cm4gT2JqZWN0LmFzc2lnbihuZXcgUmVnRXhwKGBeJHtlfSRgLGEpLHtfc3JjOmUsX2dsb2I6dH0pfXRvUmVnRXhwU291cmNlKHQpe2xldCBlPXQ/PyEhaCh0aGlzLFUpLmRvdDtpZihoKHRoaXMsayk9PT10aGlzJiZEKHRoaXMsYnQsdWUpLmNhbGwodGhpcyksIXRoaXMudHlwZSl7bGV0IGw9dGhpcy5pc1N0YXJ0KCkmJnRoaXMuaXNFbmQoKSx1PWgodGhpcyx2KS5tYXAoZD0+e3ZhciBJO2xldFt5LGYsZyxiXT10eXBlb2YgZD09InN0cmluZyI/RChJPV8seXQsaGUpLmNhbGwoSSxkLGgodGhpcyxUKSxsKTpkLnRvUmVnRXhwU291cmNlKHQpO3JldHVybiB4KHRoaXMsVCxoKHRoaXMsVCl8fGcpLHgodGhpcyxCLGgodGhpcyxCKXx8YikseX0pLmpvaW4oIiIpLGM9IiI7aWYodGhpcy5pc1N0YXJ0KCkmJnR5cGVvZiBoKHRoaXMsdilbMF09PSJzdHJpbmciJiYhKGgodGhpcyx2KS5sZW5ndGg9PT0xJiZIZS5oYXMoaCh0aGlzLHYpWzBdKSkpe2xldCB5PUZlLGY9ZSYmeS5oYXModS5jaGFyQXQoMCkpfHx1LnN0YXJ0c1dpdGgoIlxcLiIpJiZ5Lmhhcyh1LmNoYXJBdCgyKSl8fHUuc3RhcnRzV2l0aCgiXFwuXFwuIikmJnkuaGFzKHUuY2hhckF0KDQpKSxnPSFlJiYhdCYmeS5oYXModS5jaGFyQXQoMCkpO2M9Zj96ZTpnP2d0OiIifWxldCBtPSIiO3JldHVybiB0aGlzLmlzRW5kKCkmJmgoaCh0aGlzLGspLFYpJiZoKHRoaXMsQSk/LnR5cGU9PT0iISImJihtPSIoPzokfFxcLykiKSxbYyt1K20sRih1KSx4KHRoaXMsVCwhIWgodGhpcyxUKSksaCh0aGlzLEIpXX1sZXQgcz10aGlzLnR5cGU9PT0iKiJ8fHRoaXMudHlwZT09PSIrIixuPXRoaXMudHlwZT09PSIhIj8iKD86KD8hKD86IjoiKD86IixpPUQodGhpcyxsdCxNdCkuY2FsbCh0aGlzLGUpO2lmKHRoaXMuaXNTdGFydCgpJiZ0aGlzLmlzRW5kKCkmJiFpJiZ0aGlzLnR5cGUhPT0iISIpe2xldCBsPXRoaXMudG9TdHJpbmcoKTtyZXR1cm4geCh0aGlzLHYsW2xdKSx0aGlzLnR5cGU9bnVsbCx4KHRoaXMsVCx2b2lkIDApLFtsLEYodGhpcy50b1N0cmluZygpKSwhMSwhMV19bGV0IG89IXN8fHR8fGV8fCFndD8iIjpEKHRoaXMsbHQsTXQpLmNhbGwodGhpcywhMCk7bz09PWkmJihvPSIiKSxvJiYoaT1gKD86JHtpfSkoPzoke299KSo/YCk7bGV0IGE9IiI7aWYodGhpcy50eXBlPT09IiEiJiZoKHRoaXMsYXQpKWE9KHRoaXMuaXNTdGFydCgpJiYhZT9ndDoiIikrbGU7ZWxzZXtsZXQgbD10aGlzLnR5cGU9PT0iISI/IikpIisodGhpcy5pc1N0YXJ0KCkmJiFlJiYhdD9ndDoiIikrYWUrIikiOnRoaXMudHlwZT09PSJAIj8iKSI6dGhpcy50eXBlPT09Ij8iPyIpPyI6dGhpcy50eXBlPT09IisiJiZvPyIpIjp0aGlzLnR5cGU9PT0iKiImJm8/Iik/IjpgKSR7dGhpcy50eXBlfWA7YT1uK2krbH1yZXR1cm5bYSxGKGkpLHgodGhpcyxULCEhaCh0aGlzLFQpKSxoKHRoaXMsQildfX0sRz1fO2s9bmV3IFdlYWtNYXAsVD1uZXcgV2Vha01hcCxCPW5ldyBXZWFrTWFwLHY9bmV3IFdlYWtNYXAsQT1uZXcgV2Vha01hcCxIPW5ldyBXZWFrTWFwLEo9bmV3IFdlYWtNYXAsVj1uZXcgV2Vha01hcCxVPW5ldyBXZWFrTWFwLEs9bmV3IFdlYWtNYXAsYXQ9bmV3IFdlYWtNYXAsYnQ9bmV3IFdlYWtTZXQsdWU9ZnVuY3Rpb24oKXtpZih0aGlzIT09aCh0aGlzLGspKXRocm93IG5ldyBFcnJvcigic2hvdWxkIG9ubHkgY2FsbCBvbiByb290Iik7aWYoaCh0aGlzLFYpKXJldHVybiB0aGlzO3RoaXMudG9TdHJpbmcoKSx4KHRoaXMsViwhMCk7bGV0IHQ7Zm9yKDt0PWgodGhpcyxKKS5wb3AoKTspe2lmKHQudHlwZSE9PSIhIiljb250aW51ZTtsZXQgZT10LHM9aChlLEEpO2Zvcig7czspe2ZvcihsZXQgbj1oKGUsSCkrMTshcy50eXBlJiZuPGgocyx2KS5sZW5ndGg7bisrKWZvcihsZXQgaSBvZiBoKHQsdikpe2lmKHR5cGVvZiBpPT0ic3RyaW5nIil0aHJvdyBuZXcgRXJyb3IoInN0cmluZyBwYXJ0IGluIGV4dGdsb2IgQVNUPz8iKTtpLmNvcHlJbihoKHMsdilbbl0pfWU9cyxzPWgoZSxBKX19cmV0dXJuIHRoaXN9LFE9bmV3IFdlYWtTZXQsbXQ9ZnVuY3Rpb24odCxlLHMsbil7dmFyIGQseTtsZXQgaT0hMSxvPSExLGE9LTEsbD0hMTtpZihlLnR5cGU9PT1udWxsKXtsZXQgZj1zLGc9IiI7Zm9yKDtmPHQubGVuZ3RoOyl7bGV0IGI9dC5jaGFyQXQoZisrKTtpZihpfHxiPT09IlxcIil7aT0haSxnKz1iO2NvbnRpbnVlfWlmKG8pe2Y9PT1hKzE/KGI9PT0iXiJ8fGI9PT0iISIpJiYobD0hMCk6Yj09PSJdIiYmIShmPT09YSsyJiZsKSYmKG89ITEpLGcrPWI7Y29udGludWV9ZWxzZSBpZihiPT09IlsiKXtvPSEwLGE9ZixsPSExLGcrPWI7Y29udGludWV9aWYoIW4ubm9leHQmJm9lKGIpJiZ0LmNoYXJBdChmKT09PSIoIil7ZS5wdXNoKGcpLGc9IiI7bGV0IEk9bmV3IF8oYixlKTtmPUQoZD1fLFEsbXQpLmNhbGwoZCx0LEksZixuKSxlLnB1c2goSSk7Y29udGludWV9Zys9Yn1yZXR1cm4gZS5wdXNoKGcpLGZ9bGV0IHU9cysxLGM9bmV3IF8obnVsbCxlKSxtPVtdLHA9IiI7Zm9yKDt1PHQubGVuZ3RoOyl7bGV0IGY9dC5jaGFyQXQodSsrKTtpZihpfHxmPT09IlxcIil7aT0haSxwKz1mO2NvbnRpbnVlfWlmKG8pe3U9PT1hKzE/KGY9PT0iXiJ8fGY9PT0iISIpJiYobD0hMCk6Zj09PSJdIiYmISh1PT09YSsyJiZsKSYmKG89ITEpLHArPWY7Y29udGludWV9ZWxzZSBpZihmPT09IlsiKXtvPSEwLGE9dSxsPSExLHArPWY7Y29udGludWV9aWYob2UoZikmJnQuY2hhckF0KHUpPT09IigiKXtjLnB1c2gocCkscD0iIjtsZXQgZz1uZXcgXyhmLGMpO2MucHVzaChnKSx1PUQoeT1fLFEsbXQpLmNhbGwoeSx0LGcsdSxuKTtjb250aW51ZX1pZihmPT09InwiKXtjLnB1c2gocCkscD0iIixtLnB1c2goYyksYz1uZXcgXyhudWxsLGUpO2NvbnRpbnVlfWlmKGY9PT0iKSIpcmV0dXJuIHA9PT0iIiYmaChlLHYpLmxlbmd0aD09PTAmJngoZSxhdCwhMCksYy5wdXNoKHApLHA9IiIsZS5wdXNoKC4uLm0sYyksdTtwKz1mfXJldHVybiBlLnR5cGU9bnVsbCx4KGUsVCx2b2lkIDApLHgoZSx2LFt0LnN1YnN0cmluZyhzLTEpXSksdX0sbHQ9bmV3IFdlYWtTZXQsTXQ9ZnVuY3Rpb24odCl7cmV0dXJuIGgodGhpcyx2KS5tYXAoZT0+e2lmKHR5cGVvZiBlPT0ic3RyaW5nIil0aHJvdyBuZXcgRXJyb3IoInN0cmluZyB0eXBlIGluIGV4dGdsb2IgYXN0Pz8iKTtsZXRbcyxuLGksb109ZS50b1JlZ0V4cFNvdXJjZSh0KTtyZXR1cm4geCh0aGlzLEIsaCh0aGlzLEIpfHxvKSxzfSkuZmlsdGVyKGU9PiEodGhpcy5pc1N0YXJ0KCkmJnRoaXMuaXNFbmQoKSl8fCEhZSkuam9pbigifCIpfSx5dD1uZXcgV2Vha1NldCxoZT1mdW5jdGlvbih0LGUscz0hMSl7bGV0IG49ITEsaT0iIixvPSExO2ZvcihsZXQgYT0wO2E8dC5sZW5ndGg7YSsrKXtsZXQgbD10LmNoYXJBdChhKTtpZihuKXtuPSExLGkrPShWZS5oYXMobCk/IlxcIjoiIikrbDtjb250aW51ZX1pZihsPT09IlxcIil7YT09PXQubGVuZ3RoLTE/aSs9IlxcXFwiOm49ITA7Y29udGludWV9aWYobD09PSJbIil7bGV0W3UsYyxtLHBdPWllKHQsYSk7aWYobSl7aSs9dSxvPW98fGMsYSs9bS0xLGU9ZXx8cDtjb250aW51ZX19aWYobD09PSIqIil7cyYmdD09PSIqIj9pKz1sZTppKz1hZSxlPSEwO2NvbnRpbnVlfWlmKGw9PT0iPyIpe2krPV90LGU9ITA7Y29udGludWV9aSs9R2UobCl9cmV0dXJuW2ksRih0KSwhIWUsb119LEUoRyxRKSxFKEcseXQpO3ZhciBMdD0ocix7d2luZG93c1BhdGhzTm9Fc2NhcGU6dD0hMX09e30pPT50P3IucmVwbGFjZSgvWz8qKClbXF1dL2csIlskJl0iKTpyLnJlcGxhY2UoL1s/KigpW1xdXFxdL2csIlxcJCYiKTt2YXIgTz0ocix0LGU9e30pPT4oaXQodCksIWUubm9jb21tZW50JiZ0LmNoYXJBdCgwKT09PSIjIj8hMTpuZXcgdHQodCxlKS5tYXRjaChyKSkscWU9L15cKisoW14rQCE/XCpcW1woXSopJC8sWGU9cj0+dD0+IXQuc3RhcnRzV2l0aCgiLiIpJiZ0LmVuZHNXaXRoKHIpLEplPXI9PnQ9PnQuZW5kc1dpdGgociksS2U9cj0+KHI9ci50b0xvd2VyQ2FzZSgpLHQ9PiF0LnN0YXJ0c1dpdGgoIi4iKSYmdC50b0xvd2VyQ2FzZSgpLmVuZHNXaXRoKHIpKSxaZT1yPT4ocj1yLnRvTG93ZXJDYXNlKCksdD0+dC50b0xvd2VyQ2FzZSgpLmVuZHNXaXRoKHIpKSxZZT0vXlwqK1wuXCorJC8sUWU9cj0+IXIuc3RhcnRzV2l0aCgiLiIpJiZyLmluY2x1ZGVzKCIuIiksdHM9cj0+ciE9PSIuIiYmciE9PSIuLiImJnIuaW5jbHVkZXMoIi4iKSxlcz0vXlwuXCorJC8sc3M9cj0+ciE9PSIuIiYmciE9PSIuLiImJnIuc3RhcnRzV2l0aCgiLiIpLG5zPS9eXCorJC8scnM9cj0+ci5sZW5ndGghPT0wJiYhci5zdGFydHNXaXRoKCIuIiksaXM9cj0+ci5sZW5ndGghPT0wJiZyIT09Ii4iJiZyIT09Ii4uIixvcz0vXlw/KyhbXitAIT9cKlxbXChdKik/JC8sYXM9KFtyLHQ9IiJdKT0+e2xldCBlPWRlKFtyXSk7cmV0dXJuIHQ/KHQ9dC50b0xvd2VyQ2FzZSgpLHM9PmUocykmJnMudG9Mb3dlckNhc2UoKS5lbmRzV2l0aCh0KSk6ZX0sbHM9KFtyLHQ9IiJdKT0+e2xldCBlPWdlKFtyXSk7cmV0dXJuIHQ/KHQ9dC50b0xvd2VyQ2FzZSgpLHM9PmUocykmJnMudG9Mb3dlckNhc2UoKS5lbmRzV2l0aCh0KSk6ZX0sdXM9KFtyLHQ9IiJdKT0+e2xldCBlPWdlKFtyXSk7cmV0dXJuIHQ/cz0+ZShzKSYmcy5lbmRzV2l0aCh0KTplfSxocz0oW3IsdD0iIl0pPT57bGV0IGU9ZGUoW3JdKTtyZXR1cm4gdD9zPT5lKHMpJiZzLmVuZHNXaXRoKHQpOmV9LGRlPShbcl0pPT57bGV0IHQ9ci5sZW5ndGg7cmV0dXJuIGU9PmUubGVuZ3RoPT09dCYmIWUuc3RhcnRzV2l0aCgiLiIpfSxnZT0oW3JdKT0+e2xldCB0PXIubGVuZ3RoO3JldHVybiBlPT5lLmxlbmd0aD09PXQmJmUhPT0iLiImJmUhPT0iLi4ifSxtZT10eXBlb2YgcHJvY2Vzcz09Im9iamVjdCImJnByb2Nlc3M/dHlwZW9mIHByb2Nlc3MuZW52PT0ib2JqZWN0IiYmcHJvY2Vzcy5lbnYmJnByb2Nlc3MuZW52Ll9fTUlOSU1BVENIX1RFU1RJTkdfUExBVEZPUk1fX3x8cHJvY2Vzcy5wbGF0Zm9ybToicG9zaXgiLGNlPXt3aW4zMjp7c2VwOiJcXCJ9LHBvc2l4OntzZXA6Ii8ifX0sY3M9bWU9PT0id2luMzIiP2NlLndpbjMyLnNlcDpjZS5wb3NpeC5zZXA7Ty5zZXA9Y3M7dmFyIFc9U3ltYm9sKCJnbG9ic3RhciAqKiIpO08uR0xPQlNUQVI9Vzt2YXIgZnM9IlteL10iLHBzPWZzKyIqPyIsZHM9Iig/Oig/ISg/OlxcL3xeKSg/OlxcLnsxLDJ9KSgkfFxcLykpLikqPyIsZ3M9Iig/Oig/ISg/OlxcL3xeKVxcLikuKSo/Iixtcz0ocix0PXt9KT0+ZT0+TyhlLHIsdCk7Ty5maWx0ZXI9bXM7dmFyIFA9KHIsdD17fSk9Pk9iamVjdC5hc3NpZ24oe30scix0KSxicz1yPT57aWYoIXJ8fHR5cGVvZiByIT0ib2JqZWN0Inx8IU9iamVjdC5rZXlzKHIpLmxlbmd0aClyZXR1cm4gTztsZXQgdD1PO3JldHVybiBPYmplY3QuYXNzaWduKChzLG4saT17fSk9PnQocyxuLFAocixpKSkse01pbmltYXRjaDpjbGFzcyBleHRlbmRzIHQuTWluaW1hdGNoe2NvbnN0cnVjdG9yKG4saT17fSl7c3VwZXIobixQKHIsaSkpfXN0YXRpYyBkZWZhdWx0cyhuKXtyZXR1cm4gdC5kZWZhdWx0cyhQKHIsbikpLk1pbmltYXRjaH19LEFTVDpjbGFzcyBleHRlbmRzIHQuQVNUe2NvbnN0cnVjdG9yKG4saSxvPXt9KXtzdXBlcihuLGksUChyLG8pKX1zdGF0aWMgZnJvbUdsb2IobixpPXt9KXtyZXR1cm4gdC5BU1QuZnJvbUdsb2IobixQKHIsaSkpfX0sdW5lc2NhcGU6KHMsbj17fSk9PnQudW5lc2NhcGUocyxQKHIsbikpLGVzY2FwZToocyxuPXt9KT0+dC5lc2NhcGUocyxQKHIsbikpLGZpbHRlcjoocyxuPXt9KT0+dC5maWx0ZXIocyxQKHIsbikpLGRlZmF1bHRzOnM9PnQuZGVmYXVsdHMoUChyLHMpKSxtYWtlUmU6KHMsbj17fSk9PnQubWFrZVJlKHMsUChyLG4pKSxicmFjZUV4cGFuZDoocyxuPXt9KT0+dC5icmFjZUV4cGFuZChzLFAocixuKSksbWF0Y2g6KHMsbixpPXt9KT0+dC5tYXRjaChzLG4sUChyLGkpKSxzZXA6dC5zZXAsR0xPQlNUQVI6V30pfTtPLmRlZmF1bHRzPWJzO3ZhciBiZT0ocix0PXt9KT0+KGl0KHIpLHQubm9icmFjZXx8IS9ceyg/Oig/IVx7KS4pKlx9Ly50ZXN0KHIpP1tyXTooMCxwZS5kZWZhdWx0KShyKSk7Ty5icmFjZUV4cGFuZD1iZTt2YXIgeXM9KHIsdD17fSk9Pm5ldyB0dChyLHQpLm1ha2VSZSgpO08ubWFrZVJlPXlzO3ZhciB3cz0ocix0LGU9e30pPT57bGV0IHM9bmV3IHR0KHQsZSk7cmV0dXJuIHI9ci5maWx0ZXIobj0+cy5tYXRjaChuKSkscy5vcHRpb25zLm5vbnVsbCYmIXIubGVuZ3RoJiZyLnB1c2godCkscn07Ty5tYXRjaD13czt2YXIgZmU9L1s/Kl18WytAIV1cKC4qP1wpfFxbfFxdLyx4cz1yPT5yLnJlcGxhY2UoL1stW1xde30oKSorPy4sXFxeJHwjXHNdL2csIlxcJCYiKSx0dD1jbGFzc3tvcHRpb25zO3NldDtwYXR0ZXJuO3dpbmRvd3NQYXRoc05vRXNjYXBlO25vbmVnYXRlO25lZ2F0ZTtjb21tZW50O2VtcHR5O3ByZXNlcnZlTXVsdGlwbGVTbGFzaGVzO3BhcnRpYWw7Z2xvYlNldDtnbG9iUGFydHM7bm9jYXNlO2lzV2luZG93cztwbGF0Zm9ybTt3aW5kb3dzTm9NYWdpY1Jvb3Q7cmVnZXhwO2NvbnN0cnVjdG9yKHQsZT17fSl7aXQodCksZT1lfHx7fSx0aGlzLm9wdGlvbnM9ZSx0aGlzLnBhdHRlcm49dCx0aGlzLnBsYXRmb3JtPWUucGxhdGZvcm18fG1lLHRoaXMuaXNXaW5kb3dzPXRoaXMucGxhdGZvcm09PT0id2luMzIiLHRoaXMud2luZG93c1BhdGhzTm9Fc2NhcGU9ISFlLndpbmRvd3NQYXRoc05vRXNjYXBlfHxlLmFsbG93V2luZG93c0VzY2FwZT09PSExLHRoaXMud2luZG93c1BhdGhzTm9Fc2NhcGUmJih0aGlzLnBhdHRlcm49dGhpcy5wYXR0ZXJuLnJlcGxhY2UoL1xcL2csIi8iKSksdGhpcy5wcmVzZXJ2ZU11bHRpcGxlU2xhc2hlcz0hIWUucHJlc2VydmVNdWx0aXBsZVNsYXNoZXMsdGhpcy5yZWdleHA9bnVsbCx0aGlzLm5lZ2F0ZT0hMSx0aGlzLm5vbmVnYXRlPSEhZS5ub25lZ2F0ZSx0aGlzLmNvbW1lbnQ9ITEsdGhpcy5lbXB0eT0hMSx0aGlzLnBhcnRpYWw9ISFlLnBhcnRpYWwsdGhpcy5ub2Nhc2U9ISF0aGlzLm9wdGlvbnMubm9jYXNlLHRoaXMud2luZG93c05vTWFnaWNSb290PWUud2luZG93c05vTWFnaWNSb290IT09dm9pZCAwP2Uud2luZG93c05vTWFnaWNSb290OiEhKHRoaXMuaXNXaW5kb3dzJiZ0aGlzLm5vY2FzZSksdGhpcy5nbG9iU2V0PVtdLHRoaXMuZ2xvYlBhcnRzPVtdLHRoaXMuc2V0PVtdLHRoaXMubWFrZSgpfWhhc01hZ2ljKCl7aWYodGhpcy5vcHRpb25zLm1hZ2ljYWxCcmFjZXMmJnRoaXMuc2V0Lmxlbmd0aD4xKXJldHVybiEwO2ZvcihsZXQgdCBvZiB0aGlzLnNldClmb3IobGV0IGUgb2YgdClpZih0eXBlb2YgZSE9InN0cmluZyIpcmV0dXJuITA7cmV0dXJuITF9ZGVidWcoLi4udCl7fW1ha2UoKXtsZXQgdD10aGlzLnBhdHRlcm4sZT10aGlzLm9wdGlvbnM7aWYoIWUubm9jb21tZW50JiZ0LmNoYXJBdCgwKT09PSIjIil7dGhpcy5jb21tZW50PSEwO3JldHVybn1pZighdCl7dGhpcy5lbXB0eT0hMDtyZXR1cm59dGhpcy5wYXJzZU5lZ2F0ZSgpLHRoaXMuZ2xvYlNldD1bLi4ubmV3IFNldCh0aGlzLmJyYWNlRXhwYW5kKCkpXSxlLmRlYnVnJiYodGhpcy5kZWJ1Zz0oLi4uaSk9PmNvbnNvbGUuZXJyb3IoLi4uaSkpLHRoaXMuZGVidWcodGhpcy5wYXR0ZXJuLHRoaXMuZ2xvYlNldCk7bGV0IHM9dGhpcy5nbG9iU2V0Lm1hcChpPT50aGlzLnNsYXNoU3BsaXQoaSkpO3RoaXMuZ2xvYlBhcnRzPXRoaXMucHJlcHJvY2VzcyhzKSx0aGlzLmRlYnVnKHRoaXMucGF0dGVybix0aGlzLmdsb2JQYXJ0cyk7bGV0IG49dGhpcy5nbG9iUGFydHMubWFwKChpLG8sYSk9PntpZih0aGlzLmlzV2luZG93cyYmdGhpcy53aW5kb3dzTm9NYWdpY1Jvb3Qpe2xldCBsPWlbMF09PT0iIiYmaVsxXT09PSIiJiYoaVsyXT09PSI/Inx8IWZlLnRlc3QoaVsyXSkpJiYhZmUudGVzdChpWzNdKSx1PS9eW2Etel06L2kudGVzdChpWzBdKTtpZihsKXJldHVyblsuLi5pLnNsaWNlKDAsNCksLi4uaS5zbGljZSg0KS5tYXAoYz0+dGhpcy5wYXJzZShjKSldO2lmKHUpcmV0dXJuW2lbMF0sLi4uaS5zbGljZSgxKS5tYXAoYz0+dGhpcy5wYXJzZShjKSldfXJldHVybiBpLm1hcChsPT50aGlzLnBhcnNlKGwpKX0pO2lmKHRoaXMuZGVidWcodGhpcy5wYXR0ZXJuLG4pLHRoaXMuc2V0PW4uZmlsdGVyKGk9PmkuaW5kZXhPZighMSk9PT0tMSksdGhpcy5pc1dpbmRvd3MpZm9yKGxldCBpPTA7aTx0aGlzLnNldC5sZW5ndGg7aSsrKXtsZXQgbz10aGlzLnNldFtpXTtvWzBdPT09IiImJm9bMV09PT0iIiYmdGhpcy5nbG9iUGFydHNbaV1bMl09PT0iPyImJnR5cGVvZiBvWzNdPT0ic3RyaW5nIiYmL15bYS16XTokL2kudGVzdChvWzNdKSYmKG9bMl09Ij8iKX10aGlzLmRlYnVnKHRoaXMucGF0dGVybix0aGlzLnNldCl9cHJlcHJvY2Vzcyh0KXtpZih0aGlzLm9wdGlvbnMubm9nbG9ic3Rhcilmb3IobGV0IHM9MDtzPHQubGVuZ3RoO3MrKylmb3IobGV0IG49MDtuPHRbc10ubGVuZ3RoO24rKyl0W3NdW25dPT09IioqIiYmKHRbc11bbl09IioiKTtsZXR7b3B0aW1pemF0aW9uTGV2ZWw6ZT0xfT10aGlzLm9wdGlvbnM7cmV0dXJuIGU+PTI/KHQ9dGhpcy5maXJzdFBoYXNlUHJlUHJvY2Vzcyh0KSx0PXRoaXMuc2Vjb25kUGhhc2VQcmVQcm9jZXNzKHQpKTplPj0xP3Q9dGhpcy5sZXZlbE9uZU9wdGltaXplKHQpOnQ9dGhpcy5hZGphc2NlbnRHbG9ic3Rhck9wdGltaXplKHQpLHR9YWRqYXNjZW50R2xvYnN0YXJPcHRpbWl6ZSh0KXtyZXR1cm4gdC5tYXAoZT0+e2xldCBzPS0xO2Zvcig7KHM9ZS5pbmRleE9mKCIqKiIscysxKSkhPT0tMTspe2xldCBuPXM7Zm9yKDtlW24rMV09PT0iKioiOyluKys7biE9PXMmJmUuc3BsaWNlKHMsbi1zKX1yZXR1cm4gZX0pfWxldmVsT25lT3B0aW1pemUodCl7cmV0dXJuIHQubWFwKGU9PihlPWUucmVkdWNlKChzLG4pPT57bGV0IGk9c1tzLmxlbmd0aC0xXTtyZXR1cm4gbj09PSIqKiImJmk9PT0iKioiP3M6bj09PSIuLiImJmkmJmkhPT0iLi4iJiZpIT09Ii4iJiZpIT09IioqIj8ocy5wb3AoKSxzKToocy5wdXNoKG4pLHMpfSxbXSksZS5sZW5ndGg9PT0wP1siIl06ZSkpfWxldmVsVHdvRmlsZU9wdGltaXplKHQpe0FycmF5LmlzQXJyYXkodCl8fCh0PXRoaXMuc2xhc2hTcGxpdCh0KSk7bGV0IGU9ITE7ZG97aWYoZT0hMSwhdGhpcy5wcmVzZXJ2ZU11bHRpcGxlU2xhc2hlcyl7Zm9yKGxldCBuPTE7bjx0Lmxlbmd0aC0xO24rKyl7bGV0IGk9dFtuXTtuPT09MSYmaT09PSIiJiZ0WzBdPT09IiJ8fChpPT09Ii4ifHxpPT09IiIpJiYoZT0hMCx0LnNwbGljZShuLDEpLG4tLSl9dFswXT09PSIuIiYmdC5sZW5ndGg9PT0yJiYodFsxXT09PSIuInx8dFsxXT09PSIiKSYmKGU9ITAsdC5wb3AoKSl9bGV0IHM9MDtmb3IoOyhzPXQuaW5kZXhPZigiLi4iLHMrMSkpIT09LTE7KXtsZXQgbj10W3MtMV07biYmbiE9PSIuIiYmbiE9PSIuLiImJm4hPT0iKioiJiYoZT0hMCx0LnNwbGljZShzLTEsMikscy09Mil9fXdoaWxlKGUpO3JldHVybiB0Lmxlbmd0aD09PTA/WyIiXTp0fWZpcnN0UGhhc2VQcmVQcm9jZXNzKHQpe2xldCBlPSExO2Rve2U9ITE7Zm9yKGxldCBzIG9mIHQpe2xldCBuPS0xO2Zvcig7KG49cy5pbmRleE9mKCIqKiIsbisxKSkhPT0tMTspe2xldCBvPW47Zm9yKDtzW28rMV09PT0iKioiOylvKys7bz5uJiZzLnNwbGljZShuKzEsby1uKTtsZXQgYT1zW24rMV0sbD1zW24rMl0sdT1zW24rM107aWYoYSE9PSIuLiJ8fCFsfHxsPT09Ii4ifHxsPT09Ii4uInx8IXV8fHU9PT0iLiJ8fHU9PT0iLi4iKWNvbnRpbnVlO2U9ITAscy5zcGxpY2UobiwxKTtsZXQgYz1zLnNsaWNlKDApO2Nbbl09IioqIix0LnB1c2goYyksbi0tfWlmKCF0aGlzLnByZXNlcnZlTXVsdGlwbGVTbGFzaGVzKXtmb3IobGV0IG89MTtvPHMubGVuZ3RoLTE7bysrKXtsZXQgYT1zW29dO289PT0xJiZhPT09IiImJnNbMF09PT0iInx8KGE9PT0iLiJ8fGE9PT0iIikmJihlPSEwLHMuc3BsaWNlKG8sMSksby0tKX1zWzBdPT09Ii4iJiZzLmxlbmd0aD09PTImJihzWzFdPT09Ii4ifHxzWzFdPT09IiIpJiYoZT0hMCxzLnBvcCgpKX1sZXQgaT0wO2Zvcig7KGk9cy5pbmRleE9mKCIuLiIsaSsxKSkhPT0tMTspe2xldCBvPXNbaS0xXTtpZihvJiZvIT09Ii4iJiZvIT09Ii4uIiYmbyE9PSIqKiIpe2U9ITA7bGV0IGw9aT09PTEmJnNbaSsxXT09PSIqKiI/WyIuIl06W107cy5zcGxpY2UoaS0xLDIsLi4ubCkscy5sZW5ndGg9PT0wJiZzLnB1c2goIiIpLGktPTJ9fX19d2hpbGUoZSk7cmV0dXJuIHR9c2Vjb25kUGhhc2VQcmVQcm9jZXNzKHQpe2ZvcihsZXQgZT0wO2U8dC5sZW5ndGgtMTtlKyspZm9yKGxldCBzPWUrMTtzPHQubGVuZ3RoO3MrKyl7bGV0IG49dGhpcy5wYXJ0c01hdGNoKHRbZV0sdFtzXSwhdGhpcy5wcmVzZXJ2ZU11bHRpcGxlU2xhc2hlcyk7IW58fCh0W2VdPW4sdFtzXT1bXSl9cmV0dXJuIHQuZmlsdGVyKGU9PmUubGVuZ3RoKX1wYXJ0c01hdGNoKHQsZSxzPSExKXtsZXQgbj0wLGk9MCxvPVtdLGE9IiI7Zm9yKDtuPHQubGVuZ3RoJiZpPGUubGVuZ3RoOylpZih0W25dPT09ZVtpXSlvLnB1c2goYT09PSJiIj9lW2ldOnRbbl0pLG4rKyxpKys7ZWxzZSBpZihzJiZ0W25dPT09IioqIiYmZVtpXT09PXRbbisxXSlvLnB1c2godFtuXSksbisrO2Vsc2UgaWYocyYmZVtpXT09PSIqKiImJnRbbl09PT1lW2krMV0pby5wdXNoKGVbaV0pLGkrKztlbHNlIGlmKHRbbl09PT0iKiImJmVbaV0mJih0aGlzLm9wdGlvbnMuZG90fHwhZVtpXS5zdGFydHNXaXRoKCIuIikpJiZlW2ldIT09IioqIil7aWYoYT09PSJiIilyZXR1cm4hMTthPSJhIixvLnB1c2godFtuXSksbisrLGkrK31lbHNlIGlmKGVbaV09PT0iKiImJnRbbl0mJih0aGlzLm9wdGlvbnMuZG90fHwhdFtuXS5zdGFydHNXaXRoKCIuIikpJiZ0W25dIT09IioqIil7aWYoYT09PSJhIilyZXR1cm4hMTthPSJiIixvLnB1c2goZVtpXSksbisrLGkrK31lbHNlIHJldHVybiExO3JldHVybiB0Lmxlbmd0aD09PWUubGVuZ3RoJiZvfXBhcnNlTmVnYXRlKCl7aWYodGhpcy5ub25lZ2F0ZSlyZXR1cm47bGV0IHQ9dGhpcy5wYXR0ZXJuLGU9ITEscz0wO2ZvcihsZXQgbj0wO248dC5sZW5ndGgmJnQuY2hhckF0KG4pPT09IiEiO24rKyllPSFlLHMrKztzJiYodGhpcy5wYXR0ZXJuPXQuc2xpY2UocykpLHRoaXMubmVnYXRlPWV9bWF0Y2hPbmUodCxlLHM9ITEpe2xldCBuPXRoaXMub3B0aW9ucztpZih0aGlzLmlzV2luZG93cyl7bGV0IGY9dHlwZW9mIHRbMF09PSJzdHJpbmciJiYvXlthLXpdOiQvaS50ZXN0KHRbMF0pLGc9IWYmJnRbMF09PT0iIiYmdFsxXT09PSIiJiZ0WzJdPT09Ij8iJiYvXlthLXpdOiQvaS50ZXN0KHRbM10pLGI9dHlwZW9mIGVbMF09PSJzdHJpbmciJiYvXlthLXpdOiQvaS50ZXN0KGVbMF0pLEk9IWImJmVbMF09PT0iIiYmZVsxXT09PSIiJiZlWzJdPT09Ij8iJiZ0eXBlb2YgZVszXT09InN0cmluZyImJi9eW2Etel06JC9pLnRlc3QoZVszXSksUz1nPzM6Zj8wOnZvaWQgMCxNPUk/MzpiPzA6dm9pZCAwO2lmKHR5cGVvZiBTPT0ibnVtYmVyIiYmdHlwZW9mIE09PSJudW1iZXIiKXtsZXRbJCxDXT1bdFtTXSxlW01dXTskLnRvTG93ZXJDYXNlKCk9PT1DLnRvTG93ZXJDYXNlKCkmJihlW01dPSQsTT5TP2U9ZS5zbGljZShNKTpTPk0mJih0PXQuc2xpY2UoUykpKX19bGV0e29wdGltaXphdGlvbkxldmVsOmk9MX09dGhpcy5vcHRpb25zO2k+PTImJih0PXRoaXMubGV2ZWxUd29GaWxlT3B0aW1pemUodCkpLHRoaXMuZGVidWcoIm1hdGNoT25lIix0aGlzLHtmaWxlOnQscGF0dGVybjplfSksdGhpcy5kZWJ1ZygibWF0Y2hPbmUiLHQubGVuZ3RoLGUubGVuZ3RoKTtmb3IodmFyIG89MCxhPTAsbD10Lmxlbmd0aCx1PWUubGVuZ3RoO288bCYmYTx1O28rKyxhKyspe3RoaXMuZGVidWcoIm1hdGNoT25lIGxvb3AiKTt2YXIgYz1lW2FdLG09dFtvXTtpZih0aGlzLmRlYnVnKGUsYyxtKSxjPT09ITEpcmV0dXJuITE7aWYoYz09PVcpe3RoaXMuZGVidWcoIkdMT0JTVEFSIixbZSxjLG1dKTt2YXIgcD1vLGQ9YSsxO2lmKGQ9PT11KXtmb3IodGhpcy5kZWJ1ZygiKiogYXQgdGhlIGVuZCIpO288bDtvKyspaWYodFtvXT09PSIuInx8dFtvXT09PSIuLiJ8fCFuLmRvdCYmdFtvXS5jaGFyQXQoMCk9PT0iLiIpcmV0dXJuITE7cmV0dXJuITB9Zm9yKDtwPGw7KXt2YXIgeT10W3BdO2lmKHRoaXMuZGVidWcoYApnbG9ic3RhciB3aGlsZWAsdCxwLGUsZCx5KSx0aGlzLm1hdGNoT25lKHQuc2xpY2UocCksZS5zbGljZShkKSxzKSlyZXR1cm4gdGhpcy5kZWJ1ZygiZ2xvYnN0YXIgZm91bmQgbWF0Y2ghIixwLGwseSksITA7aWYoeT09PSIuInx8eT09PSIuLiJ8fCFuLmRvdCYmeS5jaGFyQXQoMCk9PT0iLiIpe3RoaXMuZGVidWcoImRvdCBkZXRlY3RlZCEiLHQscCxlLGQpO2JyZWFrfXRoaXMuZGVidWcoImdsb2JzdGFyIHN3YWxsb3cgYSBzZWdtZW50LCBhbmQgY29udGludWUiKSxwKyt9cmV0dXJuISEocyYmKHRoaXMuZGVidWcoYAo+Pj4gbm8gbWF0Y2gsIHBhcnRpYWw/YCx0LHAsZSxkKSxwPT09bCkpfWxldCBmO2lmKHR5cGVvZiBjPT0ic3RyaW5nIj8oZj1tPT09Yyx0aGlzLmRlYnVnKCJzdHJpbmcgbWF0Y2giLGMsbSxmKSk6KGY9Yy50ZXN0KG0pLHRoaXMuZGVidWcoInBhdHRlcm4gbWF0Y2giLGMsbSxmKSksIWYpcmV0dXJuITF9aWYobz09PWwmJmE9PT11KXJldHVybiEwO2lmKG89PT1sKXJldHVybiBzO2lmKGE9PT11KXJldHVybiBvPT09bC0xJiZ0W29dPT09IiI7dGhyb3cgbmV3IEVycm9yKCJ3dGY/Iil9YnJhY2VFeHBhbmQoKXtyZXR1cm4gYmUodGhpcy5wYXR0ZXJuLHRoaXMub3B0aW9ucyl9cGFyc2UodCl7aXQodCk7bGV0IGU9dGhpcy5vcHRpb25zO2lmKHQ9PT0iKioiKXJldHVybiBXO2lmKHQ9PT0iIilyZXR1cm4iIjtsZXQgcyxuPW51bGw7KHM9dC5tYXRjaChucykpP249ZS5kb3Q/aXM6cnM6KHM9dC5tYXRjaChxZSkpP249KGUubm9jYXNlP2UuZG90P1plOktlOmUuZG90P0plOlhlKShzWzFdKToocz10Lm1hdGNoKG9zKSk/bj0oZS5ub2Nhc2U/ZS5kb3Q/bHM6YXM6ZS5kb3Q/dXM6aHMpKHMpOihzPXQubWF0Y2goWWUpKT9uPWUuZG90P3RzOlFlOihzPXQubWF0Y2goZXMpKSYmKG49c3MpO2xldCBpPUcuZnJvbUdsb2IodCx0aGlzLm9wdGlvbnMpLnRvTU1QYXR0ZXJuKCk7cmV0dXJuIG4/T2JqZWN0LmFzc2lnbihpLHt0ZXN0Om59KTppfW1ha2VSZSgpe2lmKHRoaXMucmVnZXhwfHx0aGlzLnJlZ2V4cD09PSExKXJldHVybiB0aGlzLnJlZ2V4cDtsZXQgdD10aGlzLnNldDtpZighdC5sZW5ndGgpcmV0dXJuIHRoaXMucmVnZXhwPSExLHRoaXMucmVnZXhwO2xldCBlPXRoaXMub3B0aW9ucyxzPWUubm9nbG9ic3Rhcj9wczplLmRvdD9kczpncyxuPW5ldyBTZXQoZS5ub2Nhc2U/WyJpIl06W10pLGk9dC5tYXAobD0+e2xldCB1PWwubWFwKGM9PntpZihjIGluc3RhbmNlb2YgUmVnRXhwKWZvcihsZXQgbSBvZiBjLmZsYWdzLnNwbGl0KCIiKSluLmFkZChtKTtyZXR1cm4gdHlwZW9mIGM9PSJzdHJpbmciP3hzKGMpOmM9PT1XP1c6Yy5fc3JjfSk7cmV0dXJuIHUuZm9yRWFjaCgoYyxtKT0+e2xldCBwPXVbbSsxXSxkPXVbbS0xXTtjIT09V3x8ZD09PVd8fChkPT09dm9pZCAwP3AhPT12b2lkIDAmJnAhPT1XP3VbbSsxXT0iKD86XFwvfCIrcysiXFwvKT8iK3A6dVttXT1zOnA9PT12b2lkIDA/dVttLTFdPWQrIig/OlxcL3wiK3MrIik/IjpwIT09VyYmKHVbbS0xXT1kKyIoPzpcXC98XFwvIitzKyJcXC8pIitwLHVbbSsxXT1XKSl9KSx1LmZpbHRlcihjPT5jIT09Vykuam9pbigiLyIpfSkuam9pbigifCIpLFtvLGFdPXQubGVuZ3RoPjE/WyIoPzoiLCIpIl06WyIiLCIiXTtpPSJeIitvK2krYSsiJCIsdGhpcy5uZWdhdGUmJihpPSJeKD8hIitpKyIpLiskIik7dHJ5e3RoaXMucmVnZXhwPW5ldyBSZWdFeHAoaSxbLi4ubl0uam9pbigiIikpfWNhdGNoe3RoaXMucmVnZXhwPSExfXJldHVybiB0aGlzLnJlZ2V4cH1zbGFzaFNwbGl0KHQpe3JldHVybiB0aGlzLnByZXNlcnZlTXVsdGlwbGVTbGFzaGVzP3Quc3BsaXQoIi8iKTp0aGlzLmlzV2luZG93cyYmL15cL1wvW15cL10rLy50ZXN0KHQpP1siIiwuLi50LnNwbGl0KC9cLysvKV06dC5zcGxpdCgvXC8rLyl9bWF0Y2godCxlPXRoaXMucGFydGlhbCl7aWYodGhpcy5kZWJ1ZygibWF0Y2giLHQsdGhpcy5wYXR0ZXJuKSx0aGlzLmNvbW1lbnQpcmV0dXJuITE7aWYodGhpcy5lbXB0eSlyZXR1cm4gdD09PSIiO2lmKHQ9PT0iLyImJmUpcmV0dXJuITA7bGV0IHM9dGhpcy5vcHRpb25zO3RoaXMuaXNXaW5kb3dzJiYodD10LnNwbGl0KCJcXCIpLmpvaW4oIi8iKSk7bGV0IG49dGhpcy5zbGFzaFNwbGl0KHQpO3RoaXMuZGVidWcodGhpcy5wYXR0ZXJuLCJzcGxpdCIsbik7bGV0IGk9dGhpcy5zZXQ7dGhpcy5kZWJ1Zyh0aGlzLnBhdHRlcm4sInNldCIsaSk7bGV0IG89bltuLmxlbmd0aC0xXTtpZighbylmb3IobGV0IGE9bi5sZW5ndGgtMjshbyYmYT49MDthLS0pbz1uW2FdO2ZvcihsZXQgYT0wO2E8aS5sZW5ndGg7YSsrKXtsZXQgbD1pW2FdLHU9bjtpZihzLm1hdGNoQmFzZSYmbC5sZW5ndGg9PT0xJiYodT1bb10pLHRoaXMubWF0Y2hPbmUodSxsLGUpKXJldHVybiBzLmZsaXBOZWdhdGU/ITA6IXRoaXMubmVnYXRlfXJldHVybiBzLmZsaXBOZWdhdGU/ITE6dGhpcy5uZWdhdGV9c3RhdGljIGRlZmF1bHRzKHQpe3JldHVybiBPLmRlZmF1bHRzKHQpLk1pbmltYXRjaH19O08uQVNUPUc7Ty5NaW5pbWF0Y2g9dHQ7Ty5lc2NhcGU9THQ7Ty51bmVzY2FwZT1GO2Z1bmN0aW9uIHllKHIsdCl7cmV0dXJuIE8ocix0KX12YXIgd3Q9Y2xhc3N7Y29uc3RydWN0b3IodCxlLHMsbil7dGhpcy5mZXRjaD10LHRoaXMuYWxsb3dlZEhvc3RzPWUsdGhpcy5sYXN0U3RhdHVzQ29kZT0wLHRoaXMubWVtb3J5T3B0aW9ucz1zLHRoaXMubGFzdEhlYWRlcnM9bj97fTpudWxsfWNvbnRyaWJ1dGUodCl7dFtxXT8/PXt9LHRbcV0uaHR0cF9yZXF1ZXN0PShlLHMsbik9PnRoaXMubWFrZVJlcXVlc3QoZSxzLG4pLHRbcV0uaHR0cF9zdGF0dXNfY29kZT0oKT0+dGhpcy5sYXN0U3RhdHVzQ29kZSx0W3FdLmh0dHBfaGVhZGVycz1lPT50aGlzLmxhc3RIZWFkZXJzPT09bnVsbD8wbjplLnN0b3JlKEpTT04uc3RyaW5naWZ5KHRoaXMubGFzdEhlYWRlcnMpKX1hc3luYyBtYWtlUmVxdWVzdCh0LGUscyl7dGhpcy5sYXN0SGVhZGVycyE9PW51bGwmJih0aGlzLmxhc3RIZWFkZXJzPXt9KSx0aGlzLmxhc3RTdGF0dXNDb2RlPTA7bGV0IG49dC5yZWFkKGUpO2lmKG49PT1udWxsKXJldHVybiAwbjtsZXR7aGVhZGVyczppLGhlYWRlcjpvLHVybDphLG1ldGhvZDpsfT1uLmpzb24oKSx1PWw/LnRvVXBwZXJDYXNlKCk/PyJHRVQiLGM9bmV3IFVSTChhKTtpZighdGhpcy5hbGxvd2VkSG9zdHMuc29tZShmPT5mPT09Yy5ob3N0bmFtZXx8eWUoYy5ob3N0bmFtZSxmKSkpdGhyb3cgbmV3IEVycm9yKGBDYWxsIGVycm9yOiBIVFRQIHJlcXVlc3QgdG8gIiR7Y30iIGlzIG5vdCBhbGxvd2VkIChubyBhbGxvd2VkSG9zdHMgbWF0Y2ggIiR7Yy5ob3N0bmFtZX0iKWApO2xldCBwPXM9PT0wbnx8dT09PSJHRVQifHx1PT09IkhFQUQiP251bGw6dC5yZWFkKHMpPy5ieXRlcygpLGQ9dGhpcy5mZXRjaCx5PWF3YWl0IGQoYSx7aGVhZGVyczppfHxvLG1ldGhvZDp1LC4uLnA/e2JvZHk6cC5zbGljZSgpfTp7fX0pO3RoaXMubGFzdFN0YXR1c0NvZGU9eS5zdGF0dXMsdGhpcy5sYXN0SGVhZGVycyE9PW51bGwmJih0aGlzLmxhc3RIZWFkZXJzPU9iamVjdC5mcm9tRW50cmllcyh5LmhlYWRlcnMpKTt0cnl7bGV0IGY9dGhpcy5tZW1vcnlPcHRpb25zLm1heEh0dHBSZXNwb25zZUJ5dGVzP2F3YWl0IHZzKHksdGhpcy5tZW1vcnlPcHRpb25zLm1heEh0dHBSZXNwb25zZUJ5dGVzKTpuZXcgVWludDhBcnJheShhd2FpdCB5LmFycmF5QnVmZmVyKCkpO3JldHVybiB0LnN0b3JlKGYpfWNhdGNoKGYpe2lmKGYgaW5zdGFuY2VvZiBFcnJvcil7bGV0IGc9dC5zdG9yZShuZXcgVGV4dEVuY29kZXIoKS5lbmNvZGUoZi5tZXNzYWdlKSk7cmV0dXJuIHRbel0ubG9nX2Vycm9yKGcpLDBufXJldHVybiAwbn19fTthc3luYyBmdW5jdGlvbiB2cyhyLHQpe2xldCBlPXIuYm9keT8uZ2V0UmVhZGVyKCk7aWYoIWUpcmV0dXJuIG5ldyBVaW50OEFycmF5KDApO2xldCBzPTAsbj1bXTtmb3IoO3M8dDspe2xldHtkb25lOmEsdmFsdWU6bH09YXdhaXQgZS5yZWFkKCk7aWYoYSlicmVhaztpZihuLnB1c2gobCkscys9bC5sZW5ndGgscz49dCl0aHJvdyBuZXcgRXJyb3IoYFJlc3BvbnNlIGJvZHkgZXhjZWVkZWQgJHt0fSBieXRlc2ApfWxldCBpPW5ldyBVaW50OEFycmF5KHMpLG89MDtmb3IobGV0IGEgb2YgbilpLnNldChhLG8pLG8rPWEubGVuZ3RoO3JldHVybiBpfXZhciBxPSJleHRpc206aG9zdC9lbnYiLEVzPShhc3luYygpPT57fSkuY29uc3RydWN0b3IsUHQ9V2ViQXNzZW1ibHkuU3VzcGVuZGluZyxSdD1XZWJBc3NlbWJseS5wcm9taXNpbmcsV3Q9Y2xhc3N7I2U7I3Q7I3M9ITE7I247I2w7I3I7Y29uc3RydWN0b3IodCxlLHMsbixpKXt0aGlzLiNlPWUsdGhpcy4jdD1zLHRoaXMuI249bix0aGlzLiNsPXQsdGhpcy4jcj1pfWFzeW5jIHJlc2V0KCl7cmV0dXJuIHRoaXMuaXNBY3RpdmUoKT8hMToodGhpcy4jZVtkdF0oKSwhMCl9aXNBY3RpdmUoKXtyZXR1cm4gdGhpcy4jc31hc3luYyBmdW5jdGlvbkV4aXN0cyh0KXtyZXR1cm4gdHlwZW9mIHRoaXMuI3RbMV0uZXhwb3J0c1t0XT09ImZ1bmN0aW9uIn1hc3luYyBjYWxsQmxvY2sodCxlKXt0aGlzLiNzPSEwO2xldCBzPXRoaXMuI3RbMV0uZXhwb3J0c1t0XTtpZighcyl0aHJvdyBFcnJvcihgUGx1Z2luIGVycm9yOiBmdW5jdGlvbiAiJHt0fSIgZG9lcyBub3QgZXhpc3RgKTtpZih0eXBlb2YgcyE9ImZ1bmN0aW9uIil0aHJvdyBFcnJvcihgUGx1Z2luIGVycm9yOiBleHBvcnQgIiR7dH0iIGlzIG5vdCBhIGZ1bmN0aW9uYCk7dGhpcy4jZVtrdF0oZT8/bnVsbCk7dHJ5e3JldHVybiB0aGlzLiNyP2F3YWl0IFJ0KHMpKCk6cygpLHRoaXMuI2VbY3RdKCl9Y2F0Y2gobil7dGhyb3cgdGhpcy4jZVtjdF0oKSxufWZpbmFsbHl7dGhpcy4jcz0hMX19YXN5bmMgY2FsbCh0LGUscyl7dGhpcy4jZVtkdF0oKTtsZXQgbj10aGlzLiNlW1pdKGUpO3RoaXMuI2VbU3RdKHMpO2xldFtpLG9dPWF3YWl0IHRoaXMuY2FsbEJsb2NrKHQsbiksYT1pIT09bnVsbCxsPWk/P287aWYobD09PW51bGwpcmV0dXJuIG51bGw7bGV0IHU9dGhpcy4jZVtUdF0obCk7aWYoIXUpcmV0dXJuIG51bGw7bGV0IGM9bmV3IGoodS5idWZmZXIpO2lmKGEpdGhyb3cgbmV3IEVycm9yKGBQbHVnaW4tb3JpZ2luYXRlZCBlcnJvcjogJHtjLnN0cmluZygpfWApO3JldHVybiBjfWFzeW5jIGdldEV4cG9ydHMoKXtyZXR1cm4gV2ViQXNzZW1ibHkuTW9kdWxlLmV4cG9ydHModGhpcy4jdFswXSl8fFtdfWFzeW5jIGdldEltcG9ydHMoKXtyZXR1cm4gV2ViQXNzZW1ibHkuTW9kdWxlLmltcG9ydHModGhpcy4jdFswXSl8fFtdfWFzeW5jIGdldEluc3RhbmNlKCl7cmV0dXJuIHRoaXMuI3RbMV19YXN5bmMgY2xvc2UoKXthd2FpdCBQcm9taXNlLmFsbCh0aGlzLiNuLm1hcCh0PT50LmNsb3NlKCkpKSx0aGlzLiNuLmxlbmd0aD0wfX07YXN5bmMgZnVuY3Rpb24gd2Uocix0LGUscz1uZXcgWShBcnJheUJ1ZmZlcixyLmxvZ2dlcixyLmxvZ0xldmVsLHIuY29uZmlnLHIubWVtb3J5KSl7bGV0IG49e1txXTpzW3pdLGVudjp7fX0saT0hMTtmb3IobGV0IG0gaW4gci5mdW5jdGlvbnMpe25bbV09blttXXx8e307Zm9yKGxldFtwLGRdb2YgT2JqZWN0LmVudHJpZXMoci5mdW5jdGlvbnNbbV0pKXtsZXQgeT1kLmNvbnN0cnVjdG9yPT09RXM7aXx8PXk7bGV0IGY9ZC5iaW5kKG51bGwscyk7blttXVtwXT15P25ldyBQdChmKTpmfX1pZihpJiYoIVB0fHwhUnQpKXRocm93IG5ldyBUeXBlRXJyb3IoIlRoaXMgcGxhdGZvcm0gZG9lcyBub3Qgc3VwcG9ydCBhc3luYyBmdW5jdGlvbiBpbXBvcnRzIG9uIHRoZSBtYWluIHRocmVhZDsgY29uc2lkZXIgdXNpbmcgYHJ1bkluV29ya2VyYC4iKTtsZXQgbz10LmluZGV4T2YoIm1haW4iKTtpZihvPT09LTEpdGhyb3cgbmV3IEVycm9yKCdVbnJlYWNoYWJsZTogbWFuaWZlc3RzIG11c3QgaGF2ZSBhdCBsZWFzdCBvbmUgIm1haW4iIG1vZHVsZS4gRW5mb3JjZWQgYnkgInNyYy9tYW5pZmVzdC50cyIpJyk7bGV0IGE9bmV3IE1hcCxsPVtdLHU9e3N1c3BlbmRzT25JbnZva2U6aX0sYz1hd2FpdCAkdChzLFsibWFpbiJdLGVbb10sbixyLGwsdCxlLGEsdSk7cmV0dXJuIG5ldyBXdChyLHMsW2Vbb10sY10sbCx1LnN1c3BlbmRzT25JbnZva2UpfWFzeW5jIGZ1bmN0aW9uICR0KHIsdCxlLHMsbixpLG8sYSxsLHUpe2wuc2V0KGUsbnVsbCk7bGV0IGM9e30sbT1XZWJBc3NlbWJseS5Nb2R1bGUuaW1wb3J0cyhlKSxwPW51bGw7Zm9yKGxldHtraW5kOmYsbW9kdWxlOmcsbmFtZTpifW9mIG0pe2xldCBJPW8uaW5kZXhPZihnKTtpZihJPT09LTEpe2lmKGc9PT0id2FzaV9zbmFwc2hvdF9wcmV2aWV3MSImJnA9PT1udWxsKXtpZighaHQuc3VwcG9ydHNXYXNpUHJldmlldzEpdGhyb3cgbmV3IEVycm9yKCJXQVNJIGlzIG5vdCBzdXBwb3J0ZWQgb24gdGhpcyBwbGF0Zm9ybSIpO2lmKCFuLndhc2lFbmFibGVkKXRocm93IG5ldyBFcnJvcignV0FTSSBpcyBub3QgZW5hYmxlZDsgc2VlIHRoZSAidXNlV2FzaSIgcGx1Z2luIG9wdGlvbicpO3A9PT1udWxsJiYocD1hd2FpdCBIdChuLmFsbG93ZWRQYXRocyxuLmVuYWJsZVdhc2lPdXRwdXQpLGkucHVzaChwKSxzLndhc2lfc25hcHNob3RfcHJldmlldzE9YXdhaXQgcC5pbXBvcnRPYmplY3QoKSl9aWYoIU9iamVjdC5oYXNPd25Qcm9wZXJ0eS5jYWxsKHMsZykpdGhyb3cgbmV3IEVycm9yKGBmcm9tIG1vZHVsZSAiJHt0LmpvaW4oJyIvIicpfSI6IGNhbm5vdCByZXNvbHZlIGltcG9ydCAiJHtnfSIgIiR7Yn0iOiBub3QgcHJvdmlkZWQgYnkgaG9zdCBpbXBvcnRzIG5vciBsaW5rZWQgbWFuaWZlc3QgaXRlbXNgKTtpZighT2JqZWN0Lmhhc093blByb3BlcnR5LmNhbGwoc1tnXSxiKSl0aHJvdyBuZXcgRXJyb3IoYGZyb20gbW9kdWxlICIke3Quam9pbignIi8iJyl9IjogY2Fubm90IHJlc29sdmUgaW1wb3J0ICIke2d9IiAiJHtifSIgKCIke2d9IiBpcyBhIGhvc3QgbW9kdWxlLCBidXQgZG9lcyBub3QgY29udGFpbiAiJHtifSIpYCk7aWYoZz09PXEmJmI9PT0iaHR0cF9yZXF1ZXN0IiYmUnQmJnNbZ11bYl09PT1yW3pdLmh0dHBfcmVxdWVzdCYmIW4uZXhlY3V0aW5nSW5Xb3JrZXIpe2xldCBTPW5ldyB3dChuLmZldGNoLG4uYWxsb3dlZEhvc3RzLG4ubWVtb3J5LG4uYWxsb3dIdHRwUmVzcG9uc2VIZWFkZXJzKTt1LnN1c3BlbmRzT25JbnZva2U9ITA7bGV0IE09e307Uy5jb250cmlidXRlKE0pO2ZvcihsZXRbJCxDXW9mIE9iamVjdC5lbnRyaWVzKE1bcV0pKXNbZ11bJF09Qy5iaW5kKG51bGwscik7c1tnXVtiXT1uZXcgUHQoc1tnXVtiXSl9c3dpdGNoKGYpe2Nhc2UiZnVuY3Rpb24iOntjW2ddPz89e30sY1tnXVtiXT1zW2ddW2JdO2JyZWFrfWRlZmF1bHQ6dGhyb3cgbmV3IEVycm9yKGBmcm9tIG1vZHVsZSAiJHt0LmpvaW4oJyIvIicpfSI6IGluIGltcG9ydCAiJHtnfSIgIiR7Yn0iLCAiJHtmfSItdHlwZWQgaG9zdCBpbXBvcnRzIGFyZSBub3Qgc3VwcG9ydGVkIHlldGApfX1lbHNle2xldCBTPWFbSV0sTT1XZWJBc3NlbWJseS5Nb2R1bGUuZXhwb3J0cyhTKTtpZighTS5maW5kKEw9PkwubmFtZT09PWImJkwua2luZD09PWYpKXRocm93IG5ldyBFcnJvcihgZnJvbSBtb2R1bGUgIiR7dC5qb2luKCciLyInKX0iOiBjYW5ub3QgaW1wb3J0ICIke2d9IiAiJHtifSI7IG5vIGV4cG9ydCBtYXRjaGVkIHJlcXVlc3RgKTtsZXQgQz1NLmZpbmQoTD0+TC5uYW1lPT09Il9zdGFydCIpP2F3YWl0ICR0KHIsWy4uLnQsZ10sUyxzLG4saSxvLGEsbmV3IE1hcCx1KToobC5oYXMoUyl8fGF3YWl0ICR0KHIsWy4uLnQsZ10sUyxzLG4saSxvLGEsbCx1KSxsLmdldChTKSk7aWYoQyljW2ddPz89e30sY1tnXVtiXT1DLmV4cG9ydHNbYl07ZWxzZSBpZihmPT09ImZ1bmN0aW9uIil7Y1tnXT17fTtsZXQgTD1udWxsO2NbZ11bYl09KC4uLnN0KT0+e2lmKEwpcmV0dXJuIEwoLi4uc3QpO2xldCBSPWwuZ2V0KGFbSV0pO2lmKCFSKXRocm93IG5ldyBFcnJvcihgZnJvbSBtb2R1bGUgaW5zdGFuY2UgIiR7dC5qb2luKCciLyInKX0iOiB0YXJnZXQgbW9kdWxlICIke2d9IiB3YXMgbmV2ZXIgaW5zdGFudGlhdGVkYCk7cmV0dXJuIEw9Ui5leHBvcnRzW2JdLEwoLi4uc3QpfX1lbHNlIHRocm93IG5ldyBFcnJvcihgZnJvbSBtb2R1bGUgIiR7dC5qb2luKCciLyInKX0iOiBjYW5ub3QgaW1wb3J0ICIke2d9IiAiJHtifSI7IGNpcmN1bGFyIGltcG9ydHMgb2YgdHlwZT0iJHtmfSIgYXJlIG5vdCBzdXBwb3J0ZWRgKX19bGV0IGQ9YXdhaXQgV2ViQXNzZW1ibHkuaW5zdGFudGlhdGUoZSxjKSx5PWQuZXhwb3J0cy5oc19pbml0PyJoYXNrZWxsIjpkLmV4cG9ydHMuX2luaXRpYWxpemU/InJlYWN0b3IiOmQuZXhwb3J0cy5fc3RhcnQ/ImNvbW1hbmQiOiJub25lIjtpZihwKWF3YWl0IHA/LmluaXRpYWxpemUoZCksZC5leHBvcnRzLmhzX2luaXQmJmQuZXhwb3J0cy5oc19pbml0KCk7ZWxzZSBzd2l0Y2goeSl7Y2FzZSJjb21tYW5kIjpkLmV4cG9ydHMuX2luaXRpYWxpemUmJmQuZXhwb3J0cy5faW5pdGlhbGl6ZSgpLGQuZXhwb3J0cy5fc3RhcnQoKTticmVhaztjYXNlInJlYWN0b3IiOmQuZXhwb3J0cy5faW5pdGlhbGl6ZSgpO2JyZWFrO2Nhc2UiaGFza2VsbCI6ZC5leHBvcnRzLmhzX2luaXQoKTticmVha31yZXR1cm4gbC5zZXQoZSxkKSxkfXZhciBOdD1jbGFzc3tjb25zdHJ1Y3Rvcih0KXtpZighdCl0aHJvdyBuZXcgRXJyb3IoIlRoaXMgc2hvdWxkIGJlIHVucmVhY2hhYmxlOiB0aGlzIG1vZHVsZSBzaG91bGQgb25seSBiZSBpbnZva2VkIGFzIGEgd2ViIHdvcmtlci4iKTt0aGlzLnNoYXJlZERhdGE9bnVsbCx0aGlzLnNoYXJlZERhdGFWaWV3PW51bGwsdGhpcy5ob3N0RmxhZz1udWxsLHRoaXMucG9ydD10LHRoaXMucG9ydC5vbigibWVzc2FnZSIsZT0+dGhpcy5oYW5kbGVNZXNzYWdlKGUpKSx0aGlzLnBvcnQucG9zdE1lc3NhZ2Uoe3R5cGU6ImluaXRpYWxpemVkIn0pLHRoaXMuZHluYW1pY0hhbmRsZXJzPW5ldyBNYXAsdGhpcy5keW5hbWljSGFuZGxlcnMuc2V0KCJjYWxsIixhc3luYyhlLHMsbixpKT0+e2lmKCF0aGlzLmNvbnRleHQpdGhyb3cgbmV3IEVycm9yKCJpbnZhbGlkIHN0YXRlOiBubyBjb250ZXh0IGF2YWlsYWJsZSB0byB3b3JrZXIgcmVhY3RvciIpO3RoaXMuY29udGV4dFtmdF0oaSk7bGV0IG89YXdhaXQgdGhpcy5wbHVnaW4/LmNhbGxCbG9jayhzLG4pLnRoZW4oYT0+W251bGwsYV0sYT0+W2EsbnVsbF0pO2k9dGhpcy5jb250ZXh0W3B0XSgpO2ZvcihsZXRbYV1vZiBpLmJsb2NrcylhJiZlLnB1c2goYSk7cmV0dXJuIG9bMF0mJihvWzBdPXtvcmlnaW5hbFN0YWNrOm9bMF0/LnN0YWNrLG1lc3NhZ2U6b1swXT8ubWVzc2FnZX0pLHtyZXN1bHRzOm8sc3RhdGU6aX19KSx0aGlzLmR5bmFtaWNIYW5kbGVycy5zZXQoInJlc2V0Iixhc3luYyBlPT50aGlzLnBsdWdpbj8ucmVzZXQoKSksdGhpcy5keW5hbWljSGFuZGxlcnMuc2V0KCJnZXRFeHBvcnRzIixhc3luYyBlPT50aGlzLnBsdWdpbj8uZ2V0RXhwb3J0cygpKSx0aGlzLmR5bmFtaWNIYW5kbGVycy5zZXQoImdldEltcG9ydHMiLGFzeW5jIGU9PnRoaXMucGx1Z2luPy5nZXRJbXBvcnRzKCkpLHRoaXMuZHluYW1pY0hhbmRsZXJzLnNldCgiZnVuY3Rpb25FeGlzdHMiLGFzeW5jKGUscyk9PnRoaXMucGx1Z2luPy5mdW5jdGlvbkV4aXN0cyhzKSl9YXN5bmMgaGFuZGxlTWVzc2FnZSh0KXtzd2l0Y2godC50eXBlKXtjYXNlImluaXQiOnJldHVybiBhd2FpdCB0aGlzLmhhbmRsZUluaXQodCk7Y2FzZSJpbnZva2UiOnJldHVybiBhd2FpdCB0aGlzLmhhbmRsZUludm9rZSh0KX19YXN5bmMgaGFuZGxlSW52b2tlKHQpe2xldCBlPXRoaXMuZHluYW1pY0hhbmRsZXJzLmdldCh0LmhhbmRsZXIpO2lmKCFlKXJldHVybiB0aGlzLnBvcnQucG9zdE1lc3NhZ2Uoe3R5cGU6InJldHVybiIscmVzdWx0Oltgbm8gaGFuZGxlciByZWdpc3RlcmVkIGZvciAke3QuaGFuZGxlcn1gLG51bGxdfSk7bGV0IHM9W10sbj1hd2FpdCBlKHMsLi4udC5hcmdzfHxbXSkudGhlbihpPT5bbnVsbCxpXSxpPT5baSxudWxsXSk7cmV0dXJuIG5bMF0mJihuWzBdPXtvcmlnaW5hbFN0YWNrOm5bMF0/LnN0YWNrLG1lc3NhZ2U6blswXT8ubWVzc2FnZX0pLHRoaXMucG9ydC5wb3N0TWVzc2FnZSh7dHlwZToicmV0dXJuIixyZXN1bHRzOm59LHMpfWFzeW5jIGhhbmRsZUluaXQodCl7dGhpcy5zaGFyZWREYXRhPXQuc2hhcmVkRGF0YSx0aGlzLnNoYXJlZERhdGFWaWV3PW5ldyBEYXRhVmlldyh0LnNoYXJlZERhdGEpLHRoaXMuaG9zdEZsYWc9bmV3IEludDMyQXJyYXkodGhpcy5zaGFyZWREYXRhKTtsZXQgZT1PYmplY3QuZnJvbUVudHJpZXMoT2JqZWN0LmVudHJpZXModC5mdW5jdGlvbnMpLm1hcCgoW3UsY10pPT5bdSxPYmplY3QuZnJvbUVudHJpZXMoYy5tYXAobT0+W20sKHAsLi4uZCk9PnRoaXMuY2FsbEhvc3QocCx1LG0sZCldKSldKSkse3R5cGU6cyxtb2R1bGVzOm4sZnVuY3Rpb25zOmksLi4ub309dCxhPXU9PmM9PnRoaXMucG9ydC5wb3N0TWVzc2FnZSh7dHlwZToibG9nIixsZXZlbDp1LG1lc3NhZ2U6Y30pLGw9T2JqZWN0LmZyb21FbnRyaWVzKFsiaW5mbyIsImRlYnVnIiwid2FybiIsImVycm9yIiwidHJhY2UiXS5tYXAodT0+W3UsYSh1KV0pKTt0aGlzLmNvbnRleHQ9bmV3IFkoQXJyYXlCdWZmZXIsbCx0LmxvZ0xldmVsLHQuY29uZmlnLHQubWVtb3J5KSx0aGlzLnBsdWdpbj1hd2FpdCB3ZSh7Li4ubyxmdW5jdGlvbnM6ZSxmZXRjaCxsb2dnZXI6bCxleGVjdXRpbmdJbldvcmtlcjohMH0sdC5uYW1lcyxuLHRoaXMuY29udGV4dCksdGhpcy5wb3J0LnBvc3RNZXNzYWdlKHt0eXBlOiJyZWFkeSJ9KX1jYWxsSG9zdCh0LGUscyxuKXtpZighdGhpcy5ob3N0RmxhZyl0aHJvdyBuZXcgRXJyb3IoImF0dGVtcHRlZCB0byBjYWxsIGhvc3QgYmVmb3JlIHJlY2VpdmluZyBzaGFyZWQgYXJyYXkgYnVmZmVyIik7QXRvbWljcy5zdG9yZSh0aGlzLmhvc3RGbGFnLDAsTik7bGV0IGk9dFtwdF0oKTt0aGlzLnBvcnQucG9zdE1lc3NhZ2Uoe3R5cGU6Imludm9rZSIsbmFtZXNwYWNlOmUsZnVuYzpzLGFyZ3M6bixzdGF0ZTppfSk7bGV0IG89bmV3IHh0KHRoaXMuc2hhcmVkRGF0YSksYT1bXSxsO2Rve2xldCB1PW8ucmVhZFVpbnQ4KCk7c3dpdGNoKHUpe2Nhc2UgMjU1OnJldHVybiBpLmJsb2Nrcz1hLHRbZnRdKGkpLG8uY2xvc2UoKSxsO2Nhc2UgMTpsPW8ucmVhZFVpbnQ2NCgpO2JyZWFrO2Nhc2UgMjpsPW8ucmVhZEZsb2F0NjQoKTticmVhaztjYXNlIDM6bD12b2lkIDA7YnJlYWs7Y2FzZSA0OntsZXQgYz1vLnJlYWRVaW50MzIoKSxtPW8ucmVhZFVpbnQzMigpO2lmKCFtKWEucHVzaChbbnVsbCxjXSk7ZWxzZXtsZXQgcD1uZXcgVWludDhBcnJheShtKTtvLnJlYWQocCksYS5wdXNoKFtwLmJ1ZmZlcixjXSl9fWJyZWFrO2RlZmF1bHQ6dGhyb3cgbmV3IEVycm9yKGBpbnZhbGlkIHNlY3Rpb24gdHlwZT0iJHt1fSIgYXQgcG9zaXRpb24gJHtvLnBvc2l0aW9ufTsgcGxlYXNlIG9wZW4gYW4gaXNzdWUgKGh0dHBzOi8vZ2l0aHViLmNvbS9leHRpc20vanMtc2RrL2lzc3Vlcy9uZXc/dGl0bGU9c2hhcmVkK2FycmF5K2J1ZmZlcitiYWQrc2VjdGlvbit0eXBlKyR7dX0mbGFiZWxzPWJ1ZylgKX19d2hpbGUoMSl9fTtuZXcgTnQoQXMpO3ZhciBrcz01MDAsZXQseHQ9Y2xhc3N7Y29uc3RydWN0b3IodCl7RSh0aGlzLGV0LHZvaWQgMCk7dGhpcy5pbnB1dD10LHRoaXMuaW5wdXRPZmZzZXQ9Tix0aGlzLmZsYWc9bmV3IEludDMyQXJyYXkodGhpcy5pbnB1dCksdGhpcy5zY3JhdGNoPW5ldyBBcnJheUJ1ZmZlcig4KSx0aGlzLnNjcmF0Y2hWaWV3PW5ldyBEYXRhVmlldyh0aGlzLnNjcmF0Y2gpLHRoaXMucG9zaXRpb249MCx4KHRoaXMsZXQsMCksdGhpcy53YWl0KCl9Y2xvc2UoKXt0aGlzLnNpZ25hbCgpLEF0b21pY3Muc3RvcmUodGhpcy5mbGFnLDAsTil9d2FpdCgpe2xldCB0PU47ZG8gdD1BdG9taWNzLmxvYWQodGhpcy5mbGFnLDApLHQ9PT1OJiZBdG9taWNzLndhaXQodGhpcy5mbGFnLDAsTixrcyk7d2hpbGUodDw9Tik7eCh0aGlzLGV0LEF0b21pY3MubG9hZCh0aGlzLmZsYWcsMCkpLHRoaXMuaW5wdXRPZmZzZXQ9Tn1nZXQgYXZhaWxhYmxlKCl7cmV0dXJuIGgodGhpcyxldCktdGhpcy5pbnB1dE9mZnNldH1zaWduYWwoKXtBdG9taWNzLnN0b3JlKHRoaXMuZmxhZywwLE4pLEF0b21pY3Mubm90aWZ5KHRoaXMuZmxhZywwLDEpfXB1bGwoKXt0aGlzLnNpZ25hbCgpLHRoaXMud2FpdCgpfXJlYWQodCl7aWYodGhpcy5wb3NpdGlvbis9dC5ieXRlTGVuZ3RoLHQuYnl0ZUxlbmd0aDx0aGlzLmF2YWlsYWJsZSl7dC5zZXQobmV3IFVpbnQ4QXJyYXkodGhpcy5pbnB1dCkuc3ViYXJyYXkodGhpcy5pbnB1dE9mZnNldCx0aGlzLmlucHV0T2Zmc2V0K3QuYnl0ZUxlbmd0aCkpLHRoaXMuaW5wdXRPZmZzZXQrPXQuYnl0ZUxlbmd0aDtyZXR1cm59bGV0IGU9MCxzPXRoaXMuYXZhaWxhYmxlO2Rve2lmKHQuc2V0KG5ldyBVaW50OEFycmF5KHRoaXMuaW5wdXQpLnN1YmFycmF5KHRoaXMuaW5wdXRPZmZzZXQsdGhpcy5pbnB1dE9mZnNldCtzKSxlKSxlKz1zLHRoaXMuaW5wdXRPZmZzZXQrPXMsZT09PXQuYnl0ZUxlbmd0aHx8dGhpcy5hdmFpbGFibGU8MClicmVhazt0aGlzLnB1bGwoKSxzPU1hdGgubWluKE1hdGgubWF4KHRoaXMuYXZhaWxhYmxlLDApLHQuYnl0ZUxlbmd0aC1lKX13aGlsZShlIT09dC5ieXRlTGVuZ3RoKX1yZWFkVWludDgoKXtyZXR1cm4gdGhpcy5yZWFkKG5ldyBVaW50OEFycmF5KHRoaXMuc2NyYXRjaCkuc3ViYXJyYXkoMCwxKSksdGhpcy5zY3JhdGNoVmlldy5nZXRVaW50OCgwKX1yZWFkVWludDMyKCl7cmV0dXJuIHRoaXMucmVhZChuZXcgVWludDhBcnJheSh0aGlzLnNjcmF0Y2gpLnN1YmFycmF5KDAsNCkpLHRoaXMuc2NyYXRjaFZpZXcuZ2V0VWludDMyKDAsITApfXJlYWRVaW50NjQoKXtyZXR1cm4gdGhpcy5yZWFkKG5ldyBVaW50OEFycmF5KHRoaXMuc2NyYXRjaCkpLHRoaXMuc2NyYXRjaFZpZXcuZ2V0QmlnVWludDY0KDAsITApfXJlYWRGbG9hdDY0KCl7cmV0dXJuIHRoaXMucmVhZChuZXcgVWludDhBcnJheSh0aGlzLnNjcmF0Y2gpKSx0aGlzLnNjcmF0Y2hWaWV3LmdldEZsb2F0NjQoMCwhMCl9fTtldD1uZXcgV2Vha01hcCx4dC5TQUJfSURYPTA7Cg==");

// src/background-plugin.ts
import { Worker } from "node:worker_threads";
var AtomicsWaitAsync = Atomics.waitAsync || (() => {
  const src = `onmessage = ev => {
    const [b, i, v] = ev.data
    const f = new Int32Array(b)
    postMessage(Atomics.wait(f, i, v));
  }`;
  const blob = new Blob([src], { type: "text/javascript" });
  const url = URL.createObjectURL(blob);
  const w = new Worker(url, { execArgv: [] });
  return (ia, index, value) => {
    const promise = new Promise((resolve) => {
      w.once("message", (data) => {
        resolve(data);
      });
    });
    w.postMessage([ia.buffer, index, value]);
    return { async: true, value: promise };
  };
})();
var BackgroundPlugin = class {
  constructor(worker, sharedData, names, modules, opts, context) {
    this.#request = null;
    this.sharedData = sharedData;
    this.sharedDataView = new DataView(sharedData);
    this.hostFlag = new Int32Array(sharedData);
    this.opts = opts;
    this.names = names;
    this.modules = modules;
    this.worker = worker;
    this.#context = context;
    this.hostFlag[0] = SAB_BASE_OFFSET;
    this.worker.on("message", (ev) => this.#handleMessage(ev));
  }
  #context;
  #request;
  async #handleTimeout() {
    const request = this.#request;
    this.#request = [() => {
    }, () => {
    }];
    const timedOut = {};
    const failed = {};
    const result = await Promise.race(
      [
        timeout(this.opts.timeoutMs, timedOut),
        Promise.all([terminateWorker(this.worker), createWorker(this.opts, this.names, this.modules, this.sharedData)])
      ].filter(Boolean)
    ).catch(() => failed);
    this.#context[RESET]();
    if (result === timedOut) {
      this.opts.logger.error(
        "EXTISM: Plugin timed out while handling a timeout. Plugin will hang. This Wasm module may have a non-trivial `start` section."
      );
      this.worker = null;
      return;
    }
    if (result === failed) {
      this.opts.logger.error("EXTISM: Plugin failed to restart during a timeout. Plugin will hang.");
      this.worker = null;
      return;
    }
    const [, worker] = result;
    this.worker = worker;
    if (request) {
      request.pop()(new Error("EXTISM: call canceled due to timeout"));
    }
    this.#request = null;
    this.worker.on("message", (ev) => this.#handleMessage(ev));
  }
  async reset() {
    if (this.isActive()) {
      return false;
    }
    await this.#invoke("reset");
    this.#context[RESET]();
    return true;
  }
  isActive() {
    return Boolean(this.#request);
  }
  async #handleMessage(ev) {
    switch (ev?.type) {
      case "invoke":
        return this.#handleInvoke(ev);
      case "return":
        return this.#handleReturn(ev);
      case "log":
        return this.#handleLog(ev);
    }
  }
  #handleLog(ev) {
    const fn = this.opts.logger[ev.level];
    if (typeof fn !== "function") {
      this.opts.logger?.error(`failed to find loglevel="${ev.level}" on logger: message=${ev.message}`);
    } else {
      fn.call(this.opts.logger, ev.message);
    }
  }
  #handleReturn(ev) {
    const responder = this.#request || null;
    if (responder === null) {
      throw new Error(`received "return" call with no corresponding request`);
    }
    this.#request = null;
    const [resolve, reject] = responder;
    if (!Array.isArray(ev.results) || ev.results.length !== 2) {
      return reject(new Error(`received malformed "return"`));
    }
    const [err, data] = ev.results;
    err ? reject(err) : resolve(data);
  }
  async #invoke(handler, ...args) {
    if (this.#request) {
      throw new Error("plugin is not reentrant");
    }
    let resolve, reject;
    const promise = new Promise((res, rej) => {
      resolve = res;
      reject = rej;
    });
    this.#request = [resolve, reject];
    if (!this.worker) {
      throw new Error("worker not initialized");
    }
    const timedOut = {};
    Promise.race([timeout(this.opts.timeoutMs, timedOut), promise].filter(Boolean)).then(
      async (v) => {
        if (v === timedOut) {
          await this.#handleTimeout();
        }
      },
      () => {
      }
    );
    this.worker.postMessage({
      type: "invoke",
      handler,
      args
    });
    return promise;
  }
  async functionExists(funcName) {
    return await this.#invoke("functionExists", funcName);
  }
  async call(funcName, input, hostContext) {
    const index = this.#context[STORE](input);
    this.#context[SET_HOST_CONTEXT](hostContext);
    const [errorIdx, outputIdx] = await this.callBlock(funcName, index);
    const shouldThrow = errorIdx !== null;
    const idx = errorIdx ?? outputIdx;
    if (idx === null) {
      return null;
    }
    const block = this.#context[GET_BLOCK](idx);
    if (block === null) {
      return null;
    }
    const buf = new PluginOutput(
      CAPABILITIES.allowSharedBufferCodec ? block.buffer : new Uint8Array(block.buffer).slice().buffer
    );
    if (shouldThrow) {
      const msg = new TextDecoder().decode(buf);
      throw new Error(`Plugin-originated error: ${msg}`);
    }
    return buf;
  }
  async callBlock(funcName, input) {
    const exported = this.#context[EXPORT_STATE]();
    const { results, state } = await this.#invoke("call", funcName, input, exported);
    this.#context[IMPORT_STATE](state, true);
    const [err, data] = results;
    if (err) {
      throw err;
    }
    return data;
  }
  async getExports() {
    return await this.#invoke("getExports");
  }
  async getImports() {
    return await this.#invoke("getImports");
  }
  async getInstance() {
    throw new Error("todo");
  }
  async close() {
    if (this.worker) {
      await terminateWorker(this.worker);
      this.worker = null;
    }
  }
  async #handleInvoke(ev) {
    const writer = new RingBufferWriter(this.sharedData);
    const namespace = this.opts.functions[ev.namespace];
    const func = (namespace ?? {})[ev.func];
    const timer = setInterval(() => {
    }, 0);
    try {
      if (!func) {
        throw Error(`Plugin error: host function "${ev.namespace}" "${ev.func}" does not exist`);
      }
      new Uint8Array(this.sharedData).subarray(8).fill(254);
      this.#context[IMPORT_STATE](ev.state, true);
      const data = await func(this.#context, ...ev.args);
      const { blocks } = this.#context[EXPORT_STATE]();
      let promise;
      for (const [buffer, destination] of blocks) {
        promise = writer.writeUint8(4 /* Block */);
        if (promise) {
          await promise;
        }
        promise = writer.writeUint32(destination);
        if (promise) {
          await promise;
        }
        promise = writer.writeUint32(buffer?.byteLength || 0);
        if (promise) {
          await promise;
        }
        if (buffer) {
          promise = writer.write(buffer);
          if (promise) {
            await promise;
          }
        }
      }
      if (typeof data === "bigint") {
        promise = writer.writeUint8(1 /* RetI64 */);
        if (promise) {
          await promise;
        }
        promise = writer.writeUint64(data);
        if (promise) {
          await promise;
        }
      } else if (typeof data === "number") {
        promise = writer.writeUint8(2 /* RetF64 */);
        if (promise) {
          await promise;
        }
        promise = writer.writeFloat64(data);
        if (promise) {
          await promise;
        }
      } else {
        promise = writer.writeUint8(3 /* RetVoid */);
        if (promise) {
          await promise;
        }
      }
      promise = writer.writeUint8(255 /* End */);
      if (promise) {
        await promise;
      }
      await writer.flush();
    } catch (err) {
      this.close();
      const [, reject] = this.#request;
      this.#request = null;
      return reject(err);
    } finally {
      clearInterval(timer);
    }
  }
};
var MAX_WAIT = 500;
var RingBufferWriter = class {
  constructor(output) {
    this.scratch = new ArrayBuffer(8);
    this.scratchView = new DataView(this.scratch);
    this.output = output;
    this.outputOffset = SAB_BASE_OFFSET;
    this.flag = new Int32Array(this.output);
    this.wait(0);
  }
  async wait(lastKnownValue) {
    let value = 0;
    do {
      value = Atomics.load(this.flag, 0);
      if (value === lastKnownValue) {
        const { value: result, async } = AtomicsWaitAsync(this.flag, 0, lastKnownValue, MAX_WAIT);
        if (async) {
          if (await result === "timed-out") {
            continue;
          }
        }
      }
    } while (value === lastKnownValue);
  }
  signal() {
    const old = Atomics.load(this.flag, 0);
    while (Atomics.compareExchange(this.flag, 0, old, this.outputOffset) === old) {
    }
    Atomics.notify(this.flag, 0, 1);
  }
  async flush() {
    if (this.outputOffset === SAB_BASE_OFFSET) {
      return;
    }
    const workerId = this.outputOffset;
    this.signal();
    this.outputOffset = SAB_BASE_OFFSET;
    await this.wait(workerId);
  }
  async spanningWrite(input) {
    let inputOffset = 0;
    let toWrite = this.output.byteLength - this.outputOffset;
    let flushedWriteCount = 1 + Math.floor((input.byteLength - toWrite) / (this.output.byteLength - SAB_BASE_OFFSET));
    const finalWrite = (input.byteLength - toWrite) % (this.output.byteLength - SAB_BASE_OFFSET);
    do {
      new Uint8Array(this.output).set(input.subarray(inputOffset, inputOffset + toWrite), this.outputOffset);
      this.outputOffset += toWrite;
      inputOffset += toWrite;
      await this.flush();
      toWrite = this.output.byteLength - SAB_BASE_OFFSET;
      --flushedWriteCount;
    } while (flushedWriteCount != 0);
    if (finalWrite) {
      this.write(input.subarray(inputOffset, inputOffset + finalWrite));
    }
  }
  write(bytes) {
    if (bytes.byteLength + this.outputOffset < this.output.byteLength) {
      new Uint8Array(this.output).set(new Uint8Array(bytes), this.outputOffset);
      this.outputOffset += bytes.byteLength;
      return;
    }
    return this.spanningWrite(new Uint8Array(bytes));
  }
  writeUint8(value) {
    this.scratchView.setUint8(0, value);
    return this.write(this.scratch.slice(0, 1));
  }
  writeUint32(value) {
    this.scratchView.setUint32(0, value, true);
    return this.write(this.scratch.slice(0, 4));
  }
  writeUint64(value) {
    this.scratchView.setBigUint64(0, value, true);
    return this.write(this.scratch.slice(0, 8));
  }
  writeFloat64(value) {
    this.scratchView.setFloat64(0, value, true);
    return this.write(this.scratch.slice(0, 8));
  }
};
RingBufferWriter.SAB_IDX = 0;
async function createBackgroundPlugin(opts, names, modules) {
  const context = new CallContext(SharedArrayBuffer, opts.logger, opts.logLevel, opts.config, opts.memory);
  const httpContext = new HttpContext(opts.fetch, opts.allowedHosts, opts.memory, opts.allowHttpResponseHeaders);
  httpContext.contribute(opts.functions);
  opts.functions[EXTISM_ENV] ??= {};
  opts.functions[EXTISM_ENV].var_get ??= (_, key) => {
    return context[ENV].var_get(key);
  };
  opts.functions[EXTISM_ENV].var_set ??= (_, key, val) => {
    return context[ENV].var_set(key, val);
  };
  const sharedData = new SharedArrayBuffer(opts.sharedArrayBufferSize);
  new Uint8Array(sharedData).subarray(8).fill(254);
  const timedOut = {};
  let earlyWorker;
  const onworker = (w) => {
    earlyWorker = w;
  };
  const worker = await Promise.race(
    [timeout(opts.timeoutMs, timedOut), createWorker(opts, names, modules, sharedData, onworker)].filter(Boolean)
  );
  if (worker === timedOut) {
    await terminateWorker(earlyWorker);
    throw new Error("EXTISM: timed out while waiting for plugin to instantiate");
  }
  return new BackgroundPlugin(worker, sharedData, names, modules, opts, context);
}
async function createWorker(opts, names, modules, sharedData, onworker = (_w) => {
}) {
  const worker = new Worker(WORKER_URL, opts.nodeWorkerArgs);
  onworker(worker);
  await new Promise((resolve, reject) => {
    worker.on("message", function handler(ev) {
      if (ev?.type !== "initialized") {
        reject(new Error(`received unexpected message (type=${ev?.type})`));
      }
      worker.removeListener("message", handler);
      resolve(null);
    });
  });
  const onready = new Promise((resolve, reject) => {
    worker.on("message", function handler(ev) {
      if (ev?.type !== "ready") {
        reject(new Error(`received unexpected message (type=${ev?.type})`));
      }
      worker.removeListener("message", handler);
      resolve(null);
    });
  });
  const { fetch: _, logger: __, ...rest } = opts;
  const message = {
    ...rest,
    type: "init",
    functions: Object.fromEntries(Object.entries(opts.functions || {}).map(([k, v]) => [k, Object.keys(v)])),
    names,
    modules,
    sharedData
  };
  worker.postMessage(message);
  await onready;
  return worker;
}
function timeout(ms, sentinel) {
  return ms === null ? null : new Promise((resolve) => setTimeout(() => resolve(sentinel), ms));
}
async function terminateWorker(w) {
  if (typeof globalThis.Bun !== "undefined") {
    const timer = setTimeout(() => {
    }, 10);
    await w.terminate();
    clearTimeout(timer);
  } else {
    await w.terminate();
  }
}

// src/mod.ts
async function createPlugin(manifest, opts = {}) {
  opts = { ...opts };
  opts.useWasi ??= false;
  opts.enableWasiOutput ??= opts.useWasi ? CAPABILITIES.extismStdoutEnvVarSet : false;
  opts.functions = opts.functions || {};
  opts.runInWorker ??= false;
  opts.logger ??= console;
  opts.logLevel ??= "silent";
  opts.fetch ??= fetch;
  const [manifestOpts, names, moduleData] = await toWasmModuleData(
    await Promise.resolve(manifest),
    opts.fetch ?? fetch
  );
  opts.allowedPaths = opts.allowedPaths || manifestOpts.allowedPaths || {};
  opts.allowedHosts = opts.allowedHosts || manifestOpts.allowedHosts || [];
  opts.config = opts.config || manifestOpts.config || {};
  opts.memory = opts.memory || manifestOpts.memory || {};
  opts.timeoutMs = opts.timeoutMs || manifestOpts.timeoutMs || null;
  opts.nodeWorkerArgs = Object.assign(
    {
      name: "extism plugin",
      execArgv: ["--disable-warning=ExperimentalWarning"]
    },
    opts.nodeWorkerArgs || {}
  );
  if (opts.allowedHosts.length && !opts.runInWorker) {
    if (!WebAssembly.Suspending) {
      throw new TypeError(
        '"allowedHosts" requires "runInWorker: true". HTTP functions are only available to plugins running in a worker.'
      );
    }
  }
  if (opts.timeoutMs && !opts.runInWorker) {
    throw new TypeError(
      '"timeout" requires "runInWorker: true". Call timeouts are only available to plugins running in a worker.'
    );
  }
  if (opts.runInWorker && !CAPABILITIES.hasWorkerCapability) {
    throw new Error(
      "Cannot enable off-thread wasm; current context is not `crossOriginIsolated` (see https://mdn.io/crossOriginIsolated)"
    );
  }
  for (const guest in opts.allowedPaths) {
    const host = opts.allowedPaths[guest];
    if (host.startsWith("ro:")) {
      throw new Error(`Readonly dirs are not supported: ${host}`);
    }
  }
  const ic = {
    executingInWorker: false,
    allowedHosts: opts.allowedHosts,
    allowedPaths: opts.allowedPaths,
    functions: opts.functions,
    fetch: opts.fetch || fetch,
    wasiEnabled: opts.useWasi,
    logger: opts.logger,
    logLevel: logLevelToPriority(opts.logLevel || "silent"),
    config: opts.config,
    enableWasiOutput: opts.enableWasiOutput,
    sharedArrayBufferSize: Number(opts.sharedArrayBufferSize) || 1 << 16,
    timeoutMs: opts.timeoutMs,
    memory: opts.memory,
    allowHttpResponseHeaders: !!opts.allowHttpResponseHeaders,
    nodeWorkerArgs: opts.nodeWorkerArgs || {}
  };
  return (opts.runInWorker ? createBackgroundPlugin : createForegroundPlugin)(ic, names, moduleData);
}
var mod_default = createPlugin;
export {
  CAPABILITIES,
  createPlugin,
  mod_default as default,
  createPlugin as newPlugin
};
//# sourceMappingURL=mod.js.map
