/// <reference types="node" />
import { CallContext } from './call-context.ts';
import { type InternalConfig, PluginOutput } from './interfaces.ts';
import { Worker } from 'node:worker_threads';
declare class BackgroundPlugin {
    #private;
    sharedData: SharedArrayBuffer;
    sharedDataView: DataView;
    hostFlag: Int32Array;
    opts: InternalConfig;
    worker: Worker;
    modules: WebAssembly.Module[];
    names: string[];
    constructor(worker: Worker, sharedData: SharedArrayBuffer, names: string[], modules: WebAssembly.Module[], opts: InternalConfig, context: CallContext);
    reset(): Promise<boolean>;
    isActive(): boolean;
    functionExists(funcName: string): Promise<boolean>;
    call<T = any>(funcName: string, input?: string | Uint8Array, hostContext?: T): Promise<PluginOutput | null>;
    callBlock(funcName: string, input: number | null): Promise<[number | null, number | null]>;
    getExports(): Promise<WebAssembly.ModuleExportDescriptor[]>;
    getImports(): Promise<WebAssembly.ModuleImportDescriptor[]>;
    getInstance(): Promise<WebAssembly.Instance>;
    close(): Promise<void>;
}
export declare function createBackgroundPlugin(opts: InternalConfig, names: string[], modules: WebAssembly.Module[]): Promise<BackgroundPlugin>;
export {};
