"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedColumn = void 0;
const column_decorator_1 = require("./column.decorator");
const GeneratedColumn = ({ strategy = 'uuid', ...options }) => {
    let columnType;
    let columnDefault;
    switch (strategy) {
        case 'uuid': {
            columnType = 'uuid';
            columnDefault = () => 'uuid_generate_v4()';
            break;
        }
        case 'identity': {
            columnType = 'integer';
            options.identity = true;
            break;
        }
        default: {
            throw new Error(`Unsupported strategy for @GeneratedColumn ${strategy}`);
        }
    }
    return (0, column_decorator_1.Column)({
        type: columnType,
        default: columnDefault,
        ...options,
    });
};
exports.GeneratedColumn = GeneratedColumn;
//# sourceMappingURL=generated-column.decorator.js.map