"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.up = up;
exports.down = down;
const kysely_1 = require("kysely");
async function up(db) {
    await (0, kysely_1.sql) `CREATE TYPE "asset_visibility_enum" AS ENUM ('archive','timeline','hidden');`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "assets"
    ADD "visibility" asset_visibility_enum NOT NULL DEFAULT 'timeline';`.execute(db);
    await (0, kysely_1.sql) `
    UPDATE "assets"
    SET "visibility" = CASE
                        WHEN "isArchived" THEN 'archive'::asset_visibility_enum
                        WHEN "isVisible" THEN 'timeline'::asset_visibility_enum
                        ELSE 'hidden'::asset_visibility_enum
                      END;
  `.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "assets" DROP COLUMN "isVisible";`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "assets" DROP COLUMN "isArchived";`.execute(db);
}
async function down(db) {
    await (0, kysely_1.sql) `ALTER TABLE "assets" ADD COLUMN "isArchived" BOOLEAN NOT NULL DEFAULT FALSE;`.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "assets" ADD COLUMN "isVisible" BOOLEAN NOT NULL DEFAULT TRUE;`.execute(db);
    await (0, kysely_1.sql) `
      UPDATE "assets"
      SET
        "isArchived" = ("visibility" = 'archive'::asset_visibility_enum),
        "isVisible" = CASE
                        WHEN "visibility" = 'timeline'::asset_visibility_enum THEN TRUE
                        WHEN "visibility" = 'archive'::asset_visibility_enum THEN TRUE
                        ELSE FALSE
                      END;
    `.execute(db);
    await (0, kysely_1.sql) `ALTER TABLE "assets" DROP COLUMN "visibility";`.execute(db);
    await (0, kysely_1.sql) `DROP TYPE "asset_visibility_enum";`.execute(db);
}
//# sourceMappingURL=1745902563899-AddAssetVisibilityColumn.js.map