import { Selectable } from 'kysely';
import { AssetFace, Person } from 'src/database';
import { AuthDto } from 'src/dtos/auth.dto';
import { AssetEditActionItem } from 'src/dtos/editing.dto';
import { SourceType } from 'src/enum';
import { AssetFaceTable } from 'src/schema/tables/asset-face.table';
import { ImageDimensions } from 'src/types';
export declare class PersonCreateDto {
    name?: string;
    birthDate?: Date | null;
    isHidden?: boolean;
    isFavorite?: boolean;
    color?: string | null;
}
export declare class PersonUpdateDto extends PersonCreateDto {
    featureFaceAssetId?: string;
}
export declare class PeopleUpdateDto {
    people: PeopleUpdateItem[];
}
export declare class PeopleUpdateItem extends PersonUpdateDto {
    id: string;
}
export declare class MergePersonDto {
    ids: string[];
}
export declare class PersonSearchDto {
    withHidden?: boolean;
    closestPersonId?: string;
    closestAssetId?: string;
    page: number;
    size: number;
}
export declare class PersonResponseDto {
    id: string;
    name: string;
    birthDate: string | null;
    thumbnailPath: string;
    isHidden: boolean;
    updatedAt?: Date;
    isFavorite?: boolean;
    color?: string;
}
export declare class PersonWithFacesResponseDto extends PersonResponseDto {
    faces: AssetFaceWithoutPersonResponseDto[];
}
export declare class AssetFaceWithoutPersonResponseDto {
    id: string;
    imageHeight: number;
    imageWidth: number;
    boundingBoxX1: number;
    boundingBoxX2: number;
    boundingBoxY1: number;
    boundingBoxY2: number;
    sourceType?: SourceType;
}
export declare class AssetFaceResponseDto extends AssetFaceWithoutPersonResponseDto {
    person: PersonResponseDto | null;
}
export declare class AssetFaceUpdateDto {
    data: AssetFaceUpdateItem[];
}
export declare class FaceDto {
    id: string;
}
export declare class AssetFaceUpdateItem {
    personId: string;
    assetId: string;
}
export declare class AssetFaceCreateDto extends AssetFaceUpdateItem {
    imageWidth: number;
    imageHeight: number;
    x: number;
    y: number;
    width: number;
    height: number;
}
export declare class AssetFaceDeleteDto {
    force: boolean;
}
export declare class PersonStatisticsResponseDto {
    assets: number;
}
export declare class PeopleResponseDto {
    total: number;
    hidden: number;
    people: PersonResponseDto[];
    hasNextPage?: boolean;
}
export declare function mapPerson(person: Person): PersonResponseDto;
export declare function mapFacesWithoutPerson(face: Selectable<AssetFaceTable>, edits?: AssetEditActionItem[], assetDimensions?: ImageDimensions): AssetFaceWithoutPersonResponseDto;
export declare function mapFaces(face: AssetFace, auth: AuthDto, edits?: AssetEditActionItem[], assetDimensions?: ImageDimensions): AssetFaceResponseDto;
