"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthStatusResponseDto = exports.OAuthAuthorizeResponseDto = exports.OAuthConfigDto = exports.OAuthCallbackDto = exports.ValidateAccessTokenResponseDto = exports.PinCodeChangeDto = exports.SessionUnlockDto = exports.PinCodeResetDto = exports.PinCodeSetupDto = exports.ChangePasswordDto = exports.SignUpDto = exports.LogoutResponseDto = exports.LoginResponseDto = exports.LoginCredentialDto = exports.AuthDto = void 0;
exports.mapLoginResponse = mapLoginResponse;
const openapi = require("@nestjs/swagger");
const swagger_1 = require("@nestjs/swagger");
const class_transformer_1 = require("class-transformer");
const class_validator_1 = require("class-validator");
const enum_1 = require("../enum");
const validation_1 = require("../validation");
class AuthDto {
    user;
    apiKey;
    sharedLink;
    session;
    static _OPENAPI_METADATA_FACTORY() {
        return { user: { required: true, type: () => Object }, apiKey: { required: false, type: () => Object }, sharedLink: { required: false, type: () => Object }, session: { required: false, type: () => Object } };
    }
}
exports.AuthDto = AuthDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Authenticated user' }),
    __metadata("design:type", Object)
], AuthDto.prototype, "user", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'API key (if authenticated via API key)' }),
    __metadata("design:type", Object)
], AuthDto.prototype, "apiKey", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Shared link (if authenticated via shared link)' }),
    __metadata("design:type", Object)
], AuthDto.prototype, "sharedLink", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Session (if authenticated via session)' }),
    __metadata("design:type", Object)
], AuthDto.prototype, "session", void 0);
class LoginCredentialDto {
    email;
    password;
    static _OPENAPI_METADATA_FACTORY() {
        return { email: { required: true, type: () => String, format: "email" }, password: { required: true, type: () => String } };
    }
}
exports.LoginCredentialDto = LoginCredentialDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'testuser@email.com', description: 'User email' }),
    (0, class_validator_1.IsEmail)({ require_tld: false }),
    (0, class_transformer_1.Transform)(validation_1.toEmail),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], LoginCredentialDto.prototype, "email", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'password', description: 'User password' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], LoginCredentialDto.prototype, "password", void 0);
class LoginResponseDto {
    accessToken;
    userId;
    userEmail;
    name;
    profileImagePath;
    isAdmin;
    shouldChangePassword;
    isOnboarded;
    static _OPENAPI_METADATA_FACTORY() {
        return { accessToken: { required: true, type: () => String }, userId: { required: true, type: () => String }, userEmail: { required: true, type: () => String }, name: { required: true, type: () => String }, profileImagePath: { required: true, type: () => String }, isAdmin: { required: true, type: () => Boolean }, shouldChangePassword: { required: true, type: () => Boolean }, isOnboarded: { required: true, type: () => Boolean } };
    }
}
exports.LoginResponseDto = LoginResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Access token' }),
    __metadata("design:type", String)
], LoginResponseDto.prototype, "accessToken", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User ID' }),
    __metadata("design:type", String)
], LoginResponseDto.prototype, "userId", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User email' }),
    __metadata("design:type", String)
], LoginResponseDto.prototype, "userEmail", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'User name' }),
    __metadata("design:type", String)
], LoginResponseDto.prototype, "name", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Profile image path' }),
    __metadata("design:type", String)
], LoginResponseDto.prototype, "profileImagePath", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Is admin user' }),
    __metadata("design:type", Boolean)
], LoginResponseDto.prototype, "isAdmin", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Should change password' }),
    __metadata("design:type", Boolean)
], LoginResponseDto.prototype, "shouldChangePassword", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Is onboarded' }),
    __metadata("design:type", Boolean)
], LoginResponseDto.prototype, "isOnboarded", void 0);
function mapLoginResponse(entity, accessToken) {
    const onboardingMetadata = entity.metadata.find((item) => item.key === enum_1.UserMetadataKey.Onboarding)?.value;
    return {
        accessToken,
        userId: entity.id,
        userEmail: entity.email,
        name: entity.name,
        isAdmin: entity.isAdmin,
        profileImagePath: entity.profileImagePath,
        shouldChangePassword: entity.shouldChangePassword,
        isOnboarded: onboardingMetadata?.isOnboarded ?? false,
    };
}
class LogoutResponseDto {
    successful;
    redirectUri;
    static _OPENAPI_METADATA_FACTORY() {
        return { successful: { required: true, type: () => Boolean }, redirectUri: { required: true, type: () => String } };
    }
}
exports.LogoutResponseDto = LogoutResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Logout successful' }),
    __metadata("design:type", Boolean)
], LogoutResponseDto.prototype, "successful", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Redirect URI' }),
    __metadata("design:type", String)
], LogoutResponseDto.prototype, "redirectUri", void 0);
class SignUpDto extends LoginCredentialDto {
    name;
    static _OPENAPI_METADATA_FACTORY() {
        return { name: { required: true, type: () => String } };
    }
}
exports.SignUpDto = SignUpDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'Admin', description: 'User name' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], SignUpDto.prototype, "name", void 0);
class ChangePasswordDto {
    password;
    newPassword;
    invalidateSessions;
    static _OPENAPI_METADATA_FACTORY() {
        return { password: { required: true, type: () => String }, newPassword: { required: true, type: () => String, minLength: 8 }, invalidateSessions: { required: false, type: () => Boolean } };
    }
}
exports.ChangePasswordDto = ChangePasswordDto;
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'password', description: 'Current password' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], ChangePasswordDto.prototype, "password", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'password', description: 'New password (min 8 characters)' }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.MinLength)(8),
    __metadata("design:type", String)
], ChangePasswordDto.prototype, "newPassword", void 0);
__decorate([
    (0, validation_1.ValidateBoolean)({ optional: true, default: false, description: 'Invalidate all other sessions' }),
    __metadata("design:type", Boolean)
], ChangePasswordDto.prototype, "invalidateSessions", void 0);
class PinCodeSetupDto {
    pinCode;
    static _OPENAPI_METADATA_FACTORY() {
        return { pinCode: { required: true, type: () => String } };
    }
}
exports.PinCodeSetupDto = PinCodeSetupDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'PIN code (4-6 digits)' }),
    (0, validation_1.PinCode)(),
    __metadata("design:type", String)
], PinCodeSetupDto.prototype, "pinCode", void 0);
class PinCodeResetDto {
    pinCode;
    password;
    static _OPENAPI_METADATA_FACTORY() {
        return { pinCode: { required: false, type: () => String }, password: { required: false, type: () => String } };
    }
}
exports.PinCodeResetDto = PinCodeResetDto;
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'New PIN code (4-6 digits)' }),
    (0, validation_1.PinCode)({ optional: true }),
    __metadata("design:type", String)
], PinCodeResetDto.prototype, "pinCode", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'User password (required if PIN code is not provided)' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsNotEmpty)(),
    __metadata("design:type", String)
], PinCodeResetDto.prototype, "password", void 0);
class SessionUnlockDto extends PinCodeResetDto {
    static _OPENAPI_METADATA_FACTORY() {
        return {};
    }
}
exports.SessionUnlockDto = SessionUnlockDto;
class PinCodeChangeDto extends PinCodeResetDto {
    newPinCode;
    static _OPENAPI_METADATA_FACTORY() {
        return { newPinCode: { required: true, type: () => String } };
    }
}
exports.PinCodeChangeDto = PinCodeChangeDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'New PIN code (4-6 digits)' }),
    (0, validation_1.PinCode)(),
    __metadata("design:type", String)
], PinCodeChangeDto.prototype, "newPinCode", void 0);
class ValidateAccessTokenResponseDto {
    authStatus;
    static _OPENAPI_METADATA_FACTORY() {
        return { authStatus: { required: true, type: () => Boolean } };
    }
}
exports.ValidateAccessTokenResponseDto = ValidateAccessTokenResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Authentication status' }),
    __metadata("design:type", Boolean)
], ValidateAccessTokenResponseDto.prototype, "authStatus", void 0);
class OAuthCallbackDto {
    url;
    state;
    codeVerifier;
    static _OPENAPI_METADATA_FACTORY() {
        return { url: { required: true, type: () => String }, state: { required: false, type: () => String }, codeVerifier: { required: false, type: () => String } };
    }
}
exports.OAuthCallbackDto = OAuthCallbackDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'OAuth callback URL' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthCallbackDto.prototype, "url", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'OAuth state parameter' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthCallbackDto.prototype, "state", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'OAuth code verifier (PKCE)' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthCallbackDto.prototype, "codeVerifier", void 0);
class OAuthConfigDto {
    redirectUri;
    state;
    codeChallenge;
    static _OPENAPI_METADATA_FACTORY() {
        return { redirectUri: { required: true, type: () => String }, state: { required: false, type: () => String }, codeChallenge: { required: false, type: () => String } };
    }
}
exports.OAuthConfigDto = OAuthConfigDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'OAuth redirect URI' }),
    (0, class_validator_1.IsNotEmpty)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthConfigDto.prototype, "redirectUri", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'OAuth state parameter' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthConfigDto.prototype, "state", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'OAuth code challenge (PKCE)' }),
    (0, validation_1.Optional)(),
    (0, class_validator_1.IsString)(),
    __metadata("design:type", String)
], OAuthConfigDto.prototype, "codeChallenge", void 0);
class OAuthAuthorizeResponseDto {
    url;
    static _OPENAPI_METADATA_FACTORY() {
        return { url: { required: true, type: () => String } };
    }
}
exports.OAuthAuthorizeResponseDto = OAuthAuthorizeResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'OAuth authorization URL' }),
    __metadata("design:type", String)
], OAuthAuthorizeResponseDto.prototype, "url", void 0);
class AuthStatusResponseDto {
    pinCode;
    password;
    isElevated;
    expiresAt;
    pinExpiresAt;
    static _OPENAPI_METADATA_FACTORY() {
        return { pinCode: { required: true, type: () => Boolean }, password: { required: true, type: () => Boolean }, isElevated: { required: true, type: () => Boolean }, expiresAt: { required: false, type: () => String }, pinExpiresAt: { required: false, type: () => String } };
    }
}
exports.AuthStatusResponseDto = AuthStatusResponseDto;
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Has PIN code set' }),
    __metadata("design:type", Boolean)
], AuthStatusResponseDto.prototype, "pinCode", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Has password set' }),
    __metadata("design:type", Boolean)
], AuthStatusResponseDto.prototype, "password", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ description: 'Is elevated session' }),
    __metadata("design:type", Boolean)
], AuthStatusResponseDto.prototype, "isElevated", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'Session expiration date' }),
    __metadata("design:type", String)
], AuthStatusResponseDto.prototype, "expiresAt", void 0);
__decorate([
    (0, swagger_1.ApiPropertyOptional)({ description: 'PIN expiration date' }),
    __metadata("design:type", String)
], AuthStatusResponseDto.prototype, "pinExpiresAt", void 0);
//# sourceMappingURL=auth.dto.js.map