"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginController = void 0;
const openapi = require("@nestjs/swagger");
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const decorators_1 = require("../decorators");
const enum_1 = require("../enum");
const auth_guard_1 = require("../middleware/auth.guard");
const plugin_service_1 = require("../services/plugin.service");
const validation_1 = require("../validation");
let PluginController = class PluginController {
    service;
    constructor(service) {
        this.service = service;
    }
    getPluginTriggers() {
        return this.service.getTriggers();
    }
    getPlugins() {
        return this.service.getAll();
    }
    getPlugin({ id }) {
        return this.service.get(id);
    }
};
exports.PluginController = PluginController;
__decorate([
    (0, common_1.Get)('triggers'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PluginRead }),
    (0, decorators_1.Endpoint)({
        summary: 'List all plugin triggers',
        description: 'Retrieve a list of all available plugin triggers.',
        history: new decorators_1.HistoryBuilder().added('v2.3.0').alpha('v2.3.0'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/plugin.dto").PluginTriggerResponseDto] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Array)
], PluginController.prototype, "getPluginTriggers", null);
__decorate([
    (0, common_1.Get)(),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PluginRead }),
    (0, decorators_1.Endpoint)({
        summary: 'List all plugins',
        description: 'Retrieve a list of plugins available to the authenticated user.',
        history: new decorators_1.HistoryBuilder().added('v2.3.0').alpha('v2.3.0'),
    }),
    openapi.ApiResponse({ status: 200, type: [require("../dtos/plugin.dto").PluginResponseDto] }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], PluginController.prototype, "getPlugins", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, auth_guard_1.Authenticated)({ permission: enum_1.Permission.PluginRead }),
    (0, decorators_1.Endpoint)({
        summary: 'Retrieve a plugin',
        description: 'Retrieve information about a specific plugin by its ID.',
        history: new decorators_1.HistoryBuilder().added('v2.3.0').alpha('v2.3.0'),
    }),
    openapi.ApiResponse({ status: 200, type: require("../dtos/plugin.dto").PluginResponseDto }),
    __param(0, (0, common_1.Param)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [validation_1.UUIDParamDto]),
    __metadata("design:returntype", Promise)
], PluginController.prototype, "getPlugin", null);
exports.PluginController = PluginController = __decorate([
    (0, swagger_1.ApiTags)('Plugins'),
    (0, common_1.Controller)('plugins'),
    __metadata("design:paramtypes", [plugin_service_1.PluginService])
], PluginController);
//# sourceMappingURL=plugin.controller.js.map