"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImmichAdminModule = exports.MicroservicesModule = exports.MaintenanceModule = exports.ApiModule = exports.BaseModule = void 0;
const bullmq_1 = require("@nestjs/bullmq");
const common_1 = require("@nestjs/common");
const core_1 = require("@nestjs/core");
const schedule_1 = require("@nestjs/schedule");
const nestjs_cls_1 = require("nestjs-cls");
const nestjs_kysely_1 = require("nestjs-kysely");
const nestjs_otel_1 = require("nestjs-otel");
const commands_1 = require("./commands");
const constants_1 = require("./constants");
const controllers_1 = require("./controllers");
const enum_1 = require("./enum");
const maintenance_auth_guard_1 = require("./maintenance/maintenance-auth.guard");
const maintenance_health_repository_1 = require("./maintenance/maintenance-health.repository");
const maintenance_websocket_repository_1 = require("./maintenance/maintenance-websocket.repository");
const maintenance_worker_controller_1 = require("./maintenance/maintenance-worker.controller");
const maintenance_worker_service_1 = require("./maintenance/maintenance-worker.service");
const auth_guard_1 = require("./middleware/auth.guard");
const error_interceptor_1 = require("./middleware/error.interceptor");
const file_upload_interceptor_1 = require("./middleware/file-upload.interceptor");
const global_exception_filter_1 = require("./middleware/global-exception.filter");
const logging_interceptor_1 = require("./middleware/logging.interceptor");
const repositories_1 = require("./repositories");
const app_repository_1 = require("./repositories/app.repository");
const config_repository_1 = require("./repositories/config.repository");
const database_repository_1 = require("./repositories/database.repository");
const event_repository_1 = require("./repositories/event.repository");
const logging_repository_1 = require("./repositories/logging.repository");
const process_repository_1 = require("./repositories/process.repository");
const storage_repository_1 = require("./repositories/storage.repository");
const system_metadata_repository_1 = require("./repositories/system-metadata.repository");
const telemetry_repository_1 = require("./repositories/telemetry.repository");
const websocket_repository_1 = require("./repositories/websocket.repository");
const services_1 = require("./services");
const auth_service_1 = require("./services/auth.service");
const cli_service_1 = require("./services/cli.service");
const database_backup_service_1 = require("./services/database-backup.service");
const queue_service_1 = require("./services/queue.service");
const database_1 = require("./utils/database");
const common = [...repositories_1.repositories, ...services_1.services, global_exception_filter_1.GlobalExceptionFilter];
const commonMiddleware = [
    { provide: core_1.APP_FILTER, useClass: global_exception_filter_1.GlobalExceptionFilter },
    { provide: core_1.APP_PIPE, useValue: new common_1.ValidationPipe({ transform: true, whitelist: true }) },
    { provide: core_1.APP_INTERCEPTOR, useClass: logging_interceptor_1.LoggingInterceptor },
    { provide: core_1.APP_INTERCEPTOR, useClass: error_interceptor_1.ErrorInterceptor },
];
const apiMiddleware = [file_upload_interceptor_1.FileUploadInterceptor, ...commonMiddleware, { provide: core_1.APP_GUARD, useClass: auth_guard_1.AuthGuard }];
const configRepository = new config_repository_1.ConfigRepository();
const { bull, cls, database, otel } = configRepository.getEnv();
const commonImports = [
    nestjs_cls_1.ClsModule.forRoot(cls.config),
    nestjs_kysely_1.KyselyModule.forRoot((0, database_1.getKyselyConfig)(database.config)),
    nestjs_otel_1.OpenTelemetryModule.forRoot(otel),
];
const bullImports = [bullmq_1.BullModule.forRoot(bull.config), bullmq_1.BullModule.registerQueue(...bull.queues)];
let BaseModule = class BaseModule {
    worker;
    authService;
    eventRepository;
    queueService;
    telemetryRepository;
    websocketRepository;
    constructor(worker, logger, authService, eventRepository, queueService, telemetryRepository, websocketRepository) {
        this.worker = worker;
        this.authService = authService;
        this.eventRepository = eventRepository;
        this.queueService = queueService;
        this.telemetryRepository = telemetryRepository;
        this.websocketRepository = websocketRepository;
        logger.setAppName(this.worker);
    }
    async onModuleInit() {
        this.telemetryRepository.setup({ repositories: repositories_1.repositories });
        this.queueService.setServices(services_1.services);
        this.websocketRepository.setAuthFn(async (client) => this.authService.authenticate({
            headers: client.request.headers,
            queryParams: {},
            metadata: { adminRoute: false, sharedLinkRoute: false, uri: '/api/socket.io' },
        }));
        this.eventRepository.setup({ services: services_1.services });
        await this.eventRepository.emit('AppBootstrap');
    }
    async onModuleDestroy() {
        await this.eventRepository.emit('AppShutdown');
        await (0, telemetry_repository_1.teardownTelemetry)();
    }
};
exports.BaseModule = BaseModule;
exports.BaseModule = BaseModule = __decorate([
    __param(0, (0, common_1.Inject)(constants_1.IWorker)),
    __metadata("design:paramtypes", [String, logging_repository_1.LoggingRepository,
        auth_service_1.AuthService,
        event_repository_1.EventRepository,
        queue_service_1.QueueService,
        telemetry_repository_1.TelemetryRepository,
        websocket_repository_1.WebsocketRepository])
], BaseModule);
let ApiModule = class ApiModule extends BaseModule {
};
exports.ApiModule = ApiModule;
exports.ApiModule = ApiModule = __decorate([
    (0, common_1.Module)({
        imports: [...bullImports, ...commonImports, schedule_1.ScheduleModule.forRoot()],
        controllers: [...controllers_1.controllers],
        providers: [...common, ...apiMiddleware, { provide: constants_1.IWorker, useValue: enum_1.ImmichWorker.Api }],
    })
], ApiModule);
let MaintenanceModule = class MaintenanceModule {
    worker;
    maintenanceWorkerService;
    constructor(worker, logger, maintenanceWorkerService) {
        this.worker = worker;
        this.maintenanceWorkerService = maintenanceWorkerService;
        logger.setAppName(this.worker);
    }
    async onModuleInit() {
        await this.maintenanceWorkerService.init();
    }
};
exports.MaintenanceModule = MaintenanceModule;
exports.MaintenanceModule = MaintenanceModule = __decorate([
    (0, common_1.Module)({
        imports: [...commonImports],
        controllers: [maintenance_worker_controller_1.MaintenanceWorkerController],
        providers: [
            config_repository_1.ConfigRepository,
            logging_repository_1.LoggingRepository,
            storage_repository_1.StorageRepository,
            process_repository_1.ProcessRepository,
            database_repository_1.DatabaseRepository,
            system_metadata_repository_1.SystemMetadataRepository,
            app_repository_1.AppRepository,
            maintenance_health_repository_1.MaintenanceHealthRepository,
            maintenance_websocket_repository_1.MaintenanceWebsocketRepository,
            database_backup_service_1.DatabaseBackupService,
            maintenance_worker_service_1.MaintenanceWorkerService,
            ...commonMiddleware,
            { provide: core_1.APP_GUARD, useClass: maintenance_auth_guard_1.MaintenanceAuthGuard },
            { provide: constants_1.IWorker, useValue: enum_1.ImmichWorker.Maintenance },
        ],
    }),
    __param(0, (0, common_1.Inject)(constants_1.IWorker)),
    __metadata("design:paramtypes", [String, logging_repository_1.LoggingRepository,
        maintenance_worker_service_1.MaintenanceWorkerService])
], MaintenanceModule);
let MicroservicesModule = class MicroservicesModule extends BaseModule {
};
exports.MicroservicesModule = MicroservicesModule;
exports.MicroservicesModule = MicroservicesModule = __decorate([
    (0, common_1.Module)({
        imports: [...bullImports, ...commonImports],
        providers: [...common, { provide: constants_1.IWorker, useValue: enum_1.ImmichWorker.Microservices }, schedule_1.SchedulerRegistry],
    })
], MicroservicesModule);
let ImmichAdminModule = class ImmichAdminModule {
    service;
    constructor(service) {
        this.service = service;
    }
    async onModuleDestroy() {
        await this.service.cleanup();
    }
};
exports.ImmichAdminModule = ImmichAdminModule;
exports.ImmichAdminModule = ImmichAdminModule = __decorate([
    (0, common_1.Module)({
        imports: [...bullImports, ...commonImports],
        providers: [...common, ...commands_1.commandsAndQuestions, schedule_1.SchedulerRegistry],
    }),
    __metadata("design:paramtypes", [cli_service_1.CliService])
], ImmichAdminModule);
//# sourceMappingURL=app.module.js.map